//*******************************
//   TStringData
//*******************************
//  (c) 1996 by Olaf Panz
//	 Drosselgasse 4
//  21436 Marschacht
//*******************************
//  Inline-Klasse zur
//  Konvertierung diverser Typen
//  zum ASCII-String
//*******************************


// Inline- Klasse zur Typenkonvertierung
class TStringData
{
	protected :

		// Datum:
		string m_stName;
		const char *m_cszName;

	public :

		// Konstruktor fr void
		TStringData (void) : m_stName () { m_cszName =0;}

		TStringData& operator= (TStringData& oData) { m_stName = oData.m_stName; return *this; }

		// Typenkonvertierungen

		// char*
		operator const char* () { if (m_cszName) return m_cszName; else return m_stName.c_str(); }
		const char * operator= (const char *cszString) { m_stName = cszString; m_cszName = cszString; return cszString; }
		TStringData (const char*cszString) {m_stName = cszString; m_cszName = cszString;}

		// int
		operator int () { return atoi (m_stName.c_str ()); }
		int operator= (int iData) { char szBuf [37]; m_stName = itoa (iData,szBuf,10);m_cszName =0; return iData; }
		TStringData (int iData) { char szBuf [37]; m_stName = itoa (iData,szBuf,10); m_cszName =0;}

		// string
		operator string () { return m_stName; }
		string& operator= (string& stData) { m_stName = stData; m_cszName = stData.c_str(); return stData; }
		TStringData (string& stData) {m_stName = stData; m_cszName =stData.c_str();}

		// float
		operator float () { return atof (m_stName.c_str ()); }
		float operator= (float dData) { char szBuf [37]; gcvt (dData,10,szBuf); m_stName = szBuf;m_cszName =0; return dData; }
		TStringData (float dData) {char szBuf [37]; gcvt (dData,10,szBuf); m_stName = szBuf; m_cszName =0;}
};

