//*******************************
//   Media- Manager
//*******************************
//  (c) 1996 by Olaf Panz
//	 Drosselgasse 4
//  21436 Marschacht
//*******************************
//   Bmp
//  Klasse zum Laden, Bearbeiten
//  und speichern von
//  Windows-BMP-Dateien
//  mit genau 256 Farben
//*******************************

#define WIN32_LEAN_AND_MEAN
#define STRICT
#include <windows.h>

#define IMPEX _export
#include <TBmp.h>
#include <stdio.h>

TBmp::TBmp ()
{
	m_pbyData = NULL;
}

TBmp::~TBmp ()
{
	if (m_pbyData)
		delete m_pbyData;
}

// lade 256-Farb-DIB
BOOL TBmp::Load (const char *cszFile)
{
	BOOL blErg = FALSE;
	int iSize;
	HANDLE hFile;
	DWORD dwRead;

	// evt. alte Bitmap lschen
	if (m_pbyData) {
		delete m_pbyData;
		m_pbyData = 0;
	}

	// Datei ffnen
	hFile = CreateFile (cszFile,GENERIC_READ,FILE_SHARE_READ,0,OPEN_EXISTING,
				FILE_ATTRIBUTE_NORMAL | FILE_FLAG_SEQUENTIAL_SCAN,0);

	if (hFile == INVALID_HANDLE_VALUE) {
//		MessageBox (0,"Can't read file:",cszFile,MB_OK);
	} else {
		// Datei Header laden:
		ReadFile (hFile,&m_oFileHeader,sizeof (m_oFileHeader),&dwRead,NULL);

		if (m_oFileHeader.bfType != 0x4D42) {
//			MessageBox (0,"File ist not a Bitmap",cszFile,MB_OK);
		} else {

			// Info-Header laden:
			ReadFile (hFile,&m_oBmpInfo,sizeof (m_oBmpInfo),&dwRead,NULL);

			if (m_oBmpInfo.biBitCount != 8) {
//				MessageBox (0,"File has not 256-Colors",cszFile,MB_OK);
			} else {
				// StorageWidth berechnen:
				m_iStorageWidth = (m_oBmpInfo.biWidth +3) & ~3;

				// Farbpalette lesen:
				ReadFile (hFile,&m_oPal,sizeof (m_oPal),&dwRead,NULL);

				// Speicher fr Bilddaten anfordern
				iSize = m_iStorageWidth * m_oBmpInfo.biHeight;
				m_pbyData = new BYTE [iSize];

				ReadFile (hFile,m_pbyData,iSize,&dwRead,NULL);

				blErg = TRUE;
			}
		}
		// Datei wieder schlieen
		CloseHandle (hFile);
	}

	return blErg;
}

// schreibe 256-Farb-DIB
BOOL TBmp::Save (const char *cszFile)
{
	HANDLE hFile;
	DWORD dwSize;
	BOOL blErg = FALSE;

	if (m_pbyData) { // sind berhaupt Daten vorhanden?
		// Datei ffnen
		hFile = CreateFile (cszFile,GENERIC_WRITE	,FILE_SHARE_WRITE	,0,CREATE_ALWAYS,
				FILE_ATTRIBUTE_NORMAL | FILE_FLAG_SEQUENTIAL_SCAN,0);
		if (hFile == INVALID_HANDLE_VALUE) {
//			MessageBox (0,"Can't write in file:",cszFile,MB_OK);
		} else {
			// Header schreiben:
			WriteFile (hFile,&m_oFileHeader,sizeof (m_oFileHeader),&dwSize,NULL);

			// Bitmapinfo schreiben:
			WriteFile (hFile,&m_oBmpInfo,sizeof (m_oBmpInfo),&dwSize,NULL);

			// Palette schreiben
			WriteFile (hFile,&m_oPal,sizeof (m_oPal),&dwSize,NULL);

			// Daten-Bytes schreiben
			WriteFile (hFile,m_pbyData,m_iStorageWidth * m_oBmpInfo.biHeight,&dwSize,NULL);

			// Datei wieder schlieen
			CloseHandle (hFile);
			blErg = TRUE;
		}


	}
	return blErg;
}

// Schreibe nur Bild-Bytes
BOOL TBmp::SaveBits (const char *cszFile)
{
	HANDLE hFile;
	DWORD dwSize;
	BOOL blErg = FALSE;

	if (m_pbyData) { // sind berhaupt Daten vorhanden?
		// Datei ffnen
		hFile = CreateFile (cszFile,GENERIC_WRITE	,FILE_SHARE_WRITE	,0,CREATE_ALWAYS,
				FILE_ATTRIBUTE_NORMAL | FILE_FLAG_SEQUENTIAL_SCAN,0);
		if (hFile == INVALID_HANDLE_VALUE) {
//			MessageBox (0,"Can't write in file:",cszFile,MB_OK);
		} else {
			// Breite und Hhe als Vorspann schreiben:
			WriteFile (hFile,&m_oBmpInfo.biWidth,4,&dwSize,NULL);
			WriteFile (hFile,&m_oBmpInfo.biHeight,4,&dwSize,NULL);

			// Daten-Bytes schreiben
			WriteFile (hFile,m_pbyData,m_iStorageWidth * m_oBmpInfo.biHeight,&dwSize,NULL);

			// Datei wieder schlieen
			CloseHandle (hFile);
			blErg = TRUE;
		}


	}
	return blErg;
}


// Pixeladresse ermitteln:
BYTE *TBmp::GetPixelAddress (int iX,int iY)
{
	// Ist Datei geladen, und Indices gltig?
	if (!m_pbyData || iX >= m_oBmpInfo.biWidth ||
				iY >= m_oBmpInfo.biHeight)
						return NULL;
	return m_pbyData + iX + m_iStorageWidth * (m_oBmpInfo.biHeight -iY -1);
}


int TBmp::GetWidth (void)
{
	return m_oBmpInfo.biWidth;
}

int TBmp::GetHeight (void)
{
	return m_oBmpInfo.biHeight;
}

