//*******************************
//   Media- Manager
//*******************************
//  (c) 1996 by Olaf Panz
//	 Drosselgasse 4
//  21436 Marschacht
//*******************************
//   TDib
//  Klasse zum Laden, Bearbeiten
//  und speichern von
//  Windows-BMP-Dateien
//  mit genau 256 Farben
//*******************************

#ifndef TDIB_INCLUDE
	#define TDIB_INCLUDE

	#ifndef IMPEX
		#define IMPEX _import
	#endif

	class IMPEX TBmp
	{
		private :

			// Datei-Header
			BITMAPFILEHEADER m_oFileHeader;
			BITMAPINFOHEADER m_oBmpInfo;
			RGBQUAD m_oPal [256];
			BYTE *m_pbyData;
			int m_iStorageWidth;

		public :

			TBmp ();
			~TBmp ();

			// lade 256-Farb-DIB
			BOOL Load (const char *cszFile);
			// schreibe 256-Farb-DIB
			BOOL Save (const char *cszFile);
			// Schreibe nur Bild-Bytes
			BOOL SaveBits (const char *cszName);

			// Pixeladresse ermitteln:
			BYTE *GetPixelAddress (int iX,int iY);

			int GetWidth (void);
			int GetHeight (void);

	};
#endif


