{***********************
  Media-Manager
************************
 (c) 1996 by
 Olaf Panz
 Drosselgasse 4
 21436 Marschacht
***********************}
unit Memory;

interface

uses WinTypes;

procedure memset (Adr : Pointer;Value : Byte;Count : Integer); assembler;
procedure memcpy (Dest,Src : Pointer;Count : Integer); assembler;
procedure memcpyTransparency(Dest,Src : Pointer;Count : Integer); assembler;
function memcmp (Mem1,Mem2 : Pointer;Count : Integer) : WORDBOOL;  assembler;

// Kopiert bzw. schreibt jeweils 32 Bit
procedure memset32 (Adr : Pointer;Value : DWORD;Count : Integer); assembler;
procedure memcpy32 (Dest,Src : Pointer;Count : Integer); assembler;

implementation

procedure memset (Adr : Pointer;Value : Byte;Count : Integer); assembler;
asm
    push ebx


    mov ebx, Adr   // Adresse in ebx

    push ecx
    // eax 4 * mit Value fllen:
    mov cl,Value  // Value in bl
    mov al,cl
    mov ah,cl
    shl eax,16
    mov al,cl
    mov ah,cl
    pop ecx

    mov ecx,Count  // Anzahl in ecx
    mov edx,ecx    // in edx kopieren
    shr ecx,2      // Zhler durch 4 teilen
    and edx,3      // Rest n edx

    cmp ecx,0
    jz @2          // Ist ein Anteil > 4 vorhanden?

@1: mov [ebx],eax // 4 Byte schreiben
    add ebx,4
    dec ecx
    jnz @1   // Solange, bis Zhler NULL

@2: cmp edx,0 // Ist ein Rest vorhanden?
    jz @4

@3: mov [ebx],al   // Byte setzen
    inc ebx        // Adresse hhoch
    dec edx        // Counter runter
    jnz @3         // Solange bis Counter leer

@4: pop ebx

end;


procedure memcpy (Dest,Src : Pointer;Count : Integer);  assembler;
asm
    push ebx
    push edi

    mov ebx,Dest  // Destadresse in ebx
    mov eax,Src   // Source in eax
    mov ecx,Count  // Counter in ecx
    mov edi,ecx    // in edx kopieren
    shr ecx,2      // COunter durch 2 teilen
    and edi,3      // Rest in edi

    cmp ecx,0      // Gibt es einen Anteil >= 4 ?
    jz @2          // Nein:

@1: mov edx,[eax]  // 32 Bit laden
    mov [ebx],edx  // und schreiben
    add eax,4
    add ebx,4
    dec ecx        // Counter runter
    jnz @1         // solange, bis NULL

@2: cmp edi,0      // Rest vorhanden?
    jz @4

@3: mov dl,[eax]   // Datum laden
    mov [ebx],dl   // und wieder schreiben
    inc eax        // Adresszhler rauf
    inc ebx
    dec edi        // Counter runter
    jnz @3         // Solange bis Counter leer

@4: pop edi
    pop ebx
end;


procedure memset32 (Adr : Pointer;Value : DWORD;Count : Integer); assembler;
asm
    push ebx
    push eax
    push ecx

    mov ebx, Adr   // Adresse in bx
    mov eax,Value  // Value in al
    mov ecx,Count  // Anzahl in cx
    shr ecx,2      // Zhler durch 4 teilen

@1: mov [ebx],eax   // DWORD setzen
    add ebx,4       // Adresse hoch
    dec ecx        // Counter runter
    jnz @1         // Solange bis Counter leer

    pop ecx
    pop eax
    pop ebx

end;


procedure memcpy32 (Dest,Src : Pointer;Count : Integer);  assembler;
asm
    push ebx
    push eax
    push ecx
    push edx

    mov ebx,Dest  // Destadresse in ebx
    mov eax,Src   // Source in eax
    mov ecx,Count  // Counter in ecx
    shr ecx,2       // Counter durch 2 teilen

@1: mov edx,[eax]   // Datum laden
    mov [ebx],edx   // und wieder schreiben
    add eax,4        // Adresszhler rauf
    add ebx,4
    dec ecx        // Counter runter
    jnz @1         // Solange bis Counter leer

    pop edx
    pop ecx
    pop eax
    pop ebx
end;

procedure memcpyTransparency(Dest,Src : Pointer;Count : Integer); assembler;
asm
    push ebx
    push edi

    mov ebx,Dest  // Destadresse in ebx
    mov eax,Src   // Source in eax
    mov ecx,Count  // Counter in ecx


@1: mov dl,[eax]   // Datum laden
    cmp dl,0
    je @2
    mov [ebx],dl   // und wieder schreiben
@2: inc eax        // Adresszhler rauf
    inc ebx
    dec ecx        // Counter runter
    jnz @1         // Solange bis Counter leer

    pop edi
    pop ebx
end;



function memcmp (Mem1,Mem2 : Pointer;Count : Integer) : WORDBOOL;  assembler;
asm
    push ebx
    push edi

    mov ebx,Mem1  // Destadresse in ebx
    mov eax,Mem2   // Source in eax
    mov ecx,Count  // Counter in ecx
    mov edi,ecx    // in edx kopieren
    shr ecx,2      // COunter durch 2 teilen
    and edi,3      // Rest in edi

    cmp ecx,0      // Gibt es einen Anteil >= 4 ?
    jz @2          // Nein:

@1: mov edx,[eax]  // 32 Bit laden
    cmp [ebx],edx  // und vergleichen
    jne @5         // ungleich?
    add eax,4
    add ebx,4
    dec ecx        // Counter runter
    jnz @1         // solange, bis NULL

@2: cmp edi,0      // Rest vorhanden?
    jz @6

@3: mov dl,[eax]   // Datum laden
    mov [ebx],dl   // und wieder schreiben
    inc eax        // Adresszhler rauf
    inc ebx
    dec edi        // Counter runter
    jnz @3         // Solange bis Counter leer

@6: mov ax,1       // TRUE zurckliefern
    jz @4          // Springe


@5: mov ax,0       // TRUE zurckliefern

@4: pop edi
    pop ebx
end;


end.
