{***********************
  Media-Manager
************************
 (c) 1996 by
 Olaf Panz
 Drosselgasse 4
 21436 Marschacht
***********************}
unit UAAudio;

interface

uses SysUtils,wintypes,ole2,Dialogs,classes;

{2BA4CC21-0540-11cf-8963-444553540000}
const CLSID_AAudio : TGuid =        (D1:$2ba4cc21;D2:$540;D3:$11cf;D4:($89,$63,$44,$45,$53,$54,$0 ,$0 ));
      IID_IAAudio  : TGuid =        (D1:$ce918a26;D2:$308;D3:$11cf;D4:($b3,$0, $0, $aa,$0, $59,$48,$e9));
      IID_IAAudioEmitter : TGuid =  (D1:$a6424a0; D2:$317;D3:$11cf;D4:($9a,$ae,$0, $aa,$0, $4b,$43,$67));
      IID_IAAudioListener : TGuid = (D1:$37b7b160;D2:$3d0;D3:$11cf;D4:($89,$63,$44,$45,$53,$54,$0, $0 ));

      AA_MAX_NAME_LEN   = MAX_PATH+8;

      AA_PLAYSINGLE     = 1;
      AA_PLAYLOOP       = 2;
      AA_PAUSE          = 3;
      AA_RESUME         = 4;
      AA_STOP           = 5;

      AAERR_NODRIVER        = $8004000A;
      AAERR_BADFORMAT       = $80040014;
      AAERR_ZEROVECTOR      = $8004001e;
      AAERR_FILEOPEN        = $80040028;
      AAERR_CORRUPTFILE     = $80040032;
      AAERR_PARALLELVECTORS = $8004003c;
      AAERR_ALLOCATED       = $80040046;
      AAERR_INET_INIT       = $80040050;
      AAERR_INET_URLERR     = $8004005a;


type AASoundType        = (AMBIENT,LOCALIZED);
     AAUnitOfMeasure    = (METERS,FEET);
     AAReverbType       = (NONE,MOUNTAIN_RANGE,VALLEY,CANYON,AMPHITHEATRE,STADION,LECTURE_HALL,
                           LOBBY,OFFICE,HOME,BATHROOM);
     AAOutputDeviceType = (HEADPHONES, STEREO_FRONT, QUAD_SURROUND, STEREO_PLUS_READ, DOLBY_AC3);
     AALocalizeCPU      = (CPU_NONE_LOCALIZE, CPU_LOW_LOCALIZE, CPU_MODERATE_LOCALIZE);

     TUpdateProcedure  = procedure of object;

     VECTOR3D =  record
        x : single;
        y : single;
        z : single;
     end;

     TVector3D = class (TPersistent)
     private
        m_Vector : VECTOR3D;
        m_Update : TUpdateProcedure;
     protected
        procedure SetVectorX (value : single);
        procedure SetVectorY (value : single);
        procedure SetVectorZ (value : single);
     public
        property Vector : VECTOR3D read m_Vector write m_Vector;

        constructor Create (Update : TUpdateProcedure);

     published
        property X : single read m_vector.x write SetVectorX;
        property Y : single read m_vector.y write SetVectorY;
        property Z : single read m_vector.z write SetVectorZ;

     end;

     PVECTOR3D = ^VECTOR3D;

     AAEMITTERMODEL = record
        minBack  : single;
        minFront : single;
        maxBack  : single;
        maxFront : single;
        intensity: single;
     end;
     PAAEMITTERMODEL = ^AAEMITTERMODEL;

     TAAEmitterModel = class (TPersistent)
     private
        m_Emitter : AAEMITTERMODEL;
        m_Update : TUpdateProcedure;
     protected
        procedure SetMinBack (Value : Single);
        procedure SetMinFront(Value : Single);
        procedure SetMaxBack(Value : Single);
        procedure SetMaxFront(Value : Single);
        procedure SetIntensity (Value : Single);
     public
        property EmitterModel : AAEMITTERMODEL read m_Emitter write m_Emitter;
        constructor Create (Update : TUpdateProcedure);
     published
        property MinBack  : single read m_Emitter.minBack  write SetMinBack ;
        property MinFront : single read m_Emitter.minFront  write SetMinFront;
        property MaxBack  : single read m_Emitter.maxBack  write SetMaxBack;
        property MaxFront : single read m_Emitter.maxFront  write SetMaxFront;
        property Intensity: single read m_Emitter.Intensity  write SetIntensity;
     end;

     AAEMITTERDESC = record
        szFilename : array [0..AA_MAX_NAME_LEN] of char;
        dwUser : DWORD;
     end;
     PAAEMITTERDESC = ^AAEMITTERDESC;

     AAENVIROMENT = record
        reverb : AAReverbType;
        speedOfSound : single;
        useRightHand : LongBool;
        CPUBudget : AALocalizeCPU;
     end;
     PAAENVIROMENT = ^AAENVIROMENT;

     TAAEnviroment = class (TPersistent)
     private
        m_Enviroment : AAENVIROMENT;
        m_Update : TUpdateProcedure;
     protected
        procedure SetReverbType (Value : AAReverbType);
        procedure SetSpeedOfSound (Value : single);
        procedure SetUseRightHand (Value : LongBool);
        procedure SetCPUBudget (Value : AALocalizeCPU);
     public
        property Enviroment : AAENVIROMENT read m_Enviroment write m_Enviroment;
        constructor Create (Update : TUpdateProcedure);
     published
        property ReverbType : AAReverbType read m_Enviroment.reverb write SetReverbType;
        property SpeedOfSound : single read m_Enviroment.speedOfSound write SetSpeedOfSound;
        property UseRightHand : LongBool read m_Enviroment.UseRightHand write SetUseRightHand;
        property CPUBudget : AALocalizeCPU read m_Enviroment.CPUBudget write SetCPUBudget;
     end;

     AALISTENERDESC = record
        device : AAOutputDeviceType;
        hMainWnd : HWND;
        dwUser : DWORD;
     end;
     PAALISTENERDESC = ^AALISTENERDESC;

     IAAudioListener = class (IUnknown)
     public
        function SetPosition (lpPosition : PVECTOR3D) : HRESULT; virtual; stdcall; abstract;
        function SetOrientation (lpDirection,lpUp : PVECTOR3D) : HRESULT; virtual; stdcall; abstract;
        function SetVelocity (lpVelocity : PVECTOR3D) : HRESULT; virtual; stdcall; abstract;

        function GetPosition (lpPosition : PVECTOR3D) : HRESULT; virtual; stdcall; abstract;
        function GetOrientation (lpDirection,lpUp : PVECTOR3D) : HRESULT; virtual; stdcall; abstract;
        function GetVelocity (lpVelocity : PVECTOR3D) : HRESULT; virtual; stdcall; abstract;
        function GetUserData (lpdwUser : PDWORD) : HRESULT; virtual; stdcall; abstract;
     end;
     PIAudioListener = ^IAAudioListener;

     IAAudioEmitter = class (IUnknown)
     public
        function ControlMedia (dwControl : DWORD) : HRESULT; virtual; stdcall; abstract;
        function QueryMediaState (lpdwControl : PDWORD; pfSecondsPlayed,pfTotalTime : PSingle) : HRESULT; virtual; stdcall; abstract;

        function SetPosition (lpPosition : PVECTOR3D) : HRESULT; virtual; stdcall; abstract;
        function SetOrientation (lpDirection: PVECTOR3D) : HRESULT; virtual; stdcall; abstract;
        function SetVelocity (lpVelocity : PVECTOR3D) : HRESULT; virtual; stdcall; abstract;
        function SetModel (lpEmitterModel : PAAEMITTERMODEL) : HRESULT; virtual; stdcall; abstract;

        function GetOrientation (lpDirection : PVECTOR3D) : HRESULT; virtual; stdcall; abstract;
        function GetPosition (lpPosition : PVECTOR3D) : HRESULT; virtual; stdcall; abstract;
        function GetVelocity (lpVelocity : PVECTOR3D) : HRESULT; virtual; stdcall; abstract;
        function GetModel (lpEmitterModel : PAAEMITTERMODEL) : HRESULT; virtual; stdcall; abstract;
        function GetUserData (lpdwUser : PDWORD) : HRESULT; virtual; stdcall; abstract;

     end;
     PIAAudioEmitter = ^IAAudioEmitter;

     PIUnknown = ^IUnknown;

     IAAudio = class (IUnknown)
     public
        function SetEnviroment (lpEnvAttr : PAAENVIROMENT) : HRESULT;
                 virtual; stdcall; abstract;
        function CreateEmitter (lpEmitterAttr : PAAEMITTERDESC;
                                lpEmitterInterface : PIAAUDIOEMITTER;
                                reserved : PIUnknown) : HRESULT;
                 virtual; stdcall; abstract;
        function CreateListener (lpListenerAttr : PAALISTENERDESC;
                                 lpListenerInterface : PIAudioListener;
                                 reserved : PIUnknown) : HRESULT;
                 virtual; stdcall; abstract;

     end;

     RSXException = class (Exception)
     public
        constructor Create (msg : string;err : HRESULT);
     end;

function GetRSXErrorText (err : HRESULT) : string;

var RSXAudio : IAAudio;

implementation

var blIsInit : Boolean; // Wurde die Audio-Library initialisiert?

constructor RSXException.Create (msg : string;err : HRESULT);
begin
     inherited Create ('RSX error: '+ msg + ' ' + GetRSXErrorText (err));
end;

function GetRSXErrorText (err : HRESULT) : string;
begin
     case err of
          AAERR_NODRIVER : GetRSXErrorText := 'No sound driver installed.';
          AAERR_BADFORMAT : GetRSXErrorText := 'Wave driver doesnt support format.';
          AAERR_ZEROVECTOR : GetRSXErrorText := 'A zero lenght vector was specified for the orientation.';
          AAERR_FILEOPEN : GetRSXErrorText := 'An error occured opening the wave file specified.';
          AAERR_CORRUPTFILE : GetRSXErrorText := 'The wave file is corrupted (not valid).';
          AAERR_PARALLELVECTORS : GetRSXErrorText := 'The listeners orientation vectors are parallel.';
          AAERR_ALLOCATED : GetRSXErrorText := 'Sound ressources are allocated or busy.';
          AAERR_INET_INIT : GetRSXErrorText := 'Internet cant be initialized.';
          AAERR_INET_URLERR : GetRSXErrorText := 'Error opening URL.';
          else  GetRSXErrorText := 'Unknown error.';
     end;
end;

procedure InitAudio;
var res : HRESULT;
begin

     // Com initialisieren
     res := CoInitialize(Nil);
     if (res = S_OK) or (res = S_FALSE) then
     begin
        blIsInit := TRUE;
        // RSXAudio-Objekt erzeugen
        res := CoCreateInstance (CLSID_AAudio,Nil,CLSCTX_INPROC_SERVER,IID_IAAudio,RSXAudio);
        if res <> S_OK then
           MessageDlg ('Cant Create RSX-Audio-Object. Please check the RSX- Installation!',mtError,[mbAbort],0);
     end else begin
        blIsInit := FALSE;
        MessageDlg ('Cant initialize COM-Interface!',mtError,[mbAbort],0);
     end;
end;

procedure ExitAudio;
begin
     // RSXAudio freigeben
     if RSXAudio <> Nil then
     begin
        RSXAudio.Release;
        RSXAudio := Nil;
     end;

     // COM-Schnittstelle freigeben
     if blIsInit = TRUE then
     begin
          CoUninitialize;
          blIsInit := FALSE;
     end;
end;

// *************************
//  TVector3D
// *************************
constructor TVector3D.Create (Update : TUpdateProcedure);
begin
     m_Update := Update; // Updatingfunktion merken
     inherited Create;   // und inherited
end;

procedure TVector3D.SetVectorX (value : single);
begin
     m_Vector.X := value;
     if Assigned (m_Update) then
        m_Update;
end;

procedure TVector3D.SetVectorY (value : single);
begin
     m_Vector.Y := value;
     if Assigned (m_Update) then
        m_Update;
end;

procedure TVector3D.SetVectorZ (value : single);
begin
     m_Vector.Z := value;
     if Assigned (m_Update) then
        m_Update;
end;

procedure TAAEmitterModel.SetMinBack (Value : Single);
begin
   m_Emitter.minBack := Value;
   if Assigned (m_Update) then
      m_Update;
end;

procedure TAAEmitterModel.SetMinFront(Value : Single);
begin
   m_Emitter.MinFront := Value;
   if Assigned (m_Update) then
      m_Update;
end;

procedure TAAEmitterModel.SetMaxBack(Value : Single);
begin
   m_Emitter.MaxBack := Value;

   if Assigned (m_Update) then
      m_Update;
end;

procedure TAAEmitterModel.SetMaxFront(Value : Single);
begin
   m_Emitter.MaxFront := Value;

   if Assigned (m_Update) then
      m_Update;
end;

procedure TAAEmitterModel.SetIntensity (Value : Single);
begin
   m_Emitter.Intensity := Value;

   if Assigned (m_Update) then
      m_Update;
end;

constructor TAAEmitterModel.Create (Update : TUpdateProcedure);
begin
     m_Update := Update; // Updatingfunktion merken
     inherited Create;   // und inherited
end;

procedure TAAEnviroment.SetReverbType (Value : AAReverbType);
begin
   m_Enviroment.Reverb := Value;
   if Assigned (m_Update) then
      m_Update;
end;

procedure TAAEnviroment.SetSpeedOfSound (Value : single);
begin
   m_Enviroment.SpeedOfSound := Value;
   if Assigned (m_Update) then
      m_Update;
end;

procedure TAAEnviroment.SetUseRightHand (Value : LongBool);
begin
   m_Enviroment.UseRightHand := Value;
   if Assigned (m_Update) then
      m_Update;
end;

procedure TAAEnviroment.SetCPUBudget (Value : AALocalizeCPU);
begin
   m_Enviroment.CPUBudget := Value;
   if Assigned (m_Update) then
      m_Update;
end;

constructor TAAEnviroment.Create (Update : TUpdateProcedure);
begin
     m_Update := Update; // Updatingfunktion merken
     inherited Create;   // und inherited
end;



initialization
InitAudio;

finalization
ExitAudio;


end.
