{***********************
  Media-Manager
************************
 (c) 1996 by
 Olaf Panz
 Drosselgasse 4
 21436 Marschacht
***********************}
unit UMMAnimatedPicture;

interface
uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs,
  UMMPictureBase,
  UMMPicture,
  UMMAssign,
  UMMTools,
  Memory;

type

 // Datenklasse zum speichern der Animationsbild-Daten:
 TAnimPictData = class
 public
    m_iIdent : Integer; // Identifier des Mediums
    m_iSize : Integer;  // Gre des Mediums
    m_oData : TPictData; // Datensatz des Mediums

    constructor Create (iIdent : Integer);
 end;


 TMMAnimatedPicture = class (TMMPicture)
 private

    m_pMem : PCHAR; // Handle des fr die Bilder allokierten Speichers

 protected
    m_oPictureList : TList; // Liste der Bilddaten

    m_iPictureIndex : Integer; // Aktuell gezeigtes Bild

    procedure SetPictureList (pList : TList);
    procedure SetPictureIndex (iIndex : Integer);
    procedure ClearPictureList; // Bilddatenliste freigeben

 public

    constructor Create (AOwner : TComponent); override;
    destructor Destroy; override;

    property PictureList : TList  write SetPictureList;
    property PictureIndex : Integer read m_iPictureIndex write SetPictureIndex;

 published


 end;

implementation
// ****************************
//     TAnimPictData
// ****************************

constructor TAnimPictData.Create (iIdent : Integer);
begin
   // Identifier merken
   m_iIdent := iIdent;
end;



// ****************************
//     TMMAnimatedPicture
// ****************************

constructor TMMAnimatedPicture.Create (AOwner : TComponent);
begin
   // Listen erzeugen
   m_oPictureList := TList.Create;

   inherited Create (AOwner);
end;

destructor TMMAnimatedPicture.Destroy;
begin

   ClearPictureList; // Bilddatenliste freigeben
   m_oPictureList.Free; // und lschen

   inherited Destroy;

end;

procedure TMMAnimatedPicture.ClearPictureList;
var i,count : integer;
begin
   // Alle Elemente der Daten-Liste freigeben:
   count := m_oPictureList.Count -1;

   for i := 0 to count do
       TAnimPictData(m_oPictureList[i]).Free;
   m_oPictureList.Clear;

   // Globalen Speicher freigeben:
   if m_pMem <> Nil then
   begin
      GlobalFree (HGLOBAL (m_pMem));
      m_pMem := Nil;
   end;

   // Wenn alle Daten im Array gelscht wurden,
   // ist auch PictData ungltig!
   PictData.pData := Nil;
   FPicture := 0;
end;


procedure TMMAnimatedPicture.SetPictureList (pList : TList);
var oData : TAnimPictData;
    i,count,SrcWidth32 : Integer;
    hAssign : TAssignHandle;
    iTotalSize : Integer;
    iAktPos : PCHAR;
begin
   // Alte LIste lschen und neue hineinkopieren:
   ClearPictureList;

   // Medienzugriff ffnen:
   hAssign := MMAOpenMedia (MMGetForm (Self).Name);

   // Liste mit neuen Daten aufbauen:
   count := pList.count -1;
   iTotalSize := 0;

   for i := 0 to count do
   begin
      // Datensatz allokieren
      oData := TAnimPictData.Create (Integer(pList[i]));

     // Bild laden:
      // Die Gre des Mediums ermitteln
      MMAGetMedia (hAssign,oData.m_iIdent,@(oData.m_oData),8); // nur Width,Height laden
      SrcWidth32 := Norm32(oData.m_oData.iWidth);
      // und in Klasse merken
      // Speicher jeweils auf 32Bit normieren!
      oData.m_iSize := Norm32(SrcWidth32 * oData.m_oData.iHeight + 8);

      // Gesamten Speicherbedarf ermitteln
      iTotalSize := iTotalSize + oData.m_iSize;

      m_oPictureList.Add (oData); // und der Liste hinzufgen
   end;

   // Speicher allokieren
   m_pMem := Pointer (GlobalAlloc (GMEM_FIXED,iTotalSize));
   if m_pMem = Nil then
   begin
      MessageDlg ('Cant allocate Animation Memory for '+Name,mtError,[mbAbort],0);
   end else begin

      iAktPos := m_pMem;  // Wird nun als Speicher-Offset verwendet
      // Speicher auf Bilder verteilen und Daten laden:
      for i := 0 to count do
      begin
         // Akt. Datensatz ermitteln
         oData := TAnimPictData (m_oPictureList[i]);
          // Gesamtes Bild laden
         MMAGetMedia (hAssign,oData.m_iIdent,iAktPos,oData.m_iSize);
         // Zeiger auf Bild in Struktur speichern:
         oData.m_oData.pData := iAktPos;
         // Speicherzeiger weiterzhlen:
         iAktPos := iAktPos + oData.m_iSize;
      end;


   end;

   PictureIndex := m_iPictureIndex;

   MMACloseMedia (hAssign);

end;

procedure TMMAnimatedPicture.SetPictureIndex (iIndex : Integer);
var count : Integer;
    oData : TAnimPictData;
begin
   count := m_oPictureList.Count;

   if count > 0 then // nur dann etwas tun, wenn Bilder vorhanden!
   begin

      // Ist index negativ?
      if iIndex < 0 then
         iIndex := -iIndex;

      // Ist Index zu gro?
      if iIndex >= count then
         iIndex := iIndex div count;

      // Neue Daten kopieren:
      m_iPictureIndex := iIndex; // Index merken

      // Datensatz ermitteln:
      oData := TAnimPictData (m_oPictureList [m_iPictureIndex]);

      // Datensatz kopieren:
      memcpy (@PictData,@oData.m_oData,sizeof (PictData));

      // Identifier setzen:
      FPicture := oData.m_iIdent;

      // Eigenen Bereich neu zeichnen lassen:
      ReDraw;

   end;
end;


end.
