{***********************
  Media-Manager
************************
 (c) 1996 by
 Olaf Panz
 Drosselgasse 4
 21436 Marschacht
***********************}
unit UMMAssign;

interface

uses SysUtils,WinTypes,dialogs,Forms,classes,UMMTools;

type TAssignHandle = Pointer;

function MMAOpenMedia (FormName  : string): TAssignHandle;

// Medium Media des Zugriffs Handle in Buffer mit
// maximal BufSize Zeichen kopieren
procedure MMAGetMedia (Handle : TAssignHandle;Media : Integer;
                      Buffer : Pointer;BufSize : Integer);

// Medium Media als Temporre Datei auf FP kopieren und den
// Dateiname zurckliefern. Dateiname wird beim Aufruf von MMCloseMedia
// ungltig.
function MMAGetMediaFile (Handle : TAssignHandle;Media : Integer) : string;

// Medienzugriff schlieen:
procedure MMACloseMedia (var Handle : TAssignHandle);

implementation


// ffnet den Media- Zugriff fr FormName
function MMOpenMedia (FormName  : PChar) : TAssignHandle;
   stdcall; external 'MMassign';
// Medium Media des Zugriffs Handle in Buffer mit
// maximal BufSize Zeichen kopieren
procedure MMGetMedia (Handle : TAssignHandle;Media : Integer;
   Buffer : Pointer;BufSize : Integer); stdcall; external 'MMassign';

// Medium Media als Temporre Datei auf FP kopieren und den
// Dateiname zurckliefern. Dateiname wird beim Aufruf von MMCloseMedia
// ungltig.
procedure MMGetMediaFile (Handle : TAssignHandle;Media : Integer;szFileBuf : pchar);
   stdcall; external 'MMassign';


// Medienzugriff schlieen:
procedure MMCloseMedia (Handle : TAssignHandle);
   stdcall; external 'MMassign';

function MMAOpenMedia (FormName  : string): TAssignHandle;
var stFormName : array [0..255] of char;
begin
     strPcopy (stFormName,FormName);
     MMAOpenMedia := MMOpenMedia (stFormName);
end;

// Medium Media des Zugriffs Handle in Buffer mit
// maximal BufSize Zeichen kopieren
procedure MMAGetMedia (Handle : TAssignHandle;Media : Integer;
                      Buffer : Pointer;BufSize : Integer);
begin
     MMGetMedia (Handle,Media,Buffer,BufSize);
end;


// Medium Media als Temporre Datei auf FP kopieren und den
// Dateiname zurckliefern. Dateiname wird beim Aufruf von MMCloseMedia
// ungltig.
function MMAGetMediaFile (Handle : TAssignHandle;Media : Integer) : string;
var szBuf : array [0..MAX_PATH] of char;
begin
     MMGetMediaFile (Handle,Media,szBuf);
     MMAGetMediaFile := szBuf;
end;

// Medienzugriff schlieen:
procedure MMACloseMedia (var Handle : TAssignHandle);
begin
     MMCloseMedia (Handle);
     Handle := Nil;
end;

end.
