{***********************
  Media-Manager
************************
 (c) 1996 by
 Olaf Panz
 Drosselgasse 4
 21436 Marschacht
***********************}
unit UMMBase;

interface

uses WinTypes,SysUtils,dialogs;

{ Schnittstellenfunktionen zu MMBase : }
procedure MMPBSetValue (stForm,stComponent,stProperty,stValue : string);
function MMPBGetValue (stForm,stComponent,stProperty : string) : string;
procedure MMPBDelValue (stForm,stComponent,stProperty : string);
function MMPBGetKeyCount (stForm,stComponent : string) : DWORD;
function MMPBGetKey (stForm,stComponent : string;uPos : DWORD) : PCHAR;
function MMPBRenameForm (stOldName,stNewName : string) : BOOL;
function MMPBRenameComponent (stForm,stOldName,stNewName : string) : BOOL;
function MMPBGetMediaPath (stForm : string) : string;
function MMPBGetInstallPath : string;

// Ermittelt eindeutigen Identifier fr ein Neues Medium
function MMPBRegisterMedia (const stForm,stMediaName,stMediaType : string) : Integer;

// Ermittelt Arbeitsdatei + Name fr Medium
function MMPBGetMediaWorkFile (const stForm : string;Identifier : Integer) : string;

// Identifier eines Mediums nach dem Namen ermitteln
function MMPBGetIdentifier (const stForm,stName : string) : Integer;

// Anghand eines Pre-Names einen eindeutigen Mediennamen ermitteln
// und zurckliefern
function MMPBGetUniqueName (const stForm,stName : string) : string;

// Alle Daten zu einem Medium entfernen, Identifier freigeben
procedure MMPBDestroyMedia (const stForm : string;iIdentifier : Integer);


{ Konstante fr Kategorien in Datenbasis }
const cPicture = 'Picture';
      cPalette = 'Palette';
      cSound = 'Sound';    
      cPictureComponents = 'PictureComponents';
      cType = 'Type';
      cIdentifier = 'Identifier';
      cSource = 'Source';

      // Konstante fr feste Dateien
      cOptions = 'MediaManOptions';

      // Konstante fr Optionen-Datei:
      cCustomColor = 'CustomColor';   // Chapter
      cMisc = 'Misc';                 // Chapter
      cExecute = 'Execute';           // Chapter
      cReturn = 'ReturnValue';        // Value
      cDistribute = 'Distributions';


implementation

const MMPBBufferSize  = 270;

{ Funktionen in MMBase.DLL : }
procedure PBSetValue (cszForm,cszComponent,cszProperty,cszValue : PCHAR);
          stdcall; external 'MMBase';
function PBGetValue (cszForm,cszComponent,cszProperty :PCHAR) : PCHAR;
         stdcall; external 'MMBase';
procedure PBDelValue (cszForm,cszComponent,cszProperty : PCHAR);
         stdcall; external 'MMBase';
function PBGetKeyCount (cszForm,cszComponent : PCHAR) : DWORD;
         stdcall; external 'MMBase';
function PBGetKey (cszForm,cszComponent : PCHAR;uPos : DWORD) : PCHAR;
         stdcall; external 'MMBase';
function PBRenameForm (cszOldName,cszNewName : PCHAR) : LONGBOOL;
         stdcall; external 'MMBase';
function PBRenameComponent (cszForm,cszOldName,cszNewName : PCHAR) : LONGBOOL;
         stdcall; external 'MMBase';
function PBGetMediaPath (cszForm : PCHAR) : PCHAR;
         stdcall; external 'MMBase';
function PBGetInstallPath : PCHAR;
         stdcall; external 'MMBase';

{ Schnittstellenfunktionen zu MMBase : }
procedure MMPBSetValue (stForm,stComponent,stProperty,stValue : string);
var szForm,szComponent,szProperty,szValue : array [0..MMPBBufferSize] of char;
begin
     strPcopy (szForm,stForm);
     strPcopy (szComponent,stComponent);
     strPcopy (szProperty,stProperty);
     strPcopy (szValue,stValue);

     PBSetValue (szForm,szComponent,szProperty,szValue);
end;

function MMPBGetValue (stForm,stComponent,stProperty : string) : string;
var szForm,szComponent,szProperty : array [0..MMPBBufferSize] of char;
begin
     strPcopy (szForm,stForm);
     strPcopy (szComponent,stComponent);
     strPcopy (szProperty,stProperty);

     MMPBGetValue := PBGetValue (szForm,szComponent,szProperty);

end;

procedure MMPBDelValue (stForm,stComponent,stProperty : string);
var szForm,szComponent,szProperty : array [0..MMPBBufferSize] of char;
begin
     strPcopy (szForm,stForm);
     strPcopy (szComponent,stComponent);
     strPcopy (szProperty,stProperty);

     PBDelValue (szForm,szComponent,szProperty);
end;

function MMPBGetKeyCount (stForm,stComponent : string) : DWORD;
var szForm,szComponent : array [0..MMPBBufferSize] of char;
begin
     strPcopy (szForm,stForm);
     strPcopy (szComponent,stComponent);

     MMPBGetKeyCount := PBGetKeyCount (szForm,szComponent);
end;

function MMPBGetKey (stForm,stComponent : string;uPos : DWORD) : PCHAR;
var szForm,szComponent : array [0..MMPBBufferSize] of char;
begin
     strPcopy (szForm,stForm);
     strPcopy (szComponent,stComponent);

     MMPBGetKey := PBGetKey (szForm,szComponent,uPos);
end;

function MMPBRenameForm (stOldName,stNewName : string) : BOOL;
var szOldName,szNewName : array [0..MMPBBufferSize] of char;
begin
     strPcopy (szOldName,stOldName);
     strPcopy (szNewName,stNewName);

     MMPBRenameForm := PBRenameForm (szOldName,szNewName);
end;

function MMPBRenameComponent (stForm,stOldName,stNewName : string) : BOOL;
var szForm,szOldName,szNewName : array [0..MMPBBufferSize] of char;
    blErg : BOOL;
    iCount : Integer;
    stChapter,stValue : string;
begin
     strPcopy (szForm,stForm);
     strPcopy (szOldName,stOldName);
     strPcopy (szNewName,stNewName);
     blErg := PBRenameComponent (szForm,szOldName,szNewName);

     stOldName := Copy (stOldName,4,Length (stOldName));
     stNewName := Copy (stNewName,4,Length (stNewName));

     // in Medien-Eintrgen 'Component=' ndern
     iCount := MMPBGetKeyCount (stForm,'') -1;
     while iCount >= 0 do
     begin
          stChapter := MMPBGetKey (stForm,'',iCount);

          if Copy (stChapter,0,3) = 'MM*' then
          begin // Handelt es sich um ein Medien-Eintrag??
             stValue := MMPBGetValue (stForm,stChapter,'Component');

             if stValue = stOldName then
             begin
                MMPBSetValue (stForm,stChapter,'Component',stNewName);
             end;

          end;

          iCount := iCount -1;
     end;



     MMPBRenameComponent := blErg;
end;

function MMPBGetMediaPath (stForm : string) : string;
var szForm : array [0..MMPBBufferSize] of char;
begin
     strPcopy (szForm,stForm);

     MMPBGetMediaPath := PBGetMediaPath (szForm);
end;

// Ermittelt eindeutigen Identifier fr ein Neues Medium
function MMPBRegisterMedia (const stForm,stMediaName,stMediaType : string) : Integer;
var count,i : Integer;
    szMediaName,szIdent,szForm : array [0..MMPBBufferSize] of char;
    szkey : PCHAR;
    Found : Boolean;
begin
    // ersten freien Identifier ermitteln:
    // Form  in nullterminiert wandlen
    strPcopy (szForm,stForm);

    // Anzahl der Schlssel
    count := PBGetKeyCount (szForm,cIdentifier);
    i := 1; // Kleinster Identifier ist 1 !!
    Found := FALSE;
    while (count >= i) and (Found = FALSE) do
    begin
       StrPCopy (szIdent,IntToStr (i));
       szKey := PBGetValue (szForm,cIdentifier,szIdent);
       if strlen (szKey) = 0 then
          Found := TRUE
       else
          i := i +1;
    end;


    // Identifier Registrieren:
    StrPCopy (szIdent,IntToStr (i));
    StrPCopy (szMediaName,stMediaName);
    PBSetValue (szForm,cIdentifier,szIdent,szMediaName);

    // Medium registrieren
    StrPCopy (szIdent,'MM*'+szMediaName);
//    StrPCopy (szType,cType);
    StrPCopy (szMediaName,stMediaType);
    PBSetValue (szForm,szIdent,cType,szMediaName);

    MMPBRegisterMedia := i;
end;

// Alle Daten zu einem Medium entfernen, Identifier freigeben
procedure MMPBDestroyMedia (const stForm : string;iIdentifier : Integer);
var szIdent,szForm : array [0..MMPBBufferSize] of char;
    stChapter : string;
begin
    // Chaptername ermitten
    StrPCopy (szIdent,IntToStr (iIdentifier));
    StrPCopy (szForm,stForm);
    stChapter := 'MM' + PBGetValue (szForm,cIdentifier,szIdent);

    // Identifier entfernen:
    PBDelValue (szForm,cIdentifier,szIdent);

    // Chapter zum Medium entfernen
    StrPCopy (szIdent,stChapter);
    PBDelValue (szForm,szIdent,'');
end;

// Ermittelt Arbeitsdatei + Name fr Medium
function MMPBGetMediaWorkFile (const stForm : string;Identifier : Integer) : string;
var szForm : array [0..MMPBBufferSize] of char;
begin
    StrPCopy (szForm,stForm);
    // Arbeitsverzeichnis des Formulars ermitteln, Filename hinzu und fertig!
    MMPBGetMediaWorkFile := PBGetMediaPath (szForm) + 'Media.' + IntToStr (Identifier);
end;

function MMPBGetIdentifier (const stForm,stName : string) : Integer;
var szForm : array [0..MMPBBufferSize] of char;
    szKey,szValue : PCHAR;
    Count,i,ret : Integer;
begin
   StrPCopy (szForm,stForm);

   // Anzahl der Schlssel
   count := PBGetKeyCount (szForm,cIdentifier);

   ret := 0;

   // Alle Werte nach stName durchsuchen:
      for i := 0 to Count-1 do // Alle Werte nach stName durchsuchen:
   begin
      szKey := PBGetKey (szForm,cIdentifier,i);
      szValue := PBGetValue (szForm,cIdentifier,szKey);
      if szValue = stName then
         ret := StrToInt (szKey);
   end;
   MMPBGetIdentifier := ret;
end;

// Anghand eines Pre-Names einen eindeutigen Mediennamen ermitteln
// und zurckliefern
function MMPBGetUniqueName (const stForm,stName : string) : string;
var szForm,szErg : array [0..MMPBBufferSize] of char;
    szKey,szValue : PCHAR;
    stErg : string;
    Count,i,iIndex : Integer;
    blErg: Boolean;
begin
   // Formname als Null-terminated
   StrPCopy (szForm,stForm);

   // Anzahl der Schlssel
   count := PBGetKeyCount (szForm,cIdentifier);

   // Index-Zhler zurck setzen
   iIndex := 0;
   blErg := FALSE;

   // Alle Werte nach stName durchsuchen:
   while blErg = False do begin
      blErg := TRUE;
      stErg := stName + IntToStr (iIndex);
      iIndex := iIndex +1;
      StrPCopy (szErg,stErg);

      for i := 0 to Count-1 do // Alle Werte nach stErg durchsuchen:
      begin
         szKey := PBGetKey (szForm,cIdentifier,i);
         szValue := PBGetValue (szForm,cIdentifier,szKey);
         if szValue = stErg then
            blErg := FALSE; // Wenn vorhanden, kein Ergebnis gefunden
      end;
   end;

   MMPBGetUniqueName := stErg;

end;

function MMPBGetInstallPath : string;
begin
   MMPBGetInstallPath := PBGetInstallPath;
end;


end.
