{***********************
  Media-Manager
************************
 (c) 1996 by
 Olaf Panz
 Drosselgasse 4
 21436 Marschacht
***********************}
unit UMMComponentEdit;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs,dsgnintf,UMMMediaManager,UMMTools,UMMBase,
  UMMPicture,UMMCreateDistribution;

{ Basistyp des MM-Komponenten-Editors}
type
  TMMComponentEdit = class(TComponentEditor)
  private
    { Private-Deklarationen }
  protected
    { Protected-Deklarationen }
    // Media-Manager starten
    procedure ExecMediaMan;

    // Distribution erstellen
    procedure ExecDistribution;

  public
    { Public-Deklarationen }

     function GetVerb(Index: Integer): string; override;
     function GetVerbCount: Integer; override;
     procedure ExecuteVerb(Index: Integer); override;

  end;


implementation

function TMMComponentEdit.GetVerb(Index: Integer): string;
begin
   case Index of
      0 : GetVerb := 'Me&dia Manager';
      1 : GetVerb := 'Distribution erstellen';
   end;
end;


function TMMComponentEdit.GetVerbCount: Integer;
begin
     GetVerbCount := 2;
end;

procedure TMMComponentEdit.ExecuteVerb(Index: Integer);
begin
     case Index of
          0 : ExecMediaMan;
          1 : ExecDistribution;
     end;
end;

procedure TMMComponentEdit.ExecMediaMan;
var Manager : TMMMediaManager;
    Form : TForm;
begin
   // Zeiger auf Formular ermitteln
   Form := MmGetForm (Component);
   Manager := TMMMediaManager.CreateEx (Application,Form);
   Manager.ShowModal;
   Manager.Free;

   Designer.Modified;

end;

procedure TMMComponentEdit.ExecDistribution;
begin
   MMCreateDistributionDlg (Application);
end;

end.
