{***********************
  Media-Manager
************************
 (c) 1996 by
 Olaf Panz
 Drosselgasse 4
 21436 Marschacht
***********************}
unit UMMComponentNameProperty;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs,dsgnintf,UMMBase,UMMTools;

type
  TMMComponentNameProperty = class(TComponentNameProperty)
  private
    { Private-Deklarationen }
  protected
    { Protected-Deklarationen }
  public
    { Public-Deklarationen }

    procedure SetValue(const Value: string); override;

    function GetValue : string; override;

  end;

// Schecken, ob Daten von bereits gelschten
// Komponenten vorhanden sind
procedure CheckForDeletedComponets (Component : TComponent);

implementation

function TMMComponentNameProperty.GetValue : string;
begin
     CheckForDeletedComponets ( GetComponent (0));
     GetValue := inherited GetValue;
end;


procedure TMMComponentNameProperty.SetValue(const Value: string);
var stNewName,stOldName : string;
begin
   { alten Namen merken }
   stOldName := GetComponent(0).Name;

   { bergabe von Value an inherited, berprfung des Names nach Delphi-Regeln }
   inherited SetValue (Value);

   { genderten Namen ermitteln: }
   stNewName := GetValue;

   { Wurde der Name gendert ?}
   if stNewName <> stOldName then
      MMPBRenameComponent (MMGetForm (GetComponent(0)).Name,'MM*' + stOldName,'MM*' + stNewName);

end;

// Schecken, ob Daten von bereits gelschten
// Komponenten vorhanden sind
procedure CheckForDeletedComponets (Component : TComponent);
var Form : TForm;
    CompCount,CompI : Integer;
    ChapCount,ChapI : Integer;
    stValue,stChapter : string;
    stFormName : string;
    blFound : Boolean;
begin
   // Formular ermitteln
   Form := MMGetForm (Component);
   stFormName := Form.Name;

   // Counter ermitteln
   ChapCount := MMPBGetKeyCount (stFormName,'') -1; // Chapter-Counter
   CompCount := Form.ComponentCount ; // Componenten-Counter

   for ChapI := 0 to ChapCount do
   begin
      // Chapter ermitteln
      stChapter := MMPBGetKey (stFormName,'',ChapI);
      if Copy (stChapter,0,3) = 'PC*' then
      begin
         // 'PC*' entfernen
         stValue := Copy (stChapter,4,Length (stChapter));

         // ber alle Komponenten des Formulars iterieren:
         CompI := 0;
         blFound := FALSE;


         while (CompI < CompCount) and (blFound = FALSE) do
         begin
   {         MessageDlg (Form.Components[CompI].Name+ ' = '+stValue,
                       mtInformation,[mbYes],0); }

            if Form.Components[CompI].Name = stValue then
               blFound := TRUE; // Gefunden!!
            CompI := CompI +1;
         end;

         // Daten entfernen, wenn nicht gefunden:
         if blFound = FALSE then begin
            // Daten ber Komponente entfernen
{            MessageDlg ('Del Value:'+stFormName+' Chapter:'+stChapter,
                      mtInformation,[mbYes],0); }

            MMPBDelValue (stFormName,stChapter,'');

         end;
      end;
   end;

end;



end.
