{***********************
  Media-Manager
************************
 (c) 1996 by
 Olaf Panz
 Drosselgasse 4
 21436 Marschacht
***********************}
unit UMMConvertPicture;

interface

uses WinTypes,SysUtils,dialogs,ddeml,forms,
     Memory,
     UMMTools,
     UMMBase,
     UMMAssign,
     UMMPaintArea;

procedure MMConvertPicture (stForm : string;iIdentifier : Integer);

// Alle Bilder eines Formulars updaten
procedure UpdateAllPicture (Form : TForm);

function DDECBack(CallType, Fmt: UINT; ConvX: HConv; hsz1, hsz2: HSZ;
     Data: HDDEData; Data1, Data2: DWORD): HDDEData stdcall; export;

implementation

const DDE_SERVICE_NAME = 'MediaManager';
      DDE_TOPIC_NAME = 'PictureConvert';
      MMPBBufferSize = 4 * MAX_PATH;

// Instanz des Bildkonvertierers
var dwDdeInstance : LongInt;
    conv : HCONV;

procedure DDEExecute (stCommand : string);
var szCommand : array [0..MMPBBufferSize] of char;
    hKey :hSz;
begin
   if Conv <> 0 then
   begin
      // Schlssel erzeugen
      strPcopy (szCommand,stCommand);

      hKey := DdeCreateStringHandle (dwDdeInstance,szCommand,CP_WINANSI);

            DdeClientTransaction (Nil,0,Conv,hKey,
                           CF_TEXT,XTYP_REQUEST,60000,Nil);// Timeout = 5Min

      // Schlssel freigeben
      DdeFreeStringHandle (dwDdeInstance,hKey);
   end;
end;

// Bearbeite Bilddaten zu Formular cszFormName des Bilds iIdentifier
procedure MMConvertPicture (stForm : string;iIdentifier : Integer);
var stComponent,stSource,stDither,stWidth,stHeight,stTrans,stDest : string;
    stChapter : string;
begin
   //Chapter ermitteln
   stChapter := 'MM*' + MMPBGetValue (stForm,cIdentifier,IntToStr (iIdentifier));

   stComponent := MMPBGetValue (stForm,stChapter,'Component');

   if stComponent = '' then
   begin
      stWidth := MMPBGetValue (stForm,stChapter,'Width');
      stHeight := MMPBGetValue (stForm,stChapter,'Height');
   end else begin
      stWidth := MMPBGetValue (stForm,'PC*'+stComponent,'Width');
      stHeight := MMPBGetValue (stForm,'PC*'+stComponent,'Height');
   end;

//   MessageDlg ('Ident:' + IntToStr (iIdentifier) + 'Component: ' + stComponent + 'Width:' + stWidth +
//            ' Height:' + stHeight,mtInformation,[mbYes],0);

   stSource := MMPBGetValue (stForm,stChapter,'Source');
   stDither := MMPBGetValue (stForm,stChapter,'Dither');


   stTrans := MMPBGetValue (stForm,stChapter,'Transparency');

   stDest := MMPBGetMediaPath (stForm) + 'Media.' + IntToStr (iIdentifier);


   DdeExecute (stSource + '|' +
               stDither + '|' +
               stWidth + '|' +
               stHeight + '|' +
               stTrans + '|' +
               stDest + '|' +
               stForm);
   ;
end;

procedure InitUnit;
var Startup : TStartupInfo;
    ProcessInfo : TProcessInformation;
    hService,hTopic : HSZ;
begin

    // Ddeml init:
    if DdeInitialize (dwDdeInstance,DDECBack,APPCMD_CLIENTONLY,0) =
          DMLERR_NO_ERROR then
    begin
      hService := DdeCreateStringHandle (dwDdeInstance,DDE_SERVICE_NAME,CP_WINANSI);
      hTopic := DdeCreateStringHandle (dwDdeInstance,DDE_TOPIC_NAME,CP_WINANSI);

      Conv := DdeConnect (dwDdeInstance,HService,hTopic,Nil);
      if Conv = 0 then
      begin
         // Bildkonvertierer laden
         memset (@Startup,0,sizeof (Startup));
         Startup.cb := sizeof (Startup);
         if CreateProcess (Nil,'MMpiconv.exe',Nil,Nil,FALSE,NORMAL_PRIORITY_CLASS,
             Nil,Nil,Startup,ProcessInfo) = FALSE then
               MessageDlg ('Unable to load Picture-Converter. Please check installation!',
                        mtError,[mbYes],0);

         // Warten, bis Prozess bereit ist:
         WaitForInputIdle (ProcessInfo.hProcess,INFINITE);

         // Erneut versuchen, eine Verbindung herzustellen:
         Conv := DdeConnect (dwDdeInstance,HService,hTopic,Nil);
         if Conv = 0 then
         begin
            MessageDlg ('Connection to PictureConverter failed!',mtError,[mbAbort],0);
         end;
      end;

      DdeFreeStringHandle (dwDdeInstance,hService);
      DdeFreeStringHandle (dwDdeInstance,hTopic);

   end else begin
       MessageDlg ('Initialization of DDEML failed. Please check your installation.',
                  mtError,[mbAbort],0);
   end;

end;

procedure ExitUnit;
begin

   // DDE beenden:
   if Conv <> 0 then
      DdeDisconnect (Conv);
   if dwDdeInstance <> 0 then
      DdeUnInitialize (dwDdeInstance);
end;

function DDECBack(CallType, Fmt: UINT; ConvX: HConv; hsz1, hsz2: HSZ;
	  Data: HDDEData; Data1, Data2: DWORD): HDDEData;
begin
  case CallType of
     XTYP_DISCONNECT : begin
			 Conv := 0;
			 DDECBack := 1;
                       end;

     else              DDECBack := 0;

  end;


end;

procedure UpdateAllPicture (Form : TForm);
var count,i : Integer;
    stKey,stChapter,stFormName : string;

begin
   stFormName := Form.Name;

   // Anzahl der Medien ermitteln:
   count := MMPBGetKeyCount (stFormName,cIdentifier) -1;
   while count >= 0 do
   begin
      stKey := MMPBGetKey (stFormName,cIdentifier,count);
      stChapter := 'MM*' + MMPBGetValue (stFormName,cIdentifier,stkey);

      // Beschreibt dieses Chapter ein Picture?
      if MMPBGetValue (stFormName,stChapter,cType) = cPicture then
      begin
         // und konvertieren
         try
            MMConvertPicture (stFormName,StrToInt (stkey));
         except
         end;
      end;


      count := count -1;
   end;

      // Untergeordnete Componenten nach TMMWinGControl durchsuchen und NewPalette aufrufen
   for i := 1 to Form.ComponentCount do begin
       if Form.Components[i-1] is TMMPaintArea then
          // Palette in Komponente neu laden
          (Form.Components[i-1] as TMMPaintArea).NewPalette;
   end;

end;


initialization
   InitUnit;

finalization
   ExitUnit;

end.
