{***********************
  Media-Manager
************************
 (c) 1996 by
 Olaf Panz
 Drosselgasse 4
 21436 Marschacht
***********************}
unit UMMCreateDistribution;

interface

uses   Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
       StdCtrls, Buttons, ComCtrls,shellapi,
       UMMDistribute,
       UMMBase,
       UMMCreateDistributionDialog,
       UMMSelectDistribution,
       UMMINIFile,
       UMMFileSys;

const
     RSXPath = 'Intel-RSX';
     DirectXPath = 'Direct-X';
     WinGPath = 'MS-WinG';
     RedistPath = 'ReDistributable';

type
  TInclude = (WinG,RSX);
  TIncludes = set of TInclude;

procedure CreateCopyright (pLog: TMMCreateDistributionDialog;pBuf : pchar);
procedure CreateMediaFile (pLog : TMMCreateDistributionDialog;stForm,stMediaFile : string);
procedure CheckLibrarys (stForm : string;var Includes : TIncludes);

procedure MMCreateDistribution (AOwner : TComponent;stDistributionName : string);

// Dialogboxen zur Distribution + Dirstribution erstellen:
procedure MMCreateDistributionDlg (AOwner : TComponent);


implementation

procedure MMCreateDistributionDlg (AOwner : TComponent);
var Select : TMMSelectDistribution;
    Distribute : TMMDistribute;
    blErg : Integer;
    stSel : string;
begin
   // Distribution auswhlen
   Select := TMMSelectDistribution.Create (AOwner);

   blErg := Select.ShowModal;

   // Ergebnis abfragen
   stSel := Select.Selection;

   // Dialog-Ressourcen freigeben
   Select.Free;
   if (blErg = mrOK) and (stSel <> '') then
   begin
      Distribute := TMMDistribute.CreateEx (AOwner,stSel);

      // Dialog ausfhren:
      blErg := Distribute.ShowModal;

      // Dialogressourcen freigeben
      Distribute.Free;

      if blErg = mrOK then
      begin
         // Disribution erstellen
         MMCreateDistribution (AOwner,stSel);
      end;

   end;
end;

procedure MMCreateDistribution (AOwner : TComponent;stDistributionName : string);
var Log : TMMCreateDistributionDialog;
    Count : Integer;
    stInstallPath,stChapter,stForm,stDistributionPath : string;
 {   FileOP : TSHFileOpStruct;
   szBuffer : array [0..MAX_PATH] of char; }
    Include : TIncludes;
    stSource,stDest : string;
begin
     // Dialog erzeugen
     Log := TMMCreateDistributionDialog.Create (AOwner);

     Log.Show; // und parall anzeigen:

     Log.FontStyle := [fsBold,fsUnderline];
     Log.FontColor := clBlue;
     Log.Text := 'Distribution '+stDistributionName + ' erzeugen:';
     Log.FontStyle := [];
     Log.FontColor := clBlack;

     // Disribution-Chapter erzeugen
     stChapter := 'Distribute*'+ stDistributionName;

     // Distribution-Verzeichnis erzeugen
     stDistributionPath := MMPBGetValue (cOptions,stChapter,'Path');
     if stDistributionPath = '' then
     begin
        stDistributionPath := ExtractFileDir (Application.ExeName);
     end;

     stDistributionPath := stDistributionPath + 'Distribution ' +stDistributionName;

     // Distributionsverzeichnis leeren:
     MMDeleteFile (stDistributionPath,Application.Handle,'Entferne alte Distribution...');

     // und erzeugen:
     MMCreatePath (stDistributionPath);

     Log.Text := 'Distributionsverzeichnis: ' + stDistributionPath;


     stDistributionPath := stDistributionPath + '\';
     // ber alle Formulare dieser Distribution iterieren
     try
        Count := StrToInt(MMPBGetValue (cOptions,stChapter,'Count'));
     except
        Count := 0;
     end;

     Include := [];

     while Count > 0 do
     begin
        stForm := MMPBGetValue (cOptions,stChapter,IntToStr (Count));
        // MediaFile fr Formular erzeugen
        CreateMediaFile (Log,stForm,stDistributionPath + Copy (stForm,0,8) + '.Mda');

        CheckLibrarys (stForm,Include);

        Count := Count -1;
     end;

     // Dateien ins Distribution-Verzeichnis kopieren:
     // 1. EXE-Datei
     stSource := MMPBGetValue (cOptions,stChapter,'EXEFile');
     stDest := stDistributionPath + MMExtractFilename (stSource);
     Log.Text := 'Kopiere EXE-Datei...';
     MMCopyFile (stDest,stSource,TRUE,Application.Handle,'Kopiere EXE-Datei');

     // 2. WinG, falls bentigt
     stInstallPath := MMPBGetInstallPath + '\';
     if WinG in Include then
     begin
          stSource := stInstallPath +WinGPath + '\*.*';
          stDest := stDistributionPath + WinGPath;
          MMCopyFile (stDest,stSource,TRUE,Application.Handle,'Kopiere WinG-Treiber');
          Log.Text := 'Kopiere WinG-Treiber...';
     end else begin
          Log.Text := 'WinG wird nicht verwendet.';
          MMDeleteFile (stDistributionPath + WinGPath,Application.Handle,'Lschen WinG-Treiber');
     end;


     // 3. RSX, falls bentigt
     if  RSX in Include then
     begin
          stSource := stInstallPath + RSXPath + '\*.*';
          stDest := stDistributionPath + RSXPath;
          Log.Text := 'Kopiere RSX-Treiber...';
          MMCopyFile (stDest,stSource,TRUE,Application.Handle,'Kopiere RSX-Treiber');
          stSource := stInstallPath +DirectXPath + '\*.*';
          stDest := stDistributionPath + DirectXPath;
          Log.Text := 'Kopiere Direct-X Treiber...';
          MMCopyFile (stDest,stSource,FALSE,Application.Handle,'Kopiere Direct-X Treiber');
     end else begin
          Log.Text := 'RSX wird nicht verwendet.';
          MMDeleteFile (stDistributionPath + RSXPath,Application.Handle,'Lsche RSX-Treiber');
          Log.Text := 'Direct-X wird nicht verwendet.';
          MMDeleteFile (stDistributionPath + DirectXPath,Application.Handle,'Lsche Direct-X Treiber');
     end;

     // 4. Die Dateien fr jede Distribution kopieren
     stSource := stInstallPath + RedistPath + '\';
     Log.Text := 'Kopiere Redistributables...';
     MMCopyFile (stDistributionPath + 'setup2.exe',stSource + 'setup2.exe',TRUE,Application.Handle,'Kopiere Redistributables');
     MMCopyFile (stDistributionPath + 'MMAssign.DLL',stSource + 'MMAssign.DLL',TRUE,Application.Handle,'Kopiere Redistributables');

     // Kontrolle dem Dialog bergeben
     Log.FontStyle := [fsBold];
     Log.FontColor := clBlue;
     Log.Text := '';
     Log.Text := 'Fertig.';
     Log.FontStyle := [];
     Log.FontColor := clBlack;


     Log.Close;
     Log.EnableOK := TRUE;
     Log.ShowModal;

     Log.Free;

end;


procedure CreateMediaFile (pLog : TMMCreateDistributionDialog;stForm,stMediaFile : string);
const BufSize = MAX_PATH * 3;
var pCopyright : array [0..BufSize] of char;
    szFile : array [0..MAX_PATH] of char;
    pos,Count,i,v,temp,temp1 : Integer;
    List : TList;
    stKey,stValue,stPath : string;
    FindData : TSearchRec;
    MediaFile,MFile : THandle;
    blErr : Boolean;
begin
     blErr := FALSE;

     pLog.Text := '';
     pLog.FontStyle := [fsBold];
     pLog.Text := 'Erzeuge Mediendatei: ' + stMediaFile;
     pLog.FontStyle := [];

     // Objektliste erzeugen
     List := TList.Create;

     // Copyright Header erzeugen
     CreateCopyright (pLog,pCopyright);
     // Gre in die Tabelle einfgen:
     List.Add (Pointer (strlen (pCopyright)+1));

     // Medienpfad ermitteln:
     stPath := MMPBGetMediaPath (stForm) +'Media.';

     // Aufbau der Tabelle:

     // Anzahl der Schlssel
     count := MMPBGetKeyCount (stForm,cIdentifier);

     // Anzahl der Medien ausgeben:
     pLog.Text := 'Das Formular enthlt ' + IntToStr (count) + ' Medien.';
     pLog.Text := 'Ermittle die Dateilngen der Medien...';

     i := 0;  // Zhler fr Funde
     while (count > i)  do
     begin
        stKey := MMPBGetKey (stForm,cIdentifier,i);
        stValue := MMPBGetValue (stForm,cIdentifier,stKey);
        i := i +1;
        if stValue <> '' then begin
           // Gre dieses Mediums ermitteln

           if FindFirst (stPath + stKey,faAnyFile,FindData)  = 0 then
           begin
              v := (FindData.FindData.nFileSizeHigh shl 16) or (FindData.FindData.nFileSizeLow);
              List.Add (Pointer (v));
           end else begin
               pLog.FontStyle := [fsItalic,fsBold];
               pLog.FontCOlor := clRed;
               pLog.Text := 'Das Medium mit dem Identifier ' + stValue+ ' liegt nicht als konverierte Mediendatei vor.';
               pLog.Text := 'Die Distribution kann nicht erzeugt werden!';
               pLog.FontCOlor := clBlack;
               pLog.FontStyle := [];
               blErr := TRUE;
           end;

           FindClose (FindData);

        end;
     end;


     if blErr = FALSE then
     begin
        // Mediendatei zum schreiben ffnen:
        strpcopy (szFile,stMediaFile);
        MediaFile := CreateFile (szFile,GENERIC_WRITE,FILE_SHARE_WRITE,
                                 Nil,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,0);

        if MediaFile = INVALID_HANDLE_VALUE then
        begin
           pLog.FontStyle := [fsItalic,fsBold];
           pLog.FontCOlor := clRed;
           pLog.Text := 'Die MedienDatei ' + stMediaFile+ ' kann nicht erzeugt werden!';
           pLog.Text := 'Die Distribution kann nicht erzeugt werden!';
           pLog.FontCOlor := clBlack;
           pLog.FontStyle := [];
        end else begin
            // Tabelle schreiben:

            // 1. Anzahl
            v := List.Count;
            WriteFile (MediaFile,v,4,temp,Nil);

            // Position fr 1. Medium errechnen:
            pos := 4 +  // Anzahl der Medien
                   8 * v + // 8 Byte je Tabellemeintrag
                   8;  // Endeintrag -1

            // Copyrighteintrag in Tabelle
            v := 0;
            WriteFile (MediaFile,v,4,temp,NIL);
            WriteFile (MediaFile,pos,4,temp,NIL);

            pos := pos + Integer (List.Items[0]);

            pLog.Text := 'Datei-Tabelle erzeugen...';

            i := 0;  // Zhler fr Funde
            while (count > i)  do
            begin
               stKey := MMPBGetKey (stForm,cIdentifier,i);
               stValue := MMPBGetValue (stForm,cIdentifier,stKey);
               i := i +1;
               if stValue <> '' then begin
                  // Tabelleneintrag fr diesen Identifier schreiben:
                  // 1. Identifier
                  temp1 := StrToInt (stKey);
                  WriteFile (MediaFile,temp1,4,temp,Nil);
                  // 2. Dateiposition:
                  WriteFile (MediaFile,pos,4,temp,NIL);

                  // Neue Dateiposition errechnen:
                  pos := pos + Integer (List.Items[i]);
               end;
            end;

            // End-Eintrag -1 einfgen:
            temp1 := -1;
            WriteFile (MediaFile,temp1,4,temp,NIL);
            WriteFile (MediaFile,pos,4,temp,NIL);

            // Medien schreiben:
            pLog.FontStyle := [fsBold];
            pLog.Text := 'Medien kopieren...';
            pLog.FontStyle := [];

            // 1. Copyright
            WriteFile (MediaFile,pCopyright,strlen (pCopyright) +1,temp,NIL);

            pLog.Text := ' Schreibe Registrierung: ' + pCopyright;

            i := 0;  // Zhler fr Funde
            while (count > i)  do
            begin
               stKey := MMPBGetKey (stForm,cIdentifier,i);
               stValue := MMPBGetValue (stForm,cIdentifier,stKey);
               if stValue <> '' then begin
                  i := i +1;
                   // Originaldatei ffnen:
                  strpcopy (szFile,stPath + stKEy);
                  mFile := CreateFile (szFile,GENERIC_READ,FILE_SHARE_READ,
                            Nil,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,0);

                  if mFile = INVALID_HANDLE_VALUE then
                  begin
                     pLog.FontStyle := [fsItalic,fsBold];
                     pLog.FontCOlor := clRed;
                     pLog.Text := 'Das Medium mit dem Identifier ' + stValue+ ' kann nicht geffnet werden.';
                     pLog.Text := 'Die Distribution kann nicht erzeugt werden!';
                     pLog.FontCOlor := clBlack;
                     pLog.FontStyle := [];
                  end else begin
                     v := Integer (List.Items[i]); // Dateigre

                     pLog.Text := '   Fge ' + szFile + ' ein.';

                     while v >= (BufSize) do
                     begin
                        ReadFile (mFile,pCopyright,BufSize,temp,NIL);
                        WriteFile (MediaFile,pCopyright,BufSize,temp,NIL);
                        v := v - BufSize;
                     end;

                     // Rest:
                     if v > 0 then
                     begin
                        ReadFile (mFile,pCopyright,v,temp,NIL);
                        WriteFile (MediaFile,pCopyright,v,temp,NIL);
                     end;

                     // Datei schlieen
                     CloseHandle (mFile);
                  end;
               end;
            end;

            // Datei schlieen
            CloseHandle (MediaFile);
        end;
     end; // if blErr = FALSE
     // Liste freigeben
     List.Free;
end;


procedure CreateCopyright (pLog: TMMCreateDistributionDialog;pBuf : pchar);
var hKey : integer;
    i, dwTemp,dwDataSize,dwValueSize : DWORD;
    bfKey,bfValue : array [0..MAX_PATH] of char;
    stCompany,stName : string;
begin
  // Copyright-Block erzeugen
  // PfadNamen der Datenbasis aus der Registry ermitteln:
  if RegOpenKeyEx (HKEY_LOCAL_MACHINE,'Software\Panz\Media Manager\1.0',0,KEY_READ,hKey) = ERROR_SUCCESS then
  begin
     i := 0;
     dwValueSize := MAX_PATH;
     dwDataSize := MAX_PATH;
     while RegEnumValue (hKey,i,bfKey,dwValueSize,Nil,@dwTemp,@bfValue,@dwDataSize) = ERROR_SUCCESS do
     begin
        if bfKey = 'Company' then
           stCompany := bfValue
        else if bfKey = 'Name' then
           stName := bfValue;
        dwValueSize := MAX_PATH;
        dwDataSize := MAX_PATH;
        i := i +1;
     end;
     RegCloseKey (hKey);
  end;

  if (stName = '') and (stCompany = '') then
     stName := 'Unregistered'
  else
     stName := stName + ', ' + stCompany;

  // Ergebnis ausgeben:
  pLog.Text := 'Registrierung fr:';
  pLog.Text := stName;

  strpcopy (pBuf,stName);
end;

procedure CheckLibrarys (stForm : string;var Includes : TIncludes);
var count,i : Integer;
    stKey,stVal : string;
begin

   // ber alle Chapter iterieren:
   count := MMPBGetKeyCount (stForm,'') -1;

   for i := 0 to count do
   begin
      // Schlssel ermitteln und auf den Prfix reduzieren
      stKey := MMPBGetKey (stForm,'',i);

      if Copy (stKey,0,3) = 'MM*' then
      begin
         stVal := MMPBGetValue (stForm,stKey,cType);

         if stVal = cPicture then
            Includes := Includes + [WinG];
         if stVal = cSound then
            Includes := Includes + [RSX];
      end;
   end;

end;

end.
