{***********************
  Media-Manager
************************
 (c) 1996 by
 Olaf Panz
 Drosselgasse 4
 21436 Marschacht
***********************}
unit UMMCreateDistributionDialog;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls, ComCtrls;

type
  TMMCreateDistributionDialog = class(TForm)
    OK: TBitBtn;
    Log: TRichEdit;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }

    FActive : Boolean;

    procedure SetLog (stLog : string);
    procedure SetEnableOK (stVal : Boolean);
    procedure SetFontStyle (FontStyle : TFontStyles);
    procedure SetFontColor (Color : TColor);

  public
    { Public declarations }

  published

     property Text : string write SetLog;
     property EnableOK : Boolean write SetEnableOK ;
     property IsActive : Boolean read FActive;
     property FontStyle : TFontStyles write SetFontStyle;
     property FontColor : TColor write SetFontColor;

  end;


implementation

{$R *.DFM}



procedure TMMCreateDistributionDialog.SetFontStyle (FontStyle : TFontStyles);
begin
     Log.SelAttributes.Style := FontStyle;
end;

procedure TMMCreateDistributionDialog.SetFontColor (Color : TColor);
begin
          Log.SelAttributes.Color := Color;
end;

procedure TMMCreateDistributionDialog.SetLog (stLog : string);
begin
     Log.Lines.Add (stLog);
end;

procedure TMMCreateDistributionDialog.FormCreate(Sender: TObject);
begin
     FActive := TRUE;
     Log.Lines.Clear;
     OK.Enabled := FALSE;
end;

procedure TMMCreateDistributionDialog.SetEnableOK (stVal : Boolean);
begin
     OK.Enabled := stVal;
end;


procedure TMMCreateDistributionDialog.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  FActive := FALSE;
end;

end.
