{***********************
  Media-Manager
************************
 (c) 1996 by
 Olaf Panz
 Drosselgasse 4
 21436 Marschacht
***********************}
unit UMMDistribute;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls,UPathDialog, Dialogs,
  UMMBase;

type
  TMMDistribute = class(TForm)
    Forms: TListBox;
    Label1: TLabel;
    AddForm: TBitBtn;
    DelButton: TBitBtn;
    GroupBox1: TGroupBox;
    SearchExeButton: TBitBtn;
    EXEFile: TLabel;
    PathBox: TGroupBox;
    Path: TLabel;
    SearchPathButton: TBitBtn;
    OK: TBitBtn;
    Help: TBitBtn;
    BitBtn4: TBitBtn;
    OpenDialog: TOpenDialog;
    FormBox: TComboBox;
    procedure FormCreate(Sender: TObject);
    procedure SearchPathButtonClick(Sender: TObject);
    procedure SearchExeButtonClick(Sender: TObject);
    procedure AddFormClick(Sender: TObject);
    procedure DelButtonClick(Sender: TObject);
    procedure OKClick(Sender: TObject);
  private
    { Private declarations }
    m_stDistribution : string;
    m_stChapter : string;

  protected

    procedure InitDialog;

  public
    { Public declarations }

    constructor CreateEx (AOwner : TComponent;Distribution : string);


  end;

implementation

{$R *.DFM}

constructor TMMDistribute.CreateEx (AOwner : TComponent;Distribution : string);
begin
     m_stDistribution := Distribution;

     inherited Create (AOwner);
end;


procedure TMMDistribute.FormCreate(Sender: TObject);
begin
   // Dialog initialisieren

   // berschrift:
   Caption := m_stDistribution;

   // CHapter-Name erzeugen
   m_stChapter := 'Distribute*' + m_stDistribution;

   // Dialog mit Daten fllen
   InitDialog;
end;

procedure TMMDistribute.SearchPathButtonClick(Sender: TObject);
var PathDlg : TPathDialog;
begin
    PathDlg := TPathDialog.Create (Self);
    PathDlg.Caption := 'Pfad fr Distribution auswhlen';
    PathDlg.Path := Path.Caption;

    if PathDlg.Execute = TRUE then
       Path.Caption := PathDlg.Path;

    PathDlg.Free;
end;


procedure TMMDistribute.InitDialog;
var i,count : Integer;
    stVal : string;
begin
   // Ausfhrbare Datei ermitteln:
   EXEFile.Caption := MMPBGetValue (cOptions,m_stChapter,'EXEFile');

   // Pfad setzen
   Path.Caption := MMPBGetValue (cOptions,m_stChapter,'Path');

   // Formularliste einfgen
   try
      count := StrToInt (MMPBGetValue (cOptions,m_stChapter,'Count'));
   except
      count := 0;
   end;

   Forms.Items.Clear;
   if count >= 1 then
   begin
      for i:= 1 to count do
      begin
         Forms.Items.Add (MMPBGetValue (cOptions,m_stChapter,IntToStr (i)));
      end;

      Forms.ItemIndex := 0;
   end;

   // Formularvorschlagsliste zusammenstellen
   count := MMPBGetKeyCount ('','');
   FormBox.Items.Clear;

   if count >= 1 then
   begin
      count := count -1;

      for i := 0 to count do
      begin
         stVal := MMPBGetKey ('','',i);

         if (Forms.Items.IndexOf (stVal) < 0) and (stVal <> cOptions) then
         begin
            FormBox.Items.Add (stVal);
         end;
      end;

      if count >= 0 then
         FormBox.ItemIndex := 0

   end;


end;


procedure TMMDistribute.SearchExeButtonClick(Sender: TObject);
begin
     OpenDialog.FileName :=  EXEFile.Caption;

     if OpenDialog.Execute = TRUE then
     begin
        EXEFile.Caption := OpenDialog.FileName;
     end;
end;

procedure TMMDistribute.AddFormClick(Sender: TObject);
var stNew : string;
    index : Integer;
begin
   index := FormBox.ItemIndex;
   if index >= 0 then
   begin
      stNew := FormBox.Items[index];

      if stNew <> '' then
      begin
         Forms.Items.Add (stNew);
         FormBox.Items.Delete (index);
      end;

      if Forms.Items.Count > 0 then
         Forms.ItemIndex := 0;

      if FormBox.Items.Count > 0 then
         FormBox.ItemIndex := 0
      else begin
         FormBox.Text := '';
         FormBox.Repaint;
      end;

   end;

end;

procedure TMMDistribute.DelButtonClick(Sender: TObject);
var stNew : string;
    index : integer;
begin
   index := Forms.ItemIndex;

   if index >= 0 then
   begin
      stNew := Forms.Items[index];
      if stNew <> '' then
      begin
         FormBox.Items.Add (stNew);
         Forms.Items.Delete (index);
      end;

      if Forms.Items.Count > 0 then
         Forms.ItemIndex := 0;

      if FormBox.Items.Count > 0 then
         FormBox.ItemIndex := 0
      else
         FormBox.Text := '';

   end;
end;

procedure TMMDistribute.OKClick(Sender: TObject);
var i,count : integer;
begin
   // Distributions-Chapter lschen:
   MMPBDelValue (cOptions,m_stChapter,'');

   // Ausfhrbare Datei ermitteln:
   MMPBSetValue (cOptions,m_stChapter,'EXEFile',EXEFile.Caption);

   // Pfad setzen
   MMPBSetValue (cOptions,m_stChapter,'Path',Path.Caption);

   // Formularliste schreiben
   count := Forms.Items.Count;
   // Anzahl der Elemente schreiben
   MMPBSetValue (cOptions,m_stChapter,'Count',IntToStr (count));

   if count >= 1 then
   begin
      count := count -1;
      for i := 0 to count do
      begin
         MMPBSetValue (cOptions,m_stChapter,IntToStr (i+1),Forms.Items[i]);
      end;
   end;



end;

end.
