{***********************
  Media-Manager
************************
 (c) 1996 by
 Olaf Panz
 Drosselgasse 4
 21436 Marschacht
***********************}
unit UMMFileSys;

interface

uses WinTypes,SysUtils;

function MMPathExist (stPath : string) : Integer;
procedure MMCreatePath  (stPath : string);
function MMGet83Name (stLongName : string) : string;
procedure MMCreateLink (stPathObj,stPathLink,stDesc : string);
procedure MMCopyFile (stDest,stSource : string;blOverwrite : Bool;hParent : HWND;stCaption : string);
function MMExtractPath (stFile : string) : string;
function MMExtractFilename (stFile : string) : string;
procedure MMDeleteFile (stFile : string;hParent : HWND;stCaption : string);

implementation

function FSYSPathExist (cszPath : pchar) : Integer; stdcall; external 'MMTools';
procedure FSYSCreatePath (cszPath : pchar); stdcall; external 'MMTools';
function FSYSGet83Name (cszLongName : pchar) : pchar; stdcall; external 'MMTools';
procedure FSYSCreateLink (cszPathObj,cszPathLink,cszDec : pchar); stdcall; external 'MMTools';
procedure FSYSCopyFile (cszDest,cszSource : pchar;blOverwrite : WordBool;hParent : HWND;cszCaption : pchar); stdcall; external 'MMTools';
function FSYSExtractPath (cszFile : pchar) : pchar; stdcall; external 'MMTools';
function FSYSExtractFilename (cszFile : pchar) : pchar; stdcall; external 'MMTools';
procedure FSYSDeleteFile (cszFile : pchar;hParent : HWND;cszCaption : pchar); stdcall; external 'MMTools';


function MMPathExist (stPath : string) : Integer;
var szPath : array [0..MAX_PATH] of char;
begin
   strpcopy (szPath,stPath);

   MMPathExist := FSYSPathExist (szPath);

end;

procedure MMCreatePath  (stPath : string);
var szPath : array [0..MAX_PATH] of char;
begin
   strpcopy (szPath,stPath);

   FSYSCreatePath (szPath);
end;

function MMGet83Name (stLongName : string) : string;
var szLongName : array [0..MAX_PATH] of char;
begin
   strpcopy (szLongName,stLongName);

   MMGet83Name := FSYSGet83Name (szLongName);

end;

procedure MMCreateLink (stPathObj,stPathLink,stDesc : string);
var szPathObj,szPathLink,szDesc : array [0..MAX_PATH] of char;
begin
   strpcopy (szPathObj,stPathObj);
   strpcopy (szPathLink,stPathLink);
   strpcopy (szDesc,stDesc);

   FSYSCreateLink (szPathObj,szPathLink,szDesc);

end;

procedure MMCopyFile (stDest,stSource : string;blOverwrite : Bool;hParent : HWND;stCaption : string);
var szCaption,szDest,szSource : array [0..MAX_PATH] of char;
begin
   strpcopy (szDest,stDest);
   strpcopy (szSource,stSource);
   strpcopy (szCaption,stCaption);

   FSYSCopyFile (szDest,szSource,blOverwrite,hParent,szCaption);
end;

function MMExtractPath (stFile : string) : string;
var szFile : array [0..MAX_PATH] of char;
begin
   strpcopy (szFile,stFile);
   MMExtractPath := FSYSExtractPath (szFile);
end;

function MMExtractFilename (stFile : string) : string;
var szFile : array [0..MAX_PATH] of char;
begin
   strpcopy (szFile,stFile);
   MMExtractFilename := FSYSExtractFilename (szFile);
end;

procedure MMDeleteFile (stFile : string;hParent : HWND;stCaption : string);
var szCaption,szFile : array [0..MAX_PATH] of char;
begin
   strpcopy (szFile,stFile);
   strpcopy (szCaption,stCaption);
   FSYSDeleteFile (szFile,hParent,szCaption);
end;

end.
