{***********************
  Media-Manager
************************
 (c) 1996 by
 Olaf Panz
 Drosselgasse 4
 21436 Marschacht
***********************}
unit UMMFormNameProperty;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs,dsgnintf,UMMBase;

type
  TMMFormNameProperty = class(TComponentNameProperty)
  private
    { Private-Deklarationen }
  protected
    { Protected-Deklarationen }
  public
    { Public-Deklarationen }

    procedure SetValue(const Value: string); override;

  end;


implementation

procedure TMMFormNameProperty.SetValue(const Value: string);
var stNewName,stMsg,stOldName : string;
begin
   { alten Namen merken }
   stOldName := GetComponent(0).Name;

   { bergabe von Value an inherited, berprfung des Names nach Delphi-Regeln }
   inherited SetValue (Value);

   { genderten Namen ermitteln: }
   stNewName := GetValue;

   { Wurde der Name gendert ?}
   if stNewName <> stOldName then
   begin
      { evt. ndert der Media-Manager den Namen, darum wird er nun
        abgefragt, bei einer Differenz gibts eine Meldung }
      if MMPBRenameForm (stOldName,stNewName) = FALSE then
      begin
         inherited SetValue (stOldName); { Name korrigieren }
         { Meldungstext erzeugen }
         stMsg := 'Media-Manager-Formulare mssen ber das Projekt' +
                  ' hinaus einen eindeutigen Namen besitzen. Die Namesderung ' +
                  'wird nicht akzeptiert.';

         { Meldug ausgeben }
         MessageDlg (stMsg,mtInformation,[mbYes],0);
      end;

   end;

end;

end.
