{***********************
  Media-Manager
************************
 (c) 1996 by
 Olaf Panz
 Drosselgasse 4
 21436 Marschacht
***********************}
unit UMMINIFile;

interface

uses WinTypes,SysUtils;

type

TMyINIFile = class
   private
      // zeiger auf C++ -Objekt
      pINI : Pointer;

   public

      constructor Create (stFileName : string);
      destructor Destroy; override;

      function GetEntry (stSection,stEntry : string) : string;
      procedure SetEntry (stSection,stEntry,stValue : string);
      procedure DelSection (stSection : string);
      function GetKeyCount (stSection : string) : integer;
      function GetKey (stSection : string;iPos : Integer) : string;
      function GetSectionCount : Integer;
      function GetSectionName (iPos : Integer) : string;

end;

implementation

function  INICreate (cszFile : pchar): pointer; stdcall; external 'MMTools';
procedure INIDestroy (pINI : pointer); stdcall; external 'MMTools';
function  INIGetEntry (pINI : pointer;cszSection,cszEntry : pchar) : pchar; stdcall; external 'MMTools';
procedure INISetEntry (pINI : pointer;cszSection,cszEntry,cszValue : pchar);stdcall; external 'MMTools';
procedure INIDelSection(pINI : pointer;cszSection : pchar); stdcall; external 'MMTools';
function  INIGetKeyCount (pINI : pointer;cszSection : pchar) : integer; stdcall; external 'MMTools';
function  INIGetKey (pINI : pointer;cszSection : pchar; iPos : Integer) : pchar; stdcall; external 'MMTools';
function  INIGetSectionCount (pINI : pointer) : Integer; stdcall; external 'MMTools';
function  INIGetSectionName (pINI : pointer;iPos : integer) : pchar; stdcall; external 'MMTools';



constructor TMyINIFile.Create (stFileName : string);
var szFileName : array [0..MAX_PATH] of char;
begin
     strpcopy (szFileName,stFileName);

     pINI := INICreate (szFileName)
end;

destructor TMyINIFile.Destroy;
begin
     INIDestroy (pINI);
     pINI := Nil;
     inherited;
end;

function TMyINIFile.GetEntry (stSection,stEntry : string) : string;
var szSection,szEntry : array [0..MAX_PATH] of char;
begin
     strpcopy (szSection,stSection);
     strpcopy (szEntry,stEntry);

     GetEntry := INIGetEntry (pINI,szSection,szEntry);

end;

procedure TMyINIFile.SetEntry (stSection,stEntry,stValue : string);
var szSection,szEntry,szValue : array [0..MAX_PATH] of char;
begin
     strpcopy (szSection,stSection);
     strpcopy (szEntry,stEntry);
     strpcopy (szValue,stValue);

     INISetEntry (pINI,szSection,szEntry,szValue);
end;

procedure TMyINIFile.DelSection (stSection : string);
var szSection: array [0..MAX_PATH] of char;
begin
     strpcopy (szSection,stSection);

     INIDelSection (pINI,szSection);
end;

function TMyINIFile.GetKeyCount (stSection : string) : integer;
var szSection: array [0..MAX_PATH] of char;
begin
     strpcopy (szSection,stSection);

     GetKeyCount := INIGetKeyCount (pINI,szSection);
end;

function TMyINIFile.GetKey (stSection : string;iPos : Integer) : string;
var szSection: array [0..MAX_PATH] of char;
begin
     strpcopy (szSection,stSection);

     GetKey := INIGetKey (pINI,szSection,iPos);
end;

function TMyINIFile.GetSectionCount : Integer;
begin

     GetSectionCount := INIGetSectionCount (pINI);
end;

function TMyINIFile.GetSectionName (iPos : Integer) : string;
begin
     GetSectionName := INIGetSectionName (pINI,iPos);
end;

end.
