{***********************
  Media-Manager
************************
 (c) 1996 by
 Olaf Panz
 Drosselgasse 4
 21436 Marschacht
***********************}
unit UMMMediaManager;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ComCtrls,
  UMMBase,
  UMMMediaManagerNew,
  UMMPalettenEditor,
  UMMTools,
  UMMPaintArea,
  UMMPictureEditor,
  Memory,
  UMMOptionDialog,
  UMMConvertPicture,
  UMMPicture,
  UMMCreateDistribution,
  UMMSoundEditDialog,
  UMMHelpTopics
  ;

type
  TMMMediaManager = class(TForm)
    Medien: TTreeView;
    Label1: TLabel;
    Help: TBitBtn;
    OK: TBitBtn;
    New: TBitBtn;
    Delete: TBitBtn;
    Edit: TBitBtn;
    ImageList1: TImageList;
    Compile: TBitBtn;
    BitBtn1: TBitBtn;
    Aktualisieren: TBitBtn;
    IdentifierLabel: TLabel;
    Identifier: TLabel;
    SaveDialog: TSaveDialog;
    procedure OKClick(Sender: TObject);
    procedure CancelClick(Sender: TObject);
    procedure CreateForm(Sender: TObject);
    procedure NewClick(Sender: TObject);
    procedure MedienChange(Sender: TObject; Node: TTreeNode);
    procedure EditClick(Sender: TObject);
    procedure MedienEdited(Sender: TObject; Node: TTreeNode;
      var S: string);
    procedure DeleteClick(Sender: TObject);
    procedure MedienDblClick(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure AktualisierenClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure CompileClick(Sender: TObject);

  private
    { Private-Deklarationen }
    m_FormName : string; { Name des zu bearbeitenden Formulars }
    m_Directory : string; { Directory fr Daten }

    { Zeiger auf TreeView- Elemente }
    m_Root : TTreeNode;   { Zeiger auf Root }
    m_Picture : TTreeNode; { Zeiger auf Bilder-Node }
    m_Palette : TTreeNode; { Zeiger auf Paletten-Node }
    m_Sound : TTreeNode; // Zeiger auf Sound-Node

    m_DefaultNewType : Integer; { Default-Media-Type fr New }
    m_SelectedNode : TTreeNode; { Aktuell gewhlte Node }
    m_Form : TForm;

  protected

    // Palette im aktuellen TMMWinGControl updaten
    // Component mu eine Komponente desselben Formulars sein:
    procedure UpdatePalette;

    // Liste aktualisieren
    procedure UpdateList;

    // Unit mit Identifier erzeugen:
    procedure CreateUnit;

  public
    { Public-Deklarationen }
    // m_Component ist die aktuell bearbeitete Komponente
    constructor CreateEx (AOwner : TComponent;Form : TForm);

  end;

// Alle Bilder updaten
procedure UpdatePictureView (Form : TForm);


implementation

{$R *.DFM}


constructor TMMMediaManager.CreateEx (AOwner : TComponent;Form : TForm);
begin
    { Formular- Name des zu bearbeitenden Formulars merken }
     m_Form := Form;
     m_FormName := Form.Name;

     m_Directory := MMPBGetMediaPath (m_FormName);

     // Defaultwerte setzen
     m_DefaultNewType := 0;

     inherited Create (AOwner);

end;


procedure TMMMediaManager.OKClick(Sender: TObject);
begin
     // Identifier-Unit erstellen
     CreateUnit;
     ModalResult := mrOK;
     Close;
end;

procedure TMMMediaManager.CancelClick(Sender: TObject);
begin
     ModalResult := mrCancel;
     Close;

end;

procedure TMMMediaManager.UpdateList;
var Count,i : Integer;
    stKey,stValue,stType : string;
    Node : TTreeNode;
    ImageIndex,SelectedIndex : Integer;
begin
     // vorhandene Liste lschen:
     Medien.Items.Clear;

     { TTreeView Komponente mit Daten fllen }
     { Formular-Zweig einfgen }
     m_Root := Medien.Items.AddChild (Nil,m_FormName);
     m_Root.ImageIndex := 0;
     m_Root.SelectedIndex := 1;

     { Kategorien einfgen }
     m_Picture := Medien.Items.AddChild (m_Root,'Bilder'); { Bilder }
     m_Picture.ImageIndex := 2;
     m_Picture.SelectedIndex := 3;
     m_Palette := Medien.Items.AddChild (m_Root,'Palette'); { Palette }
     m_Palette.ImageIndex := 4;
     m_Palette.SelectedIndex := 5;
     m_Sound := Medien.Items.AddChild (m_Root,'Klang'); // Sound
     m_Sound.ImageIndex := 6;
     m_Sound.SelectedIndex := 7;

     // Medien in die Liste einfgen
     Count := MMPBGetKeyCount (m_FormName,cIdentifier) -1; // Anzahl der Medien ermitteln
     while Count >= 0 do
     begin
        // Identifier ermitteln
        stKey := MMPBGetKey (m_FormName,cIdentifier,Count);

        // Bezeichner ermitteln:
        stValue := MMPBGetValue (m_FormName,cIdentifier,stKey);

        // Typ ermitteln:
        stType := MMPBGetValue (m_FormName,'MM*'+stValue,cType);

        // Einfge-Node bestimmen:
        if stType = cPalette then
        begin
           Node := m_Palette;
           ImageIndex := 4;
           SelectedIndex := 5;
        end else if stType = cPicture then
        begin
           Node := m_Picture;
           ImageIndex := 2;
           SelectedIndex := 3;
        end else if stType = cSound then begin
           Node := m_Sound;
           ImageIndex := 6;
           SelectedIndex := 7;
        end else begin
           Node := m_Root; // unbekanntes ins Root, da fllts auf!!
           ImageIndex := 0;
           SelectedIndex := 1;
        end;

        i := StrToInt (stKey); // Identifier ermitteln

        {Medium einfgen einfgen }
        Node := Medien.Items.AddChild (Node,stValue);
        Node.ImageIndex := ImageIndex;
        Node.SelectedIndex := SelectedIndex;

        memcpy (@Node.Data,@i,4); // In Data-Pointer den Identifiert ablegen
        Count := Count -1;
     end;

     Medien.FullExpand;

end;


procedure TMMMediaManager.CreateForm(Sender: TObject);
var Count : Integer;
    Key,Value : string;
begin

     // Ist die Palette definiert ?
     Key := 'MM*' + MMPBGetValue (m_FormName,cIdentifier,'1'); // Name der Palette ermitteln
     Value := MMPBGetValue (m_FormName,Key,cType); // Abfragen: Type=

     if Value = '' then
     begin // Palette existiert noch nicht, also registrieren
           // und Identifier ermitteln.

        Count := MMPBRegisterMedia (m_FormName,cPalette,cPalette);

        // Herkunft setzen [MM*Palette]  Palette=*
        MMPBSetValue (m_FormName,'MM*'+cPalette,cPalette,'*');

        // Arbeitsdatei-Name fr Palette ermitteln
        Key := MMPBGetMediaWorkFile (m_FormName,Count);

        // Paletten-Datei erzeugen
        CreatePalette (Key);

        // Palette im Formular updaten
        UpdatePalette;
     end;

     UpdateList; // LIste darstellen

end;

procedure TMMMediaManager.NewClick(Sender: TObject);
var New : TMMMediaManagerNew;
    stName : string;
    iIdentifier : Integer;
begin
     New := TMMMediaManagerNew.Create (Self);

     { Aktuell markiertes Element im Baum als Default :}
     New.Selected := m_DefaultNewType;

     if New.ShowModal = mrOK then
     begin
          case New.Selected of
             0 :    // Neues Bild
                begin
                   // Vorlufigen Namen bestimmen
                   stName := MMPBGetUniqueName (m_FormName,'Picture');
                   // Medium registrieren
                   iIdentifier := MMPBRegisterMedia (m_FormName,stName,cPicture);

                   // EditPicture aufrufen
                   if MMEditPicture (Self,m_FormName,iIdentifier) = FALSE then
                   begin // Medium wieder entfernen:
                      MMPBDestroyMedia (m_FormName,iIdentifier);
                   end;

                   // und anzeigen
                   UpdateList;

                end;
             1 : // Neuer Sound
                begin
                   // Vorlufigen Namen bestimmen
                   stName := MMPBGetUniqueName (m_FormName,'Sound');
                   // Medium registrieren
                   iIdentifier := MMPBRegisterMedia (m_FormName,stName,cSound);
                   if MMEditSound (Self,m_FormName,iIdentifier) = FALSE then
                   begin
                      MMPBDestroyMedia (m_FormName,iIdentifier);
                   end;
                   // und anzeigen
                   UpdateList;

                end;
          end;

     end;

     New.Free;
end;

procedure TMMMediaManager.MedienChange(Sender: TObject; Node: TTreeNode);
var DelEnable,EditEnable,
    ReadOnly : Boolean;
    iIdent : Integer;
begin

    m_SelectedNode := Node;

    // Bestimmen, ob selektiertes Objekt bearbeitbar oder
    // lschbar ist:
    DelEnable := FALSE;
    EditEnable := FALSE;
    ReadOnly := TRUE;

    // Identifier des umzubenennenden Mediums ermitteln
    memcpy (@iIdent,@Node.Data,4);
    // und in Identifier-Zeile darstellen:
    if iIdent <> 0 then
    begin
        IdentifierLabel.Enabled := TRUE;
        Identifier.Caption := IntToStr (iIdent);
    end else begin
        Identifier.Caption :='';
        IdentifierLabel.Enabled := FALSE;
    end;


    // Teste, ob Bild
    if ((Node.HasAsParent (m_Picture) = TRUE) and (Node <> m_Picture)) then
    begin
       DelEnable := TRUE; // Delete Button einschalten
       EditEnable := TRUE; // Edit-Button einschalten
       ReadOnly := FALSE; // Rename zulassen
    end;
    // Teste, ob Palette
    if ((Node.HasAsParent (m_Palette) = TRUE) and (Node <> m_Palette)) then
       EditEnable := TRUE; // Edit-Button einschalten

    // Teste, ob Sound
    if ((Node.HasAsParent (m_Sound) = TRUE) and (Node <> m_Sound)) then
    begin
       DelEnable := TRUE; // Delete Button einschalten
       EditEnable := TRUE; // Edit-Button einschalten
       ReadOnly := FALSE; // Rename zulassen
    end;

    // Buttons enablen
    Delete.Enabled := DelEnable;
    Edit.Enabled := EditEnable;
    Medien.ReadOnly := ReadOnly;

    // m_DefaultNewType setzen
    if Node.HasAsParent (m_Picture) = TRUE then
        m_DefaultNewType := 0; // Bild

end;

procedure TMMMediaManager.EditClick(Sender: TObject);
type EditorType = (Non,Palette,Picture,Sound);
var eType : EditorType;
    pal : TMMPalettenEditor;
    ident : Integer;
begin
   eType := Non;

   // Paletten-Editor starten ?
   if m_SelectedNode.HasAsParent (m_Palette) = TRUE then
      eType := Palette;
   if m_SelectedNode.HasAsParent (m_Picture) = TRUE then
      eType := Picture;
   if m_SelectedNode.HasAsParent (m_Sound) = TRUE then
      eType := Sound;

   case eType of
      Palette :
         begin
            // Paletten-Identifier ermitteln :
            ident := MMPBGetIdentifier (m_FormName,cPalette);

            pal := TMMPalettenEditor.CreateEx (Self,MMPBGetMediaWorkFile (m_FormName,ident),m_Form);
            Pal.ShowModal;
            pal.Free;
            // Palette im Formular updaten
            UpdatePalette;

         end;
      Picture :
         begin
             // Picture-Identifier ermitteln :
            memcpy (@Ident,@m_SelectedNode.Data,4);
            MMEditPicture (Self,m_FormName,Ident)
         end;
      Sound :
         begin
             // Picture-Identifier ermitteln :
            memcpy (@Ident,@m_SelectedNode.Data,4);
            MMEditSound (Self,m_FormName,Ident)
         end;

   end;



end;

// Palette im aktuellen TMMWinGControl updaten
// Component mu eine Komponente desselben Formulars sein:
procedure TMMMediaManager.UpdatePalette;
var i : Integer;
begin

   // Untergeordnete Componenten nach TMMWinGControl durchsuchen und NewPalette aufrufen
   for i := 1 to m_Form.ComponentCount do begin
       if m_Form.Components[i-1] is TMMPaintArea then
          // Palette in Komponente neu laden
          (m_Form.Components[i-1] as TMMPaintArea).NewPalette;
   end;

  // Alle Bilder updaten
  UpdatePictureView (m_Form);

end;



procedure TMMMediaManager.MedienEdited(Sender: TObject; Node: TTreeNode;
      var S: string);
var iIdent,iCount : Integer;
    stOldChapter,stKey,stValue,stChapter : string;
    i,count : Integer;
begin
   // Identifier des umzubenennenden Mediums ermitteln
   memcpy (@iIdent,@Node.Data,4);

   // Entspricht der neue Namen dem Format einer Pascal-Konstante?
   if (S[1] <> '_') and ((S[1] < 'A') or (S[1] > 'Z')) and
       ((S[1] < 'a') or (S[1] > 'z')) then
          S[1] := '_';

   count := Length(S);
   for i := 2 to count do
   begin
      if (S[i] <> '_') and ((S[i] < 'A') or (S[i] > 'Z')) and
          ((S[i] < 'a') or (S[i] > 'z')) and
          ((S[i] < '0') or (S[i] > '9'))  then
             S[i] := '_';

   end;

   // Gibt es den Namen schon?
   stChapter := 'MM*'+S;
   stOldChapter := 'MM*' + Node.Text;
   if MMPBGetValue (m_FormName,stChapter,cType) <> '' then
   begin
      MessageDlg ('Der Name ' + S + ' ist bereits vergeben.',mtError,[mbOk],0);

      // alten Namen ermitteln und nderung rckgngig machen
      S := Node.Text;
   end else begin // nderung wird akzeptiert:
      // Identifier setzen:
      MMPBSetValue( M_FormName,cIdentifier,IntToStr (iIdent),S);

      // Daten zur Komponente kopieren
      iCount := MMPBGetKeyCount (m_FormName,stOldChapter);
      while (iCount > 0) do
      begin
         // Schlssel ermitteln
         stKey := MMPBGetKey (m_FormName,stOldChapter,iCount-1);
         // Datum zum Schlssel ermitteln
         stValue := MMPBGetValue (m_FormName,stOldChapter,stKey);
         // und Datum wieder schreiben
         MMPBSetValue (m_FormName,stChapter,stKey,stValue);

         // Iterator:
         iCount := iCount -1;
      end;

      // Altes Kapitel lschen
      MMPBDelValue (m_FormName,stOldChapter,'');

      // S ist neuer Name!
      // Node.Text ist alter Name!

  end;

//   UpdateList; // nderungen in Liste darstellen

end;

procedure TMMMediaManager.DeleteClick(Sender: TObject);
var iIdent : Integer;
begin
   // Identifier des umzubenennenden Mediums ermitteln
   memcpy (@iIdent,@m_SelectedNode.Data,4);

   // bist du auch wirklichwirklichwirklich sicher ?
   if MessageDlg ('Soll das Medium ' + m_SelectedNode.Text + ' wirklich gelscht werden?'
              ,mtConfirmation,[mbYes,mbNo],0) = mrYes then
   begin
       // Identifier lschen:
       MMPBDelValue (m_FormName,cIdentifier,IntToStr (iIdent));
       // Medien-Chapter lschen
       MMPBDelValue (m_FormName,'MM*'+m_SelectedNode.Text,'');

       // nderungen in Liste darstellen
       UpdateList;
   end;

end;

procedure TMMMediaManager.MedienDblClick(Sender: TObject);
begin
     // Wenn aktuell ausgewhlten Listenelement bearbeitbar,
     // dann Edit-Funktion bei Doppelklick ausgfhren
     if Edit.Enabled = TRUE then
          EditClick (Sender);
end;

procedure TMMMediaManager.BitBtn1Click(Sender: TObject);
var Option : TMMOptionDialog;
begin
   Option := TMMOptionDialog.CreateEx (Self,m_FormName);
   Option.ShowModal;
   Option.Free;
end;

procedure TMMMediaManager.AktualisierenClick(Sender: TObject);
begin
     // Bilddaten anpassen
     UpdateAllPicture (m_Form);

     // Alle Bilder neu anzeigen
     UpdatePictureView (m_Form);

end;

// Unit mit Identifier erzeugen:
procedure TMMMediaManager.CreateUnit;
var stFile,stUnit : string;
    hFile : THandle;
    szBuf : array [0..MAX_PATH] of char;
    i,Count : Integer;
    stType,stIdent,stName : string;
begin
    stFile := MMPBGetValue (m_FormName,cMisc,'Unit');

    if stFile = '' then
    begin
       SaveDialog.Execute;
       stFile := SaveDialog.FileName;
    end;

    if stFile <> '' then
    begin
       // Dateiname schreiben
       MMPBSetValue (m_FormName,cMisc,'Unit',stFile);

       strpcopy (szBuf,stFile);
       // Datei ffnen
       hFile := CreateFile (szBuf,GENERIC_WRITE,FILE_SHARE_WRITE,
                         Nil,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,0);
       // Den Unit-Namen erzeugen
       // '.' suchen
       i := 0;
       count := strlen (szBuf);
       while (i < count) and (szBuf[i] <> '.') do  i := i +1;
       // Dort String terminieren:
       memset (@szBuf[i],0,1);
       // letzten Backslash suchen
       while (szBuf[i] <> '\') and (i >= 0) do i := i -1;

       if i >= 0 then
          stUnit := szBuf + i+1
       else
          stUnit := stFile;

       // Unit-Zeile schreiben

       WriteText (hFile,'Unit ' + stUnit + ';');
       WriteText (hFile,'');  // Leerzeile

       // Copyright schreiben
       WriteText (hFile,'//**************************************');
       WriteText (hFile,'//*           Media-Manager            *');
       WriteText (hFile,'//*                                    *');
       WriteText (hFile,'//*   (c) 1996 by Olaf Panz            *');
       WriteText (hFile,'//*   Drosselgasse 4                   *');
       WriteText (hFile,'//*                                    *');
       WriteText (hFile,'//*   21436 Marschacht                 *');
       WriteText (hFile,'//*                                    *');
       WriteText (hFile,'//**************************************');
       WriteText (hFile,'//*                                    *');
       WriteText (hFile,'//* This file is created automatically *');
       WriteText (hFile,'//* by the Media-Manager.              *');
       WriteText (hFile,'//* Every changes would be overwritten *');
       WriteText (hFile,'//* when you are calling the           *');
       WriteText (hFile,'//* Media-Manager next time!           *');
       WriteText (hFile,'//*                                    *');
       WriteText (hFile,'//**************************************');
       WriteText (hFile,'');

       // Interface einleiten
       WriteText (hFile,'Interface');

       // Constantendefinition einleiten
       WriteText (hFile,'');
       WriteText (hFile,'Const');
       WriteText (hFile,'');

       // ber alle Identifier iterieren:
       Count := MMPBGetKeyCount (m_FormName,cIdentifier) -1; // Anzahl der Chapter ermitteln
       while Count >= 0 do
       begin
          // Identifier-Daten ermitteln
          stIdent := MMPBGetKey (m_FormName,cIdentifier,Count);
          if stIdent <> '' then
          begin
             stName := MMPBGetValue (m_FormName,cIdentifier,stIdent);
             stType := MMPBGetValue (m_FormName,'MM*'+stName,cType);

              // und in Unit schreiben
             WriteText (hFile,'    ' + stName + ' = ' + stIdent + '; // '+ stType);

             Count := Count -1;
          end;
       end;

       // Implementation einleiten
       WriteText (hFile,'');
       WriteText (hFile,'Implementation');
       WriteText (hFile,'');

       // Unitende einleiten
       WriteText (hFile,'');
       WriteText (hFile,'end.');
       WriteText (hFile,'');
       // und Schlieen
       CloseHandle (hFile);

    end;

end;

procedure UpdatePictureView (Form : TForm);
var count : Integer;
    Pict : TMMPicture;
begin
   // Alle Bilder des Formulars neu laden
   count := Form.ComponentCount -1;

   while count >= 0 do begin
         if Form.Components[count] is TMMPicture then
         begin
              Pict := Form.Components[count] as TMMPicture;
              Pict.Picture := Pict.Picture;
         end;
         count := count -1;
   end;
end;




procedure TMMMediaManager.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
     // Alle Bilder updaten
     UpdatePictureView (m_Form);
end;

procedure TMMMediaManager.CompileClick(Sender: TObject);
begin
     MMCreateDistributionDlg (Self);
end;

{
     // Medien in die Liste einfgen
     Count := MMPBGetKeyCount (m_FormName,''); // Anzahl der Chapter ermitteln
     while Count > 0 do
     begin
        Key := MMPBGetKey (m_FormName,'',Count-1);
        if copy (Key,0,3) = 'MM*' then
        begin // Beschreibt Chapter ein Medium?
           Value := MMPBGetValue (m_FormName,Key,cType);// Type ermitteln

           // Einfge-Node bestimmen:
           if Value = cPalette then
           begin
              Node := m_Palette;
              ImageIndex := 4;
              SelectedIndex := 5;
           end else if Value = cPicture then
           begin
              Node := m_Picture;
              ImageIndex := 2;
              SelectedIndex := 3;
           end else if Value = cSound then begin
              Node := m_Sound;
              ImageIndex := 6;
              SelectedIndex := 7;
           end else begin
              Node := m_Root; // unbekanntes ins Root, da fllts auf!!
              ImageIndex := 0;
              SelectedIndex := 1;
           end;

           // Aus Chaptername den Media-Name erzeugen:
           Key := Copy (Key,4,Length (Key)-3);

           i := MMPBGetIdentifier (m_FormName,Key); // Identifier ermitteln

           //Medium einfgen einfgen
           Node := Medien.Items.AddChild (Node,Key);
           Node.ImageIndex := ImageIndex;
           Node.SelectedIndex := SelectedIndex;

           memcpy (@Node.Data,@i,4); // In Data-Pointer den Identifiert ablegen


        end;
        Count := Count -1;
     end;
}

end.
