{***********************
  Media-Manager
************************
 (c) 1996 by
 Olaf Panz
 Drosselgasse 4
 21436 Marschacht
***********************}
unit UMMOptionDialog;

interface

uses
  SysUtils, Windows, Messages, Classes, Graphics, Controls,
  StdCtrls, ExtCtrls, Forms, ComCtrls, Buttons,MMSystem,Dialogs,
  UMMBase,UMMTools,UMMDevelopingTools;

type
  TMMOptionDialog = class(TForm)
    PageControl: TPageControl;
    TabSheet1: TTabSheet;
    Cancel: TBitBtn;
    Help: TBitBtn;
    OK: TBitBtn;
    AboutMediaManager: TTabSheet;
    Image1: TImage;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Bevel1: TBevel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    TransformMedia: TCheckBox;
    Bevel2: TBevel;
    Label8: TLabel;
    Label9: TLabel;
    AboutTimer: TTimer;
    Label10: TLabel;
    SearchMediaManUnit: TBitBtn;
    SaveMediaManUnit: TSaveDialog;
    MediaManUnit: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure OKClick(Sender: TObject);
    procedure AboutTimerTimer(Sender: TObject);
    procedure PageControlChange(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure SearchMediaManUnitClick(Sender: TObject);


  protected

    EnabledAboutTimer : Boolean; // Ist der About-Sound aktiv?
    m_stFormName : string;


  public

    constructor CreateEx (AOwner : TComponent;FormName : string);

  end;

implementation

{$R *.DFM}
constructor TMMOptionDialog.CreateEx (AOwner : TComponent;FormName : string);
begin
   m_stFormName := FormName;
   inherited Create (AOwner)

end;

procedure TMMOptionDialog.FormCreate(Sender: TObject);
begin
   // Dialog initialisieren
   TransformMedia.Checked := OPTGetBool (cMisc,'TransformMedia');

   // Unit-Datei:
   MediaManUnit.Caption := MMPBGetValue (m_stFormName,cMisc,'Unit');

   EnabledAboutTimer := FALSE;
end;

procedure TMMOptionDialog.OKClick(Sender: TObject);
begin
   // genderte Daten merken
   OPTSetBool (cMisc,'TransformMedia',TransformMedia.Checked);
   // Unit-Datei speichern
   MMPBSetValue (m_stFormName,cMisc,'Unit',MediaManUnit.Caption);
end;


procedure TMMOptionDialog.AboutTimerTimer(Sender: TObject);
begin
   if EnabledAboutTimer = TRUE then
     mciSendString ('play mm.wav',Nil,0,0);
end;

procedure TMMOptionDialog.PageControlChange(Sender: TObject);
begin
     if PageControl.ActivePage = AboutMediaManager then
        EnabledAboutTimer := TRUE
     else
        EnabledAboutTimer := FALSE;

end;

procedure TMMOptionDialog.FormDestroy(Sender: TObject);
begin
     EnabledAboutTimer := FALSE;
end;

procedure TMMOptionDialog.BitBtn1Click(Sender: TObject);
begin
     MessageDlg ('Hei',mtInformation,[mbYes],0);
end;

procedure TMMOptionDialog.SearchMediaManUnitClick(Sender: TObject);
begin
     if SaveMediaManUnit.Execute = TRUE then
     begin
        MediaManUnit.Caption := SaveMediaManUnit.FileName;
     end;

end;

end.
