{***********************
  Media-Manager
************************
 (c) 1996 by
 Olaf Panz
 Drosselgasse 4
 21436 Marschacht
***********************}
unit UMMPaintAreaComponentEdit;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs,dsgnintf,UMMMediaManager,UMMTools,UMMPalettenEditor,
  UMMComponentEdit,UMMBase,UMMPaintArea;

{ Basistyp des MM-Komponenten-Editors}
type
  TMMPaintAreaComponentEdit = class(TMMComponentEdit)
  private
    { Private-Deklarationen }
  protected
    { Protected-Deklarationen }
    // Paletten-Editor ausfhren
    procedure ExecPalEdit;

  public
    { Public-Deklarationen }

     function GetVerb(Index: Integer): string; override;
     function GetVerbCount: Integer; override;
     procedure ExecuteVerb(Index: Integer); override;

  end;


implementation


function TMMPaintAreaComponentEdit.GetVerb(Index: Integer): string;
begin
   case Index of
      0 : GetVerb := '&Palette bearbeiten';
      1 : GetVerb := 'Me&dia Manager';
      2 : GetVerb := 'Distribution erstellen';
   end;
end;


function TMMPaintAreaComponentEdit.GetVerbCount: Integer;
begin
     GetVerbCount := 3;
end;

procedure TMMPaintAreaComponentEdit.ExecuteVerb(Index: Integer);
begin
     case Index of
          0 : ExecPalEdit;
          1 : begin
                 ExecMediaMan;
                 // Palette in Komponente neu laden
                 (Component as TMMPaintArea).NewPalette;
              end;
          2 : ExecDistribution;

     end;
end;

// Paletten-Editor ausfhren
procedure TMMPaintAreaComponentEdit.ExecPalEdit;
var PalEdit  : TMMPalettenEditor;
    ident   : Integer;
    FormName,Key,Value : string;
    Count : Integer;
    Form : TForm;
begin

     Form := MMGetForm (Component);
     FormName := Form.Name;

     // Ist die Palette definiert ?
     Key := 'MM*' + MMPBGetValue (FormName,cIdentifier,'1'); // Name der Palette ermitteln
     Value := MMPBGetValue (FormName,Key,cType); // Abfragen: Type=

     if Value = '' then
     begin // Palette existiert noch nicht, also registrieren
           // und Identifier ermitteln.

        Count := MMPBRegisterMedia (FormName,cPalette,cPalette);

        // Herkunft setzen [MM*Palette]  Palette=*
        MMPBSetValue (FormName,'MM*'+cPalette,cPalette,'*');

        // Arbeitsdatei-Name fr Palette ermitteln
        Key := MMPBGetMediaWorkFile (FormName,Count);

        // Paletten-Datei erzeugen
        CreatePalette (Key);

        // Palette in Komponente neu laden
        (Component as TMMPaintArea).NewPalette;

     end;

   // Paletten-Identifier ermitteln :
   ident := MMPBGetIdentifier (FormName,cPalette);

   PalEdit := TMMPalettenEditor.CreateEx (Application,MMPBGetMediaWorkFile (FormName,ident),Form);

   PalEdit.ShowModal;
   PalEdit.Free;

   // Palette in Komponente neu laden
   (Component as TMMPaintArea).NewPalette;

   Designer.Modified;

end;



end.
