{***********************
  Media-Manager
************************
 (c) 1996 by
 Olaf Panz
 Drosselgasse 4
 21436 Marschacht
***********************}
unit UMMPalettenEditor;



interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls, 
  Buttons, ExtCtrls, UMMBase,CommDlg,dialogs, ComCtrls,UMMDevelopingTools,UMMTools,
  Memory,UMMConvertPicture;

type
  TShapes = array [0..255] of TShape;
  TMMPalettenEditor = class(TForm)
    Palette: TGroupBox;
    Label1: TLabel;
    ColorName: TLabel;
    Label2: TLabel;
    Red: TLabel;
    Label3: TLabel;
    Green: TLabel;
    Label4: TLabel;
    Blue: TLabel;
    Cancel: TBitBtn;
    Help: TBitBtn;
    OK: TBitBtn;
    Load: TBitBtn;
    CreateBtn: TBitBtn;
    PRed: TProgressBar;
    PGreen: TProgressBar;
    PBlue: TProgressBar;
    OpenDialog: TOpenDialog;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure OKClick(Sender: TObject);
    procedure CreateBtnClick(Sender: TObject);
    procedure LoadClick(Sender: TObject);
  private
    { Private declarations }
    m_Shapes : TShapes;  { Liste der Paletten-Shapes }

    m_ColorDlgParam : TChooseColor;
    m_CustomColors : TCustomColors;

    m_PalFile : string;
    m_Form : TForm;
    m_Palette : TPalette;
    m_OldPal : TPalette;

    procedure PaletteMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure PaletteMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);

    // Palette von Datei neu laden und darstellen:
    procedure LoadPalette;


  public
    { Public declarations }
    constructor CreateEx (AOwner : TComponent;PaletteFile : string;Form : TForm);
  end;

// Erstellt Paletten Datei mit Default-Palette
procedure CreatePalette (Name : string);


implementation

{$R *.DFM}

constructor TMMPalettenEditor.CreateEx (AOwner : TComponent;PaletteFile : string;Form : TForm);
var hFile : THandle;
    szFile : array [0..MAX_PATH] of char;
    read : DWORD;
begin
     { Paletten-Index merken }
     m_PalFile := PaletteFile;
     m_Form := Form;

     strPcopy (szFile,PaletteFile);
     // Palette laden :
     hFile := CreateFile (szFile,GENERIC_READ,FILE_SHARE_READ,
                         Nil,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,0);
     if hFile <> INVALID_HANDLE_VALUE then
     begin
        // Palette laden
        ReadFile (hFile,m_Palette,sizeof (m_Palette),read,Nil);
        // und wieder schlieen:
        CloseHandle (hFile);
     end;

     // Palette merken, um beim Beenden nderungen festzustellen
     m_OldPal := m_Palette;

     inherited Create (AOwner);
end;

procedure TMMPalettenEditor.FormCreate(Sender: TObject);
const SIZE = 16;
type CustomColorCounter = 'A'..'P';
var zeile,spalte,index,c : Integer;
begin
   // Palettenanzeige erzeugen :
   for zeile := 0 to 15 do begin
       for spalte := 0 to 15 do begin
           index := zeile * 16 + spalte;
           m_Shapes [index] := TShape.Create (Palette);
           m_Shapes [index].Parent := Palette;
           m_Shapes [index].Tag := index; // Index mu dem Objekt bekannt sein!
           m_Shapes [index].OnMouseMove := PaletteMouseMove; // Farb-Infos anzeigen
           m_Shapes [index].OnMouseUp := PaletteMouseUp; // Farbe bearbeiten
           // Shape Positionieren:
           m_Shapes [index].Left := 16 + SIZE * spalte;
           m_Shapes [index].Top := 16 + SIZE * zeile;
           m_Shapes [index].Width := SIZE;
           m_Shapes [index].Height:= SIZE;

           c := TColor(m_Palette[index]);
           m_Shapes [index].Brush.Color := (c and $ff00ff00) or
              ((c and $00ff0000)shr 16) or ((c and $000000ff) shl 16);


       end;
   end;
   // ColorDlgParam Initialisieren
   m_ColorDlgParam.lStructSize := sizeof (TChooseColor);
   m_ColorDlgParam.hwndOwner := Handle;
   m_ColorDlgParam.hInstance := Application.Handle;
   m_ColorDlgParam.rgbResult := m_CustomColors[0];
   m_ColorDlgParam.lpCustColors := @m_CustomColors;
   m_ColorDlgParam.Flags := CC_FULLOPEN or CC_RGBINIT;
   m_ColorDlgParam.lCustData := 0;
   m_ColorDlgParam.lpfnHook := NIl;
   m_ColorDlgParam.lpTemplateName := Nil;

   //  Custom-Farben aus Datenbasis ermitteln
   for index := 0 to MaxCustomColors-1 do
   begin
      try
         zeile := StrToInt (MMPBGetValue(cOptions,cCustomColor,'Color'+ IntToStr(index)));
         m_CustomColors[index] := zeile;
      except
         m_CustomColors[index] := 0;
      end;
   end;

   // Text aus Anzeige-Elementen entfernen
   Red.Caption := '';
   Blue.Caption := '';
   Green.Caption := '';
   ColorName.Caption := '';
end;


procedure TMMPalettenEditor.PaletteMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
var Name : string;
    val,index : Integer;
begin
   // Bezeichnung der aktuellen Farbe ausgeben
   index := (Sender as TComponent).Tag;
   Name := IntToStr (index);

   if index = 0 then
      Name := Name + ' (Hintergrundfarbe)';

   val := m_Palette [index].peBlue;
   Red.Caption := IntToStr (val);
   PRed.Position := val;

   val := m_Palette [index].peGreen;
   Green.Caption := IntToStr (val);
   PGreen.Position := val;

   val := m_Palette [index].peRed;
   Blue.Caption := IntToStr (val);
   PBlue.Position := val;

   ColorName.Caption := Name;
end;

procedure TMMPalettenEditor.PaletteMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var index,c : Integer;
begin
   index := (Sender as TComponent).Tag;

   // Farben rot und blau vertauschen:
   c := Integer(m_Palette[index]);

   m_ColorDlgParam.rgbResult :=(c and $ff00ff00) or
    ((c and $00ff0000)shr 16) or ((c and $000000ff) shl 16);
   //m_ColorDlgParam.rgbResult := Integer(m_Palette [index]); // Default-Farbe

   if ChooseColor (m_ColorDlgParam) =TRUE then
   begin // Wurde Dialog mit OK beendet, Ergebnis merken:
      c := m_ColorDlgParam.rgbResult;

      c := (c and $ff00ff00) or
       ((c and $00ff0000)shr 16) or ((c and $000000ff) shl 16);
      m_Palette [index] := TPaletteEntry (c);
      // un Farbe gleich anzeigen:
      (Sender as TShape).Brush.Color := m_ColorDlgParam.rgbResult;

      if index = 0 then
      begin
         m_Palette [255] := TPaletteEntry (c);
         // un Farbe gleich anzeigen:
         m_Shapes [255].Brush.Color := m_ColorDlgParam.rgbResult;
      end;

      if index = 255 then
      begin
         m_Palette [0] := TPaletteEntry (c);
         // un Farbe gleich anzeigen:
         m_Shapes [0].Brush.Color := m_ColorDlgParam.rgbResult;
      end;

   end;
end;

procedure TMMPalettenEditor.FormDestroy(Sender: TObject);
var i : Integer;
begin
   //  Custom-Farben in Datenbasis schreiben
   for i := 0 to MaxCustomColors-1 do
   begin
      MMPBSetValue (cOptions,cCustomColor,'Color' + IntToStr (i),
                   IntToStr(m_CustomColors[i]));
   end;

   // Shapes wieder freigeben
   for i := 0 to 255 do
       m_Shapes[i].Free;

end;

procedure TMMPalettenEditor.OKClick(Sender: TObject);
var szFile : array [0..MAX_PATH] of char;
    datei : THandle;
    written : DWORD;
begin
   if memcmp (@m_Palette,@m_OldPal,sizeof (m_OldPal)) = FALSE then
   begin
      // genderte Daten schreiben :
      strPcopy (szFile,m_PalFile);
      // Datei zum Schreiben ffnen
      datei := CreateFile (szFile,GENERIC_WRITE,FILE_SHARE_WRITE,
                          Nil,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,0);
      if datei <> INVALID_HANDLE_VALUE then
      begin
         WriteFile (datei,m_Palette,sizeof (m_Palette),written,Nil);

         // uns Schlieen
         CloseHandle (datei);
      end;

      // Wenn sofortige Anpassung gefordert ist,
      // alle Bilder neu konvertieren
      if OPTGetBool (cMisc,'TransformMedia') = TRUE then
         UpdateAllPicture (m_Form);
   end;
end;

procedure CreatePalette (Name : string);
const DefaultPalLow : array [0..9] of TPALETTEENTRY
      = ((peRed:000;peGreen:000;peBlue:000;peFlags:0),
         (peRed:128;peGreen:000;peBlue:000;peFlags:0),
         (peRed:000;peGreen:128;peBlue:000;peFlags:0),
         (peRed:128;peGreen:128;peBlue:000;peFlags:0),
         (peRed:000;peGreen:000;peBlue:128;peFlags:0),
         (peRed:128;peGreen:000;peBlue:128;peFlags:0),
         (peRed:000;peGreen:128;peBlue:128;peFlags:0),
         (peRed:192;peGreen:192;peBlue:192;peFlags:0),
         (peRed:192;peGreen:220;peBlue:192;peFlags:0),
         (peRed:166;peGreen:202;peBlue:240;peFlags:0));

const DefaultPalHigh : array [245..255] of TPALETTEENTRY
      = ((peRed:255;peGreen:255;peBlue:255;peFlags:0),
         (peRed:255;peGreen:251;peBlue:244;peFlags:0),
         (peRed:160;peGreen:160;peBlue:164;peFlags:0),
         (peRed:128;peGreen:128;peBlue:128;peFlags:0),
         (peRed:255;peGreen:000;peBlue:000;peFlags:0),
         (peRed:000;peGreen:255;peBlue:000;peFlags:0),
         (peRed:255;peGreen:255;peBlue:000;peFlags:0),
         (peRed:000;peGreen:000;peBlue:255;peFlags:0),
         (peRed:255;peGreen:000;peBlue:255;peFlags:0),
         (peRed:000;peGreen:255;peBlue:255;peFlags:0),
         (peRed:000;peGreen:000;peBlue:000;peFlags:0));
var szFile : array [0..MAX_PATH] of char;
    datei : THandle;
    Palette : TPalette;
    i,Color : Integer;
    written : DWORD;
const ColorAdd = 70789;
begin
     // Dateiname in Nullterminiert wandeln:
     strPCopy (szFile,Name);


     // Datei zum Schreiben ffnen
     datei := CreateFile (szFile,GENERIC_WRITE,FILE_SHARE_WRITE,
                         Nil,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,0);
     if datei <> INVALID_HANDLE_VALUE then
     begin
          // Datei ist nun offen, also kann
          // die Default-Palette erzeugt werden:

          // feste Bereiche oben und unten bestimmen:
          for i:=0 to 9 do
              Palette[i] := DefaultPalLow[i];
          for i:=245 to 255 do
              Palette[i] := DefaultPalHigh[i];

          // Restliche Farben gleichverteilen:
          Color := ColorAdd;
          for i := 10 to 244 do
          begin
              Palette [i] := TPALETTEENTRY(Color);
              Color := Color + ColorAdd;
          end;


          // Nun Palette in Datei schreiben:
          WriteFile (datei,Palette,sizeof (Palette),written,Nil);

          // uns Schlieen
          CloseHandle (datei);
     end;
end;
procedure TMMPalettenEditor.CreateBtnClick(Sender: TObject);
begin
   // Normpalette erzeugen:
   CreatePalette (m_PalFile);

   // Palette laden :
   LoadPalette;
end;

procedure TMMPalettenEditor.LoadPalette;
var hFile : THandle;
    zeile,spalte,c,index,read : Integer;
    szFile : array [0..MAX_PATH] of char;
begin
   strPcopy (szFile,m_PalFile);
   hFile :=CreateFile (szFile,GENERIC_READ,FILE_SHARE_READ,
                       Nil,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,0);
   if hFile <> INVALID_HANDLE_VALUE then
   begin
      // Palette laden
      ReadFile (hFile,m_Palette,sizeof (m_Palette),read,Nil);
      // und wieder schlieen:
      CloseHandle (hFile);
   end;

        // Palettenanzeige erzeugen :
   for zeile := 0 to 15 do begin
       for spalte := 0 to 15 do begin
           index := zeile * 16 + spalte;
           c := TColor(m_Palette[index]);
           m_Shapes [index].Brush.Color := (c and $ff00ff00) or
              ((c and $00ff0000)shr 16) or ((c and $000000ff) shl 16);

       end;
   end;
end;


procedure TMMPalettenEditor.LoadClick(Sender: TObject);
var hFile,hWrite : THANDLE;
    Info : TBitmapFileHeader;
    InfoHeader : TBitmapInfoHeader;
    szFile : array [0..MAX_PATH] of char;
    read : Integer;
    pal : TPalette;
begin
     // letzten Pfad als Default ermitteln
     OpenDialog.InitialDir := MMPBGetValue (cOptions,cCustomColor,'LastPath');
     if OpenDialog.Execute = TRUE then
     begin
        strpcopy (szFile,OpenDialog.FileName);
        // Palette laden:
        hFile := CreateFile (szFile,GENERIC_READ,FILE_SHARE_READ,
                       Nil,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,0);
        // Filw-Header laden:
        ReadFile (hFile,Info,sizeof (Info),read,NIL);

        if Info.bfType <> $4d42 then
        begin
           MessageDlg ('This is not a valid Bitmap-File.',mtError,[mbAbort],0);
        end else begin
           // InfoHeader laden:
           ReadFile (hFile,InfoHeader,sizeof (InfoHeader),read,NIL);
           if InfoHeader.biBitCount <> 8 then
           begin
              MessageDlg ('This is Bitmap has not 256 Colors.',mtError,[mbAbort],0);
           end else begin
              // Palette laden
              ReadFile (hFile,pal,sizeof (pal),read,NIL);

             // Datei zum Schreiben ffnen
             strPcopy (szFile,m_PalFile);
             hWrite := CreateFile (szFile,GENERIC_WRITE,FILE_SHARE_WRITE,
                         Nil,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,0);
             // Palette schreiben
             WriteFile (hWrite,pal,sizeof (pal),read,NIL);
             CloseHandle (hWrite); // und schlieen
           end;
        end;

        // Datei schlieen
        CloseHandle (hFile);

        LoadPalette;
     end;
end;

end.
