{***********************
  Media-Manager
************************
 (c) 1996 by
 Olaf Panz
 Drosselgasse 4
 21436 Marschacht
***********************}
unit UMMPictureBase;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs,
  UMMTools,
  Memory,
  UMMAssign;

type

  TPictData = record
     iWidth : Integer;
     iHeight : Integer;
     pData : PChar;
  end;

  // Zeiger auf Zeichenfunktion zum Neuzeichnen
  // eines Fensterbereichs:
  TRepaintArea = procedure (PaintRect : TRect) of object;


  TMMPictureBase = class(TGraphicControl)
  private

  protected
    { Private-Deklarationen }
    FVisible : Boolean; // Ist die Komponente sichtbar?
    PictData : TPictData; { Bild-Daten }
    FPicture : Integer; { Picture- Identifier }

    // Da das Setzen von Top/Left nur ber ererbte Funktionen
    // mglich ist, und diese ein neuzeichnen ber Windows-Funktionen
    // initieren, was ein Bildflackern verursacht, wird zur Laufzeit
    // eine Positionsnderung ber Move und MoveLeft bzw. MoveTop
    // bearbeitet.

    MoveLeft,MoveTop : Integer;

    pRepaintArea : TRepaintArea; { Zeiger auf Zeichenfunktion }


    // Bei nderung der Bounds Neuzeichnen den Neuen + Alten Bereichs
    // Einleiten
    procedure Setbounds(ALeft, ATop, AWidth, AHeight: Integer); override;

    // Eigenschaft Visible setzen:
    procedure SetVisible (blVisible : Boolean);

    // Komponente neu zeichnen
    procedure ReDraw;

  public
    { Public-Deklarationen }
    constructor Create (AOwner : TComponent); override;
    destructor Destroy; override;

    // Aufruf durch Paint-Area
    procedure PaintEx (pBackBuffer : PChar;PaintRect : TRect;hAssign : TAssignHandle;
          DestWidth32,DestHeight : Integer);

    // Bewege Komponente zur Laufzeit nach :
    procedure Move (iLeft,iTop : Integer);

    // Zeiger auf Paint-Area setzen:
    procedure SetPaintFunc (PaintFunc : TRepaintArea);

  published
    { Published-Deklarationen }
    property Width;
    property Height;
    property Align;
    property Visible read FVisible write SetVisible;

    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;


  end;


implementation

destructor TMMPictureBase.Destroy;
begin
     if (PictData.pData <> Nil) then
     begin
          FreeMem (PictData.pData);
          PictData.pData := Nil;
     end;
     inherited;
end;


constructor TMMPictureBase.Create (AOwner : TComponent);
begin
     // Defaultwerte setzen
     pRepaintArea := Nil;
     PictData.pData := Nil;
     Width := 50;
     Height := 50;
     FPicture := 0;
     FVisible := TRUE;

     inherited Create (AOwner);
end;

procedure TMMPictureBase.PaintEx (pBackBuffer : PChar;PaintRect : TRect;hAssign : TAssignHandle;
          DestWidth32,DestHeight : Integer);
var X,Y,W,H : Integer;
    xOff,yOff,SrcWidth32 : Integer;
    i : Integer;
    pSrc,pDest : PChar;
begin
     if FVisible = TRUE then
     begin
        if PaintRect.Top > MoveTop then begin
           Y := PaintRect.Top;
           yOff := Y - MoveTop;
        end else begin
           Y := MoveTop;
           yOff := 0;

        end;

        if PaintRect.Left > MoveLeft then begin
           X := PaintRect.Left;
           xOff := X - MoveLeft
        end else begin
           X := MoveLeft;
           xOff := 0;
        end;

        if PaintRect.Bottom < (MoveTop + Height) then
           H := PaintRect.Bottom - y -1
        else
           H := (MoveTop + Height) - y -1;

        if PaintRect.Right < (MoveLeft + Width) then
           W := PaintRect.Right - x
        else
           W := (MoveLeft + Width) - x ;


         // gibt es einen sichtbaren Bereich?
        if (W > 0) and (H > 0) then
        begin
           if PictData.pData = Nil then // Ist das Bild schon geladen?
           begin
                // Die Gre des Mediums ermitteln
                MMAGetMedia (hAssign,FPicture,@PictData,8); // nur Width,Height laden
                SrcWidth32 := Norm32(PictData.iWidth);
                i := SrcWidth32 * PictData.iHeight + 8;
                // Speicher allokieren
                PictData.pData := AllocMem (i);
                MMAGetMedia (hAssign,FPicture,PictData.pData,i); // Gesamtes Bild laden
           end else
              SrcWidth32 := Norm32(PictData.iWidth);

           pDest := pBackBuffer + x + (DestHeight -y -h-1) * DestWidth32;
           // entspricht die Mediengre der Componentengre?
           if (Width = PictData.iWidth) and (Height = PictData.iHeight) then
           begin
              // Bild in Buffer kopieren
              pSrc := PictData.pData + 8 + xOff + (PictData.iHeight - yOff -h-1) * SrcWidth32;
              for i := 0 to h do
              begin
                 memcpyTransparency (pDest + i * DestWidth32,
                        pSrc + i * SrcWidth32,W);
              end;
          end else begin
              for i := 0 to h do // Wenn Bild nicht angezeigt werden kann
              // Bildschirmbereich ausfllen
              begin
                 memset (pDest + i * DestWidth32,FPicture and 255,W);
              end;

          end;

        end;

   end; // if Visible = TRUE ...
end;


// Bei nderung der Bounds Neuzeichnen den Neuen + Alten Bereichs
// Einleiten
procedure TMMPictureBase.Setbounds(ALeft, ATop, AWidth, AHeight: Integer);
begin
   // in Move-Koordinaten speichern:
   MoveLeft := ALeft;
   MoveTop := ATop;

   inherited SetBounds (ALeft,ATop,AWidth,AHeight);
end;

// Bewege Komponente zur Laufzeit nach :
procedure TMMPictureBase.Move (iLeft,iTop : Integer);
var UniRect : TRect;
begin
   // nur etwas tun, wenn Zeiger auf Zeichenfunktion bekannt!
   if Assigned (pRepaintArea) then
   begin
      // Vereinigung von neuem und alten Rect bilden:
      if iLeft < MoveLeft then
      begin
         UniRect.Left := iLeft;
         UniRect.Right := MoveLeft + Width;
      end else begin
         UniRect.Left := MoveLeft;
         UniRect.Right := iLeft + Width;
      end;

      if iTop < MoveTop then
      begin
         UniRect.Top := iTop;
         UniRect.Bottom := MoveTop + Height;
      end else begin
         UniRect.Top := MoveTop;
         UniRect.Bottom := iTop + Height;
      end;

      // Neue Values setzen
      MoveTop := iTop;
      MoveLeft := iLeft;

      // genderten Bereich neu Zeichnen:
      pRepaintArea (UniRect);
   end;

end;

procedure TMMPictureBase.SetVisible (blVisible : Boolean);
begin
     if blVisible <> FVisible then // Nur etwas tun, wenn der Wert sich vom alten unterscheidet!
     begin
          // Wert Merken
          FVisible := blVisible;

          // Eigenen Bereich neu zeichnen lassen:
          ReDraw;
     end;
end;


// Komponente neu zeichnen
procedure TMMPictureBase.ReDraw;
var Rect : TRect;
begin
   // Eigenen Bereich neu zeichnen lassen:
   if (Parent.HandleAllocated = TRUE) and (Assigned (pRepaintArea)) then
   begin
      // Rect erzeugen
      Rect.Top := Top;
      Rect.Left := Left;
      Rect.Bottom := Rect.Top + Height;
      Rect.Right := Rect.Left + Width;
      pRepaintArea (Rect);
   end;

end;

// Zeiger auf Paint-Area setzen:
procedure TMMPictureBase.SetPaintFunc (PaintFunc : TRepaintArea);
begin
     pRepaintArea := PaintFunc;
end;




end.
