{***********************
  Media-Manager
************************
 (c) 1996 by
 Olaf Panz
 Drosselgasse 4
 21436 Marschacht
***********************}
unit UMMPictureComponentEdit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  UMMComponentEdit,UMMBase,UMMTools,UMMPictureEditor,UMMPicture,
  UMMSelectPictureDialog;

type
  TMMPictureComponentEdit = class(TMMComponentEdit)
  private
    { Private-Deklarationen }
  protected
    { Protected-Deklarationen }
    procedure ExecPictureEdit;

  public
    { Public-Deklarationen }
     function GetVerb(Index: Integer): string; override;
     function GetVerbCount: Integer; override;
     procedure ExecuteVerb(Index: Integer); override;


  published
    { Published-Deklarationen }
  end;


implementation

function TMMPictureComponentEdit.GetVerb(Index: Integer): string;
begin
   case Index of
      0 : GetVerb := '&Bild auswhlen';
      1 : GetVerb := 'Me&dia Manager';
      2 : GetVerb := 'Distribution erstellen';
   end;
end;


function TMMPictureComponentEdit.GetVerbCount: Integer;
begin
     GetVerbCount := 3;
end;

procedure TMMPictureComponentEdit.ExecuteVerb(Index: Integer);
begin
     case Index of
          0 : ExecPictureEdit;
          1 : ExecMediaMan;
          2 : ExecDistribution;
     end;
end;

procedure TMMPictureComponentEdit.ExecPictureEdit;
var Select : TMMSelectPictureDialog;
    Pict : TMMPicture;
begin
   Pict := Component as TMMPicture;
   Select := TMMSelectPictureDialog.CreateEx (Application,MMGetForm (Pict),Pict.Picture );

   if Select.ShowModal = mrOK then
   begin
      // Genderte Daten zurckschreiben
      Pict.Picture := Select.m_iIdent;
   end;

   Designer.Modified;
   Select.Free;
end;


end.
