{***********************
  Media-Manager
************************
 (c) 1996 by
 Olaf Panz
 Drosselgasse 4
 21436 Marschacht
***********************}
unit UMMPictureDimensionProperty;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  dsgnintf,UMMBase,UMMTools,
  UMMConvertPicture,
  UMMDevelopingTools,
  UMMPictureBase,
  UMMPicture,
  UMMAnimatedPicture;

type
  TMMPictureDimensionProperty = class(TIntegerProperty)
  private
    { Private-Deklarationen }
  protected
    { Protected-Deklarationen }
  public
    { Public-Deklarationen }
    function GetValue : string; override;

  published
    { Published-Deklarationen }
  end;


implementation

function TMMPictureDimensionProperty.GetValue : string;
var c : TMMPictureBase;
    Old,Value,Name,Chapter,Form,Key : string;
    iIdent : Integer;
    Count : Integer;
begin
     // Aktuellen Wert ermitteln
     Value := inherited GetValue;

     // Keys fr Zugriff auf alte Daten ermitteln:
     Name := GetName;
     c := GetComponent(0) as TMMPictureBase;
     Form := MMGetForm (c).Name ;
     Chapter := 'PC*' + c.Name;

     // Alten Value ermitten:
     Old := MMPBGetValue (Form,Chapter,Name);

     // ein neuer Wert?
     if Old <> Value then
     begin
          // Wert setzen
          MMPBSetValue (Form,Chapter,Name,Value);

          // In den Optionen nachschauen, ob
          // die Grafik sofort angepasst werden soll:
          if OPTGetBool (cMisc,'TransformMedia') = TRUE then
          begin
             // ber alle Chapter iterieren
             // und alle MM*Picture, die sich auf diese Komponente beziehen
             // neu konvertieren

             // ANzahl der Chapter ermitteln
             Count := MMPBGetKeyCount (Form,''); // Anzahl der Chapter ermitteln
             while Count > 0 do
             begin
                Key := MMPBGetKey (Form,'',Count-1);
                if copy (Key,0,3) = 'MM*' then
                begin // Beschreibt Chapter ein Medium?
                   Old := MMPBGetValue (Form,Key,cType);// Type ermitteln

                   // handelt es sich um ein Bild?
                   if Old = cPicture then
                   begin
                      // Ist dieses Bild mit der aktuellen Komponente verknpft?
                      Old := MMPBGetValue (Form,Key,'Component');
                      if Old = c.Name then
                      begin
                         // Aus Chaptername den Media-Name erzeugen:
                         Key := Copy (Key,4,Length (Key)-3);

                         // Identifier ermitteln:
                         iIdent := MMPBGetIdentifier (Form,Key);

                         // und Bild .konvertieren:
                         MMConvertPicture (Form,iIdent);

                      end;
                   end;

                end;
                Count := Count -1;
             end;
             // neuladen initiieren:
             if GetComponent (0) is TMMPicture then
               (GetComponent (0) as TMMPicture).Picture := (GetComponent (0) as TMMPicture).Picture;
             if GetComponent (0) is TMMAnimatedPicture then
               (GetComponent (0) as TMMAnimatedPicture).PictureIndex := (GetComponent (0) as TMMAnimatedPicture).PictureIndex;

          end;
     end;



     GetValue := Value;
end;

end.
