{***********************
  Media-Manager
************************
 (c) 1996 by
 Olaf Panz
 Drosselgasse 4
 21436 Marschacht
***********************}
unit UMMPictureEditor;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls,CommDlg,
  UMMBase, Dialogs,
  UMMConvertPicture,
  UMMTools,
  UMMDevelopingTools;

type
  TDimKind = (User,Component);

  TMMPictureEditor = class(TForm)
    Label1: TLabel;
    m_File: TLabel;
    m_OK: TBitBtn;
    m_Help: TBitBtn;
    m_Load: TBitBtn;
    Label3: TLabel;
    m_DitherType: TComboBox;
    GroupBox1: TGroupBox;
    m_DimComponent: TRadioButton;
    m_DimComp: TComboBox;
    m_EditWidth: TEdit;
    m_EditHeight: TEdit;
    m_EditWidthLabel: TLabel;
    m_DimUser: TRadioButton;
    m_EditHeightLabel: TLabel;
    GroupBox2: TGroupBox;
    m_UseTrans: TCheckBox;
    m_TransRedLabel: TLabel;
    m_TransGreenLabel: TLabel;
    m_TransBlueLabel: TLabel;
    m_TransRed: TEdit;
    m_TransGreen: TEdit;
    m_TransBlue: TEdit;
    m_TransShape: TShape;
    m_EditTransColor: TBitBtn;
    m_Aktualize: TBitBtn;
    ScrollBox1: TScrollBox;
    m_Image: TImage;
    OpenDialog: TOpenDialog;
    m_Shape: TShape;
    procedure FormCreate(Sender: TObject);
    procedure m_OKClick(Sender: TObject);
    procedure m_AktualizeClick(Sender: TObject);
    procedure m_DitherTypeChange(Sender: TObject);
    procedure m_DimCompChange(Sender: TObject);
    procedure m_DimComponentClick(Sender: TObject);
    procedure m_DimUserClick(Sender: TObject);
    procedure m_UseTransClick(Sender: TObject);
    procedure m_TransRedChange(Sender: TObject);
    procedure m_TransGreenChange(Sender: TObject);
    procedure m_TransBlueChange(Sender: TObject);
    procedure m_EditWidthChange(Sender: TObject);
    procedure m_EditHeightChange(Sender: TObject);
    procedure m_EditTransColorClick(Sender: TObject);
    procedure m_LoadClick(Sender: TObject);
  private
    { Private declarations }
    m_stForm : string; // Formular
    m_iIdent : Integer; // Identifier des Bildes

    m_stChapter : string; // Daten Chapter
    m_Dithering : Integer; // aktuelles Dithering
    m_stFile : string; // Aktuelle Quelldatei
    m_stComponent : string; // Komponente, welche die Gre festlegt
    m_iWidth,m_iHeight : Integer; // Gre der Komponente
    m_OldTransparency,m_Transparency : Integer; // Transparenz-Farbe
    m_DimKind : TDimKind;

    m_IsPictureUpdated : Boolean;

  public
    { Public declarations }
    constructor CreateEx (AOwner : TComponent;Form : string;iIdent : Integer);

    procedure UpdatePicture; // Bild konvertieren und darstellen
    procedure SaveParameter; // Bearbeitete Daten speichern
    procedure SetDimensionFromComponent; // Bild-Dimension von Komponente ermitten, wenn
                                         // Abhngigkeit besteht
    procedure SetTransparency; // Transparenz setzen

    procedure SetDimension; // Gren-Dialogelemente setzen
  end;

  function MMEditPicture (Owner : TComponent;Form : string;iIdent : Integer) : Boolean;

implementation

{$R *.DFM}
const
     DitherTypes : array [0..7] of string =
                 ('None','Floyd Stein','Burkes','Stucki','Sierra',
                 'Stevenson','Jarvis','Ordered');

constructor TMMPictureEditor.CreateEx (AOwner : TComponent;Form : string;iIdent : Integer);
begin
     // Daten merken:
     m_stForm := Form;
     m_iIdent := iIDent;

     m_IsPictureUpdated := FALSE;

     inherited Create (AOwner);

end;


function MMEditPicture (Owner : TComponent;Form : string;iIdent : Integer) : Boolean;
var
  MMPictureEditor: TMMPictureEditor;
begin

  MMPictureEditor := TMMPictureEditor.CreateEx (Owner,Form,iIdent);

  MMPictureEditor.ShowModal;

  MMPictureEditor.Free;

  MMEditPicture := TRUE;

end;

procedure TMMPictureEditor.FormCreate(Sender: TObject);
var i,count,sel,j : Integer;
    stKey : string;
begin
   // aktuelle Bilddaten aus Datenbasis ermitteln:

   // Dazu Chapter-Name erzeugen
   m_stChapter := MMPBGetValue (m_stForm,cIdentifier,IntToStr (m_iIdent));

   // Dialogberschrift setzen
   Caption := m_stChapter;
   m_stChapter := 'MM*'+m_stChapter;

   // Datei ermitteln
   m_stFile := MMPBGetValue (m_stForm,m_stChapter,'Source');
   // Komponente ermitteln
   m_stComponent := MMPBGetValue (m_stForm,m_stChapter,'Component');

   try // try.except-Block wegen StrToInt
      // Dithering
      m_Dithering := StrToInt (MMPBGetValue (m_stForm,m_stChapter,'Dither'));
      // Breite
      m_iWidth := StrToInt (MMPBGetValue (m_stForm,m_stChapter,'Width'));
      // Hhe
      m_iHeight := StrToInt (MMPBGetValue (m_stForm,m_stChapter,'Height'));
      // Transparenz
      m_Transparency := StrToInt (MMPBGetValue (m_stForm,m_stChapter,'Transparency'));
      m_OldTransparency := m_Transparency;
   except
   end;

   if MMPBGetValue (m_stForm,m_stChapter,'DimKind') = 'User' then
      m_DimKind := User
   else
      m_DimKind := Component;

   // Dithering-Konstante init:
   m_DitherType.Items.Clear;
   for i:= 0 to 7 do
      m_DitherType.Items.Add (DitherTypes[i]);

   // aktuelles Dithering setzen:
   m_DitherType.ItemIndex := m_Dithering;

   // Komponentenliste init:
   m_DimComp.Items.Clear;
   // ber alle Chapter mit [PC*...] iterieren
   count := MMPBGetKeyCount (m_stForm,'') -1; // Anzahl der Chapter ermitteln
   sel := -1; // Selekted Index
   j := 0; // Zhlt die hinzugefgten Elemente:
   for i := 0 to count do
   begin
       stKey := MMPBGetKey (m_stForm,'',i);
       if copy (stKey,0,3) = 'PC*' then
       begin
          // aus Chapter Komponentenname ermitteln:
          stKey := copy (stKey,4,length (stKey));
          // Name in die Liste einfgen
          m_DimComp.Items.Add (stKey);
          // Handelt es sich um die aktuelle Auswahl?
          if stKey = m_stComponent then
             sel := j;
          j := j+1;
       end;
   end;

   if sel <> -1 then
      m_DimComp.ItemIndex := sel;

   if m_Transparency = -1 then
      m_UseTrans.Checked := FALSE
   else
      m_UseTrans.Checked := TRUE;

   // Gre setzen
   SetDimension;

   // Dialog init:
   UpdatePicture; // Bild konvertieren und darstellen

  // Dateiname schreiben
   m_File.Caption := m_stFile;

   SetTransparency;

end;


procedure TMMPictureEditor.UpdatePicture; // Bild konvertieren und darstellen
var path : array [0..MAX_PATH] of char;
begin
     if m_stFile <> '' then
     begin
        // Parameter speichern
        SaveParameter;
        // und Konvertierung durchfhren
        MMConvertPicture (m_stForm,m_iIdent);

        GetWindowsDirectory (path,MAX_PATH);

        // Bild in Dialog laden
        try
           m_Image.Picture.LoadFromFile (path + '\picedit.bmp');
           m_IsPictureUpdated := TRUE;
        except
        end;
     end;
end;


procedure TMMPictureEditor.SaveParameter; // Bearbeitete Daten speichern
var stDimKind : string;
begin
   // Source-Dateiname
   MMPBSetValue (m_stForm,m_stChapter,'Source',m_stFile);
   // Dithering
   MMPBSetValue (m_stForm,m_stChapter,'Dither',IntToStr (m_Dithering));
   // Breite
   MMPBSetValue (m_stForm,m_stChapter,'Width',IntToStr (m_iWidth));
   // Hhe
   MMPBSetValue (m_stForm,m_stChapter,'Height',IntToStr (m_iHeight));
   // Transparenz
   MMPBSetValue (m_stForm,m_stChapter,'Transparency',IntToStr (m_Transparency));

   // DimKind
   if m_DimKind = User then
      stDimKind := 'User'
   else begin
      stDimKind := 'Component';
      // Componente
      MMPBSetValue (m_stForm,m_stChapter,'Component',m_stComponent);
   end;

   MMPBSetValue (m_stForm,m_stChapter,'DimKind',stDimKind);

end;

procedure TMMPictureEditor.SetDimensionFromComponent; // Bild-Dimension von Komponente ermitten, wenn
                                         // Abhngigkeit besteht
var stChapter,stErg : string;
begin
   if m_DimKind = Component then begin
      // Chaptername ermitteln
      stChapter := 'PC*'+m_stComponent;

      // Breite ermitteln
      stErg := MMPBGetValue (m_stForm,stChapter,'Width');
      if stErg <> '' then
      begin
         try
            m_iWidth := StrToInt (stErg);
         except
         end;
      end;

      // Hhe ermitteln
      stErg := MMPBGetValue (m_stForm,stChapter,'Height');
      if stErg <> '' then
      begin
         try
            m_iHeight := StrToInt (stErg);
         except
         end;
      end;

   end;
end;

procedure TMMPictureEditor.SetTransparency; // Transparenz setzen
var Enable : Boolean;
begin
     if m_Transparency = -1 then
     begin
        Enable := FALSE;
        m_TransShape.Pen.Style := psClear;
        m_TransShape.Brush.Style := bsClear;
        m_TransRed.Text := '';
        m_TransGreen.Text:='';
        m_TransBlue.Text:= '';

     end else begin
        Enable := TRUE;
        // Transparenz-Farbe anzeigen
        m_TransShape.Pen.Style := psSolid;
        m_TransShape.Brush.Style := bsSolid;

        m_TransShape.Brush.Color := m_Transparency;
{        m_TransShape.Brush.Color := ((m_Transparency and $00ff0000) shr 16) or
                                    (m_Transparency and $0000ff00) or
                                    ((m_Transparency and $000000ff) shl 16); }

        m_TransBlue.Text := IntToStr ((m_Transparency and $00ff0000) shr 16);
        m_TransGreen.Text:=IntToStr ((m_Transparency and $0000ff00) shr 8 );
        m_TransRed.Text:= IntToStr (m_Transparency  and $000000ff);

     end;

     m_EditTransColor.Enabled := Enable;
     m_TransRed.Enabled := Enable;
     m_TransBlue.Enabled := Enable;
     m_TransGreen.Enabled := Enable;
     m_TransRedLabel.Enabled := Enable;
     m_TransBlueLabel.Enabled := Enable;
     m_TransGreenLabel.Enabled := Enable;

end;

procedure TMMPictureEditor.SetDimension; // Gren-Dialogelemente setzen
var blUser : Boolean;
begin


   if m_DimKind = User then begin
      blUser := TRUE;
      m_DimUser.Checked := TRUE;
   end else begin
      SetDimensionFromComponent; // Width/Height an Komponentengre anpassen

      blUser := FALSE;
      m_DimComponent.Checked := TRUE;
   end;

   // Mae angeben:
   m_EditWidth.Text := IntToStr (m_iWidth);
   m_EditHeight.Text := IntToStr (m_iHeight);

   m_EditWidth.Enabled := blUser;
   m_EditHeight.Enabled := blUser;
   m_EditWidthLabel.Enabled := blUser;
   m_EditHeightLabel.Enabled := blUser;

   if blUser = TRUE then
      blUser := FALSE
   else
      blUser := TRUE;

   m_DimComp.Enabled := blUser;


end;

procedure TMMPictureEditor.m_OKClick(Sender: TObject);
begin
   // Bild updaten, wenn nicht aktuell
   if m_IsPictureUpdated = FALSE then
   begin
      // nur updaten, wenn in den Optionen sofortiges
      // Updaten gewhlt ist!!!
      if OPTGetBool (cMisc,'TransformMedia') = TRUE then
            UpdatePicture;
   end;

   // Parameter sichern:
   SaveParameter;
   // Dialog beenden
   Close;
end;

procedure TMMPictureEditor.m_AktualizeClick(Sender: TObject);
begin
   // Bild updaten
   UpdatePicture;

end;

procedure TMMPictureEditor.m_DitherTypeChange(Sender: TObject);
begin
     m_Dithering := m_DitherType.ItemIndex;
     m_IsPictureUpdated := FALSE;
end;

procedure TMMPictureEditor.m_DimCompChange(Sender: TObject);
begin
   m_stComponent := m_DimComp.Items[m_DimComp.ItemIndex];
   m_IsPictureUpdated := FALSE;

   SetDimension;
end;

procedure TMMPictureEditor.m_DimComponentClick(Sender: TObject);
begin
   m_DimKind := Component;
   m_IsPictureUpdated := FALSE;
   SetDimension;
end;

procedure TMMPictureEditor.m_DimUserClick(Sender: TObject);
begin
   m_DimKind := User;
   m_IsPictureUpdated := FALSE;

   SetDimension;
end;

procedure TMMPictureEditor.m_UseTransClick(Sender: TObject);
begin
   m_IsPictureUpdated := FALSE;
   if m_UseTrans.Checked = TRUE then
   begin
      m_Transparency := m_OldTransparency;
   end else begin
      if m_Transparency = -1 then
         m_OldTransparency := 0
      else
         m_OldTransparency := m_Transparency;
         
      m_Transparency := -1;
   end;

   SetTransparency;
end;

procedure TMMPictureEditor.m_TransRedChange(Sender: TObject);
var i : Integer;
begin
   try
      i := StrToInt (m_TransRed.Text);
      m_Transparency := (m_Transparency and $ffffff00) or ( i and  $000000ff);
      SetTransparency;
      m_IsPictureUpdated := FALSE;

   except
   end;

end;

procedure TMMPictureEditor.m_TransGreenChange(Sender: TObject);
var i : Integer;
begin
   try
      i := StrToInt (m_TransGreen.Text);
      m_Transparency := (m_Transparency and $ffff00ff) or ((i shl 8) and $0000ff00);
      SetTransparency;
      m_IsPictureUpdated := FALSE;

   except
   end;
end;

procedure TMMPictureEditor.m_TransBlueChange(Sender: TObject);
var i : Integer;
begin
   try
      i := StrToInt (m_TransBlue.Text);
      m_Transparency := (m_Transparency and $ff00ffff) or ((i shl 16) and $00ff0000);
      SetTransparency;
      m_IsPictureUpdated := FALSE;

   except
   end;


end;

procedure TMMPictureEditor.m_EditWidthChange(Sender: TObject);
begin
   try
      m_iWidth := StrToInt (m_EditWidth.Text);
      m_IsPictureUpdated := FALSE;

   except
   end;
end;

procedure TMMPictureEditor.m_EditHeightChange(Sender: TObject);
begin
   try
      m_iHeight := StrToInt (m_EditHeight.Text);
      m_IsPictureUpdated := FALSE;
   except
   end;

end;


procedure TMMPictureEditor.m_EditTransColorClick(Sender: TObject);
var ColorDlgParam : TChooseColor;
    CustomColors : TCustomColors;
    i,color : Integer;
begin
   // ColorDlgParam Initialisieren
   ColorDlgParam.lStructSize := sizeof (TChooseColor);
   ColorDlgParam.hwndOwner := Handle;
   ColorDlgParam.hInstance := Application.Handle;
   ColorDlgParam.rgbResult := CustomColors[0];
   ColorDlgParam.lpCustColors := @CustomColors;
   ColorDlgParam.Flags := CC_FULLOPEN or CC_RGBINIT;
   ColorDlgParam.lCustData := 0;
   ColorDlgParam.lpfnHook := NIl;
   ColorDlgParam.lpTemplateName := Nil;

   //  Custom-Farben aus Datenbasis ermitteln
   for i := 0 to MaxCustomColors-1 do
   begin
      try
         color := StrToInt (MMPBGetValue(cOptions,cCustomColor,'Color'+ IntToStr(i)));
         CustomColors[i] := color;
      except
         CustomColors[i] := 0;
      end;
   end;


   ColorDlgParam.rgbResult := m_Transparency;

   if ChooseColor (ColorDlgParam) =TRUE then
   begin // Wurde Dialog mit OK beendet, Ergebnis merken:
      m_Transparency := ColorDlgParam.rgbResult;
      m_IsPictureUpdated := FALSE;


      // Dialog updaten
      SetTransparency;
   end;

   //  Custom-Farben in Datenbasis schreiben
   for i := 0 to MaxCustomColors-1 do
   begin
      MMPBSetValue (cOptions,cCustomColor,'Color' + IntToStr (i),
                   IntToStr(CustomColors[i]));
   end;


end;

procedure TMMPictureEditor.m_LoadClick(Sender: TObject);
begin

     OpenDialog.FileName := m_stFile;

     if OpenDialog.Execute = true then
     begin
        m_IsPictureUpdated := FALSE;
        m_stFile := OpenDialog.FileName;
        m_File.Caption := m_stFile;
        UpdatePicture;
     end;
    
end;

end.
