{***********************
  Media-Manager
************************
 (c) 1996 by
 Olaf Panz
 Drosselgasse 4
 21436 Marschacht
***********************}
unit UMMPictureProperty;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  dsgnintf,UMMSelectPictureDialog,UMMTools,
  UMMPicture,
  UMMBase;

type
  TMMPictureProperty = class(TPropertyEditor)
  private
    { Private-Deklarationen }
  protected
    { Protected-Deklarationen }
  public
    { Public-Deklarationen }
    function GetAttributes: TPropertyAttributes; override;
    procedure Edit; override;                  

    function GetValue: string; override;

  end;


implementation

function TMMPictureProperty.GetAttributes: TPropertyAttributes;
begin
     GetAttributes := [paDialog];
end;

procedure TMMPictureProperty.Edit;
var Select : TMMSelectPictureDialog;
    Pict : TMMPicture;
begin
   Pict := GetComponent (0) as TMMPicture;
   Select := TMMSelectPictureDialog.CreateEx (Application,MMGetForm (Pict),Pict.Picture );
   if Select.ShowModal = mrOK then
   begin
      // Datum zurckschreiben
      Pict.Picture := Select.m_iIdent;
   end;
   
   Select.Free;
end;


function TMMPictureProperty.GetValue: string;
var Pict : TMMPicture;
begin
   Pict := GetComponent(0) as TMMPicture;
   if Pict.Picture = 0 then
      GetValue := 'Nicht definiert'
   else
      GetValue := MMPBGetValue (MMGetForm (Pict).Name,cIdentifier,IntToStr(Pict.Picture));
end;


end.
