{***********************
  Media-Manager
************************
 (c) 1996 by
 Olaf Panz
 Drosselgasse 4
 21436 Marschacht
***********************}
unit UMMSelectDistribution;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls,dialogs,
  UMMBase;

type
  TMMSelectDistribution = class(TForm)
    DistNames: TComboBox;
    Label1: TLabel;
    OK: TBitBtn;
    BitBtn2: TBitBtn;
    Help: TBitBtn;
    Add: TSpeedButton;
    Delete: TSpeedButton;
    procedure FormCreate(Sender: TObject);
    procedure AddClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure DeleteClick(Sender: TObject);
  private
    { Private declarations }

    FSelection : string;

    procedure FillDistributionList;

  public
    { Public declarations }
  published

    property Selection : string read FSelection;

  end;


implementation

{$R *.DFM}

procedure TMMSelectDistribution.FormCreate(Sender: TObject);
begin
     // Dialog initialisieren
     FillDistributionList;
end;

// Distributionsliste mit definierten Distributionen fllen:
procedure TMMSelectDistribution.FillDistributionList;
var stLast,stVal : string;
    i,j,count : Integer;

begin
   stLast := MMPBGetValue (cOptions,cDistribute,'LastSelection');

   // Anzahl der Distributionen ermitteln
   try
      count := StrToInt (MMPBGetValue (cOptions,cDistribute,'Count'));
   except
      count := 0;
   end;

   // Liste im Dialog lschen:
   DistNames.Items.Clear;

   // ber alle Distributionen iterieren:
   j := -1;
   for i := 1 to count do
   begin
      stVal := MMPBGetValue (cOptions,cDistribute,IntToStr (i));
      if stVal = stLast then
         j := i-1;
      DistNames.Items.Add (stVal);
   end;

   // Ist die letzte Auswahl in der LIste?
   if j <> -1 then
   begin
      DistNames.ItemIndex := j;
   end else begin
      if count > 0 then
         DistNames.ItemIndex := 0;
   end;

end;


procedure TMMSelectDistribution.AddClick(Sender: TObject);
var stNew : string;
    i : integer;
begin
     stNew := InputBox ('Neue Distribution','Geben Sie einen neuen Namen ein:','');
     if stNew <> '' then
     begin
        if DistNames.Items.IndexOf (stNew) <> -1 then
        begin
           MessageDlg ('Es existiert bereits eine Distribution mit diesem Namen!',
                      mtError,[mbAbort],0);
        end else begin
           // Anzahl der Verwalteten Distributionen ermitteln
           try
              i := StrToInt (MMPBGetValue (cOptions,cDistribute,'Count'));
           except
              i := 0;
           end;
           i := i +1;

           // Datum schreiben
           MMPBSetValue (cOptions,cDistribute,IntToStr (i),stNew);
           // Neue Anzahl schreiben
           MMPBSetValue (cOptions,cDistribute,'Count',IntToStr (i));
           // Letzte Selektion schreiben
           MMPBSetValue (cOptions,cDistribute,'LastSelection',stNew);


           // Liste updaten
           FillDistributionList;
        end;
     end;
end;

procedure TMMSelectDistribution.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
     FSelection := DistNames.Text;

     // letzte Auswahl speichern
     MMPBSetValue (cOptions,cDistribute,'LastSelection',FSelection);
end;

procedure TMMSelectDistribution.DeleteClick(Sender: TObject);
var i,iSel : Integer;
begin
    iSel := DistNames.ItemIndex;

    if iSel = -1 then
    begin
       MessageDlg ('Es ist keine Distribution zum lschen ausgewhlt!',mtError,[mbAbort],0);
    end else begin
       // Datum lschen
       DistNames.Items.Delete (iSel);

       // und Daten zurckschreiben:

       // zuerst Chapter lschen
       MMPBDelValue (cOptions,cDistribute,'');

       // Anzahl der Elemente ermitteln
       iSel := DistNames.Items.Count;

       // Neue Anzahl schreiben
       MMPBSetValue (cOptions,cDistribute,'Count',IntToStr (iSel));

       // Daten schreiben
       for i := 1 to iSel do
       begin
          MMPBSetValue (cOptions,cDistribute,IntToStr (i),DistNames.Items[i-1]);
       end;

       // Liste updaten
       FillDistributionList;

    end;

end;

end.
