{***********************
  Media-Manager
************************
 (c) 1996 by
 Olaf Panz
 Drosselgasse 4
 21436 Marschacht
***********************}
unit UMMSelectSoundDialog;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls,
  UMMBase,
  UMMMediaManager,
  UMMSoundEditDialog;

type
  TMMSelectSoundDialog = class(TForm)
    Bevel1: TBevel;
    Cancel: TBitBtn;
    Help: TBitBtn;
    OK: TBitBtn;
    PictureList: TComboBox;
    Label1: TLabel;
    Edit: TBitBtn;
    MediaMan: TBitBtn;
    procedure MediaManagerClick(Sender: TObject);
    procedure OKClick(Sender: TObject);
    procedure EditClick(Sender: TObject);
    procedure PictureListChange(Sender: TObject);
  private
    { Private declarations }
    m_Form : TForm;

  protected 

    // Edit-Button auswhleb
    procedure SelectEdit (blSelect : Boolean);
    procedure UpdateList;

  public
    { Public declarations }
    m_iIdent : Integer; // Auswahl, Ergebnis1

    constructor CreateEx (AOwner : TComponent;Form : TForm;iIdent : Integer);

  end;

//var
//  MMSelectPictureDialog: TMMSelectPictureDialog;

implementation

{$R *.DFM}

{ Public declarations }
constructor TMMSelectSoundDialog.CreateEx (AOwner : TComponent;Form : TForm;iIdent : Integer);
begin
     inherited Create (AOwner);
     m_Form := Form;
     m_iIdent := iIdent;

     UpdateList;

end;

procedure TMMSelectSoundDialog.UpdateList;
var count : Integer;
    Key,Value : string;
    blSelect : Boolean;
begin
  Count := MMPBGetKeyCount (m_Form.Name,''); // Anzahl der Chapter ermitteln
  PictureList.Items.Clear;

  while Count > 0 do
  begin
     Key := MMPBGetKey (m_Form.Name,'',Count-1);

     if copy (Key,0,3) = 'MM*' then
     begin // Beschreibt Chapter ein Medium?
        Value := MMPBGetValue (m_Form.Name,Key,cType);// Type ermitteln

        if Value = cSound then
        begin
           // Aus Chaptername den Media-Name erzeugen:
           Key := Copy (Key,4,Length (Key)-3);
           // Und der Combo-Box hinzufgen
           PictureList.Items.Add (Key);
        end
     end;
     Count := Count -1;
  end;


  if m_iIdent <> 0 then
  begin
     Key := MMPBGetValue (m_Form.Name,cIdentifier,IntToStr(m_iIdent));
  // Aktuelle Auswahl selektieren:
     PictureList.ItemIndex := PictureList.Items.IndexOf (Key);
     blSelect := TRUE;
  end else begin
     blSelect := FALSE;
  end;

  SelectEdit (blSelect);
end;
procedure TMMSelectSoundDialog.MediaManagerClick(Sender: TObject);
var Manager : TMMMediaManager;
begin
   Manager := TMMMediaManager.CreateEx (Application,m_Form);
   Manager.ShowModal;
   Manager.Free;

end;

procedure TMMSelectSoundDialog.OKClick(Sender: TObject);
begin
     m_iIdent := MMPBGetIdentifier (m_Form.Name,PictureList.Items[PictureList.ItemIndex]);
     inherited;
end;

procedure TMMSelectSoundDialog.EditClick(Sender: TObject);
var iIdent : Integer;
begin
   // Picture-Identifier ermitteln :
   iIdent :=MMPBGetIdentifier (m_Form.Name,PictureList.Items[PictureList.ItemIndex]);

   if iIdent > 1 then
      MMEditSound (Self,m_Form.Name,iIdent);

   UpdateList;

end;

// Edit-Button auswhlen
procedure TMMSelectSoundDialog.SelectEdit (blSelect : Boolean);
begin
     Edit.Enabled := blSelect;
end;


procedure TMMSelectSoundDialog.PictureListChange(Sender: TObject);
begin
     if PictureList.Text <> '' then
        SelectEdit (TRUE)
     else
        SelectEdit (FALSE);
end;


end.
