{***********************
  Media-Manager
************************
 (c) 1996 by
 Olaf Panz
 Drosselgasse 4
 21436 Marschacht
***********************}
unit UMMSoundEditDialog;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls, Dialogs, UMMBase,mmsystem,
  UMMFileSys,
  UMMSoundListener,
  UMMSoundEmitter;

type
  TMMSoundEditDialog = class(TForm)
    Label1: TLabel;
    Medium: TLabel;
    Panel1: TPanel;
    Label3: TLabel;
    SoundFile: TEdit;
    Search: TBitBtn;
    Play: TSpeedButton;
    Ok: TBitBtn;
    Help: TBitBtn;
    Cancel: TBitBtn;
    OpenDialog: TOpenDialog;
    Stop: TSpeedButton;
    MMSoundEmitter: TMMSoundEmitter;
    MMSoundListener1: TMMSoundListener;
    procedure SoundFileExit(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure PlayClick(Sender: TObject);
    procedure SearchClick(Sender: TObject);
    procedure OkClick(Sender: TObject);
    procedure StopClick(Sender: TObject);
  private
    { Private declarations }
    m_stFormName : string; // Name des Formulars
    m_stMediaName : string; // Name des Mediums
    m_stChapter : string; // Name des Chapters in der Datenbasis
    m_stFilename : string; // Dateiname des Klangs
    m_iIdentifier : Integer;


    procedure EnablePlay (blEnable : Boolean);

  public
    { Public declarations }
    constructor CreateEx (AOwner : TComponent;stFormName : string;iIdentifier : Integer);

  end;



function MMEditSound (AOwner : TComponent;stFormName : string;iIdentifier : Integer): Boolean;

implementation

{$R *.DFM}

constructor TMMSoundEditDialog.CreateEx (AOwner : TComponent;stFormName : string;iIdentifier : Integer);
begin
     m_stFormName := stFormName;
     m_iIdentifier := iIdentifier;
     m_stMediaName := MMPBGetValue (m_stFormName,cIdentifier,IntToStr (iIdentifier));
     m_stChapter := 'MM*' + m_stMediaName;
     m_stFilename := MMPBGetValue (m_stFormName,m_stChapter,cSource); // Dateiname der WAVE ermitteln

     inherited Create (AOwner);
end;


procedure TMMSoundEditDialog.SoundFileExit(Sender: TObject);
begin
     if FileExists (SoundFile.Text) = FALSE then
     begin
        EnablePlay (FALSE);
     end else begin
        EnablePlay (TRUE);
        m_stFilename := SoundFile.Text;
     end;
end;

procedure TMMSoundEditDialog.EnablePlay (blEnable : Boolean);
begin
  Play.Enabled := blEnable;
end;


procedure TMMSoundEditDialog.FormCreate(Sender: TObject);
begin
     // Name der Komponente anzeigen
     Medium.Caption := m_stMediaName;

     // Dateiname anzeigen
     if FileExists (m_stFilename) = TRUE then
     begin
        SoundFile.Text := m_stFilename;
        EnablePlay (TRUE);
     end else begin
        EnablePlay (FALSE);
     end;

end;

function MMEditSound (AOwner : TComponent;stFormName : string;iIdentifier : Integer): Boolean;
var dlg : TMMSoundEditDialog;
begin
   dlg := TMMSoundEditDialog.CreateEx (AOwner,stFormName,iIdentifier);
   if dlg.ShowModal = mrOK then
      MMEditSound := TRUE
   else
      MMEditSound := FALSE;
   dlg.Free;
end;

procedure TMMSoundEditDialog.PlayClick(Sender: TObject);
begin
   MMSoundEmitter.Stop;
   MMSoundEmitter.SoundFile := m_stFilename;
   MMSoundEmitter.Play;
end;


procedure TMMSoundEditDialog.SearchClick(Sender: TObject);
begin
   OpenDialog.FileName := m_stFilename;
   if OpenDialog.Execute = TRUE then
   begin
      m_stFileName := OpenDialog.FileName;
      SoundFile.Text := m_stFilename;
      EnablePlay (TRUE);
   end;

end;

procedure TMMSoundEditDialog.OkClick(Sender: TObject);
var stDest : string;
begin
   MMPBSetValue (m_stFormName,m_stChapter,cSource,m_stFilename);

   // Destination File ermitten
   stDest := MMPBGetMediaWorkFile (m_stFormName,m_iIdentifier);
   // Klang Datei in die Datenbasis kopieren:
   MMCopyFile (stDest,m_stFilename,TRUE,Application.Handle,'Kopiere Klang in Datenbasis...');
end;

procedure TMMSoundEditDialog.StopClick(Sender: TObject);
begin
   MMSoundEmitter.Stop;
end;

end.
