{***********************
  Media-Manager
************************
 (c) 1996 by
 Olaf Panz
 Drosselgasse 4
 21436 Marschacht
***********************}
unit UMMSoundEmitterComponentEdit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  UMMComponentEdit,UMMBase,UMMTools,
  UMMSoundEmitter,
  UMMSelectSoundDialog;

type
  TMMSoundEmitterComponentEdit = class(TMMComponentEdit)
  private
    { Private-Deklarationen }
  protected
    { Protected-Deklarationen }
    procedure ExecSoundEdit;

  public
    { Public-Deklarationen }
     function GetVerb(Index: Integer): string; override;
     function GetVerbCount: Integer; override;
     procedure ExecuteVerb(Index: Integer); override;


  published
    { Published-Deklarationen }
  end;


implementation

function TMMSoundEmitterComponentEdit.GetVerb(Index: Integer): string;
begin
   case Index of
      0 : GetVerb := '&Klang auswhlen';
      1 : GetVerb := 'Me&dia Manager';
      2 : GetVerb := 'Distribution erstellen';
   end;
end;


function TMMSoundEmitterComponentEdit.GetVerbCount: Integer;
begin
     GetVerbCount := 3;
end;

procedure TMMSoundEmitterComponentEdit.ExecuteVerb(Index: Integer);
begin
     case Index of
          0 : ExecSoundEdit;
          1 : ExecMediaMan;
          2 : ExecDistribution;
     end;
end;

procedure TMMSoundEmitterComponentEdit.ExecSoundEdit;
var Select : TMMSelectSoundDialog;
    Sound : TMMSoundEmitter;
begin
   Sound := Component as TMMSoundEmitter;
   Select := TMMSelectSoundDialog.CreateEx (Application,MMGetForm (Sound),Sound.Sound );

   if Select.ShowModal = mrOK then
   begin
      // Genderte Daten zurckschreiben
      Sound.Sound := Select.m_iIdent;
   end;

   Designer.Modified;
   Select.Free;
end;


end.
