{***********************
  Media-Manager
************************
 (c) 1996 by
 Olaf Panz
 Drosselgasse 4
 21436 Marschacht
***********************}
unit UMMSoundListener;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  UAAudio,
  UMMTools;

const UpVector : VECTOR3D = (X:0;Y:1;Z:1);

type
  TMMSoundListener = class(TComponent)
  private
    { Private-Deklarationen }
    m_Enviroment : TAAEnviroment; //  Umgebungsdaten, derzeit nicht implementiert

    m_ListenerDesc : AALISTENERDESC; // Listener-Daten

    m_Position : TVector3D;
    m_Orientation : TVector3D;
    m_Listener : IAAudioListener;

  protected
    { Protected-Deklarationen }

    // Zugriffe auf Propertys:
    procedure SetEnviroment (env : TAAEnviroment);
    procedure SetOutputDeviceType (output : AAOutputDeviceType);
    procedure SetPosition (position : TVector3D);
    procedure SetOrientation (orientation : TVector3D);

    // Listener-Objekt erzeugen
    procedure CreateListener;

    // Listener-Objekt entfernen
    procedure DestroyListener;

    procedure UpdatePosition;
    procedure UpdateEnviroment;
    procedure UpdateOrientation;


  public
    { Public-Deklarationen }
    constructor Create (AOwner : TComponent); override;
    destructor Destroy; override;

  published
    { Published-Deklarationen }

    // Enviroment
    property Enviroment : TAAEnviroment read m_Enviroment write SetEnviroment;

    // Listener
    property OutputDeviceType : AAOutputDeviceType read m_ListenerDesc.device write SetOutputDeviceType;

    // Position
    property Position : TVector3D read m_Position write SetPosition;
    property Orientation : TVector3D read m_Orientation write SetOrientation;

  end;


implementation

procedure TMMSoundListener.SetOutputDeviceType (output : AAOutputDeviceType);
begin
     m_ListenerDesc.device := output;

     // Gleich anpassen, indem LIstener zerstrt und neu erzeugt wird
     DestroyListener;
     CreateListener;
end;

// Zugriffe auf Propertys:
procedure TMMSoundListener.SetEnviroment (env : TAAEnviroment);
begin
     m_Enviroment := env;
     UpdateEnviroment;
end;


procedure TMMSoundListener.SetPosition (position : TVector3D);
begin
     m_Position := position;
     UpdatePosition;
end;

procedure TMMSoundListener.SetOrientation (orientation : TVector3D);
begin
     m_Orientation := orientation;
     UpdateOrientation;
end;

procedure TMMSoundListener.UpdatePosition;
var erg : HRESULT;
begin
     if m_Listener <> Nil then
     begin
        erg := m_Listener.SetPosition (@position.Vector);
        if erg <> S_OK then
           raise RSXException.Create ('UpdatePosition',erg);
     end;

end;

procedure TMMSoundListener.UpdateEnviroment;
var erg : HRESULT;
begin
     if RSXAudio <> Nil then
     begin
          erg := RSXAudio.SetEnviroment (@m_Enviroment.Enviroment);
          if erg <> S_OK then
             raise RSXException.Create ('UpdateEnviroment',erg);
     end;
end;

procedure TMMSoundListener.UpdateOrientation;
var erg : HRESULT;
begin
     if m_Listener <> Nil then
     begin
        erg := m_Listener.SetOrientation (@orientation.Vector,@UpVector);
        if erg <> S_OK then
           raise RSXException.Create ('UpdatenOrientation',erg);
     end;
end;


constructor TMMSoundListener.Create (AOwner : TComponent);
begin
   // Defaultwerte setzen:
   m_Listener := NIL;

   // Subobjekte erzeugen
   m_Position := TVector3D.Create (UpdatePosition);
   m_Orientation := TVector3D.Create (UpdateOrientation);
   m_Enviroment := TAAEnviroment.Create (UpdateEnviroment);

   m_Enviroment.ReverbType := NONE;
   m_Enviroment.UseRightHand := FALSE;
   m_Enviroment.SpeedOfSound := 0.0;
   m_Enviroment.CPUBudget := CPU_MODERATE_LOCALIZE;


   m_Position.x := 0.0;
   m_Position.y := 0.0;
   m_Position.z := 0.0;

   m_Orientation.x := 0.0;
   m_Orientation.y := 0.0;
   m_Orientation.z := 1.0;

   m_ListenerDesc.dwUser := 0;
   m_ListenerDesc.device := STEREO_FRONT;

   inherited Create (AOwner);

   // COM-Objekt erzeugen
   m_ListenerDesc.hMainWnd := MMGetForm (Self).Handle;
   CreateListener;

end;

procedure TMMSoundListener.CreateListener;
var res : HRESULT;
begin
   if RSXAudio <> Nil then
   begin
      try
         // Enviroment setzen
         UpdateEnviroment;

         res := RSXAudio.CreateListener (@m_ListenerDesc, // LIstener Description
                                         @m_Listener,
                                         Nil);
         if res <> S_OK then
            raise RSXException.Create ('CreateListener',res);

         // Grundparameter einstellen
         UpdatePosition;
         UpdateOrientation;
      except
      end;

   end;
end;

// Listener-Objekt entfernen
procedure TMMSoundListener.DestroyListener;
begin

   if m_Listener <> Nil then
   begin
      m_Listener.Release;
      m_Listener := NIl;
   end;

end;

destructor TMMSoundListener.Destroy;
begin

     DestroyListener;

     inherited Destroy;

     // Subobjeke lschen
     m_Orientation.Free;
     m_Position.Free;
     m_Enviroment.Free;

end;


end.
