{***********************
  Media-Manager
************************
 (c) 1996 by
 Olaf Panz
 Drosselgasse 4
 21436 Marschacht
***********************}
unit UMMSoundProperty;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  dsgnintf,UMMSelectPictureDialog,UMMTools,
  UMMSoundEmitter,
  UMMSelectSoundDialog,
  UMMBase;

type
  TMMSoundProperty = class(TPropertyEditor)
  private
    { Private-Deklarationen }
  protected
    { Protected-Deklarationen }
  public
    { Public-Deklarationen }
    function GetAttributes: TPropertyAttributes; override;
    procedure Edit; override;

    function GetValue: string; override;

  end;


implementation

function TMMSoundProperty.GetAttributes: TPropertyAttributes;
begin
     GetAttributes := [paDialog];
end;

procedure TMMSoundProperty.Edit;
var Select : TMMSelectSoundDialog;
    Sound : TMMSoundEmitter;
begin
   Sound := GetComponent (0) as TMMSoundEmitter;
   Select := TMMSelectSoundDialog.CreateEx (Application,MMGetForm (Sound),Sound.Sound);
   if Select.ShowModal = mrOK then
   begin
      // Datum zurckschreiben
      Sound.Sound := Select.m_iIdent;
   end;

   Select.Free;
end;


function TMMSoundProperty.GetValue: string;
var Sound : TMMSoundEmitter;
begin
   Sound := GetComponent(0) as TMMSoundEmitter;
   if Sound.Sound = 0 then
      GetValue := 'Nicht definiert'
   else
      GetValue := MMPBGetValue (MMGetForm (Sound).Name,cIdentifier,IntToStr(Sound.Sound));
end;


end.
