{***********************
  Media-Manager
************************
 (c) 1996 by
 Olaf Panz
 Drosselgasse 4
 21436 Marschacht
***********************}
unit UPathDialog;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

const
     BIF_ReturnOnlyFSDirs   =$0001;  // For finding a folder to start document searching
     BIF_DontGoBelowDomain  =$0002;  // For starting the Find Computer
     BIF_RetrunFSAncestors  =$0008;
     BIF_BrowseForComputer  =$1000;  // Browsing for Computers.
     BIF_BrowseForPrinter   =$2000;  // Browsing for Printers

type

  TBrowseFolderOptionList = (ReturnOnlyFSDirs,DontGoBelowDomain,RetrunFSAncestors,
                             BrowseForComputer,BrowseForPrinter);

  TBrowseFolderOption = set of TBrowseFolderOptionList;

  TPathDialog = class(TComponent)
  private
    { Private-Deklarationen }
  protected
    { Protected-Deklarationen }
    FCaption : string;
    FPath : string;
    FOption : TBrowseFolderOption;

  public
    { Public-Deklarationen }
    function Execute : Boolean;

    constructor Create (AOwner : TComponent); override;

  published
    { Published-Deklarationen }
    property Caption : string read FCaption write FCaption;
    property Path : string read FPath write FPath;
    property Option : TBrowseFolderOption read Foption write FOption default [ReturnOnlyFSDirs];

  end;

procedure Register;

implementation

                                            
{$L ShellFnc.obj}
function BrowseFolder(hParent : HWND;szTitle,szPath,szBuffer : pchar;iOptions : Integer) : Integer; stdcall; external;
procedure SHGetDesktopFolder; stdcall external 'shell32' index 216;
procedure SHBrowseForFolder; stdcall external 'shell32' index 208;


constructor TPathDialog.Create (AOwner : TComponent);
begin
     // Defaults setzen
     FCaption := '';
     FPath := '';
     FOption := [ReturnOnlyFSDirs];

     inherited Create (AOwner);
end;

function TPathDialog.Execute : Boolean;
var szTitle,szPath,szBuffer : array [0..MAX_PATH] of char;
    Option,i: Integer;
begin

   // Daten umkopieren
   strpcopy (szTitle,FCaption);
   strpcopy (szPath,FPath);
   i := strlen (szPath);
   if i > 0 then begin
      if szPath[i-1] = '\' then
         szPath [i-1] := char(0);
   end;


   // OPtionen setzen:
   if ReturnOnlyFSDirs in FOption then
      Option := BIF_ReturnOnlyFSDirs
   else
      Option := 0;
   if DontGoBelowDomain in FOption then
      Option := Option or BIF_DontGoBelowDomain;
   if RetrunFSAncestors in FOption then
      Option := Option or BIF_RetrunFSAncestors;
   if BrowseForComputer in FOption then
      Option := Option or BIF_BrowseForComputer;
   if BrowseForPrinter in FOption then
      Option := Option or BIF_BrowseForPrinter;


   if BrowseFolder (Application.Handle,szTitle,szPath,szBuffer,Option) <> 0 then
   begin

      FPath:= szPath;

      i := strlen (szPath);
      if i > 0 then begin
         if szPath[i-1] <> '\' then
            FPath := FPath + '\';
      end;
      Execute := TRUE;
   end else begin
      Execute := FALSE;
   end;

end;


procedure Register;
begin
     RegisterComponents('Dialoge',[TPathDialog]);
end;

end.
