
{*******************************************************}
{                                                       }
{       WinG Import Unit for Borland Pascal             }
{                                                       }
{       Written by Mike Scott, CIS 100140,2420          }
{       Preliminary version 9th July 1994               }
{       Modified for Delphi 2.0 1996 by Olaf Panz       }
{       Drosselgasse 4, 21436 Marschacht, Germany       }
{                                                       }
{*******************************************************}

unit WinG32 ;

interface

uses WinTypes ;

{ WinG Types }

type
  PPointer = ^pointer ;
  PRGBQuad = ^TRGBQuad ;
  WING_DITHER_TYPE = word ;

const
  WING_DISPERSED_4x4 = 0 ;
  WING_DISPERSED_8x8 = 1 ;
  WING_CLUSTERED_4x4 = 2 ;

{ WinG DC's & WinG Bitmaps }

function  WinGCreateDC : HDC ;stdcall;
function  WinGCreateBitmap( hWinGDC : HDC ;
                            pHeader : PBitmapInfo ;
                            ppBits  : PPointer ) : HBitmap ;stdcall;
function  WinGGetDIBPointer( hWinGBitmap : HBitmap ;
                             pHeader     : PBitmapInfo ) : pointer ; stdcall;
function  WinGRecommendDIBFormat( pHeader : PBitmapInfo ) : Bool ;stdcall;
function  WinGGetDIBColorTable( hWinGDC         : HDC ;
                                StartIndex      : word ;
                                NumberOfEntries : word ;
                                pColors         : PRGBQuad ) : word ;stdcall;
function  WinGSetDIBColorTable( hWinGDC         : HDC ;
                                StartIndex      : word ;
                                NumberOfEntries : word ;
                                pColors         : PRGBQuad ) : word ;stdcall;

{ Blts }

function  WinGBitBlt( hdcDest      : HDC ;
                      nXOriginDest : integer ;
                      nYOriginDest : integer ;
                      nWidthDest   : integer ;
                      nHeightDest  : integer ;
                      hdcSrc       : HDC ;
                      nXOriginSrc  : integer ;
                      nYOriginSrc  : integer ) : Bool ;stdcall;
function  WinGStretchBlt( hdcDest      : HDC ;
                          nXOriginDest : integer ;
                          nYOriginDest : integer ;
                          nWidthDest   : integer ;
                          nHeightDest  : integer ;
                          hdcSrc       : HDC ;
                          nXOriginSrc  : integer ;
                          nYOriginSrc  : integer ;
                          nWidthSrc    : integer ;
                          nHeightSrc   : integer ) : Bool ;stdcall;

{ Halftoning }

function  WinGCreateHalftoneBrush( DC         : HDC ;
                                   Color      : TColorRef ;
                                   DitherType : WING_DITHER_TYPE ) : HBrush ;stdcall;
function  WinGCreateHalftonePalette : HPalette ;stdcall;


implementation

function  WinGCreateDC ;              stdcall; external 'WinG32' index 3 ;
function  WinGCreateBitmap ;          stdcall; external 'WinG32' index 2 ;
function  WinGGetDIBPointer ;         stdcall; external 'WinG32' index 7 ;
function  WinGRecommendDIBFormat ;    stdcall; external 'WinG32' index 8 ;
function  WinGGetDIBColorTable ;      stdcall; external 'WinG32' index 6 ;
function  WinGSetDIBColorTable ;      stdcall; external 'WinG32' index 9 ;
function  WinGBitBlt ;                stdcall; external 'WinG32' index 1 ;
function  WinGStretchBlt ;            stdcall; external 'WinG32' index 10 ;
function  WinGCreateHalftoneBrush ;   stdcall; external 'WinG32' index 4 ;
function  WinGCreateHalftonePalette ; stdcall; external 'WinG32' index 5 ;


end.
