// ******************************************
// * Projekt:  EditAutoRun						  *
// ******************************************
// * Modul:											  *
// *	editrun.exe									  *
// ******************************************
// * (c) 1995 by Olaf Panz						  *
// * Drosselgasse 4								  *
// *													  *
// * 21436 Marschacht							  *
// *													  *
// * Tel. 07723-50278							  *
// *		 04176-1268								  *
// ******************************************
// * Erstellt: 17.10.95 Olaf Panz			  *
// ******************************************
// * Datei:											  *
// *	autorun.cpp 								  *
// ******************************************
// * Funktion:										  *
// *  Klasse: EditAutoRunDlg					  *
// *   Bearbeiten der AutoRun.INF			  *
// ******************************************
// * Version: 1.0									  *
// ******************************************
#include <autorun.h>
#include <autorun.hh>
#include <owl\opensave.h>
#include <iniverw.h>
#include <autorun.rh>
#include <dlg_elem.rh>
#include <dir.h>
#include <filehelp.h>
#include <stdio.h>
#include <scdini.rh>

// ******************************************
// 		Klasse: EditAutoRunDlg
// ******************************************

EditAutoRunDlg::EditAutoRunDlg (TWindow *parent,LPCSTR filename) :
	TDialog (parent,DLG_EditAutoRun),
	ini (filename),
	SAutoPlay (this,DLG_13),
	SHeadline (this,DLG_4),
	SText (this,DLG_6),
	SExecute (this,DLG_8),
	SIcon (this,DLG_12),
	SName (this,DLG_25),
	SStart (this,DLG_24),
	SMenu (this,DLG_26),
	EAutoPlay (this,DLG_1),
	EHeadline (this,DLG_5),
	EText (this,DLG_7),
	EExecute (this,DLG_9),
	EIconFile (this,DLG_10),
	EIconNumber (this,DLG_11),
	EStart (this,DLG_18),
	EMenu (this,DLG_19),
	EName (this,DLG_17),
	LEntries (this,DLG_14),
	CStartCD (this,DLG_2),
	GStartCD (this,DLG_3),
	BSearchExecute (this,DLG_23),
	BAutoPlay (this,DLG_20),
	BStart (this,DLG_22),
	BDelEntry (this,DLG_16),
	BTest (this,DLG_27),
	INFPath (MAXPATH),
	TempPath (MAXPATH),
	ShellArray (10,0,10)

{
	Icon = NULL;
	OldIconNum = 0;
	AktuellShell = NULL;
	// INF-Path init
	strcpy (INFPath,fh -> ExtractPath (filename));
	fh -> AddSlash (INFPath);
}

// Destruktor
EditAutoRunDlg::~EditAutoRunDlg ()
{
}

// Fenster initialisieren
void EditAutoRunDlg::SetupWindow ()
{
	char *d;
	Buffer buf (MAXPATH);

	TDialog::SetupWindow ();

	// AutoPlay-File
	EAutoPlay.SetText (ini.GetResEntry (ARI_Chapter,ARI_Open));

	// Icon-File ermitteln
	Buffer i(ini.GetResEntry (ARI_Chapter,ARI_Icon)); // Icon-Eintrag ermitteln
	int nr = 0;

	if (strlen (i) >0) { // Sind Daten vorhanden ?
		d = strchr (i,','); // Trennung zwischen Filename und Nummer ermitteln
		if (d) // Wenn TRennung vorhanden:
			*d = '\0'; // String am Trennzeichen beenden

		// IconNumber ermitteln
		if (d) { // Wenn Nummer angegeben wurde :
			nr = atoi (d+1); // Nummer als INT ermitteln
		}

		EIconFile.SetText (i); // Dateiname setzen
		itoa (nr,buf,10); // Zurck in String wandeln, so ist gewhrleistet, da eine Zahl im Dialogelement steht
		EIconNumber.SetText (buf); // Nummer Dialogelement berehmen
		CheckIcon (FALSE); // Icon checken, fehlerhafte Daten kommentarlos lschen

	}

	// Changed-Variable init
	IsAutoPlayChanged = FALSE;
	IsStartChanged = FALSE;
	IsExecuteChanged = FALSE;


	// Start-CD-Parameter init

	// Alle Parameter ermitteln
	const char *h = ini.GetResEntry (ATR_Section,ATR_Headline);
	const char *t = ini.GetResEntry (ATR_Section,ATR_Text);
	const char *e = ini.GetResEntry (ATR_Section,ATR_Execute);

	// Ist einer der Parameter gltig?
	if (strlen (h) || strlen (t) || strlen (e)) { // Dann ist StartCD selektiert und Daten werden dargestellt:
		// Texte ausgeben
		EHeadline.SetText (h);
		EText.SetText (t);
		EExecute.SetText (e);
		CStartCD.Check (); // Checkbox markieren
	} else
		CStartCD.Uncheck (); // Markierung aufheben

	CheckStartCD ();

	// Shell-Array fllen
	int size = ini.GetKeySize (ARI_Chapter); // Anzahl der Schlssel ermitteln
	string ind = GetApplication () -> LoadString (ARI_Shell); // Indikator fr Shell-Eintrge ermitteln
	t = ind.c_str();

	// Alle Shell-Namen ermitteln
	for (int k=0;k < size;k++) { // ber alle Schlssel iterieren
		Buffer key(ini.GetKey (ARI_Chapter,k)); // Schlssel ermitteln

		// Ist der Beginn des Schlssels == Shell-Indikator?
		for (int j=0;t[j] != '\0';j++) { // ber Shell-Key iterieren
			if (t[j] != key[j])
				break;
		}
		if (t[j] == '\0') { // Shell-Eintrag!!
			d = strchr (((char*)key)+j,'\\');
			if (d != NULL)  // Geht der Key ber den Namen hinaus?
				*d = '\0'; // Ja: am Backslash terminieren


			ShellData *sd = new ShellData (((char*)key)+j); // ShellData erzeugen
			if (sd) {
				if (ShellArray.Find (sd) == INT_MAX)  // Ist Eintrag schon vorhanden?
					ShellArray.Add (sd); // Nein: Eintrag einfgen
				else
					delete sd; // Ansonsten Objekt lschen
			}
		}
	}


	// Kapitel-Name laden
	string chap = GetApplication () -> LoadString (ARI_Chapter);
	// Command-Indikator laden
	string com  = GetApplication () -> LoadString (ARI_Command);

	ShellDataArrayIterator sdi (ShellArray);


	while (sdi) {
		ShellData *shell = sdi.Current(); // Shell-Daten-Zeiger ermitteln

		//  Meneintrag-Key erzeugen
		strcpy (buf,t); // Shell-Indikator
		strcat (buf,shell -> c_str ()); // Name hinzufgen

		shell -> Menu = string (ini.GetEntry (chap.c_str(),buf)); // Eintrag ermitteln und in ShellData sichern

		// Execute-Key erzeugen
		strcat (buf,com.c_str()); // Command-Indikator zum bestehenden Schlssel hinzufgen
		shell -> Execute = string (ini.GetEntry (chap.c_str(),buf)); // Execute laden
		sdi++;
	}

	// Aktuell Selektierter Eintrag:
	EntrySelect = 0;
	SetEntries ();

}

// Fensterdaten sichern
void EditAutoRunDlg::CloseWindow (int ret)
{
	Buffer buf (BUFSIZE); // Buffer bereitstellen
	int nr;

	// Auto-Text-Eintrag sichern
	EAutoPlay.GetText (buf,BUFSIZE);
	ini.SetResEntry (ARI_Chapter,ARI_Open,buf);

	// Icon sichern
	EIconNumber.GetText (buf,BUFSIZE); // Nummer ermitteln
	nr = atoi (buf); // in INT konvertieren
	// Icon Datei ermitteln
	EIconFile.GetText (buf,BUFSIZE-19); // 19 = maxlen (itoa) + ','
	strcat (buf,","); // Trennzeichen einfgen
	itoa (nr,strchr (buf,'\0'),10); // Nummer anfgen
	ini.SetResEntry (ARI_Chapter,ARI_Icon,buf);

	if (CStartCD.GetCheck () == BF_CHECKED) { // Wenn Start-CD selektiert:
		// berschrift sichern
		EHeadline.GetText (buf,BUFSIZE);
		ini.SetResEntry (ATR_Section,ATR_Headline,buf);
		// Text sichern
		EText.GetText (buf,BUFSIZE);
		ini.SetResEntry (ATR_Section,ATR_Text,buf);
		// Executable sichern
		EExecute.GetText (buf,BUFSIZE);
		ini.SetResEntry (ATR_Section,ATR_Execute,buf);
	} else  // Wenn  Start-CD nicht selektiert:
		ini.DelResSection (ATR_Section); // Kapitel in AutoRun.INF lschen

	// Shell-Eintrge sichern

	// ber alle ShellArray-Eintrtge iterieren
	ShellDataArrayIterator sdi (ShellArray);
	// Kapitel-Name laden
	string chap = GetApplication () -> LoadString (ARI_Chapter);
	// Command-Indikator laden
	string com  = GetApplication () -> LoadString (ARI_Command);
	// Indikator fr Shell-Eintrge ermitteln
	string ind = GetApplication () -> LoadString (ARI_Shell);

	while (sdi) {
		strcpy (buf,ind.c_str()); // Shell-Indikator
		strcat (buf,sdi.Current () -> c_str()); // Name hinzu

		// Meneintrag setzen
		ini.SetEntry (chap.c_str(),buf,sdi.Current () -> Menu.c_str());

		// Command setzen
		strcat (buf,com.c_str()); // Command-Indikator hinzu
		ini.SetEntry (chap.c_str(),buf,sdi.Current () -> Execute.c_str());
		sdi++;
	}

	TDialog::CloseWindow (ret);
}


// Ermittlung des absoluten Pfad auf der Festplatte
LPSTR EditAutoRunDlg::GetAbsFile (LPCSTR file)
{
	if (strchr (file,':') == 0) { // Wenn noch kein ':' als Trennzeichen des Laufwerks vorhanden:
		// Basispfad einfgen
		strcpy (TempPath,INFPath);
		strcat (TempPath,file); // Dateinamen anhngen
	} else
		strcpy (TempPath,file); // Wenn Pfad schon absolut: Pfad in Ergebnis kopieren

	return TempPath;	// Ergebnis liefern
}

// Ermittlung des relativen Pfads auf CD-ROM
// Liefert NULL, wenn File nicht im CD-Bereich

LPCSTR EditAutoRunDlg::GetRelFile (LPCSTR file)
{
	int i;

	// Prfen , of INFPath in file enthalten:
	for (i=0;INFPath[i] != '\0';i++)
		if (INFPath[i] != file[i])
			break;

	if (INFPath[i] != 0)  // Nicht enthalten:
		return NULL;
	return file + i; // String hinter INFPath zurckliefern

}

// Zeichnen des Icons
void EditAutoRunDlg::EvPaint (void)
{
	if (Icon) { // Nur Anzeigen, wenn Icon gltig
		PAINTSTRUCT ps;
		HDC hdc =  BeginPaint (*this,&ps);
		TRect client;

		SIcon.GetClientRect (client); // Position des Platzhalter-Dlg-Elements ermitteln

		DrawIcon  (hdc,SIcon.Attr.X,SIcon.Attr.Y,Icon); // Icon zeichnen
		EndPaint (*this,&ps);
	}
   TDialog::EvPaint ();
}

// Prft, ob Datei im Bereich der virtuellen CD
// Der Pfad von File mu absolut sein!
// liegt. Ist dies nicht der Fall, wird angeboten,
// die Datei zu kopieren
// Ret: TRUE: OK, FALSE : nicht auf virtueller CD
BOOL EditAutoRunDlg::CheckFile (LPSTR file,BOOL DoMsg)
{
	BOOL ok = TRUE;
	const char *rel = GetRelFile(file);

	if (rel == NULL) { // Datei liegt nicht im Bereich der virtuellen CD!
		if (DoMsg == TRUE) {
			switch (MessageBox (GetApplication () -> LoadString (MSG_NotOnVirtualCD).c_str(),
									  GetApplication () -> LoadString (MSG_Headline).c_str(),
									  MB_YESNO)) {

				case IDYES : // Datei kopieren:
				{
					Buffer dest (MAXPATH);	// Zieldatei
					strcpy (dest,INFPath);	// Virtuellen CD-Pfad kopieren
					strcat (dest,fh -> ExtractFilename (file)); // und Dateiname hinzufgen

					if (fh -> Copy (file,dest) == FALSE) { // Datei kopieren
						MessageBox (GetApplication () -> LoadString (MSG_CantCopyFile).c_str(),
										GetApplication () -> LoadString (MSG_Headline).c_str(),
										MB_OK);
						ok = FALSE; // Fehler
					} else {
						strcpy (file,dest); // Filename anpassen
						rel = GetRelFile (dest);
					}
					break;
				}
				default :
					ok = FALSE;
					break;
			}
		} else // DoMsg == FALSE:
			ok = FALSE;
	}

	// Existiert die Datei ?
	if (ok == TRUE) { // File ist OK:
		Buffer f (rel); // berschreibbaren Puffer fr den Relativen Anteil von file
		char *c = strchr (f,' '); // Trennzeichen zu Startparametern suchen
		if (c) // Wenn Trennzeichen vorhanden
			*c = '\0'; // Name am Trennzeichen terminieren
		if (fh -> FileExist (f) == FALSE) {  // Existiert die Datei?
			if (strchr (f,'\\') == NULL) { // Wenn kein Datei-Pfad angegeben, knnte es sich um
														 // eine Datei PATH= (z.B.im Windows-Verzeichnis) handeln!)
				OFSTRUCT of;
				if (OpenFile (f,&of,OF_EXIST) == HFILE_ERROR)
					ok = FALSE;
			} else
				ok = FALSE;
			if (ok == FALSE) {
				if (DoMsg == TRUE)
					MessageBox (GetApplication () -> LoadString (MSG_FileDontExist).c_str(),
									GetApplication () -> LoadString (MSG_Headline).c_str(), // Nein, Fehlermeldung erzeugen
									MB_OK);
			}
		}
	}
	return ok;
}



// Ld, prft die IconDatei
// Ist Icon gltig, werden Daten in OldIconFile & OldIconNum bernommen, sowie das Icon gezeichnet
// Geprft werden die Daten im Dialog
// Ist DoMsg ==True, so werden Fehler angezeigt und Lsungen geboten
// Bei DoMsg == FALSE werden Falsche Daten einfach gelscht.
void EditAutoRunDlg::CheckIcon (BOOL DoMsg)
{
	Buffer file (MAXPATH);
	Buffer Num (17);
	int nr = 0;
	BOOL err = FALSE;
	HICON ico;

	// Icon-Datei ermitteln
	EIconFile.GetText (file,MAXPATH);

	if (strlen (file)) { // Ist eine Datei angegeben?
		strcpy (file,GetAbsFile (file)); // Die Dateiangabe mu absolut sein!
		if (CheckFile (file,DoMsg) == FALSE) // Im Bereich der virtuellen CD ?
			err = TRUE;

		if (err == FALSE) {// Ist Icon aus Datei ladbar?
			// Number ermitteln
			EIconNumber.GetText (Num,16);
			nr = atoi (Num);

			// Prfen, ob Icon ladbar:

			ico = ExtractIcon (GetApplication () -> GetInstance (),file,nr);

			if (!ico) { // Wenn Icon-Handle ungltig:

				if (DoMsg == TRUE)
					MessageBox (GetApplication () -> LoadString (MSG_IconNotFound).c_str(),
									GetApplication () -> LoadString (MSG_Headline).c_str(), // Fehlermeldung erzeugen
									MB_OK);
				err = TRUE;
			} else {
				Icon = ico; // neues Icon zuordnen
				Invalidate (); // Gesamten Dialog neu zeichnen
			}
		}
		if (err == TRUE) { // Fehlerbehandlung: Alte Werte setzen
			EIconFile.SetText (OldIconFile.c_str()); // Dateiname setzen
			itoa (OldIconNum,Num,10); // Zurck in String wandeln, so ist gewhrleistet, da eine Zahl im Dialogelement steht
			EIconNumber.SetText (Num); // Nummer Dialogelement berehmen
		} else {
			OldIconFile = string (GetRelFile (file)); // Gltige Werte merken
			EIconFile.SetText (OldIconFile.c_str()); // Dateiname setzen
			OldIconNum = nr;	// Nummer des Icons merken
		}
	} else {
		Icon = NULL;
		Invalidate (); // Gesamten Dialog neu zeichnen
	}

	IsIconChanged = FALSE; // Icon wurde vom Benutzer noch nicht gendert

}

// Icon-Datei ermitteln
void EditAutoRunDlg::SearchIconFile (void)
{
	// Dateiname ermitteln
	int len = EIconFile.GetTextLen ()+1; // Stringlnge ermitteln
	Buffer buf ((len+1 < MAXPATH)?MAXPATH:len+1);	// Speicher bereitstellen mit Lnge len+1, mind. MAXPATH
	EIconFile.GetText (buf,len);	//  String holen
	strcpy (buf,GetAbsFile (buf));  // Absoluten Pfad herstellen

	Buffer dir (MAXPATH); // Directory ermitteln
	strcpy (dir,fh -> ExtractPath (buf));

	// Filter ermitteln
	string filter = GetApplication () -> LoadString (FIL_IconFiles);


	TOpenSaveDialog::TData data (OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST | OFN_HIDEREADONLY,
										  filter.c_str(),
										  0,                       // custom Filter
										  dir);					// Initial-Dir

	strcpy (buf,fh -> ExtractFilename (buf)); // Alten Dateinamen bernehmen
	data.FileName = buf; // Filename als Default setzen

	if (TFileOpenDialog (this,data,NULL).Execute () == IDOK) { // Wenn OK
		EIconFile.SetText (data.FileName); // Datei in Dialog bernehmen
		EIconNumber.SetText ("0"); //Icon-Nummer zurcksetzen
		CheckIcon (TRUE);	// Icon prfen und neu zeichnen
	}
}

// AutoPlay-Datei ermitteln
void EditAutoRunDlg::SearchAutoPlay (void)
{
	// Dateiname ermitteln
	int len = EAutoPlay.GetTextLen ()+1; // Stringlnge ermitteln
	Buffer buf ((len+1 < MAXPATH)?MAXPATH:len+1);	// Speicher bereitstellen mit Lnge len+1, mind. MAXPATH
	EAutoPlay.GetText (buf,len);	//  String holen
	strcpy (buf,GetAbsFile (buf));  // Absoluten Pfad herstellen

	Buffer dir (MAXPATH); // Directory ermitteln
	strcpy (dir,fh -> ExtractPath (buf));

	// Filter ermitteln
	string filter = GetApplication () -> LoadString (FIL_Executable);


	TOpenSaveDialog::TData data (OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST | OFN_HIDEREADONLY,
										  filter.c_str(),
										  0,                       // custom Filter
										  dir);					// Initial-Dir

	strcpy (buf,fh -> ExtractFilename (buf)); // Alten Dateinamen bernehmen
	data.FileName = buf; // Filename als Default setzen

	if (TFileOpenDialog (this,data,NULL).Execute () == IDOK) { // Wenn OK
		CheckFile (data.FileName); // Datei Checken, Ergebnis anzeigen und evt. Datei kopieren
		EAutoPlay.SetText (GetRelFile(data.FileName)); // Datei auf jeden Fall in den Dialog bernehmen
	}

}

void EditAutoRunDlg::SearchStartFile (void)
{
// Dateiname ermitteln
	int len = EStart.GetTextLen ()+1; // Stringlnge ermitteln
	Buffer buf ((len < MAXPATH)?MAXPATH:len+1);	// Speicher bereitstellen mit Lnge len+1, mind. MAXPATH
	EStart.GetText (buf,len);	//  String holen
	strcpy (buf,GetAbsFile (buf));  // Absoluten Pfad herstellen

	Buffer dir (MAXPATH); // Directory ermitteln
	strcpy (dir,fh -> ExtractPath (buf));

	// Filter ermitteln
	string filter = GetApplication () -> LoadString (FIL_Executable);


	TOpenSaveDialog::TData data (OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST | OFN_HIDEREADONLY,
										  filter.c_str(),
										  0,                       // custom Filter
										  dir);					// Initial-Dir

	strcpy (buf,fh -> ExtractFilename (buf)); // Alten Dateinamen bernehmen
	data.FileName = buf; // Filename als Default setzen

	if (TFileOpenDialog (this,data,NULL).Execute () == IDOK) { // Wenn OK
		CheckFile (data.FileName); // Datei Checken, Ergebnis anzeigen und evt. Datei kopieren
		EStart.SetText (GetRelFile(data.FileName)); // Datei auf jeden Fall in den Dialog bernehmen
	}
}

// Neue Ausfhrbare Start-CD-Datei suchen
void EditAutoRunDlg::SearchExecute (void)
{
// Dateiname ermitteln
	int len = EExecute.GetTextLen ()+1; // Stringlnge ermitteln
	Buffer buf ((len+1 < MAXPATH)?MAXPATH:len+1);	// Speicher bereitstellen mit Lnge len+1, mind. MAXPATH
	EExecute.GetText (buf,len);	//  String holen
	strcpy (buf,GetAbsFile (buf));  // Absoluten Pfad herstellen

	Buffer dir (MAXPATH); // Directory ermitteln
	strcpy (dir,fh -> ExtractPath (buf));

	// Filter ermitteln
	string filter = GetApplication () -> LoadString (FIL_Executable);


	TOpenSaveDialog::TData data (OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST | OFN_HIDEREADONLY,
										  filter.c_str(),
										  0,                       // custom Filter
										  dir);					// Initial-Dir

	strcpy (buf,fh -> ExtractFilename (buf)); // Alten Dateinamen bernehmen
	data.FileName = buf; // Filename als Default setzen

	if (TFileOpenDialog (this,data,NULL).Execute () == IDOK) { // Wenn OK
		CheckFile (data.FileName); // Datei Checken, Ergebnis anzeigen und evt. Datei kopieren
		EExecute.SetText (GetRelFile(data.FileName)); // Datei auf jeden Fall in den Dialog bernehmen
	}
}

// Auto-Play Eingaben prfen:
void EditAutoRunDlg::KillFocusAutoPlay (void)
{
	if (IsAutoPlayChanged == TRUE) { // Nur Prfen, wenn editiert wurde:
		int len = EAutoPlay.GetTextLen ()+1; // Stringlnge ermitteln
		Buffer buf ((len+1 < MAXPATH)?MAXPATH:len+1);	// Speicher bereitstellen mit Lnge len+1, mind. MAXPATH
		EAutoPlay.GetText (buf,len);	//  String holen
		strcpy (buf,GetAbsFile (buf));  // Absoluten Pfad herstellen
		if (CheckFile (buf) == TRUE) { // Wenn Ergebnis erfolgreich: Datum zurck kopieren
			EAutoPlay.SetText (GetRelFile(buf));
		}
		IsAutoPlayChanged = FALSE; // nderungsflag lschen
	}
}

// Startzeilen Eingaben prfen:
void EditAutoRunDlg::KillFocusStart (void)
{
	if (IsStartChanged == TRUE) { // Nur Prfen, wenn editiert wurde:
		int len = EStart.GetTextLen ()+1; // Stringlnge ermitteln
		Buffer buf ((len+1 < MAXPATH)?MAXPATH:len+1);	// Speicher bereitstellen mit Lnge len+1, mind. MAXPATH
		EStart.GetText (buf,len);	//  String holen
		strcpy (buf,GetAbsFile (buf));  // Absoluten Pfad herstellen
		if (CheckFile (buf) == TRUE) { // Wenn Ergebnis erfolgreich: Datum zurck kopieren
			EStart.SetText (GetRelFile(buf));
		}
		IsStartChanged = FALSE;    // nderungsflag lschen
	}
}

// nderungen in StartCD:: Exeute prfen
void EditAutoRunDlg::KillFocusExecute (void)
{
	if (IsExecuteChanged == TRUE) { // Nur Prfen, wenn editiert wurde:
		int len = EExecute.GetTextLen ()+1; // Stringlnge ermitteln
		Buffer buf ((len+1 < MAXPATH)?MAXPATH:len+1);	// Speicher bereitstellen mit Lnge len+1, mind. MAXPATH
		EExecute.GetText (buf,len);	//  String holen
		strcpy (buf,GetAbsFile (buf));  // Absoluten Pfad herstellen
		if (CheckFile (buf) == TRUE) { // Wenn Ergebnis erfolgreich: Datum zurck kopieren
			EExecute.SetText (GetRelFile(buf));
		}
		IsExecuteChanged = FALSE;    // nderungsflag lschen
	}
}

// Stellung von StartCD prfen, und dementsprechend
// Start-CD Dialogfelder grayen, wenn Check-Box gecheckt
// wurde, und alle Felder leer sind, werden Default-Werte
// gesetzt
void EditAutoRunDlg::CheckStartCD (void)
{
	BOOL enable,err = FALSE;

	if (CStartCD.GetCheck () == BF_CHECKED) { // Wenn Feld markiert:
		enable = TRUE;
		// StartCD-Filename ermitteln:
		string scd = GetApplication () -> LoadString (TXT_StartCDName);
		const char *abs = GetAbsFile (scd.c_str()); // Absoluten Pfad ermitteln


		// Liegt StartCD.exe im richtigen Verzeichnis?
		if (fh -> FileExist (abs) == FALSE) {  // Nein: Dorthin kopieren
			if (fh -> SaveResource (RT_RCDATA,EXE_StartCD,abs) == FALSE) { // Datei aus Resource heraus kopieren
				// Ist ein Fehler aufgetreten?
				MessageBox (GetApplication () -> LoadString (MSG_CantCopyFile).c_str(), // Fehlermeldung ausgeben
								GetApplication () -> LoadString (MSG_Headline).c_str(),
								MB_OK);
				enable = FALSE; // StartCD kann nicht verwendet werden
				err = TRUE;
			}
		}
		if (err == FALSE) {
			// AutoPlay auf StartCD.EXE setzen
			EAutoPlay.SetText (scd.c_str());

			// Icon setzen, wenn keines definiert:
			if (EIconFile.GetTextLen () == 0) {
				EIconFile.SetText (scd.c_str()); // Icon setzen
				EIconNumber.SetText ("0");
				CheckIcon (FALSE); // und kommentarlos prfen
			}

			// Mssen Default-Werte gesetz werden?
			if (EHeadline.GetTextLen () == 0 && EText.GetTextLen () == 0 && EExecute.GetTextLen () == 0) { // Nur wenn alle 3 EIngabefelder leer sind!
				EHeadline.SetText (GetApplication () -> LoadString (TXT_HeadlineDefault).c_str()); // Defaults setzen
				EText.SetText (GetApplication () -> LoadString (TXT_TextDefault).c_str());
				EExecute.SetText (GetApplication () -> LoadString (TXT_ExecDefault).c_str());
			}
		}
	} else
		enable = FALSE;

	// Dialog-Elemente fr StartCD enablen/disablen
	GStartCD.EnableWindow (enable);
	SHeadline.EnableWindow (enable);
	SText.EnableWindow (enable);
	SExecute.EnableWindow (enable);
	EName.EnableWindow (enable);
	EHeadline.EnableWindow (enable);
	EExecute.EnableWindow (enable);
	EText.EnableWindow (enable);
	BSearchExecute.EnableWindow (enable);
	BTest.EnableWindow (enable);

	// AutoPlay-Eintrag wird enabled, wenn StartCD diabled wird
	enable = (enable == TRUE)? FALSE:TRUE;
	SAutoPlay.EnableWindow (enable);
	EAutoPlay.EnableWindow (enable);
	BAutoPlay.EnableWindow (enable);

}

// Popup-Eintrge in Liste setzen
// ruft auch SetEntry auf
void EditAutoRunDlg::SetEntries (void)
{
	int i = 0;
	ShellDataArrayIterator sdi(ShellArray);
	LEntries.ClearList (); // Listeninhalte lschen

	while (sdi) { // ber alle Elemente iterieren
		LEntries.AddString (sdi.Current () -> c_str ()); // String in Liste bernehmen
		if (sdi.Current () == AktuellShell)
			EntrySelect = i;

		sdi++; // Nchstes Element
		i++;
	}

	i = ShellArray.GetItemsInContainer (); // Anzahl der Listenelemente ermitteln

	if (EntrySelect >= i) // Markiertes Objekt anpassen
		EntrySelect = i-1;

	LEntries.SetCaretIndex (EntrySelect,TRUE); // Markierung setzen
	LEntries.SetSelIndex (EntrySelect); // Markierung setzen

	SetEntry (); // Markiertes Objekt darstellen
}

// Aktuell gewhlten Eintrag in Dlg-Felder aufnehmen
void EditAutoRunDlg::SetEntry (void)
{
	Buffer buf (MAXPATH);
	ShellDataArrayIterator sdi(ShellArray);
	int i = EntrySelect = LEntries.GetCaretIndex (); // Selekiertes Objekt ermitteln
	BOOL enable;

	if (AktuellShell) { // Wird gerade ein Datensatz bearbeitet?
		// Execute sichern
		EStart.GetText (buf,MAXPATH);
		AktuellShell -> Execute = buf;
		// Menu-Eintrag sichern
		EMenu.GetText (buf,MAXPATH);
		AktuellShell -> Menu = buf;   
	}

	while (i && sdi) { // Selekiertes Objekt anfahren
		sdi++;
		i--;
	}

	if (sdi) { // Wenn Objekt gltig:
		AktuellShell = sdi.Current ();
		enable = TRUE;
		EName.SetText (AktuellShell -> c_str()); // Name setzen
		EStart.SetText (AktuellShell -> Execute.c_str()); // Text setzen
		EMenu.SetText (AktuellShell -> Menu.c_str()); // Menu setzen
	} else {
		AktuellShell = NULL;
		enable = FALSE;
		EName.SetText (""); // Name lschen
		EStart.SetText (""); // Text lschen
		EMenu.SetText (""); //Menu lschen
	}

	// Dlg-Felder disablen, wenn keine Daten vorhanden
	BDelEntry.EnableWindow (enable);
	BStart.EnableWindow (enable);
	EName.EnableWindow (enable);
	SName.EnableWindow (enable);
	SStart.EnableWindow (enable);
	SMenu.EnableWindow (enable);
	EStart.EnableWindow (enable);
	EMenu.EnableWindow (enable);
}

// Erzeugen eines eindeutigen 8-Stelligen Names
// fr einen Shell\ Eintrag
// Dafr mu Name >= 9 Zeichen gro sein
void EditAutoRunDlg::CreateShellName (LPSTR Name)
{
	Buffer nr (18);
	Buffer file (MAXPATH);
	int len = strlen (Name);

	unsigned i,j=0;

	// Ungltige Zeichen entfernen
	for (i=0;i < len && j < 8;i++) {
		if (isalnum (Name[i])) { // zu prfendes Zeichen in Zahl oder Buchstabe
			Name[j] = Name[i]; // Zeichen kopieren
			j++; // Zhler erhhen
		}
	}
	Name [j] = '\0'; // Neuen String teriminieren

	ShellData sd (Name); // Suchobjekt erzeugen
	if (ShellArray.Find (&sd) == INT_MAX) // Wenn Datensatz mit diesem Namen nicht vorhanden:
		return; // Dann ist der Name OK!

	// Dem Namen wird nun eine laufende Nummer angehngt
	for ( i=1;i != 0;i++) {	// Fr alle Zahlen von 0 - 0xffff, bis frei Stelle gefunden:
		itoa (i,nr,10); // Integer in String konvertieren
		strcpy (file,Name); // Original-Namen kopieren

		file.Set (8-strlen (nr),'\0'); // String so terminieren, da Nummern-String + String <= 8 ist
		strcat (file,nr);

		ShellData sd (file); // Suchobjekt erzeugen

		if (ShellArray.Find (&sd) == INT_MAX) { // Freien Platz gefunden?
			strcpy (Name,file); // Ja: Ergebnis sichern
			return; // Aufgabe beendet
		}
	}
	// Aufgabe nicht lsbar:
	Name[0] = '\0';
	return;
}


// Neuen Popup-Eintrag erzeugen
void EditAutoRunDlg::NewEntry (void)
{
	Buffer Name (MAXPATH);

	// Default-Name fr neue Eintrge ermitteln
	strcpy (Name,GetApplication () -> LoadString (TXT_DefaultPopupEntry).c_str());
	CreateShellName (Name);

	ShellData *sd = new ShellData (Name); // Neuen Datensatz erzeugen

	if (sd) { // Wenn Datum erzeugt wurde:
		AktuellShell = NULL;
		ShellArray.Add (sd); // Datum einfgen und Index auf neues Element setzen
		EntrySelect= ShellArray.Find (sd);
		SetEntries (); // Eintrge neu setzen
	}
}

// Aktuellen Popup-Entry lschen
void EditAutoRunDlg::DelEntry (void)
{
	// Benutzer fragen, ob wirklich gelscht werden soll:

	if (MessageBox (GetApplication () -> LoadString (MSG_DeleteEntry).c_str(),
						 GetApplication () -> LoadString (MSG_DeleteEntryHeadline).c_str(),
						 MB_YESNO) == IDYES) {
		// zu lschende Position ermitteln
	//	int pos = LEntries.GetCaretIndex ();
		ShellDataArrayIterator sdi (ShellArray);
	//	ShellData *prev = NULL;


		ShellArray.Destroy (AktuellShell); // Element lschen
		AktuellShell = NULL;

		SetEntries (); // Liste neu fllen
	}
}

void EditAutoRunDlg::KillFocusName (void)
{

	if (IsNameChanged == TRUE) { // Nur prfen, wenn Zeile gendert wurde
		if (AktuellShell) { // Shell aktuell zum Bearbeiten bekannt?
			int len = EName.GetTextLen()+1; // Ja: neuen Eintrag ermitteln
			Buffer Name ((len < MAXPATH)?MAXPATH:len+1);
			EName.GetText (Name,len); // Meneintrag lesen
			string exe = AktuellShell -> Execute; // Aktuelle Daten sichern
			string men = AktuellShell -> Menu;
			ShellArray.Destroy (AktuellShell); // altes Objekt lschen

			if (strlen (Name) == 0) { // Wenn kein Name angegeben:
				Buffer buf (MAXPATH);
				EMenu.GetText (buf,MAXPATH); // Wurde im Feld Meneintrag etwas eingetragen?
				if (strlen (buf) > 0) {
					strcpy (Name,buf);
				} else { // Wenn nicht:
					EStart.GetText (buf,MAXPATH); // Wurde im Feld Startzeile etwas eingetragen?
					if (strlen (buf) > 0) {
						strcpy (Name,buf);
					} else { // Wenn auch dort keine EIngabe vorhanden, Default-Name laden:
						strcpy (Name,GetApplication () -> LoadString (TXT_DefaultPopupEntry).c_str());
					}
				}
			}

			CreateShellName (Name); // Gltigen Shell-Name erzeugen

			ShellData *sd = new ShellData (Name); // Neues Datenobjekt erzeugen
			if (sd)  { // Wenn Erzeugung erfolgreich:
				sd -> Execute = exe; // alte Daten in neunes Objekt schreiben
				sd -> Menu = men;
				AktuellShell = sd;

				ShellArray.Add (sd); // und neues Objekt einfgen
				EntrySelect = ShellArray.Find (sd);

				SetEntries ();
			}
		}
	IsNameChanged = FALSE;
	}
}

void EditAutoRunDlg::TestStartCD (void)
{
	// berschrift ermitteln
	int len = EHeadline.GetTextLen()+1; // Ja: neuen Eintrag ermitteln
	Buffer  Headline(len + 1);
	EHeadline.GetText (Headline,len); // Meneintrag lesen

	// Fragetext ermitteln
	len = EText.GetTextLen()+1; // Ja: neuen Eintrag ermitteln
	Buffer Text (len +1);
	EText.GetText (Text,len); // Meneintrag lesen

	// Ausfhrbare Datei ermitteln
	len = EExecute.GetTextLen()+1; // Ja: neuen Eintrag ermitteln
	Buffer Exec ((len < MAXPATH)?MAXPATH:len+1);
	EExecute.GetText (Exec,len); // Meneintrag lesen

	if (::MessageBox (HWND(),Text,Headline,MB_YESNO) == IDYES) {
		// virtuelle CD als akt. Laufwerk setzen:
		setdisk (toupper(INFPath[0])- 'A');
		chdir (INFPath); // Virtuelles ROOL als aktuelles Verzeichnis
		unsigned err = 0;
		switch (WinExec (Exec,SW_SHOWNORMAL)) { // Datei starten, Fehler ausgeben
			case 0 :
				err = ERR_OutOfMemory;
				break;
			case ERROR_BAD_FORMAT :
				err = ERR_FileNotValid;
				break;
			case ERROR_FILE_NOT_FOUND :
				err = ERR_FileNotFound;
				break;
			case ERROR_PATH_NOT_FOUND :
				err = ERR_PathNotFount;
				break;
		}
		if (err) { // Wenn ein Fehler aufgetreten:
			// Und Message ausgeben
			MessageBox (GetApplication () -> LoadString (ERR_Headline).c_str(),
							GetApplication () -> LoadString (err).c_str(),MB_ICONHAND | MB_OK);
		}
	}
}

// Online-Hilfe aufrufen
void EditAutoRunDlg::Help (void)
{
	Buffer buf (MAXPATH);

	// Dateiname erzeugen
	strcpy (buf,fh -> GetModulPath ());
	fh -> AddSlash (buf);

	strcat (buf,"Set95Up.HLP");

	WinHelp (buf,HELP_INDEX,HELP_EditAutoRun_00);
}

DEFINE_RESPONSE_TABLE1 (EditAutoRunDlg,TDialog)
	// Zeichenfunktion:
	EV_WM_PAINT,
// Buttons :
	EV_COMMAND (DLG_20,SearchAutoPlay),
	EV_COMMAND (DLG_21,SearchIconFile),
	EV_COMMAND (DLG_15,NewEntry),
	EV_COMMAND (DLG_16,DelEntry),
	EV_COMMAND (DLG_22,SearchStartFile),
	EV_COMMAND (DLG_23,SearchExecute),
	EV_COMMAND (DLG_27,TestStartCD),
	EV_COMMAND (IDHELP,Help),

// Nachrichten von Dialogelementen:
	// Icon-Bereich:
	EV_EN_KILLFOCUS (DLG_10,KillFocusIconFile),
	EV_EN_CHANGE (DLG_10,ChangeIconFile),
	EV_EN_KILLFOCUS (DLG_11,KillFocusIconNum),
	EV_EN_CHANGE (DLG_11,ChangeIconNum),
	EV_EN_KILLFOCUS (DLG_1,KillFocusAutoPlay),
	EV_EN_CHANGE (DLG_1,ChangeAutoPlay),
	EV_EN_KILLFOCUS (DLG_18,KillFocusStart),
	EV_EN_CHANGE (DLG_18,ChangeStart),
	EV_EN_KILLFOCUS (DLG_9,KillFocusExecute),
	EV_EN_CHANGE (DLG_9,ChangeExecute),
	EV_EN_KILLFOCUS (DLG_17,KillFocusName),
	EV_EN_CHANGE (DLG_17,ChangeName),

	EV_BN_CLICKED (DLG_2,CheckStartCD),

	EV_LBN_SELCHANGE (DLG_14,SetEntry),



END_RESPONSE_TABLE;

