// ******************************************
// * Projekt:  EditAutoRun						  *
// ******************************************
// * Modul:											  *
// *	editrun.exe									  *
// ******************************************
// * (c) 1995 by Olaf Panz						  *
// * Drosselgasse 4								  *
// *													  *
// * 21436 Marschacht							  *
// *													  *
// * Tel. 07723-50278							  *
// *		 04176-1268								  *
// ******************************************
// * Erstellt: 17.10.95 Olaf Panz			  *
// ******************************************
// * Datei:											  *
// *	editscd.cpp 								  *
// ******************************************
// * Funktion:										  *
// *  Main-Funktion								  *
// ******************************************
// * Version: 1.0									  *
// ******************************************
#include <owl\applicat.h>
#include <owl\framewin.h>
#include <filehelp.h>
#include <buffers.h>
#include <startcd.rh>
#include <scdini.rh>
#include <editrun.rh>
#include <autorun.h>
#include <owl\opensave.h>

class EditRunFrame : public TFrameWindow
{
	public :

		EditRunFrame (TWindow* parent,const char far *title,TWindow* client,BOOL ShrinkToClient)
			: TFrameWindow (parent,title,client,ShrinkToClient) {}

		virtual void GetWindowClass (WNDCLASS& wnd) { TFrameWindow::GetWindowClass (wnd);
															  wnd.hIcon = LoadIcon (GetApplication () -> GetInstance (), MAKEINTRESOURCE (ICO_EditRun)); }
};



class EditAutoRunApp : public TApplication
{
		string file;

	public :

		EditAutoRunApp (LPCSTR f) : TApplication () { 	EnableBWCC (TRUE); file = string(f); }
		~EditAutoRunApp () {  }

		void InitMainWindow ()
		{
				SetMainWindow (new EditRunFrame (0,LoadString (TXT_AppName).c_str(), new EditAutoRunDlg (NULL,file.c_str()),TRUE));
		}
};

int OwlMain (int /*argc*/,char * /*argv/*/ [])
{
	Buffer dir (MAXPATH),filter (MAXPATH),name (MAXPATH);

	// File-Help init
	fh = new FileHelp (_hInstance);

	// Filter ermitteln
	LoadString (_hInstance,FIL_AutoRunINF,filter,MAXPATH);

	// Applicationsname ermitteln
	LoadString (_hInstance,TXT_AppName,name,MAXPATH);

	// Start-Pfad ermitteln
	strcpy (dir,fh -> GetModulPath ());

	OPENFILENAME ofn;
	Buffer file (MAXPATH);

	// Struktur init
	memset (&ofn,0,sizeof (ofn)); // STruktur-Inhalt lschen
	ofn.lStructSize = sizeof (OPENFILENAME);
	ofn.hInstance =_hInstance;
	ofn.lpstrFilter = filter;

	// | in '\0' umwandlen:
	for (char *c = filter;*c != '\0';c++)
		if (*c == '|')
			*c = '\0';

	ofn.lpstrFile = file;
	strcpy (file,"AutoStart.INF");
	ofn.nMaxFile = MAXPATH;
	ofn.lpstrTitle = name;
	ofn.lpstrInitialDir = dir;
	ofn.Flags = OFN_CREATEPROMPT | OFN_PATHMUSTEXIST | OFN_HIDEREADONLY | OFN_NOREADONLYRETURN;

	if (GetOpenFileName (&ofn) == TRUE) 
		return EditAutoRunApp(ofn.lpstrFile).Run();

	if (fh)
		delete fh;
}

