// INI-Verwaltung
//
// (c) 1995 by Olaf Panz
//
// 	Drosselgasse 4
//		21436 Marschacht
//
// Datei: iniverw.cpp
//
// Lesen,Bearbeiten,Schreiben von INI-Dateien

#define BUFSIZE 512
#define FLOATBUF 25

#include "iniverw.h"
#include <math.h>


// --------------------------------
// class rtext
// Speichert Infos einer Section
// --------------------------------
FileIO& rtext::GetRemark (FileIO& os)
{
	if (remark.length ())
		os << "\t; " << remark.c_str ();

	return os;
}
rtext::rtext (const char *s) : string (s)
{
}

const char* rtext::SetRemark (const char* r)
{
	remark = string (r);
	return r;
}



int operator==(const rtext &t1,const rtext &t2) { return !strcmpi (t1.c_str(),t2.c_str()); }

entry::entry (const char *s) : rtext (s)
{
}
// --------------------------------
// 	class entry
// --------------------------------

const char* entry::GetValue (void)
{
	return Value.c_str();
}

const char* entry::SetValue (const char* v)
{
	Value = string(v);
	return Value.c_str ();
}

// --------------------------------
// class section
// Speichert Infos einer Section
// --------------------------------

section::section (const char *s) : rtext (s), Texts (10,0,10), Entries (10,0,10)
{
}

section::~section ()
{
}

void section::Add (rtext* sl)
{
	Texts.Add (sl);
}

void section::Add (entry *el)
{
	Entries.Add (el);
}

unsigned section::GetTextItems (void)
{
	return Texts.GetItemsInContainer ();
}

unsigned section::GetEntryItems (void)
{
	return Entries.GetItemsInContainer ();
}

StrgList* section::GetTexts (void)
{
	return &Texts;
}

EntryList* section::GetEntries (void)
{
	return &Entries;
}



// --------------------------------
// File-Handling-Klasse
// --------------------------------

FileIO& operator<< (FileIO &f,const char *c) { f.settext (c); return f; }

FileIO::FileIO (const char *file,unsigned mode)
{
	of.cBytes = sizeof (OFSTRUCT);
	next = -1;
	loaded = 0;
	Write = FALSE;

	hf = OpenFile (file,&of,mode);

	if (hf != HFILE_ERROR)
		Eof = FALSE;
	else
		Eof = TRUE;
}

FileIO::~FileIO ()
{
	if (Write == TRUE)       // Buffer sichern
		_lwrite (hf,buf,next);

	if (hf != HFILE_ERROR)
		_lclose (hf);
}

BOOL FileIO::good (void)
{
	if (hf == HFILE_ERROR)
		return FALSE;
	else
		return TRUE;
}


const char *FileIO::getline (void)
{
	int akt;

	if (Eof == TRUE)
		return "";

	if (next == -1) { 	// Es wurde noch nicht geladen
		loaded = _lread (hf,buf,FILEBUF);
		if (loaded == HFILE_ERROR || loaded == 0) {
			Eof = TRUE;
			return "";
		}
		next = 0;
	}

	for (akt = next;akt <= loaded && buf[akt] != '\n';akt++)		// nchste Zeile extrahieren
		;

	if (buf [akt] != '\n') {		// Zeile wurde nicht komplett gelesen!
		akt = loaded-next;
		memmove (buf,buf+next,akt);
		buf[akt] ='\0';

		loaded = _lread (hf,buf+akt,FILEBUF-akt-1) + akt;

		if (loaded == HFILE_ERROR || loaded == 0) {
			Eof = TRUE;
		} else {
			next = 0;
			for (akt = 0;akt <= loaded && buf[akt] != '\n';akt++)		// nchste Zeile extrahieren
				;
		}
	}

	int ret;

	buf[akt-1]='\0';
	ret = next;
	next = akt+1;
	if (next >= loaded)
		next = -1;

	return (char*)buf+ret;

}

void FileIO::settext (const char *b)
{
	unsigned size;

	Write = TRUE;
	if (next == -1) { 	// Start
		next = 0;
		buf [0] = '\0';
	}

	size = strlen (b);

	if ((next + size) > (FILEBUF-1)) {
		// Buffer speichern
		_lwrite (hf,buf,next);
		next = 0;
		buf [0] = '\0';

		if (size > (FILEBUF-1)) {// Passt nicht in Buffer
			_lwrite (hf,b,size);
			return;
		}
	}

	strcat (buf,b);
	next += size;
	return;
}



// --------------------------------
// class INIFile
// Speichert Infos einer Section
// --------------------------------

INIFile::INIFile (const char *File,HINSTANCE inst)
{
	sectionlist = new SectionList (20,0,20);

	char *c,*d,*rem;
	FileIO in (File,OF_READ | OF_SHARE_COMPAT);
	section *se;
	rtext *st;
	entry *et;

	hinstance = inst;

	file = string (File);

	se = NULL;
	if (in.good()) {
		while (in.eof() == FALSE) {    // Sektionsberschrift suchen
			Buffer buf (in.getline ()); // in.getline ist immer gltig!
			rem = strchr (buf,';'); // Bemerkungen abschneiden
			if (rem) {
				*rem = '\0';
				rem = ExtractText (rem+1);	// Bemerkung merken
			} else
				rem = NULL;
			c = strchr (buf,'[');
			if (c) {
				d = strchr (buf,']');
				if (d) {		// Sektionsname gefunden.
					*d = '\0';
					se = new section (ExtractText(c+1));
					if (se != NULL) {
						se -> SetRemark (rem);
						sectionlist -> Add (se);
					}
				} // end if (d)
			} else if (se) {

				c = ExtractText (buf);
				if (*c != '\0') {		// Zeile hat einen Inhalt:
					d = strchr (buf,'=');	// Entry oder Text ?
					if (d) {		// Entry !
						if (c < d) {  // Gleichheitszeichen nicht erstes Zeichen in Zeile?
							*d = '\0';
							et = new entry (c);
							if (et != NULL) {
								et -> SetValue (ExtractText(d+1));
								if (rem != NULL)
									et -> SetRemark (rem);
								se -> Add (et);
							}
						} // end if (c < d)
					} else {
						st = new rtext (c);
						if (st != NULL) {
							if (rem != NULL)
								st -> SetRemark (rem);
							se -> Add (st);
						}
					} // end else if (d)
				}

			} // end if (se)
		} //end while
	}

	dosave = FALSE;
}

void INIFile::Save (void)
{
	unsigned sec,ent,secMax,entMax;
	section *se;
	rtext *rt;
	entry *en;
	SectionListIterator sli (*sectionlist);
	StrgListIterator *str;
	EntryListIterator *eli;

	if (dosave == FALSE)	// Nur Speichern, wenn Daten nicht aktuell
		return;

	FileIO of(file.c_str(),OF_CREATE | OF_WRITE);

	secMax = sectionlist -> GetItemsInContainer ();
	for (sec = 0;sec < secMax;sec++) {
		se = sli.Current();
		sli++;
		if (sec != 0)
			of << "\r\n";
		of << "[" << se->c_str() << "]";
		se -> GetRemark (of) << "\r\n";

		entMax = se -> GetEntryItems ();
		eli = new EntryListIterator (*(se -> GetEntries()));
		for (ent= 1; ent <= entMax;ent++) {
			en = eli -> Current();
			(*eli)++;
			if (strlen(en -> GetValue ())) { // Nur schreiben, wenn auch Daten vorhanden
				of << en->c_str() << "=" << en->GetValue();
				en -> GetRemark (of) << "\r\n";
			}
		}

		delete eli;

		entMax = se -> GetTextItems ();
		str = new StrgListIterator (*(se -> GetTexts()));
		for (ent= 0; ent < entMax;ent++) {
			rt = str -> Current ();
			(*str)++;
			if (strlen (rt -> c_str ())) { // Nur ausgeben, wenn Daten vorhanden
				of << rt->c_str();
				rt -> GetRemark (of) << "\r\n";
			}
		}
		delete str;
	}
	of << "\r\n\r\n";

	dosave = FALSE;
}

char *INIFile::ExtractText (char *t)
{
	char *c;
	c = t + strlen (t)-1;

	while (isspace (*c) && c >= t) {
		*c = '\0';
		c--;
	}
	for (c=t;*c != '0' && isspace (*c);c++)
		;
	return c;
}


INIFile::~INIFile ()
{
	Save ();
	if (sectionlist)
		delete sectionlist;
}

// Zugriffsfunktionen

// Entry-Funktionen mit Strings
const char *INIFile::GetEntry (const char *Section,const char *Entry,const char *Default)
{
	section *se = GetSection (Section);
	unsigned u;

	if (se) {
		entry en(Entry);
		u = se -> GetEntries () -> Find (&en); // Eintrag suchen
		if (u != INT_MAX)
			return (*(se -> GetEntries ()))[u] ->GetValue();
	}
	return Default;
}

float INIFile::GetFloatEntry (const char *Section,const char *Entry,float Default)
{
	float ret;
	Buffer buf (FLOATBUF+1);

	gcvt (Default,FLOATBUF,buf);

	ret = atof (GetEntry (Section,Entry,buf));

	return ret;
}


void INIFile::SetEntry (const char *Section,const char *Entry,const char *Value)
{
	section *se = GetSection (Section);
	entry *ent;
	unsigned u;


	if (!se) {
		se = new section (Section);
		sectionlist -> Add (se);
		dosave = TRUE;
	}

	entry en(Entry);
	u = se -> GetEntries () -> Find (&en); // Eintrag suchen
	if (u != INT_MAX) {	// Eintrag vorhanden:
		ent = (*(se -> GetEntries ()))[u];
		if (strcmp (ent -> GetValue (),Value) != 0) {
			ent -> SetValue (Value);
			dosave = TRUE;
		}
	} else { // Eintrag neu anlegen
		ent = new entry (Entry);
		ent -> SetValue (Value);
		se -> Add (ent);
		dosave = TRUE;
	}

}
void INIFile::SetFloatEntry (const char *Section,const char *Entry,float Value)
{
	Buffer buf(FLOATBUF+1);

	gcvt (Value,FLOATBUF,buf);

	SetEntry (Section,Entry,buf);

}

void INIFile::SetEntryDefault (const char *Section,const char *Entry,const char *Default)
{
	section *se = GetSection (Section);
	entry *ent;
	unsigned u;


	if (!se) {
		se = new section (Section);
		sectionlist -> Add (se);
		dosave = TRUE;
	}
	entry en(Entry);
	u = se -> GetEntries () -> Find (&en); // Eintrag suchen
	if (u == INT_MAX) {	// Eintrag nicht vorhanden:
		ent = new entry (Entry);
		ent -> SetValue (Default);
		se -> Add (ent);
		dosave = TRUE;
	}

}

void INIFile::SetFloatEntryDefault (const char *Section,const char *Entry,float Default)
{
	Buffer buf (FLOATBUF+1);

	gcvt (Default,FLOATBUF,buf);

	SetEntryDefault (Section,Entry,buf);

}

void  INIFile::DelEntry (const char *Section,const char *Entry)
{
	section *se = GetSection (Section);
	unsigned u;


	if (se) {
		entry en(Entry);
		u = se -> GetEntries () -> Find (&en); // Eintrag suchen
		if (u != INT_MAX) {	// Eintrag vorhanden:
			se -> GetEntries () -> Destroy (u);
			dosave = TRUE;
			if (se -> GetEntries () -> IsEmpty () && se -> GetTexts () -> IsEmpty()) {// Wenn Sektion leer, Sektion lschen
				sectionlist -> Destroy (se);
			}
		}
	}
}

// Entry-Funktionen mit Ressource-Integern
const char *INIFile::GetResEntry (unsigned Section,unsigned Entry,const char *Default)
{
	Buffer b1,b2;

	LoadString (hinstance,Section,b1,BUFSIZE);
	LoadString (hinstance,Entry,b2,BUFSIZE);
	return GetEntry (b1,b2,Default);
}

float INIFile::GetResFloatEntry (unsigned Section,unsigned Entry,float Default)
{
	Buffer buf (FLOATBUF+1);

	gcvt (Default,FLOATBUF,buf);
	return atof (GetResEntry (Section,Entry,buf));
}

void INIFile::SetResEntry (unsigned Section,unsigned Entry,const char *Value)
{
	Buffer b1,b2;

	LoadString (hinstance,Section,b1,BUFSIZE);
	LoadString (hinstance,Entry,b2,BUFSIZE);
	SetEntry (b1,b2,Value);
}

void INIFile::SetResFloatEntry (unsigned Section,unsigned Entry,float Value)
{
	Buffer buf (FLOATBUF+1);

	gcvt (Value,FLOATBUF,buf);
	SetResEntry (Section,Entry,buf);
}

void INIFile::SetResEntryDefault (unsigned Section,unsigned Entry,const char *Default)
{
	Buffer b1,b2;

	LoadString (hinstance,Section,b1,BUFSIZE);
	LoadString (hinstance,Entry,b2,BUFSIZE);
	SetEntryDefault (b1,b2,Default);
}

void INIFile::SetResFloatEntryDefault (unsigned Section,unsigned Entry,float Default)
{
	Buffer buf (FLOATBUF+1);

	gcvt (Default,FLOATBUF,buf);

	SetResEntryDefault (Section,Entry,buf);
}

void INIFile::DelResEntry (unsigned Section,unsigned Entry)
{
	Buffer b1,b2;

	LoadString (hinstance,Section,b1,BUFSIZE);
	LoadString (hinstance,Entry,b2,BUFSIZE);
	DelEntry (b1,b2);
}

// Freitext-Funktionen mit Strings
unsigned INIFile::GetSize (const char *Section)
{
	section *se = GetSection (Section);

	if (se) {
		return se -> GetTexts () -> GetItemsInContainer ();
	} else
		return 0;
}

const char *INIFile::GetText (const char *Section,unsigned pos)
{
	unsigned i;
	section *se = GetSection (Section);

	StrgList *rt;


	if (se) {
		rt = se  -> GetTexts ();;
		i= rt -> GetItemsInContainer ();
		if (pos >= i)
			pos = i-1;

		StrgListIterator sli(*rt);

		while (pos >0) {
			sli++;
			pos--;
		}
		return sli.Current () -> c_str ();
	}
	return "";
}

void INIFile::SetText (const char *Section,const char *Value,unsigned pos)	// Wenn pos nicht angegeben, wird zugefgt
{
	unsigned u,i;

	section e (Section);
	section *se = GetSection (Section);
	StrgList *rt;

	if (!se) {
		se = new section (Section);
		sectionlist -> Add (se);
	} 

	rt = se -> GetTexts ();
	i= rt -> GetItemsInContainer ();


	if (rt -> HasMember (&rtext (Value)) == 0) { // Nur einfgen, wenn Datensatz noch nicht vorhanden
		if (pos >= i || pos == INT_MAX) {
			rt -> Add (new rtext (Value));
		} else {
			StrgListIterator sli(*rt);


			while (pos >0) {
				sli++;
				pos--;
			}
			u = rt -> Find (sli.Current ());
			if (u != INT_MAX)
				rt -> Destroy (u);
			rt -> AddAt (new rtext (Value),u);

		}
		dosave = TRUE;
	}
}

void INIFile::DelText (const char *Section,unsigned pos)
{
	unsigned k;

	section *se = GetSection (Section);
	StrgList *rt;

	if (se) {

		rt = se -> GetTexts ();
		if (pos < rt -> GetItemsInContainer ()) {
			StrgListIterator sli(*rt);

			while (pos >0) {
				sli++;
				pos--;
			}
			k = rt -> Find (sli.Current());
			if (k != INT_MAX)
				rt -> Destroy (k);

			dosave = TRUE;
			if (se -> GetEntries () -> IsEmpty () && rt -> IsEmpty()) // Wenn Sektion leer, Sektion lschen
				sectionlist -> Destroy (se);
		}
	}
}

void INIFile::DelText (const char *Section,const char *text)
{
	unsigned i;

	section *se = GetSection (Section);
	StrgList *rt;

	if (se) {

		rt = se -> GetTexts ();
		i = rt -> Find (&rtext (text));
		if (i != INT_MAX) {
			rt -> Destroy (i);
			dosave = TRUE;
			if (se -> GetEntries () -> IsEmpty () && rt -> IsEmpty()) // Wenn Sektion leer, Sektion lschen
				sectionlist -> Destroy (se);
		}
	}
}


// Freitext-Funktionen mit Ressource-Integern
unsigned INIFile::GetResSize (unsigned Section)
{
	Buffer se;

	LoadString (hinstance,Section,se,BUFSIZE);
	return GetSize (se);
}

const char *INIFile::GetResText (unsigned Section,unsigned pos)
{
	Buffer se;

	LoadString (hinstance,Section,se,BUFSIZE);
	return GetText (se,pos);
}


// Wenn pos nicht angegeben, wird zugefgt
void INIFile::SetResText (unsigned Section,const char *Value,unsigned pos)
{
	Buffer se;

	LoadString (hinstance,Section,se,BUFSIZE);
	SetText (se,Value,pos);
}

void INIFile::DelResText (unsigned Section,unsigned pos)
{
	Buffer se;

	LoadString (hinstance,Section,se,BUFSIZE);
	DelText (se,pos);
}

void INIFile::DelResText (unsigned Section,const char *text)
{
	Buffer se;

	LoadString (hinstance,Section,se,BUFSIZE);
	DelText (se,text);
}

// Section-Funktionen mit Strings
void INIFile::DelSection (const char *Section)
{
	unsigned u;

	section e (Section);

	u = sectionlist -> Find (&e); // Sektion suchen
	if (u != INT_MAX) { // Sektion vorhanden
		sectionlist -> Destroy (u);
		dosave = TRUE;
	}
}

section* INIFile::GetSection (const char *Section)
{
	unsigned u;

	if (strlen(Section)) {
		section s (Section);

		u = sectionlist -> Find (&s);
		if (u != INT_MAX)
			return (*sectionlist)[u];
	}
	return NULL;
}


// Section-Funktionen mit Ressource-Integern
void INIFile::DelResSection (unsigned Section)
{
	Buffer se;

	LoadString (hinstance,Section,se,BUFSIZE);
	DelSection (se);
}

section* INIFile::GetResSection (unsigned Section)
{
	Buffer se;

	LoadString (hinstance,Section,se,BUFSIZE);
	return GetSection (se);
}

// Ermmittlung von Key-Listen mit Strings
unsigned INIFile::GetKeySize (const char *Section)
{
	section *se = GetSection (Section);

	if (se) {
		return se -> GetEntries () -> GetItemsInContainer ();
	} else
		return 0;
}

const char *INIFile::GetKey (const char *Section,unsigned pos)
{
	unsigned i;

	section *se = GetSection (Section);
	EntryList *rt;


	if (se) {
		rt = se -> GetEntries ();
		if (rt) {
			i= rt -> GetItemsInContainer ();
			if (pos >= i)
				pos = i-1;

		EntryListIterator sli(*rt);

		while (pos >0) {
			sli++;
			pos--;
		}

		return sli.Current () -> c_str ();

		}
	}
	return "";

}

// Ermmittlung von Key-Listen mit Ressource-Integern
unsigned INIFile::GetKeySize (unsigned Section)
{
	Buffer se;

	LoadString (hinstance,Section,se,BUFSIZE);

	return GetKeySize ((char*)se);
}

const char *INIFile::GetResKey (unsigned Section,unsigned pos)
{
	Buffer se;

	LoadString (hinstance,Section,se,BUFSIZE);

	return GetKey ((char*)se,pos);
}
void INIFile::DontSave (void)
{
	dosave = FALSE;
}

void INIFile::DoSave (void)
{
	dosave = TRUE;
}


