// ******************************************
// * Projekt:  EditAutoRun						  *
// ******************************************
// * Modul:											  *
// *	startcd.exe									  *
// ******************************************
// * (c) 1995 by Olaf Panz						  *
// * Drosselgasse 4								  *
// *													  *
// * 21436 Marschacht							  *
// *													  *
// * Tel. 07723-50278							  *
// *		 04176-1268								  *
// ******************************************
// * Erstellt: 17.10.95 Olaf Panz			  *
// ******************************************
// * Datei:											  *
// *	startcd.cpp 								  *
// ******************************************
// * Funktion:										  *
// *  Main-Funktion								  *
// ******************************************
// * Version: 1.0									  *
// ******************************************
#include <windows.h>
#include <dir.h>
#include <startcd.rh>
#include <buffers.h>

#define BUFSIZE 512


int PASCAL WinMain (HINSTANCE instance,HINSTANCE,LPSTR,int)
{
	Buffer AutoRun (MAXPATH); // Autorun-Datei ermitteln
	Buffer Section (BUFSIZE); // Sektionsstring aufnehmen
	Buffer Key (BUFSIZE);		// Schlsselwort zum Zugriff auf INI-Daten
	Buffer Headline (BUFSIZE);	// berschrift
	Buffer Text (BUFSIZE);  // Ergebnis
	Buffer File (MAXPATH); // Dateiname

	// AutoRun-Datei ermitteln
	GetModuleFileName (instance,AutoRun,MAXPATH); // Modulname ermitteln
	// Es wird davon ausgegangen, da diesen Programm auf dem geleichen Datentrger
	// wie die AutoStart-Datei liegt.
	AutoRun.Set (1,'\0'); // nur den Laufwerksbuchstaben bernehmen
	strcat (AutoRun,":\\");
//	strcpy (File,AutoRun); // Die Ausfrhbare Datei liegt auch auf der CD!
	LoadString (instance,ATR_Filename,strchr (AutoRun,'\0'),MAXPATH-strlen (AutoRun));// Dateinamen laden anhngen

	// Sektion in INF-Datei auf Ressource ermitteln
	LoadString (instance,ATR_Section,Section,BUFSIZE);

	// berschrift ermitteln
	LoadString (instance,ATR_Headline,Key,BUFSIZE);
	GetPrivateProfileString (Section,Key,"",Headline,BUFSIZE,AutoRun);

	// Text ermitteln
	LoadString (instance,ATR_Text,Key,BUFSIZE);
	GetPrivateProfileString (Section,Key,"",Text,BUFSIZE,AutoRun);

	// Ausfrbare Datei ermitteln
	LoadString (instance,ATR_Execute,Key,BUFSIZE);
	GetPrivateProfileString (Section,Key,"",File,BUFSIZE-strlen (File),AutoRun);

	// CD als akt. Laufwerk setzen:
	setdisk (toupper(AutoRun[0])- 'A');
	chdir ("\\"); // dort das Grundverzeichnis als aktuell setzen


	// Benutzer fragen:

	if (MessageBox (NULL,Text,Headline,MB_ICONQUESTION | MB_YESNO) == IDYES) {  // Bei ja:
		unsigned err = 0;
		switch (WinExec (File,SW_SHOWNORMAL)) { // Datei starten, Fehler ausgeben
			case 0 :
				err = ERR_OutOfMemory;
				break;
			case ERROR_BAD_FORMAT :
				err = ERR_FileNotValid;
				break;
			case ERROR_FILE_NOT_FOUND :
				err = ERR_FileNotFound;
				break;
			case ERROR_PATH_NOT_FOUND :
				err = ERR_PathNotFount;
				break;
		}
		if (err) { // Wenn ein Fehler aufgetreten:
			/// Fehlermeldung laden
			LoadString (instance,ERR_Headline,Headline,BUFSIZE);
			LoadString (instance,err,Text,BUFSIZE);
			// Und Message ausgeben
			MessageBox (NULL,Headline,Text,MB_ICONHAND | MB_OK);
		}


	}
   return 0;
}
