// ******************************************
// * Projekt:  EditAutoRun						  *
// ******************************************
// * Modul:											  *
// *	editrun.exe									  *
// ******************************************
// * (c) 1995 by Olaf Panz						  *
// * Drosselgasse 4								  *
// *													  *
// * 21436 Marschacht							  *
// *													  *
// * Tel. 07723-50278							  *
// *		 04176-1268								  *
// ******************************************
// * Erstellt: 17.10.95 Olaf Panz			  *
// ******************************************
// * Datei:											  *
// *	autorun.h	 								  *
// ******************************************
// * Funktion:										  *
// *  Klasse: EditAutoRunDlg					  *
// *   Bearbeiten der AutoRun.INF			  *
// ******************************************
// * Version: 1.0									  *
// ******************************************
#include <owl\dialog.h>
#include <owl\static.h>
#include <owl\edit.h>
#include <owl\listbox.h>
#include <owl\gdiobjec.h>
#include <owl\groupbox.h>
#include <owl\checkbox.h>
#include <owl\button.h>
#include <iniverw.h>
#include <buffers.h>

struct ShellData : public string
{
	// Konstruktor:
	ShellData (LPCSTR name) : string (name) {}

	string Execute;
	string Menu;

};


typedef TISArrayAsVector <ShellData> ShellDataArray;
typedef TISArrayAsVectorIterator <ShellData> ShellDataArrayIterator;


class EditAutoRunDlg : public TDialog
{
	private :

		// Pfad der zu bearbeitenden INF-Datei
		Buffer INFPath;
		Buffer TempPath; // Temp-Buffer fr Pfade

		// Dialogelemente:
		TStatic SAutoPlay,SHeadline,SText,SExecute,
				  SIcon,SName,SStart,SMenu;
		TEdit EAutoPlay,EHeadline,EText,EExecute,EIconFile,
				EIconNumber,EStart,EMenu,EName;
		TListBox LEntries;
		TCheckBox CStartCD;
		TGroupBox GStartCD;
		TButton BSearchExecute,BAutoPlay,BStart,BDelEntry,BTest;

		// Iconobjekt
		HICON Icon;
		// Wurden die Icon-Auswahl vom Benutzer verndert
		BOOL IsIconChanged;

		// Wurde AutoPlay gendert?
		BOOL IsAutoPlayChanged;

		// Wurde die Startzeile gendert?
		BOOL IsStartChanged;

		// Wurde StartCD: Execute gender ?
		BOOL IsExecuteChanged;

		// Wurde das Menu-Feld gendert?
		BOOL IsNameChanged;

		// Gltige od. leerer Icon-Dateiname
		string OldIconFile;
		// Gltige od. leerer Icon-Nummer
		int OldIconNum;

		// AutoRun.INF Objekt
		INIFile ini;

		// Shell-Daten
		ShellDataArray ShellArray;

      ShellData *AktuellShell;

		// Aktuell gewhlter Eintrag
		int EntrySelect;


	protected :

		// Ermittlung des absoluten Pfad auf der Festplatte
		LPSTR GetAbsFile (LPCSTR file);

		// Ermittlung des relativen Pfads auf CD-RUN
		// Liefert NULL, wenn File nicht im CD-Bereich
		LPCSTR GetRelFile (LPCSTR file);

		// Ld, prft die IconDatei
		// Ist Icon gltig, werden Daten in OldIconFile & OldIconNum bernommen, sowie das Icon gezeichnet
		// Geprft werden die Daten im Dialog
		// Ist DoMsg ==True, so werden Fehler angezeigt und Lsungen geboten
		// Bei DoMsg == FALSE werden Falsche Daten einfach gelscht.
		void CheckIcon (BOOL DoMsg=TRUE);

		// Prft, ob Datei im Bereich der virtuellen CD
		// liegt. Ist dies nicht der Fall, wird angeboten,
		// die Datei zu kopieren
		// Ret: TRUE: OK, FALSE : nicht auf virtueller CD
		BOOL CheckFile (LPSTR file,BOOL DoMsg=TRUE);


		// Stellung von StartCD prfen, und dementsprechend
		// Start-CD Dialogfelder grayen, wenn Check-Box gecheckt
		// wurde, und alle Felder leer sind, werden Default-Werte
		// gesetzt
		void CheckStartCD (void);

		// Popup-Eintrge in Liste setzen
		// ruft auch SetEntry auf
		void SetEntries (void);

		// Aktuell gewhlten Eintrag in Dlg-Felder aufnehmen
		void SetEntry (void);

		// Erzeugen eines eindeutigen 8-Stelligen Names
		// fr einen Shell\ Eintrag
		void CreateShellName (LPSTR Name);

	public :

		// Konstruktor
		EditAutoRunDlg (TWindow *parent,LPCSTR filename);

		// Destruktor
		~EditAutoRunDlg ();

		// Fenster initialisieren
		virtual void SetupWindow ();

		// Fensterdaten sichern
		virtual void CloseWindow (int ret);

		// Zeichnen des Icons
		virtual void EvPaint (void);

		// AutoPlay-Datei ermitteln
		void SearchAutoPlay (void);

		// Icon-Datei ermitteln
		void SearchIconFile (void);

		// Startzeile eines Meneintrags ermitteln
		void SearchStartFile (void);

		// Neue Ausfhrbare Start-CD-Datei suchen
		void SearchExecute (void);

		// Neuen Popup-Eintrag erzeugen
		void NewEntry (void);

		// Aktuellen Popup-Entry lschen
		void DelEntry (void);

		// Icon-Angaben wurden gendert:
		void ChangeIconFile (void) { IsIconChanged = TRUE; }
		void ChangeIconNum (void) { IsIconChanged = TRUE; }

		// Icon-Angaben prfen und neu zeichnen lassen
		void KillFocusIconFile (void) { if (IsIconChanged == TRUE) CheckIcon (TRUE); }
		void KillFocusIconNum (void) { if (IsIconChanged == TRUE) CheckIcon (TRUE); }

		// AutoPlay-Eintrag nderungen erfassen
		void ChangeAutoPlay (void) { IsAutoPlayChanged = TRUE; }

		// Startzeile  nderungen erfassen
		void ChangeStart (void) { IsStartChanged = TRUE; }

		// Auto-Play Eingaben prfen:
		void KillFocusAutoPlay (void);

		// Startzeilen Eingaben prfen:
		void KillFocusStart (void);

		// Erfasssen, ob StartCD:: Execute gendert wurde:
		void ChangeExecute (void) { IsExecuteChanged = TRUE; }

		// nderungen in StartCD:: Exeute prfen
		void KillFocusExecute (void);

		// nderungen im Feld Menu ermitteln
		void ChangeName (void) { IsNameChanged = TRUE; }
		void KillFocusName (void);

		// StartCD- EINstellungen testen
		void TestStartCD (void);

		// Online-Hilfe aufrufen
		void Help (void);

		DECLARE_RESPONSE_TABLE (EditAutoRunDlg);
};

