// Dynamische Buffer-Verwaltung
//
// (c) 1995 by Olaf Panz
//
// 	Drosselgasse 4
//		21436 Marschacht
//
// Datei: buffers.h
//
// Bereitstellen von dynamischen Buffern der Gre BUFSIZE
// Zugriff ber char* - Castingoperatoren

#ifndef BUFFERS
	#ifndef BUFSIZE
		#define BUFSIZE 512
	#endif

	#define BUFFERS

	#ifdef __BCPLUSPLUS__
		#include <cstring.h>
	#else
		#include <string.h>
	#endif

	class Buffer
	{
		private :

			char *buf;

		public :

			Buffer (int i = BUFSIZE) 
				{ buf = new char [i]; }
			Buffer (const char *b) 
				{ buf = new char [strlen (b)+1]; strcpy (buf,b); }
			~Buffer () { if (buf) delete buf; }

			operator char * () 
				{ return buf; }
			char operator [] (int i) 
				{ return buf [i]; }
			operator long () 
				{ return (long) buf; }

			#ifdef __BCPLUSPLUS__
				operator string () 
					{return string (buf); }
			#endif

			void Set (int pos,char c) 
				{ buf [pos] = c; }
			void Clr (void) 
				{ *buf = '\0'; }
	};
#endif

