// INI-Verwaltung
//
// (c) 1995 by Olaf Panz
//
// 	Drosselgasse 4                            
//		21436 Marschacht
//
// Datei: iniverw.h
//
// Lesen,Bearbeiten,Schreiben von INI-Dateien


#ifndef INIVERWALTUNG
	#define INIVERWALTUNG
	#include <classlib\arrays.h>
	#include <cstring.h>
	#include <fstream.h>
	#include "buffers.h"

	#define FILEBUF 2048


	class FileIO
	{
	private :

		OFSTRUCT of;
		HFILE hf;
		char buf [FILEBUF+1];
		int next;
		int loaded;
		BOOL Eof;
		BOOL Write;

	public :

		FileIO (const char *file,unsigned mode);
		~FileIO ();

		const char *getline (void);
		void settext (const char *b);
		BOOL good (void);
		BOOL eof (void) { return Eof; }
		friend FileIO& operator<< (FileIO &f,const char *c);
	};

	class rtext : public string
	{
		private :

			string remark;

		public :

			rtext (const char *s);

			FileIO& GetRemark (FileIO& OS);
			const char* SetRemark (const char* r);
			friend int operator== (const rtext &t1,const rtext &t2);
	};


	typedef TIArrayAsVector<rtext> StrgList;
	typedef TIArrayAsVectorIterator<rtext> StrgListIterator;

	class entry : public rtext
	{
		private :

			string Value;

		public :

			entry (const char *s);

			const char* GetValue (void);
			const char* SetValue (const char* v);
	};

	typedef TISArrayAsVector<entry> EntryList;
	typedef TISArrayAsVectorIterator<entry> EntryListIterator;


	class section : public rtext
	{
		private :

			StrgList Texts;
			EntryList Entries;

		public :

			section (const char *s);
			~section ();
			void Add (rtext* sl);
			void Add (entry *el);

			unsigned GetTextItems (void);
			unsigned GetEntryItems (void);
			StrgList* GetTexts (void);
			EntryList* GetEntries (void);

	};

	typedef TISArrayAsVector<section> SectionList;
	typedef TISArrayAsVectorIterator<section> SectionListIterator;


	class INIFile
	{
		private :

			SectionList *sectionlist;
			BOOL dosave;

		protected :

			char *ExtractText (char *t);
			HINSTANCE hinstance;
			string file;

		public :

			INIFile (const char *file,HINSTANCE hi=(HINSTANCE)0);
			~INIFile ();

			void Save (void);  // Speichert nur, wenn Daten verndert wurden!
			void DontSave (void);
			void DoSave (void);

			// Entry-Funktionen mit Strings
			const char *GetEntry (const char *Section,const char *Entry,const char *Default = "");
			float GetFloatEntry (const char *Section,const char *Entry,float Default = 0.0);
			void SetEntry (const char *Section,const char *Entry,const char *Value);
			void SetFloatEntry (const char *Section,const char *Entry,float Value);
			void SetEntryDefault (const char *Section,const char *Entry,const char *Default);
			void SetFloatEntryDefault (const char *Section,const char *Entry,float Default);
			void DelEntry (const char *Section,const char *Entry);

			// Entry-Funktionen mit Ressource-Integern
			const char *GetResEntry (unsigned Section,unsigned Entry,const char *Default = "");
			float GetResFloatEntry (unsigned Section,unsigned Entry,float Default = 0.0);
			void SetResEntry (unsigned Section,unsigned Entry,const char *Value);
			void SetResFloatEntry (unsigned Section,unsigned Entry,float Value);
			void SetResEntryDefault (unsigned Section,unsigned Entry,const char *Default);
			void SetResFloatEntryDefault (unsigned Section,unsigned Entry,float Default);
			void DelResEntry (unsigned Section,unsigned Entry);

			// Freitext-Funktionen mit Strings
			unsigned GetSize (const char *Section);
			const char *GetText (const char *Section,unsigned pos);
			
			// Wenn pos nicht angegeben, wird zugefgt
			void SetText (const char *Section,const char *value,unsigned pos= INT_MAX);	
			void DelText (const char *Section,unsigned pos);
			void DelText (const char *Section,const char *text);

			// Freitext-Funktionen mit Ressource-Integern
			unsigned GetResSize (unsigned Section);
			const char *GetResText (unsigned Section,unsigned pos);
			
			// Wenn pos nicht angegeben, wird am Ende zugefgt
			void SetResText (unsigned Section,const char *value,unsigned pos= INT_MAX);	
			void DelResText (unsigned Section,unsigned pos);
			void DelResText (unsigned Section,const char *text);

			// Section-Funktionen mit Strings
			void DelSection (const char *Section);
			section* GetSection (const char *Section);

			// Section-Funktionen mit Ressource-Integern
			void DelResSection (unsigned Section);
			section* GetResSection (unsigned Section);

			// Ermmittlung von Key-Listen mit Strings
			unsigned GetKeySize (const char *Section);
			const char *GetKey (const char *Section,unsigned pos);

			// Ermmittlung von Key-Listen mit Ressource-Integern
			unsigned GetKeySize (unsigned Section);
			const char *GetResKey (unsigned Section,unsigned pos);
};


#endif
