{********************************************}
{*                                          *}
{*     LEAD.PAS generated from LEAD.VBX     *}
{*                                          *}
{********************************************}

unit LeadDef;

interface

uses WinTypes, SysUtils, Classes, Graphics, Forms, Controls, VBXCtrl, BIVBX;

{ $DEFINE InitTLEADBitmap}
{^- Remove space to enable default init data -- See documentation. }



const

{ PropertySet property constants }

   LVB_PROPSET_PRO = 0;
   LVB_PROPSET_EXP = 1;

{ Effect property constants }

   LVB_EFFECT_NONE = 0;
   LVB_EFFECT_WIPE_DOWN = 1;
   LVB_EFFECT_WIPE_UP = 2;
   LVB_EFFECT_WIPE_RIGHT = 3;
   LVB_EFFECT_WIPE_LEFT = 4;
   LVB_EFFECT_RANDOM_PIXEL = 5;
   LVB_EFFECT_RANDOM_SMALLBOX = 6;
   LVB_EFFECT_RANDOM_MEDIUMBOX = 7;
   LVB_EFFECT_RANDOM_LARGEBOX = 8;
   LVB_EFFECT_RANDOM_HLINE = 9;
   LVB_EFFECT_RANDOM_VLINE = 10;
   LVB_EFFECT_VMIDDLE = 11;
   LVB_EFFECT_HMIDDLE = 12;
   LVB_EFFECT_HINTERLACE = 13;
   LVB_EFFECT_VINTERLACE = 14;
   LVB_EFFECT_HINTERLACE_OUTWARD = 13;
   LVB_EFFECT_VINTERLACE_OUTWARD = 14;
   LVB_EFFECT_OUTTOIN = 15;
   LVB_EFFECT_INTOOUT = 16;
   LVB_EFFECT_OUTTOIN_INTERLACE = 17;
   LVB_EFFECT_INTOOUT_INTERLACE = 18;
   LVB_EFFECT_SPIRAL_IN = 19;
   LVB_EFFECT_SPIRAL_OUT = 20;
   LVB_EFFECT_HMIDDLE_INWARD = 21;
   LVB_EFFECT_VMIDDLE_INWARD = 22;
   LVB_EFFECT_VINTERLACE_INWARD = 23;
   LVB_EFFECT_HINTERLACE_INWARD = 24;
   LVB_EFFECT_VINTERLACE_RIGHT = 25;
   LVB_EFFECT_VINTERLACE_LEFT = 26;
   LVB_EFFECT_HINTERLACE_UP = 27;
   LVB_EFFECT_HINTERLACE_DOWN = 28;

{ Halftone property constants }

   LVB_HT_PRINT = 0;
   LVB_HT_VIEW = 1;

{ FltEmboss property constants }

   LVB_EMBOSS_N = 0;
   LVB_EMBOSS_NE = 1;
   LVB_EMBOSS_E = 2;
   LVB_EMBOSS_SE = 3;
   LVB_EMBOSS_S = 4;
   LVB_EMBOSS_SW = 5;
   LVB_EMBOSS_W = 6;
   LVB_EMBOSS_NW = 7;

{ FltGradient property constants }

   LVB_GRADIENT_N = 0;
   LVB_GRADIENT_NE = 1;
   LVB_GRADIENT_E = 2;
   LVB_GRADIENT_SE = 3;
   LVB_GRADIENT_S = 4;
   LVB_GRADIENT_SW = 5;
   LVB_GRADIENT_W = 6;
   LVB_GRADIENT_NW = 7;

{ FltLaplace property constants }

   LVB_LAPLACE_1 = 0;
   LVB_LAPLACE_2 = 1;
   LVB_LAPLACE_3 = 2;
   LVB_LAPLACE_DIAG = 3;
   LVB_LAPLACE_HORZ = 4;
   LVB_LAPLACE_VERT = 5;

{ FltSobel property constants }

   LVB_SOBEL_HORZ = 0;
   LVB_SOBEL_VERT = 1;

{ FltPrewitt property constants }

   LVB_PREWITT_HORZ = 0;
   LVB_PREWITT_VERT = 1;

{ FltShiftDiff property constants }

   LVB_SHIFTDIFF_DIAG = 0;
   LVB_SHIFTDIFF_HORZ = 1;
   LVB_SHIFTDIFF_VERT = 2;

{ FltLineSeg property constants }

   LVB_LINESEG_HORZ = 0;
   LVB_LINESEG_VERT = 1;
   LVB_LINESEG_LTOR = 2;
   LVB_LINESEG_RTOL = 3;

{ FltErosion property constants }

   LVB_EROSION_OMNI = 0;
   LVB_EROSION_HORZ = 1;
   LVB_EROSION_VERT = 2;
   LVB_EROSION_DIAG = 3;

{ FltDilation property constants }

   LVB_DILATION_OMNI = 0;
   LVB_DILATION_HORZ = 1;
   LVB_DILATION_VERT = 2;
   LVB_DILATION_DIAG = 3;

{ SaveFile and InfoFile property constants }

   LVB_FILE_LEAD = 0;
   LVB_FILE_LEAD1JFIF = 1;
   LVB_FILE_LEAD2JFIF = 2;
   LVB_FILE_JFIF = 3;
   LVB_FILE_LEAD1JTIF = 4;
   LVB_FILE_LEAD2JTIF = 5;
   LVB_FILE_JTIF = 6;
   LVB_FILE_BMP = 7;
   LVB_FILE_OS2 = 8;
   LVB_FILE_TIF = 9;
   LVB_FILE_TIFLZW = 10;
   LVB_FILE_TGA = 11;
   LVB_FILE_PCX = 12;
   LVB_FILE_GIF = 13;
   LVB_FILE_EPS = 14;
   LVB_FILE_CALS = 15;
   LVB_FILE_WMF = 16;
   LVB_FILE_WPG = 17;
   LVB_FILE_RAS = 18;
   LVB_FILE_MAC = 19;
   LVB_FILE_PCT = 20;
   LVB_FILE_MSP = 21;
   LVB_FILE_IMG = 22;
   LVB_FILE_LEAD1BIT = 23;
   LVB_FILE_CCITT = 24;
   LVB_FILE_CCITT_GROUP3_1DIM = 25;
   LVB_FILE_CCITT_GROUP3_2DIM = 26;
   LVB_FILE_CCITT_GROUP4 = 27;
   LVB_FILE_FAX_G3_1D = 28;
   LVB_FILE_FAX_G3_2D = 29;
   LVB_FILE_FAX_G4 = 30;
   LVB_FILE_WFX_G3_1D = 31;
   LVB_FILE_WFX_G4 = 32;
   LVB_FILE_ICA_G3_1D = 33;
   LVB_FILE_ICA_G3_2D = 34;
   LVB_FILE_ICA_G4 = 35;
   LVB_FILE_OS2_2 = 36;
   LVB_FILE_PNG = 37;
   LVB_FILE_PSD = 38;
   LVB_FILE_READONLY = 39;

{ BitChgPalette property constants }

   LVB_PALETTE_OPTIMIZED = 0;
   LVB_PALETTE_FIXED = 1;
   LVB_PALETTE_USER = 2;
   LVB_PALETTE_IDENTITY = 3;

{ BitChgOrder property constants }

   LVB_ORDER_BGR = 0;
   LVB_ORDER_RGB = 1;

{ BitChgDither property constants }

   LVB_DITHER_NONE = 0;
   LVB_DITHER_FLOYD = 1;
   LVB_DITHER_BURKES = 2;
   LVB_DITHER_STUCKI = 3;
   LVB_DITHER_SIERRA = 4;
   LVB_DITHER_STEVENSON = 5;
   LVB_DITHER_JARVIS = 6;
   LVB_DITHER_ORDERED = 7;
   LVB_DITHER_LAST = 7;

{ SaveQFactor property constants }

   LVB_QFACTOR_PQ1 = -1;       { Perfect quality option 1 }
   LVB_QFACTOR_PQ2 = -2;       { Perfect quality option 2 }
   LVB_QFACTOR_QFS = -3;       { Quality far more important than size }
   LVB_QFACTOR_QMS = -4;       { Quality more important than size }
   LVB_QFACTOR_QS = -5;        { Quality and size are equally important }
   LVB_QFACTOR_SQS = -6;       { Size more important than quality -Sharp }
   LVB_QFACTOR_SQT = -7;       { Size more important than quality - Less Tilling }
   LVB_QFACTOR_MCQ = -8;       { Maximum Compression, keeping quality as good as possible }
   LVB_QFACTOR_MC = -9;        { Maximum compression }

{ Channel constants }

   LVB_CHANNEL_MASTER = 0;     { All channels }
   LVB_CHANNEL_RED = 1;        { Red channel }
   LVB_CHANNEL_GREEN = 2;      { Green channel }
   LVB_CHANNEL_BLUE = 3;       { Blue channel }

{ BitonalScaling constants }

   LVB_BITONAL_NORMAL = 0;              { Normal scaling }
   LVB_BITONAL_FAVORBLACK = 1;          { Favor black }
   LVB_BITONAL_SCALETOGRAY = 2;         { Scale to gray }

{ Underlay constants }

   LVB_UNDERLAYTYPE_TILE = 0;           { Tile underlay }
   LVB_UNDERLAYTYPE_STRETCH = 1;        { Stretch underlay to image }

{ Combine Ops }

   LVB_CB_SRC_NOP = $0;
   LVB_CB_SRC_NOT = $1;
   LVB_CB_SRC_0 = $2;
   LVB_CB_SRC_1 = $3;

   LVB_CB_DST_NOP = $0;
   LVB_CB_DST_NOT = $10;
   LVB_CB_DST_0 = $20;
   LVB_CB_DST_1 = $30;

   LVB_CB_OP_AND = $0;
   LVB_CB_OP_OR = $100;
   LVB_CB_OP_XOR = $200;
   LVB_CB_OP_ADD = $300;
   LVB_CB_OP_SUBSRC = $400;
   LVB_CB_OP_SUBDST = $500;
   LVB_CB_OP_MUL = $600;
   LVB_CB_OP_DIVSRC = $700;
   LVB_CB_OP_DIVDST = $800;
   LVB_CB_OP_AVG = $900;
   LVB_CB_OP_MIN = $A00;
   LVB_CB_OP_MAX = $B00;

   LVB_CB_RES_NOP = $0;
   LVB_CB_RES_NOT = $1000;
   LVB_CB_RES_0 = $2000;
   LVB_CB_RES_1 = $3000;

{ Resize Types }

   LVB_RESIZE_NORMAL = 0;
   LVB_RESIZE_INTERPOLATE = 1;

{ Color separate and merge constants }

   LVB_COLORSEP_RGB = 0;
   LVB_COLORSEP_CMYK = 1;
   LVB_COLORSEP_HSV = 2;
   LVB_COLORSEP_HLS = 3;
   LVB_COLORSEP_CMY = 4;

{ PaintPalette constants }

   LVB_PAINTPALETTE_AUTO = 0;
   LVB_PAINTPALETTE_FIXED = 1;

{ PCDResolution constants }

   LVB_PCDRES_BASE_OVER_64 = 0;  {   64 x   96 }
   PLVB_CDRES_BASE_OVER_16 = 1;  {  128 x  192 }
   LVB_PCDRES_BASE_OVER_4 = 2;   {  256 x  384 }
   LVB_PCDRES_BASE = 3;          {  512 x  768 }
   LVB_PCDRES_4BASE = 4;         { 1024 x 1536 }
   LVB_PCDRES_16BASE = 5;        { 2048 x 3072 }

{ LEAD.VBX error codes }

   LVB_ERR_FAILURE = 20000;            { General failure }
   LVB_ERR_NO_MEMORY = 20001;          { Not enough memory available }
   LVB_ERR_NO_BITMAP = 20002;          { Invalid bitmap handle }
   LVB_ERR_MEMORY_TOO_LOW = 20003;     { Not enough memory available }
   LVB_ERR_FILE_LSEEK = 20004;         { Error seeking to position }
   LVB_ERR_FILE_WRITE = 20005;         { Error writing file }
   LVB_ERR_FILE_GONE = 20006;          { File not present - abort }
   LVB_ERR_FILE_READ = 20007;          { Error reading file }
   LVB_ERR_INV_FILENAME = 20008;       { Invalid filename specified }
   LVB_ERR_FILE_FORMAT = 20009;        { Invalid file format }
   LVB_ERR_FILE_NOT_FOUND = 20010;     { File not found }
   LVB_ERR_INV_RANGE = 20011;          { Invalid width/height }
   LVB_ERR_IMAGE_TYPE = 20012;         { Image format recognized, but sub-type not supported }
   LVB_ERR_INV_PARAMETER = 20013;      { Invalid parmameter passed }
   LVB_ERR_FILE_OPEN = 20014;          { Not able to open file }
   LVB_ERR_UNKNOWN_COMP = 20015;       { Unknown compression format }
   LVB_ERR_NOT_SUPPORTED = 20016;      { Not available for file format requested }
   LVB_ERR_NOT_256_COLOR = 20017;      { VGA card only supports 256 colors (8 bit) }
   LVB_ERR_PRINTER = 20018;            { Printer error }
   LVB_ERR_CRC_CHECK = 20019;          { Data CRC check error }
   LVB_ERR_QFACTOR = 20021;            { Invalid QFactor specified }
   LVB_ERR_TARGAINSTALL = 20022;       { TARGA not installed }
   LVB_ERR_OUTPUTTYPE = 20023;         { Invalid compression format }
   LVB_ERR_XORIGIN = 20024;            { X origin specified invalid }
   LVB_ERR_YORIGIN = 20025;            { Y origin specified invalid }
   LVB_ERR_VIDEOTYPE = 20026;          { Invalid video mode }
   LVB_ERR_BITPERPIXEL = 20027;        { Invalid bits/pixel }
   LVB_ERR_WINDOWSIZE = 20028;         { Invalid window size }
   LVB_ERR_NORMAL_ABORT = 20029;       { Escape key pressed }
   LVB_ERR_NOT_INITIALIZED = 20030;    { Internal error - call LEAD }
   LVB_ERR_CU_BUSY = 20031;            { Internal error - call LEAD }
   LVB_ERR_INVALID_TABLE_TYPE = 20032; { Internal error - call LEAD }
   LVB_ERR_UNEQUAL_TABLES = 20033;     { Internal error - call LEAD }
   LVB_ERR_INVALID_BUFFER = 20034;     { Internal error - call LEAD }
   LVB_ERR_MISSING_TILE_DATA = 20035;  { Internal error - call LEAD }
   LVB_ERR_INVALID_QVALUE = 20036;     { Internal error - call LEAD }
   LVB_ERR_INVALID_DATA = 20037;       { Internal error - call LEAD }
   LVB_ERR_INVALID_COMPRESSED_TYPE = 20038;    { Internal error - call LEAD }
   LVB_ERR_INVALID_COMPONENT_NUM = 20039;      { Internal error - call LEAD }
   LVB_ERR_INVALID_PIXEL_TYPE = 20040;         { Internal error - call LEAD }
   LVB_ERR_INVALID_PIXEL_SAMPLING = 20041;     { Internal error - call LEAD }
   LVB_ERR_INVALID_SOURCE_FILE = 20042;        { Internal error - call LEAD }
   LVB_ERR_INVALID_TARGET_FILE = 20043;        { Internal error - call LEAD }
   LVB_ERR_INVALID_IMAGE_DIMS = 20044;         { Internal error - call LEAD }
   LVB_ERR_INVALID_TILE_DIMS = 20045;          { Internal error - call LEAD }
   LVB_ERR_INVALID_PIX_BUFF_DIMS = 20046;      { Internal error - call LEAD }
   LVB_ERR_SEGMENT_OVERFLOW = 20047;           { Internal error - call LEAD }
   LVB_ERR_INVALID_SUBSAMPLING = 20048;        { Internal error - call LEAD }
   LVB_ERR_INVALID_Q_VIS_TABLE = 20049;        { Internal error - call LEAD }
   LVB_ERR_INVALID_DC_CODE_TABLE = 20050;      { Internal error - call LEAD }
   LVB_ERR_INVALID_AC_CODE_TABLE = 20051;      { Internal error - call LEAD }
   LVB_ERR_INSUFFICIENT_DATA = 20052;          { Internal error - call LEAD }
   LVB_ERR_MISSING_FUNC_POINTER = 20053;       { Internal error - call LEAD }
   LVB_ERR_TOO_MANY_DC_CODE_TABLES = 20054;    { Internal error - call LEAD }
   LVB_ERR_TOO_MANY_AC_CODE_TABLES = 20055;    { Internal error - call LEAD }
   LVB_ERR_INVALID_SUBIMAGE = 20056;           { Internal error - call LEAD }
   LVB_ERR_INVALID_ABORTION = 20057;           { Internal error - call LEAD }
   LVB_ERR_CU_NO_SUPPORT = 20058;              { Internal error - call LEAD }
   LVB_ERR_CU_FAILURE = 20059;                 { Internal error - call LEAD }
   LVB_ERR_BAD_POINTER = 20060;                { Internal error - call LEAD }
   LVB_ERR_HEADER_DATA_FAILURE = 20061;        { Internal error - call LEAD }
   LVB_ERR_COMPRESSED_DATA_FAILURE = 20062;    { Internal error - call LEAD }

   LVB_ERR_FIXEDPAL_DATA = 20063;      { Fixed palette data not found }
   LVB_ERR_LOADFONT_DATA = 20064;      { Fixed palette data not found }
   LVB_ERR_NO_STAMP = 20065;           { Stamp not found }

   LVB_ERR_G3CODE_INVALID = 20070;     { Invalid group 3 code }
   LVB_ERR_G3CODE_EOF = 20071;         { Group3 code end of file }
   LVB_ERR_G3CODE_EOL = 20072;         { Group3 code end of code }
   LVB_ERR_PREMATURE_EOF = 20073;      { Premature EOF at scanline }
   LVB_ERR_PREMATURE_EOL = 20074;      { Premature end-of-line code }
   LVB_ERR_UNCOMP_EOF = 20075;         { Premature end-of-line code }
   LVB_ERR_ACT_INCOMP = 20076;         { Premature end-of-line code }
   LVB_ERR_BAD_DECODE_STATE = 20077;   { Premature end-of-line code }
   LVB_ERR_VERSION_NUMBER = 20078;     { Bad version number }
   LVB_ERR_TWAIN_NODSM = 20079;        { Twain source manager not found }
   LVB_ERR_TWAIN_BUMMER = 20080;       { Twain failure due to unknown causes }
   LVB_ERR_TWAIN_LOWMEMORY = 20081;    { Twain not enough memory to perform operation }
   LVB_ERR_TWAIN_NODS = 20082;         { Twain no Data Source }
   LVB_ERR_TWAIN_MAXCONNECTIONS = 20083;       { Twain DS is connected to max possible apps }
   LVB_ERR_TWAIN_OPERATIONERROR = 20084;       { Twain DS or DSM reported error, app shouldn't }
   LVB_ERR_TWAIN_BADCAP = 20085;       { Twain unknown capability }
   LVB_ERR_TWAIN_BADPROTOCOL = 20086;  { Twain unrecognized MSG DG DAT combination }
   LVB_ERR_TWAIN_BADVALUE = 20087;     { Twain data parameter out of range }
   LVB_ERR_TWAIN_SEQERROR = 20088;     { Twain DG DAT MSG out of expected sequence }
   LVB_ERR_TWAIN_BADDEST = 20089;      { Twain unknown destination App/Src in DSM_Entry }
   LVB_ERR_TWAIN_CANCEL = 20090;       { Twain operation was cancelled }


type
  TLEADBitmapPaintEvent = procedure (Sender: TObject) of object;
  TLEADBitmapResizeEvent = procedure (Sender: TObject) of object;
  TLEADBitmapScrollEvent = procedure (Sender: TObject) of object;
  TLEADBitmapStatusEvent = procedure (Sender: TObject; var Percent: Integer)
    of object;
  TLEADBitmapTwainImageEvent = procedure (Sender: TObject) of object;

  { TLEADBitmap }

  TLEADBitmap = class(TVBXControl)
  protected
    FOnPaint: TLEADBitmapPaintEvent;
    FOnResize: TLEADBitmapResizeEvent;
    FOnScroll: TLEADBitmapScrollEvent;
    FOnStatus: TLEADBitmapStatusEvent;
    FOnTwainImage: TLEADBitmapTwainImageEvent;
    { Event handler }
    procedure HandleVBXEvent(var Message: TWMVBXFireEvent); override;
    procedure DefineProperties(Filer: TFiler); override;
  public
    constructor Create(AOwner: TComponent); override;

    property Index: TVBInteger index 1 read GetIntProp;
    property pFile: TVBString index 18 read GetStringProp write SetStringProp;
    property Bitmap: TVBInteger index 19 read GetIntProp write SetIntProp;
    property BitmapWidth: TVBInteger index 20 read GetIntProp write
      SetIntProp;
    property BitmapHeight: TVBInteger index 21 read GetIntProp write
      SetIntProp;
    property BitmapBits: TVBInteger index 22 read GetIntProp write SetIntProp;
    property Rotate: TVBInteger index 23 read GetIntProp write SetIntProp;
    property Reverse: Boolean index 24 read GetBoolProp write SetBoolProp;
    property Flip: Boolean index 25 read GetBoolProp write SetBoolProp;
    property Invert: Boolean index 26 read GetBoolProp write SetBoolProp;
    property Intensity: TVBInteger index 27 read GetIntProp write SetIntProp;
    property Contrast: TVBInteger index 28 read GetIntProp write SetIntProp;
    property Hue: TVBInteger index 29 read GetIntProp write SetIntProp;
    property Saturation: TVBInteger index 30 read GetIntProp write SetIntProp;
    property Sharpness: TVBInteger index 31 read GetIntProp write SetIntProp;
    property Average: TVBInteger index 32 read GetIntProp write SetIntProp;
    property Median: TVBInteger index 33 read GetIntProp write SetIntProp;
    property Posterize: TVBInteger index 34 read GetIntProp write SetIntProp;
    property Mosaic: TVBInteger index 35 read GetIntProp write SetIntProp;
    property HistoEq: Boolean index 36 read GetBoolProp write SetBoolProp;
    property ResizeWidth: TVBInteger index 37 read GetIntProp write
      SetIntProp;
    property ResizeHeight: TVBInteger index 38 read GetIntProp write
      SetIntProp;
    property Resize: Boolean index 39 read GetBoolProp write SetBoolProp;
    property Repaint: Boolean index 41 read GetBoolProp write SetBoolProp;
    property FilePage: TVBInteger index 43 read GetIntProp write SetIntProp;
    property GrayScale: Boolean index 44 read GetBoolProp write SetBoolProp;
    property Halftone: TVBEnum index 45 read GetEnumProp write SetEnumProp;
    property FltEmboss: TVBEnum index 46 read GetEnumProp write SetEnumProp;
    property FltGradient: TVBEnum index 47 read GetEnumProp write SetEnumProp;
    property FltLaplace: TVBEnum index 48 read GetEnumProp write SetEnumProp;
    property FltSobel: TVBEnum index 49 read GetEnumProp write SetEnumProp;
    property FltPrewitt: TVBEnum index 50 read GetEnumProp write SetEnumProp;
    property hDC: TVBInteger index 51 read GetIntProp;
    property TwainSelect: Boolean index 52 read GetBoolProp write SetBoolProp;
    property TwainAcquire: Boolean index 53 read GetBoolProp write
      SetBoolProp;
    property ImageLeft: TVBInteger index 54 read GetIntProp write SetIntProp;
    property ImageTop: TVBInteger index 55 read GetIntProp write SetIntProp;
    property ImageWidth: TVBInteger index 56 read GetIntProp write SetIntProp;
    property ImageHeight: TVBInteger index 57 read GetIntProp write
      SetIntProp;
    property CropLeft: TVBInteger index 58 read GetIntProp write SetIntProp;
    property CropTop: TVBInteger index 59 read GetIntProp write SetIntProp;
    property CropWidth: TVBInteger index 60 read GetIntProp write SetIntProp;
    property CropHeight: TVBInteger index 61 read GetIntProp write SetIntProp;
    property Crop: Boolean index 62 read GetBoolProp write SetBoolProp;
    property Copy: Boolean index 63 read GetBoolProp write SetBoolProp;
    property Paste: Boolean index 64 read GetBoolProp write SetBoolProp;
    property SaveFile: TVBString index 65 read GetStringProp write
      SetStringProp;
    property SaveBits: TVBInteger index 66 read GetIntProp write SetIntProp;
    property SaveQFactor: TVBInteger index 67 read GetIntProp write
      SetIntProp;
    property SaveFormat: TVBEnum index 68 read GetEnumProp write SetEnumProp;
    property BitChgPalette: TVBEnum index 69 read GetEnumProp write
      SetEnumProp;
    property BitChgOrder: TVBEnum index 70 read GetEnumProp write SetEnumProp;
    property BitChgDither: TVBEnum index 71 read GetEnumProp write
      SetEnumProp;
    property PrintLeft: TVBInteger index 72 read GetIntProp write SetIntProp;
    property PrintTop: TVBInteger index 73 read GetIntProp write SetIntProp;
    property PrintWidth: TVBInteger index 74 read GetIntProp write SetIntProp;
    property PrintHeight: TVBInteger index 75 read GetIntProp write
      SetIntProp;
    property PrintBitmap: TVBInteger index 76 read GetIntProp write
      SetIntProp;
    property BitmapDC: TVBInteger index 77 read GetIntProp write SetIntProp;
    property InfoFile: TVBString index 78 read GetStringProp write
      SetStringProp;
    property InfoFormat: TVBEnum index 79 read GetEnumProp;
    property InfoWidth: TVBInteger index 80 read GetIntProp;
    property InfoHeight: TVBInteger index 81 read GetIntProp;
    property InfoBits: TVBInteger index 82 read GetIntProp;
    property InfoSizeDisk: TVBLongint index 83 read GetLongProp;
    property InfoSizeMem: TVBLongint index 84 read GetLongProp;
    property InfoCompress: TVBString index 85 read GetStringProp;
    property InfoPage: TVBInteger index 86 read GetIntProp write SetIntProp;
    property BitmapPalette[Index: Integer]: TColor index 88 read
      GetColorArrayProp write SetColorArrayProp;
    property SaveMulti: Boolean index 90 read GetBoolProp write SetBoolProp;
    property BitmapScaleWidth: TVBInteger index 91 read GetIntProp write
      SetIntProp;
    property BitmapScaleHeight: TVBInteger index 92 read GetIntProp write
      SetIntProp;
    property InfoScaleWidth: TVBInteger index 93 read GetIntProp write
      SetIntProp;
    property InfoScaleHeight: TVBInteger index 94 read GetIntProp write
      SetIntProp;
    property BitmapOrder: TVBEnum index 96 read GetEnumProp write SetEnumProp;
    property Picture: TVBPic index 97 read GetPictureProp write
      SetPictureProp;
    property PictureCreate: Boolean index 98 read GetBoolProp write
      SetBoolProp;
    property FltShiftDiff: TVBEnum index 99 read GetEnumProp write
      SetEnumProp;
    property FltLineSeg: TVBEnum index 100 read GetEnumProp write SetEnumProp;
    property FltErosion: TVBEnum index 102 read GetEnumProp write SetEnumProp;
    property FltDilation: TVBEnum index 103 read GetEnumProp write
      SetEnumProp;
    property PaintBwAsGray: Boolean index 104 read GetBoolProp write
      SetBoolProp;
    property Despeckle: Boolean index 105 read GetBoolProp write SetBoolProp;
    property PropertySet: TVBEnum index 106 read GetEnumProp write
      SetEnumProp;
    property Deskew: Boolean index 107 read GetBoolProp write SetBoolProp;
    property HistoContrast: TVBInteger index 108 read GetIntProp write
      SetIntProp;
    property RotateFine: TVBLongint index 109 read GetLongProp write SetProp;
    property GammaCorrect: TVBInteger index 110 read GetIntProp write
      SetIntProp;
    property Fill: TColor index 111 read GetColorProp write SetColorProp;
    property BitmapXRes: TVBInteger index 112 read GetIntProp write
      SetIntProp;
    property BitmapYRes: TVBInteger index 113 read GetIntProp write
      SetIntProp;
    property StretchIntensity: Boolean index 114 read GetBoolProp write
      SetBoolProp;
    property ShearX: TVBInteger index 115 read GetIntProp write SetIntProp;
    property ShearY: TVBInteger index 116 read GetIntProp write SetIntProp;
    property BitChgUserPal[Index: Integer]: TColor index 117 read
      GetColorArrayProp write SetColorArrayProp;
    property IntensityDetectLow: TVBInteger index 118 read GetIntProp write
      SetIntProp;
    property IntensityDetectHigh: TVBInteger index 119 read GetIntProp write
      SetIntProp;
    property IntensityDetect: Boolean index 120 read GetBoolProp write
      SetBoolProp;
    property Trim: Boolean index 121 read GetBoolProp write SetBoolProp;
    property TrimLeft: TVBInteger index 122 read GetIntProp write SetIntProp;
    property TrimTop: TVBInteger index 123 read GetIntProp write SetIntProp;
    property TrimWidth: TVBInteger index 124 read GetIntProp write SetIntProp;
    property TrimHeight: TVBInteger index 125 read GetIntProp write
      SetIntProp;
    property AddNoise: TVBInteger index 126 read GetIntProp write SetIntProp;
    property AddNoiseChannel: TVBEnum index 127 read GetEnumProp write
      SetEnumProp;
    property UnderlayType: TVBEnum index 129 read GetEnumProp write
      SetEnumProp;
    property Underlay: TVBInteger index 130 read GetIntProp write SetIntProp;
    property Capture: TVBInteger index 132 read GetIntProp write SetIntProp;
    property CaptureLeft: TVBInteger index 133 read GetIntProp write
      SetIntProp;
    property CaptureTop: TVBInteger index 134 read GetIntProp write
      SetIntProp;
    property CaptureWidth: TVBInteger index 135 read GetIntProp write
      SetIntProp;
    property CaptureHeight: TVBInteger index 136 read GetIntProp write
      SetIntProp;
    property CreateBitmap: Boolean index 137 read GetBoolProp write
      SetBoolProp;
    property CreateBits: TVBInteger index 138 read GetIntProp write
      SetIntProp;
    property CreateWidth: TVBInteger index 139 read GetIntProp write
      SetIntProp;
    property CreateHeight: TVBInteger index 140 read GetIntProp write
      SetIntProp;
    property Combine: TVBInteger index 143 read GetIntProp write SetIntProp;
    property CombineOp: TVBLongint index 144 read GetLongProp write SetProp;
    property CombineDstLeft: TVBInteger index 145 read GetIntProp write
      SetIntProp;
    property CombineDstTop: TVBInteger index 146 read GetIntProp write
      SetIntProp;
    property CombineWidth: TVBInteger index 147 read GetIntProp write
      SetIntProp;
    property CombineHeight: TVBInteger index 148 read GetIntProp write
      SetIntProp;
    property CombineSrcLeft: TVBInteger index 149 read GetIntProp write
      SetIntProp;
    property CombineSrcTop: TVBInteger index 150 read GetIntProp write
      SetIntProp;
    property HalftoneAngle: TVBLongint index 151 read GetLongProp write
      SetProp;
    property FltEmbossDepth: TVBInteger index 152 read GetIntProp write
      SetIntProp;
    property PrintCrop: Boolean index 153 read GetBoolProp write SetBoolProp;
    property PrintCropLeft: TVBInteger index 154 read GetIntProp write
      SetIntProp;
    property PrintCropTop: TVBInteger index 155 read GetIntProp write
      SetIntProp;
    property PrintCropWidth: TVBInteger index 156 read GetIntProp write
      SetIntProp;
    property PrintCropHeight: TVBInteger index 157 read GetIntProp write
      SetIntProp;
    property ResizeType: TVBEnum index 158 read GetEnumProp write SetEnumProp;
    property SaveStamp: Boolean index 159 read GetBoolProp write SetBoolProp;
    property SaveStampBits: TVBInteger index 160 read GetIntProp write
      SetIntProp;
    property SaveStampWidth: TVBInteger index 161 read GetIntProp write
      SetIntProp;
    property SaveStampHeight: TVBInteger index 162 read GetIntProp write
      SetIntProp;
    property LoadStamp: Boolean index 163 read GetBoolProp write SetBoolProp;
    property ColorSeparate: TVBEnum index 164 read GetEnumProp write
      SetEnumProp;
    property ColorMerge: TVBEnum index 165 read GetEnumProp write SetEnumProp;
    property ColorPlanes[Index: Integer]: TVBInteger index 166 read
      GetIntArrayProp write SetIntArrayProp;
    property Histogram[Index: Integer]: TVBLongint index 168 read
      GetLongArrayProp write SetLongArrayProp;
    property HistogramAcquire: Boolean index 169 read GetBoolProp write
      SetBoolProp;
    property HistogramChannel: TVBEnum index 170 read GetEnumProp write
      SetEnumProp;
    property InfoPCDResolution[Index: Integer]: Boolean index 171 read
      GetBoolArrayProp;
    property PCDResolution: TVBEnum index 172 read GetEnumProp write
      SetEnumProp;
    property RemapTable[Index: Integer]: TVBInteger index 173 read
      GetIntArrayProp write SetIntArrayProp;
    property RemapChannel: TVBEnum index 174 read GetEnumProp write
      SetEnumProp;
    property RemapIntensity: Boolean index 175 read GetBoolProp write
      SetBoolProp;
    property DIB: TVBInteger index 176 read GetIntProp write SetIntProp;
    property DDB: TVBInteger index 177 read GetIntProp write SetIntProp;
    property BackPalette: Boolean index 178 read GetBoolProp write
      SetBoolProp;
  published
    property BackColor: TColor index 3 read GetColorProp write SetColorProp
      default -2147483633;
    property Enabled;
    property Visible;
    property MousePointer: TVBEnum index 10 read GetEnumProp write
      SetEnumProp default 0;
    property TabOrder;
    property DragMode;
    property DragCursor;
    property TabStop;
    property BorderStyle: TVBEnum index 17 read GetEnumProp write SetEnumProp
      default 0;
    property AutoRepaint: Boolean index 40 read GetBoolProp write SetBoolProp
      default False;
    property Effect: TVBEnum index 42 read GetEnumProp write SetEnumProp
      default 0;
    property BackErase: Boolean index 87 read GetBoolProp write SetBoolProp
      default True;
    property AutoScroll: Boolean index 89 read GetBoolProp write SetBoolProp
      default False;
    property PaintWhileLoad: Boolean index 95 read GetBoolProp write
      SetBoolProp default False;
    property PaintDither: TVBEnum index 101 read GetEnumProp write
      SetEnumProp default 0;
    property BitonalScaling: TVBEnum index 128 read GetEnumProp write
      SetEnumProp default 0;
    property EnableStatus: Boolean index 131 read GetBoolProp write
      SetBoolProp default False;
    property EnableTwainMulti: Boolean index 141 read GetBoolProp write
      SetBoolProp default False;
    property PaintROP3: TVBLongint index 142 read GetLongProp write SetProp
      default 13369376;
    property PaintPalette: TVBEnum index 167 read GetEnumProp write
      SetEnumProp default 0;
    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnEndDrag;
    property OnDragOver;
    property OnEnter;
    property OnKeyDown;
    property OnKeyPress;
    property OnKeyUp;
    property OnExit;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnPaint: TLEADBitmapPaintEvent read FOnPaint write FOnPaint;
    property OnResize: TLEADBitmapResizeEvent read FOnResize write FOnResize;
    property OnScroll: TLEADBitmapScrollEvent read FOnScroll write FOnScroll;
    property OnStatus: TLEADBitmapStatusEvent read FOnStatus write FOnStatus;
    property OnTwainImage: TLEADBitmapTwainImageEvent read FOnTwainImage
      write FOnTwainImage;
  end;

procedure Register;


implementation

{ Default form data for TLEADBitmap }

{$IFDEF InitTLEADBitmap}

const
  TLEADBitmapInitLen = 73;

procedure TLEADBitmapInitData; near; assembler;
asm
	DB	$00,$0A,$4C,$45,$41,$44,$42,$69,$74,$6D,$61,$70,$01,$00,$00,$03
	DB	$FF,$FF,$FF,$00,$04,$08,$FF,$FF,$09,$FF,$FF,$0A,$00,$0B,$00,$00
	DB	$0D,$00,$0F,$00,$00,$10,$00,$11,$00,$28,$00,$00,$2A,$00,$57,$FF
	DB	$FF,$59,$00,$00,$5F,$00,$00,$65,$00,$80,$00,$83,$00,$00,$8D,$00
	DB	$00,$8E,$20,$00,$CC,$00,$A7,$00,$FF
end;

{$ENDIF}

{ TLEADBitmap }

constructor TLEADBitmap.Create(AOwner: TComponent);
begin
  FVBXFile := StrNew('LEAD.VBX');
  FVBXClass := StrNew('LEADBitmap');
  SetBounds(0, 0, 80, 32);
  inherited Create(AOwner);
  ControlStyle := ControlStyle - [csCaptureMouse, csClickEvents] +
    [csAcceptsControls];
  TabStop := True;
  FVBXFlags := [vfLoadMessage];
  {$IFDEF InitTLEADBitmap}
  FHForm := VBXCreateFormFile(TLEADBitmapInitLen, @TLEADBitmapInitData);
  {$ENDIF}
end;

procedure TLEADBitmap.HandleVBXEvent(var Message: TWMVBXFireEvent);
begin
  case Message.VBXEvent^.EventIndex of
    0: DispatchNotifyEvent(OnClick);
    1: DispatchNotifyEvent(OnDblClick);
    2: begin end; { VCL Handles OnDragDrop }
    3: begin end; { VCL Handles OnDragOver }
    4: begin end; { VCL Handles OnGotFocus }
    5: DispatchKeyEvent(OnKeyDown, Message);
    6: DispatchKeyPressedEvent(OnKeyPress, Message);
    7: DispatchKeyEvent(OnKeyUp, Message);
    8: begin end; { VCL Handles OnLostFocus }
    9: DispatchMouseEvent(OnMouseDown, Message);
    10: DispatchMouseMoveEvent(OnMouseMove, Message);
    11: DispatchMouseEvent(OnMouseUp, Message);
    12: DispatchCustomEvent(FOnPaint, Message, 12);
    13: DispatchCustomEvent(FOnResize, Message, 13);
    14: DispatchCustomEvent(FOnScroll, Message, 14);
    15: DispatchCustomEvent(FOnStatus, Message, 15);
    16: DispatchCustomEvent(FOnTwainImage, Message, 16);
  end;
end;

procedure TLEADBitmap.DefineProperties(Filer: TFiler);
begin
  inherited DefineProperties(Filer);
end;

{ Designer registration }
procedure Register;
begin
  RegisterComponents('VBX', [
    TLEADBitmap]);
end;

end.
