unit Leadhelp;

interface

uses leaddef;

const COLOR_1BIT	 		=	1;
		 COLOR_4BIT	 		=	2;
		 COLOR_8BIT	 		=	3;
		 COLOR_8BITGRAY	=	4;
		 COLOR_16BIT		=	5;
		 COLOR_24BIT		=	6;
		 COLOR_32BIT		=	7;

type	FarbFormatListe = set of COLOR_1BIT..COLOR_32BIT;

function GetFormatText (Format : Integer) : string;
function GetFormatColors (Format : Integer) : FarbFormatListe;
procedure SetPictureExtension (var DestFile : string;SaveFormat : integer);

implementation

function GetFormatText (Format : Integer) : string;
begin
	case Format of
		LVB_FILE_LEAD :
			Result := 'LEAD';
		LVB_FILE_LEAD1JFIF :
			Result := 'Lead1 JPEG File Interchange';
		LVB_FILE_LEAD2JFIF :
			Result := 'Lead2 JPEG File Interchange';
		LVB_FILE_JFIF :
			Result := 'JPEG File Interchange';
		LVB_FILE_LEAD1JTIF :
			Result := 'Lead1 Tagged Image File with JPEG';
		LVB_FILE_LEAD2JTIF :
			Result := 'Lead2 Tagged Image File with JPEG';
		LVB_FILE_JTIF :
			Result := 'Tagged Image File with JPEG';
		LVB_FILE_BMP :
			Result := 'Windows Bitmap';
		LVB_FILE_OS2 :
			Result := 'OS/2 Bitmap V1.x';
		LVB_FILE_TIF :
			Result := 'Tagged Image File';
		LVB_FILE_TIFLZW :
			Result := 'Tagged Image File with Lempel-Ziv-Compressing';
		LVB_FILE_TGA :
			Result := 'Targa';
		LVB_FILE_PCX :
			Result := 'ZSoft PCX';
		LVB_FILE_GIF :
			Result := 'CompuServe GIF';
		LVB_FILE_EPS :
			Result := 'Encapsulated PostScript';
		LVB_FILE_CALS :
			Result := 'CALS Raster';
		LVB_FILE_WMF :
			Result := 'Windows Meta-File';
		LVB_FILE_WPG :
			Result := 'WordPerfect Grafic (Raster only)';
		LVB_FILE_RAS :
			Result := 'Sun Raster';
		LVB_FILE_MAC :
			Result := 'MacPaint';
		LVB_FILE_PCT :
			Result := 'Macintosh Pict';
		LVB_FILE_MSP :
			Result := 'Microsoft Paint';
		LVB_FILE_IMG :
			Result := 'GEM Image';
		LVB_FILE_LEAD1BIT :
			Result := 'Lead 1 Bit';
		LVB_FILE_CCITT :
			Result := 'CCITT';
		LVB_FILE_CCITT_GROUP3_1DIM :
			Result := 'CCITT Group3 1Dim';
		LVB_FILE_CCITT_GROUP3_2DIM :
			Result := 'CCITT Group3 2Dim';
		LVB_FILE_CCITT_GROUP4 :
			Result := 'CCITT Group4';
		LVB_FILE_FAX_G3_1D :
			Result := 'FAX Group3 1Dim';
		LVB_FILE_FAX_G3_2D :
			Result := 'FAX Group3 2Dim';
		LVB_FILE_FAX_G4 :
			Result := 'FAX Group4';
		LVB_FILE_WFX_G3_1D :
			Result := 'WinFax Group3 1Dim';
		LVB_FILE_WFX_G4 :
			Result := 'WinFax Group4';
		LVB_FILE_ICA_G3_1D :
			Result := 'ICA Group3 1Dim';
		LVB_FILE_ICA_G3_2D :
			Result := 'ICA Group3 2Dim';
		LVB_FILE_ICA_G4 :
			Result := 'ICA Group4';
		LVB_FILE_OS2_2 :
			Result := 'OS/2 Bitmap V2.x';
		LVB_FILE_PNG  :
			Result := 'Portabe Network Graphics';
		LVB_FILE_PSD :
		Result := 'Adobe Photoshop 3.0';
		LVB_FILE_READONLY :
		Result := 'Kodak Photo CD';
	 else
		Result := 'Unknown FileFormat';
	end;
end;

function GetFormatColors (Format : Integer) : FarbFormatListe;
begin
	case Format of
		LVB_FILE_LEAD :
			Result := [COLOR_8BITGRAY,COLOR_24BIT];
		LVB_FILE_LEAD1JFIF :
			Result := [COLOR_8BITGRAY,COLOR_24BIT];
		LVB_FILE_LEAD2JFIF :
			Result := [COLOR_8BITGRAY , COLOR_24BIT];
		LVB_FILE_JFIF :
			Result := [COLOR_8BITGRAY , COLOR_24BIT];
		LVB_FILE_LEAD1JTIF :
			Result := [COLOR_8BITGRAY , COLOR_24BIT];
		LVB_FILE_LEAD2JTIF :
			Result := [COLOR_8BITGRAY , COLOR_24BIT];
		LVB_FILE_JTIF :
			Result := [COLOR_8BITGRAY , COLOR_24BIT];
		LVB_FILE_BMP :
			Result := [COLOR_1BIT , COLOR_4BIT , COLOR_8BIT ,COLOR_8BITGRAY ,COLOR_24BIT];
		LVB_FILE_OS2 :
			Result := [COLOR_1BIT , COLOR_4BIT , COLOR_8BIT , COLOR_8BITGRAY ,COLOR_24BIT];
		LVB_FILE_TIF :
			Result := [COLOR_1BIT , COLOR_4BIT , COLOR_8BIT ,COLOR_8BITGRAY , COLOR_16BIT , COLOR_24BIT];
		LVB_FILE_TIFLZW :
			Result := [COLOR_1BIT , COLOR_8BIT ,COLOR_8BITGRAY , COLOR_16BIT , COLOR_24BIT];
		LVB_FILE_TGA :
			Result := [COLOR_8BIT ,COLOR_8BITGRAY , COLOR_16BIT , COLOR_24BIT , COLOR_32BIT];
		LVB_FILE_PCX :
			Result := [COLOR_1BIT , COLOR_4BIT , COLOR_8BIT ,COLOR_8BITGRAY , COLOR_24BIT];
		LVB_FILE_GIF :
			Result := [COLOR_8BIT,COLOR_8BITGRAY ];
		LVB_FILE_EPS :
			Result := [COLOR_8BITGRAY];
		LVB_FILE_CALS :
			Result := [COLOR_1BIT];
		LVB_FILE_WMF :
			Result := [COLOR_8BIT,COLOR_8BITGRAY  , COLOR_24BIT];
		LVB_FILE_WPG :
			Result := [COLOR_1BIT , COLOR_4BIT , COLOR_8BIT,COLOR_8BITGRAY ];
		LVB_FILE_RAS :
			Result := [COLOR_1BIT , COLOR_4BIT , COLOR_8BIT,COLOR_8BITGRAY  , COLOR_24BIT , COLOR_32BIT];
		LVB_FILE_MAC :
			Result := [COLOR_1BIT];
		LVB_FILE_PCT :
			Result := [COLOR_1BIT , COLOR_4BIT , COLOR_8BIT ,COLOR_8BITGRAY , COLOR_24BIT];
		LVB_FILE_MSP :
			Result := [COLOR_1BIT];
		LVB_FILE_IMG :
			Result := [COLOR_1BIT];
		LVB_FILE_LEAD1BIT :
			Result := [COLOR_1BIT];
		LVB_FILE_CCITT :
			Result := [COLOR_1BIT];
		LVB_FILE_CCITT_GROUP3_1DIM :
			Result := [COLOR_1BIT];
		LVB_FILE_CCITT_GROUP3_2DIM :
			Result := [COLOR_1BIT];
		LVB_FILE_CCITT_GROUP4 :
			Result := [COLOR_1BIT];
		LVB_FILE_FAX_G3_1D :
			Result := [COLOR_1BIT];
		LVB_FILE_FAX_G3_2D :
			Result := [COLOR_1BIT];
		LVB_FILE_FAX_G4 :
			Result := [COLOR_1BIT];
		LVB_FILE_WFX_G3_1D :
			Result := [COLOR_1BIT];
		LVB_FILE_WFX_G4 :
			Result := [COLOR_1BIT];
		LVB_FILE_ICA_G3_1D :
			Result := [COLOR_1BIT];
		LVB_FILE_ICA_G3_2D :
			Result := [COLOR_1BIT];
		LVB_FILE_ICA_G4 :
			Result := [COLOR_1BIT];
		LVB_FILE_OS2_2 :
			Result := [COLOR_1BIT , COLOR_4BIT , COLOR_8BIT ,COLOR_8BITGRAY , COLOR_24BIT];
		LVB_FILE_PNG  :
			Result := [COLOR_1BIT , COLOR_4BIT , COLOR_8BIT ,COLOR_8BITGRAY , COLOR_16BIT , COLOR_24BIT , COLOR_32BIT];
		LVB_FILE_PSD :
			Result := [COLOR_4BIT , COLOR_8BIT ,COLOR_8BITGRAY , COLOR_16BIT , COLOR_24BIT ];
	 else
		Result := [];
	end;
end;

procedure SetPictureExtension (var DestFile : string;SaveFormat : integer);
var ext : string;
		i : integer;
begin
	case SaveFormat of
		LVB_FILE_LEAD :
			ext := 'CMP';
		LVB_FILE_LEAD1JFIF :
			ext := 'JPG';
		LVB_FILE_LEAD2JFIF :
			ext := 'JPG';
		LVB_FILE_JFIF :
			ext := 'JPG';
		LVB_FILE_LEAD1JTIF :
			ext := 'CMP';
		LVB_FILE_LEAD2JTIF :
			ext := 'CMP';
		LVB_FILE_JTIF :
			ext := 'JPG';
		LVB_FILE_BMP :
			ext := 'BMP';
		LVB_FILE_OS2 :
			ext := 'BMP';
		LVB_FILE_TIF :
			ext := 'TIF';
		LVB_FILE_TIFLZW :
			ext := 'TIF';
		LVB_FILE_TGA :
			ext := 'TGA';
		LVB_FILE_PCX :
			ext := 'PCX';
		LVB_FILE_GIF :
			ext := 'GIF';
		LVB_FILE_EPS :
			ext := 'EPS';
		LVB_FILE_CALS :
			ext := 'CAL';
		LVB_FILE_WMF :
			ext := 'WMF';
		LVB_FILE_WPG :
			ext := 'WPG';
		LVB_FILE_RAS :
			ext := 'RAS';
		LVB_FILE_MAC :
			ext := 'MAC';
		LVB_FILE_PCT :
			ext := 'PCT';
		LVB_FILE_MSP :
			ext := 'MSP';
		LVB_FILE_IMG :
			ext := 'IMG';
		LVB_FILE_LEAD1BIT :
			ext := 'CMP';
		LVB_FILE_CCITT :
			ext := 'TIF';
		LVB_FILE_CCITT_GROUP3_1DIM :
			ext := 'TIF';
			LVB_FILE_CCITT_GROUP3_2DIM :
				ext := 'TIF';
		LVB_FILE_CCITT_GROUP4 :
				ext := 'TIF';
		LVB_FILE_FAX_G3_1D :
			ext := 'FAX';
		LVB_FILE_FAX_G3_2D :
			ext := 'FAX';
		LVB_FILE_FAX_G4 :
			ext := 'FAX';
		LVB_FILE_WFX_G3_1D :
			ext := 'WFX';
		LVB_FILE_WFX_G4 :
			ext := 'WFX';
		LVB_FILE_ICA_G3_1D :
			ext := 'ICA';
		LVB_FILE_ICA_G3_2D :
			ext := 'ICA';
		LVB_FILE_ICA_G4 :
			ext := 'ICA';
		LVB_FILE_OS2_2 :
			ext := 'BMP';
		LVB_FILE_PNG  :
			ext := 'PNG';
		LVB_FILE_PSD :
			ext := 'PSD';
	end;

	for i := length (DestFile) downto 0 do
	begin
		if DestFile[i] = '.' then
		begin
			DestFile := Copy (DestFile,0,i)+ ext;
			break;
		end;

	end;


end;


end.
