unit Maindlg;
{ Achtung: beim Lschen von Listen durch Clear werden wahrscheinlich die
	Listenelemente nicht freigegeben!}
interface

uses
	SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
	Forms, Dialogs, StdCtrls, Buttons, TabNotBk, VBXCtrl, Lead,Import, Menus,
	ConstDef,INIFiles,LeadHelp,leaddef, ExtCtrls, Searchp,FileCtrl,about;

type
	TRainbowFunc = function: HPalette;

	IntObj = class
		Element : Integer;
	end;

	ColorObj = class
		Color : TColorRef;
		Count : LongInt;
	end;

	FileFormatInfo = record
		Id : Integer;
		Name : string;
		Colors : FarbFormatListe;
	end;

	TMainDialog = class(TForm)
	  TabbedNotebook: TTabbedNotebook;
	  PictureList: TListBox;
	  AddPicture: TBitBtn;
	  DelPicture: TBitBtn;
	  OpenDialog: TOpenDialog;
	  Preview: TLeadView;
	  MainMenu1: TMainMenu;
	  Datei1: TMenuItem;
	  Neu1: TMenuItem;
	  ffnen1: TMenuItem;
	  Speichern1: TMenuItem;
	  N1: TMenuItem;
	  Beenden1: TMenuItem;
	  FileInfoGroup: TGroupBox;
	  InfoPictureFormatCaption: TLabel;
	  InfoPictureFormat: TLabel;
	  InfoHeightCaption: TLabel;
	  InfoHeight: TLabel;
	  InfoWidthCaption: TLabel;
	  InfoWidth: TLabel;
	  InfoBitsPixelCaption: TLabel;
	  InfoBitsPixel: TLabel;
	  Speichernunter1: TMenuItem;
	  SaveDialog: TSaveDialog;
	  GroupBox1: TGroupBox;
	  ViewPreview: TSpeedButton;
	  Label1: TLabel;
	  Label2: TLabel;
	  NewHeight: TEdit;
	  NewWidth: TEdit;
	  PictureFormat: TComboBox;
	  Label3: TLabel;
	  GroupBox2: TGroupBox;
	  Label4: TLabel;
	  Label5: TLabel;
	  EditNormWidth: TEdit;
	  EditNormHeight: TEdit;
    WorkArea: TLeadView;
	  ActivityLog: TMemo;
	  StartWork: TBitBtn;
	  Label6: TLabel;
    GroupBox3: TGroupBox;
    ColorFormat1: TRadioButton;
    ColorFormat4: TRadioButton;
    ColorFormat8: TRadioButton;
    ColorFormat8Gray: TRadioButton;
    ColorFormat16: TRadioButton;
    ColorFormat24: TRadioButton;
    ColorFormat32: TRadioButton;
    DitherGroup: TGroupBox;
    DitherNone: TRadioButton;
    DitherFloydStein: TRadioButton;
	  DitherBurkes: TRadioButton;
	  DitherStucki: TRadioButton;
	  DitherSierra: TRadioButton;
	  DitherStevenson: TRadioButton;
    DitherJarvis: TRadioButton;
	  DitherOrdered: TRadioButton;
    Label7: TLabel;
	  EditOutputPath: TEdit;
	  SpeedButton1: TSpeedButton;
	  PfadSuchen: TSearchPath;
    Label8: TLabel;
    N2: TMenuItem;
    Hilfe1: TMenuItem;
    Shareware1: TMenuItem;
    Bittebeachten1: TMenuItem;
    N3: TMenuItem;
	  ber1: TMenuItem;
	  procedure AddPictureClick(Sender: TObject);
	  procedure DelPictureClick(Sender: TObject);
	  procedure Beenden1Click(Sender: TObject);
	  procedure FormCreate(Sender: TObject);
	  procedure Speichern1Click(Sender: TObject);
	  procedure ffnen1Click(Sender: TObject);
	  procedure PictureListExist(Sender: TObject);
	  procedure PictureListClick(Sender: TObject);
	  procedure SpeichernUnterClick(Sender: TObject);
	  procedure Neu1Click(Sender: TObject);
	  procedure ViewPreviewClick(Sender: TObject);
	  procedure NewHeightExit(Sender: TObject);
	  procedure NewWidthExit(Sender: TObject);
	  procedure FormClose(Sender: TObject; var Action: TCloseAction);
	  procedure PictureFormatChange(Sender: TObject);
	  procedure ColorFormat1Click(Sender: TObject);
	  procedure ColorFormat4Click(Sender: TObject);
	  procedure ColorFormat8Click(Sender: TObject);
	  procedure ColorFormat8GrayClick(Sender: TObject);
	  procedure ColorFormat16Click(Sender: TObject);
	  procedure ColorFormat24Click(Sender: TObject);
	  procedure ColorFormat32Click(Sender: TObject);
	  procedure DitherNoneClick(Sender: TObject);
	  procedure DitherFloydSteinClick(Sender: TObject);
	  procedure DitherBurkesClick(Sender: TObject);
	  procedure DitherStuckiClick(Sender: TObject);
	  procedure DitherSierraClick(Sender: TObject);
	  procedure DitherStevensonClick(Sender: TObject);
	  procedure DitherJarvisClick(Sender: TObject);
	  procedure DitherOrderedClick(Sender: TObject);
	  procedure SpeedButton1Click(Sender: TObject);
	  procedure EditOutputPathChange(Sender: TObject);
	  procedure StartWorkClick(Sender: TObject);
	  procedure EditNormWidthExit(Sender: TObject);
	  procedure EditNormHeightExit(Sender: TObject);
	  procedure ber1Click(Sender: TObject);

	private
	  { Private-Deklarationen }
		{Global Variable :}
		DefaultDir : string;
		ini : TINIFile;

		{ Project-Variable :}
		ProjectFile : string;
		SourceList : TStrings; {List of source-Files}
		SourceWidthList : TList;
		SourceHeightList : TList;
		SaveFormat : Integer;
		Dither : Integer;
		Colors : Integer;
		NormWidth : Integer;
		NormHeight : Integer;
		OutputPath : string;

		{ Others:}
		hRainbowPalette: HPalette;
		hVBX : THandle;
		L_CreateRainbowPalette : TRainbowFunc;
		LastPreviewPicture : string;
		FileFormats : array [0..(LVB_FILE_READONLY-1)] of FileFormatInfo;
		
		procedure UpdateFileList;
		procedure UpdateInfoView;
		procedure LoadProject;
		procedure SaveProject;
		procedure SpeichernUnterDlg;
		procedure ProjectSpeichernDlg;
		procedure AskForSave;
		procedure GetNewWidth;
		procedure GetNewHeight;
		function GetPalette : HPalette;
		procedure InitOutputFormatList;
		procedure FileFormatChange;
		procedure ColorFormatChange;
		procedure SetDithering;
		procedure SetColorFormat;
		procedure ConvertPicture (SourceFile,DestFile : string;Width, Height : Integer);

	public
	  { Public-Deklarationen }

	end;

var
	MainDialog : TMainDialog;

implementation

{$R *.DFM}

procedure TMainDialog.AddPictureClick(Sender: TObject);
var anzahl,pos : integer;
	  Obj : IntObj;
begin
	OpenDialog.Title := 'Bild hinzufgen';
	OpenDialog.InitialDir := DefaultDir;
	OpenDialog.FileName := '';
	OpenDialog.Filter   := FilterExpr1 + FilterExpr2;
	OpenDialog.HelpContext := 0;
	OpenDialog.Options := [ofAllowMultiSelect,ofFileMustExist,ofHideReadOnly];

	if OpenDialog.Execute then
		begin
			GetDir (0,DefaultDir);
			anzahl := OpenDialog.Files.Count;
			pos := 0;
				while pos < anzahl do
					begin
						SourceList.Add (OpenDialog.Files[pos]);
						Obj := IntObj.Create;
						Obj.Element := -1;
						SourceWidthList.Add (Obj);
						Obj := IntObj.Create;
						Obj.Element := -1;
						SourceHeightList.Add (Obj);
						pos := pos +1;
					end;
			UpdateFileList;
		end;
end;


procedure TMainDialog.LoadProject;
var	prj : TINIFile;
		imax,i : Integer;
		buf : string;
		position : byte;
		Obj : IntObj;
begin
	prj := TINIFile.Create (ProjectFile);
	SourceList.Clear;
	SourceWidthList.Clear;
	SourceHeightList.Clear;
	prj.ReadSection(FileChapter,SourceList);

	imax := SourceList.Count-1;
	for i := 0 to imax do
	begin
{  	SourceList[i] := Copy (SourceList[i],0,Pos (SourceList[i],'=')-1);}
		buf := prj.ReadString (FileChapter,SourceList[i],'-1,-1');
		position := Pos (',',buf); { looking for the kommata }
		if position <> 0 then
		begin
			Obj := IntObj.Create;
			try
				Obj.Element := StrToInt (Copy (buf,0,position-1));
			except
				Obj.Element := -1;
			end;
			SourceWidthList.Add (Obj);

			Obj := IntObj.Create;
			try
				Obj.Element := StrToInt (Copy (buf,position+1,Length (buf)-position));
			except
				Obj.Element := -1;
			end;
			SourceHeightList.Add (Obj);
		end
		else
		begin
			Obj := IntObj.Create;
			Obj.Element := -1;
			SourceWidthList.Add (Obj);
			Obj := IntObj.Create;
			Obj.Element := -1;
			SourceHeightList.Add (Obj);
		end
	end;
	SaveFormat := prj.ReadInteger (OutputChapter,OutputFormat,LVB_FILE_BMP);
	Dither := prj.ReadInteger (OutputChapter,OutputDither,LVB_DITHER_BURKES);
	Colors := prj.ReadInteger (OutputChapter,OutputColor,COLOR_8BIT);
	NormWidth := prj.ReadInteger (OutputChapter,OutputNormWidth,-1);
	NormHeight := prj.ReadInteger (OutputChapter,OutputNormHeight,-1);
	OutputPath := prj.ReadString (OutputChapter,OutputPathEntry,DefaultDir);


	prj.Destroy;
	UpdateFileList;
end;

procedure TMainDialog.SaveProject ;
var i,imax : integer;
	  prj : TINIFile;
	  Obj1,Obj2 : IntObj;
begin

{	GetNewWidth;
	GetNewHeight;}
	TabbedNotebook.SetFocus;

	prj := TINIFile.Create (ProjectFile);
	imax := SourceList.Count-1;
	prj.EraseSection (FileChapter);
	for i := 0 to imax do
	begin
		Obj1 := SourceWidthList.Items[i];
		Obj2 := SourceHeightList.Items[i];
		prj.WriteString (FileChapter,SourceList[i],IntToStr (Obj1.Element) + ','+ IntToStr(Obj2.Element));
	end;

	prj.WriteInteger (OutputChapter,OutputFormat,SaveFormat);
	prj.WriteInteger (OutputChapter,OutputDither,Dither);
	prj.WriteInteger (OutputChapter,OutputColor,Colors);
	prj.WriteInteger (OutputChapter,OutputNormWidth,NormWidth);
	prj.WriteInteger (OutputChapter,OutputNormHeight,NormHeight);
	prj.WriteString (OutputChapter,OutputPathEntry,OutputPath);

	prj.Destroy;

end;


procedure TMainDialog.UpdateFileList;
var i,imax,j : integer;
	  s,t : string;
const TextLen = 25;
begin
	PictureList.Items.Clear;
	imax := SourceList.Count-1;
	for i := 0 to imax do
	begin
		t := SourceList.Strings [i];
		j := Length(t);
		if j >TextLen then
			s := Copy (t,0,3) + '...' + Copy (t,j - (TextLen-6),TextLen-5)
		else
			s := SourceList [i];

		PictureList.Items.Add (s);
	end;
	PictureList.ItemIndex := 0;
	UpdateInfoView;
end;

procedure TMainDialog.DelPictureClick(Sender: TObject);
var Index : Integer;
	  List : TStrings;
	  i,imax : Integer;
begin
		Index := PictureList.ItemIndex;
		if Index <> -1 then
		begin
			SourceList.Delete (Index);
			SourceWidthList.Delete (Index);
			SourceHeightList.Delete (Index);

			UpdateFileList;
		end;
		index := index -1;
		if index > -1 then
			PictureList.ItemIndex := index
		else if PictureList.Items.Count > -1 then
			PictureList.ItemIndex := 0;


end;

procedure TMainDialog.UpdateInfoView;
var FileName : string;
	  Index : Integer;
	  DoClearInfo : BOOL;
	  Obj : IntObj;
begin
	{ sollen Infos oder Preview gezeigt werden, und ist ein Element in der Liste selektier? }
	DoClearInfo := FALSE;
	Index := PictureList.ItemIndex;
	if Index <> -1 then
	begin
		FileName := SourceList.Strings[Index];
		{ Setzen der Neuen Dimensionen }
		Obj := SourceHeightList.Items [Index];
		if Obj.Element = -1 then
			NewHeight.Text := OriginalDimension
		else
			NewHeight.Text := IntToStr (Obj.Element);

		Obj := SourceWidthList.Items [Index];
		if Obj.Element = -1 then
			NewWidth.Text := OriginalDimension
		else
			NewWidth.Text := IntToStr (Obj.Element);

		Preview.InfoPage  := 0;
		if FileExists (FileName) = TRUE then
		begin
			try
				Preview.InfoFile := FileName;
				InfoPictureFormat.Caption := GetFormatText (Preview.InfoFormat);
				InfoHeight.Caption := IntToStr( Preview.InfoHeight);
				InfoWidth.Caption := IntToStr( Preview.InfoWidth);
				InfoBitsPixel.Caption := IntToStr( Preview.InfoBits);
			except
				on EVBXError do begin
					InfoPictureFormat.Caption := NotSupported;
					DoClearInfo := TRUE;
				end;

			end;
		end
		else
		begin
			InfoPictureFormat.Caption := FileNotFound;
			DoClearInfo := TRUE;
		end;

		if DoClearInfo = TRUE then
		begin
			InfoHeight.Caption := '';
			InfoWidth.Caption := '';
			InfoBitsPixel.Caption := '';
		end;

	end;
end;

procedure TMainDialog.Beenden1Click(Sender: TObject);
begin
	PostQuitMessage (0);
end;

procedure TMainDialog.FormCreate(Sender: TObject);
var buffer : array [0..255] of char;
	  buffer1 : array [0..255] of char;
	  i : Cardinal;
	  ModulDir : string;
begin

	{ Goldener Schnitt:}
	Preview.Width := (Preview.Height div 3) * 5;

	LastPreviewPicture := '';

	{ initiate the VBX-Palette }
	hVBX := LoadLibrary ('LEAD.VBX');
	@L_CreateRainbowPalette := GetProcAddress (hVBX,'L_CREATERAINBOWPALETTE');
	hRainbowPalette := L_CreateRainbowPalette;

	SourceList := TStringList.Create;
	SourceWidthList := TList.Create;
	SourceHeightList := TList.Create;

	{ Defaults}
	SaveFormat := LVB_FILE_BMP;
	Dither := LVB_DITHER_STUCKI;
	Colors := COLOR_8BIT;
	NormWidth := -1;
	NormHeight := -1;
	OutputPath := DefaultDir;

	{Load the ini-Datas}
	GetModuleFileName (hInstance,buffer,255);
	for i := strLen (buffer) downto 0 do
	begin
		if buffer[i] = '\' then
		begin
			strlcopy (buffer1,buffer,i);
			ModulDir   := strpas (buffer1);
			Break;
		end;

	end;

	ini := TINIFile.Create (ModulDir + '\PictConv.INI');

	{ Read the last Searching-Dir }
	DefaultDir := ini.ReadString (PictConv,PathEntry,ModulDir);
	ProjectFile := ini.ReadString (PictConv,PrjEntry,ModulDir + '\default.pcj');
	{ check, if ProjectFile is valid }
	if FileExists (ProjectFile) = TRUE then
		LoadProject
	else
		begin
			ProjectFile := '';
			UpdateFileList;
		end;

	{ Init Application}

	InitOutputFormatList;

end;

procedure TMainDialog.ProjectSpeichernDlg;
begin
	if FileExists (ProjectFile) = FALSE then
		SpeichernUnterDlg
	else
		SaveProject ;
end;


procedure TMainDialog.Speichern1Click(Sender: TObject);
begin
	ProjectSpeichernDlg;
end;

procedure TMainDialog.ffnen1Click(Sender: TObject);
begin
	AskForSave;

	OpenDialog.Title := 'Projekt ffnen';
	OpenDialog.InitialDir := DefaultDir;
	OpenDialog.FileName := '';
	OpenDialog.Filter   := ProjectFilter;
	OpenDialog.HelpContext := 0;
	OpenDialog.Options := [ofFileMustExist,ofHideReadOnly];

	if OpenDialog.Execute then
	begin
		GetDir (0,DefaultDir);
		ProjectFile := OpenDialog.FileName;

		LoadProject;
		UpdateFileList;

	end;

end;

procedure TMainDialog.PictureListExist(Sender: TObject);
begin
	UpdateInfoView;
end;

procedure TMainDialog.PictureListClick(Sender: TObject);
begin
	UpdateInfoView;
end;

procedure TMainDialog.SpeichernUnterDlg;
begin

	SaveDialog.Title := 'Projekt speichern';
	SaveDialog.InitialDir := DefaultDir;
	SaveDialog.FileName := ProjectFile;
	SaveDialog.Filter   := ProjectFilter;
	SaveDialog.HelpContext := 0;

	if SaveDialog.Execute then
	begin
		GetDir (0,DefaultDir);
		ProjectFile := SaveDialog.FileName;
		SaveProject;
	end;

end;



procedure TMainDialog.SpeichernUnterClick(Sender: TObject);
begin
	SpeichernUnterDlg;
end;

procedure TMainDialog.AskForSave;
begin
	if Application.MessageBox ('Soll das aktuelle Projekt gespeichert werden?','Projekt laden',MB_YESNO) = IDYES then
		ProjectSpeichernDlg;
end;

procedure TMainDialog.Neu1Click(Sender: TObject);
begin
	AskForSave;
	ProjectFile := '';
	SourceList.Clear;
	SourceWidthList.Clear;
	SourceHeightList.Clear;

	UpdateFileList;

end;

function TMainDialog.GetPalette : HPalette;
begin
	GetPalette := hRainbowPalette;
end;

procedure TMainDialog.ViewPreviewClick(Sender: TObject);
var FileName : string;
	  Index : Integer;
	  Cursur : HCursor;
begin
	Index := PictureList.ItemIndex;


	if Index <> -1 then
	begin
	  FileName := SourceList.Strings[Index];
	  if (FileName <> LastPreviewPicture) and (FileExists (FileName) = TRUE) then
	  begin
		  Cursor := SetCursor (LoadCursor (0,IDC_WAIT));
		  LastPreviewPicture := FileName;
		  { Load the Preview-Bitmap }
		  Preview.PaintWhileLoad := FALSE;
		  Preview.BackPalette := TRUE;
		  Preview.pFile := FileName;
		  Preview.ImageWidth := 15 * Preview.Width;
		  Preview.ImageHeight := 15 *Preview.Height;
		  Preview.Repaint := TRUE;
		  SetCursor (Cursor);
	  end;

	end;

end;

procedure TMainDialog.NewHeightExit(Sender: TObject);
begin
	GetNewHeight;
  UpdateInfoView;
end;

procedure TMainDialog.GetNewHeight;
var Value : Integer;
	  Obj : IntObj;
begin
	try
		Value := StrToInt (NewHeight.Text);
	except
		on EConvertError do
			Value := -1;
	end;

	if Value <= 0 then
		Value := -1;
	Obj := SourceHeightList.Items [PictureList.ItemIndex];
	Obj.Element := Value;
{	SourceHeightList.Strings[PictureList.ItemIndex] := IntToStr (Value);}


end;

procedure TMainDialog.NewWidthExit(Sender: TObject);
begin
	GetNewWidth;
	UpdateInfoView;
end;

procedure TMainDialog.GetNewWidth;
var Value : Integer;
	  Obj : IntObj;
begin
try
		Value := StrToInt (NewWidth.Text);
	except
		on EConvertError do
			Value := -1;
	end;

	if Value <= 0 then
		Value := -1;

	Obj := SourceWidthList.Items [PictureList.ItemIndex];
	Obj.Element := Value;
{	SourceWidthList.Strings[PictureList.ItemIndex] := IntToStr (Value);}


end;

procedure TMainDialog.FormClose(Sender: TObject; var Action: TCloseAction);
begin

	ProjectSpeichernDlg;
	{ Save Program-Parameter }
	ini.WriteString (PictConv,PathEntry,DefaultDir);
	ini.WriteString (PictConv,PrjEntry,ProjectFile);

	SourceList.Destroy;
	SourceWidthList.Destroy;
	SourceHeightList.Destroy;
	ini.Destroy;

end;

procedure TMainDialog.InitOutputFormatList;
var i : integer;
begin
	PictureFormat.Items.Clear;

	for i := 0 to LVB_FILE_READONLY-1 do
	begin
		FileFormats[i].Id := i;
		FileFormats[i].Name := GetFormatText (i);
		PictureFormat.Items.Add (FileFormats[i].Name);
		FileFormats[i].Colors := GetFormatColors (i);
	end;

	if (SaveFormat < 0) or (SaveFormat >= LVB_FILE_READONLY) then
		SaveFormat := LVB_FILE_BMP;

	PictureFormat.ItemIndex := SaveFormat;

	FileFormatChange;

	if NormWidth <= 0 then
		EditNormWidth.Text := ''
	else
		EditNormWidth.Text := IntToStr (NormWidth);

	if NormHeight <= 0 then
		EditNormHeight.Text := ''
	else
		EditNormHeight.Text := IntToStr (NormHeight);

	EditOutputPath.Text := OutputPath;
	SetColorFormat;

end;

procedure TMainDialog.FileFormatChange;
var i : FarbFormatListe;
	  ShowDither : BOOL;
begin

	i := FileFormats [SaveFormat].Colors;

	if COLOR_1BIT in i then
		ColorFormat1.Enabled := TRUE
	else
		ColorFormat1.Enabled := FALSE;
	if COLOR_4BIT in i then
		ColorFormat4.Enabled := TRUE
	else
		ColorFormat4.Enabled := FALSE;
	if COLOR_8BIT in i then
		ColorFormat8.Enabled := TRUE
	else
		ColorFormat8.Enabled := FALSE;
	if COLOR_8BITGRAY in i then
		ColorFormat8Gray.Enabled := TRUE
	else
		ColorFormat8Gray.Enabled := FALSE;
	if COLOR_16BIT in i then
		ColorFormat16.Enabled := TRUE
	else
		ColorFormat16.Enabled := FALSE;
	if COLOR_24BIT in i then
		ColorFormat24.Enabled := TRUE
	else
		ColorFormat24.Enabled := FALSE;
	if COLOR_32BIT in i then
		ColorFormat32.Enabled := TRUE
	else
		ColorFormat32.Enabled := FALSE;

	ColorFormatChange;

end;

procedure TMainDialog.ColorFormatChange;
var ShowDither : BOOL;
	  i : Integer;
begin

	{ check, if selected Color-Format is valid for the File-Format}
	if not (Colors  in FileFormats [SaveFormat].Colors) then
	begin
		for i := COLOR_1BIT to COLOR_32BIT do
		begin
			if i in FileFormats [SaveFormat].Colors then
			begin
				Colors := i;
				SetColorFormat;
				break;
			end;
		end;
		{ look for a valid color }
	end;


	if (Colors = COLOR_1BIT ) or (Colors = COLOR_4BIT ) or (Colors =  COLOR_8BIT ) or (Colors =  COLOR_8BITGRAY ) then
		ShowDither := TRUE
	else
		ShowDither := FALSE;

	DitherGroup.Enabled := ShowDither;
	DitherNone.Enabled := ShowDither;
	DitherFloydStein.Enabled := ShowDither;
	DitherBurkes.Enabled := ShowDither;
	DitherStucki.Enabled := ShowDither;
	DitherSierra.Enabled := ShowDither;
	DitherStevenson.Enabled := ShowDither;
	DitherJarvis.Enabled := ShowDither;
	DitherOrdered.Enabled := ShowDither;
	if ShowDither = TRUE then
		SetDithering;
end;

procedure TMainDialog.SetColorFormat;
begin

	case Colors of
		COLOR_1BIT :
			ColorFormat1.Checked := TRUE;
		COLOR_4BIT :
			ColorFormat4.Checked := TRUE;
		COLOR_8BIT :
			ColorFormat8.Checked := TRUE;
		COLOR_8BITGRAY :
			ColorFormat8Gray.Checked := TRUE;
		COLOR_16BIT :
			ColorFormat16.Checked := TRUE;
		COLOR_24BIT :
			ColorFormat24.Checked := TRUE;
		COLOR_32BIT :
			ColorFormat32.Checked := TRUE;
	end;
end;


procedure TMainDialog.SetDithering;
begin

	case Dither of
		LVB_DITHER_NONE :
			DitherNone.Checked := TRUE;
		LVB_DITHER_FLOYD :
			DitherFloydStein.Checked := TRUE;
		LVB_DITHER_STUCKI :
			DitherStucki.Checked := TRUE;
		LVB_DITHER_BURKES :
			DitherBurkes.Checked := TRUE;
		LVB_DITHER_SIERRA :
			DitherSierra.Checked := TRUE;
		LVB_DITHER_STEVENSON :
			DitherStevenson.Checked := TRUE;
		LVB_DITHER_JARVIS :
			DitherJarvis.Checked := TRUE;
		LVB_DITHER_ORDERED :
			DitherOrdered.Checked := TRUE;
		else
		begin
			DitherNone.Checked := TRUE;
			Dither := LVB_DITHER_NONE;
		end
	end;
end;


procedure TMainDialog.PictureFormatChange(Sender: TObject);
begin
	SaveFormat :=  PictureFormat.ItemIndex;
	FileFormatChange;
end;

procedure TMainDialog.ColorFormat1Click(Sender: TObject);
begin
	Colors := COLOR_1BIT;
	ColorFormatChange;
end;

procedure TMainDialog.ColorFormat4Click(Sender: TObject);
begin
	Colors := COLOR_4BIT;
	ColorFormatChange;

end;

procedure TMainDialog.ColorFormat8Click(Sender: TObject);
begin
	Colors := COLOR_8BIT;
	ColorFormatChange;

end;

procedure TMainDialog.ColorFormat8GrayClick(Sender: TObject);
begin
	Colors := COLOR_8BITGRAY;
	ColorFormatChange;

end;

procedure TMainDialog.ColorFormat16Click(Sender: TObject);
begin
	Colors := COLOR_16BIT;
	ColorFormatChange;

end;

procedure TMainDialog.ColorFormat24Click(Sender: TObject);
begin
	Colors := COLOR_24BIT;
	ColorFormatChange;

end;

procedure TMainDialog.ColorFormat32Click(Sender: TObject);
begin
	Colors := COLOR_32BIT;
	ColorFormatChange;

end;

procedure TMainDialog.DitherNoneClick(Sender: TObject);
begin
	Dither := LVB_DITHER_NONE;
end;

procedure TMainDialog.DitherFloydSteinClick(Sender: TObject);
begin
	Dither := LVB_DITHER_FLOYD;
end;

procedure TMainDialog.DitherBurkesClick(Sender: TObject);
begin
	Dither := LVB_DITHER_BURKES;
end;

procedure TMainDialog.DitherStuckiClick(Sender: TObject);
begin
	Dither := LVB_DITHER_STUCKI;
end;

procedure TMainDialog.DitherSierraClick(Sender: TObject);
begin
	Dither := LVB_DITHER_SIERRA;
end;

procedure TMainDialog.DitherStevensonClick(Sender: TObject);
begin
	Dither := LVB_DITHER_STEVENSON;
end;

procedure TMainDialog.DitherJarvisClick(Sender: TObject);
begin
	Dither := LVB_DITHER_JARVIS;
end;

procedure TMainDialog.DitherOrderedClick(Sender: TObject);
begin
	Dither := LVB_DITHER_ORDERED;
end;

procedure TMainDialog.SpeedButton1Click(Sender: TObject);
begin
	PfadSuchen.Path := EditOutputPath.Text;
	if PfadSuchen.Execute = TRUE then
	begin
		EditOutputPath.Text := PfadSuchen.Path;
		OutputPath := PfadSuchen.Path;
	end

end;

procedure TMainDialog.EditOutputPathChange(Sender: TObject);
begin
	if  DirectoryExists (EditOutputPath.Text) then
		OutputPath := EditOutputPath.Text
	else
		EditOutputPath.Text := OutputPath;

end;

procedure TMainDialog.StartWorkClick(Sender: TObject);
var 	i,j,imax : Integer;
		buffer,dest : string;
		w,h : integer;
		Obj : IntObj;
		Cursor : TCursor;
begin
	StartWork.Enabled := FALSE;
	{ Convert all picture in the specified format:}
	Cursor := SetCursor (LoadCursor (0,IDC_WAIT));
	imax := SourceList.Count-1;

	ActivityLog.Clear;
	ActivityLog.Repaint;

	for i := 0 to imax do
	begin
		buffer := SourceList [i];
		dest := OutputPath;

		{ Create Destination Filename }
		for j := Length (buffer) downto 0 do
		begin
			if buffer[j] = '\' then
			begin
				dest := dest + '\' + Copy (buffer,j+1,Length (buffer)-j);
				Break;
			end;
		end;

		SetPictureExtension (dest,SaveFormat);

		{ Breite ermitteln}
		obj := SourceWidthList.Items[i];
		if NormWidth <> -1 then
			w := NormWidth
		else if obj.Element <> -1 then
			w := obj.Element
		else
			w := -1;
		{ Hhe ermitteln }
		obj := SourceHeightList.Items[i];
		if NormHeight <> -1 then
			h := NormHeight
		else if obj.Element <> -1 then
			h := obj.Element
		else
			h := -1;
		{ Konvertierung aufrufen }
		ConvertPicture (SourceList [i],dest,w,h);

	end;

	ActivityLog.Lines.Add ('...Bearbeitung beendet.');
	SetCursor (Cursor);
 	StartWork.Enabled := TRUE;

end;

procedure TMainDialog.ConvertPicture (SourceFile,DestFile : string;Width, Height : Integer);
var i : integer;
	  ColorNumber : Integer;
	  ColorEntry : ColorObj;
	  ColorList : TList;
begin
	try
		ActivityLog.Lines.Add ('Bearbeite: ' + SourceFile);
		ColorList := TList.Create;

		WorkArea.InfoPage  := 0;
		if FileExists (SourceFile) = TRUE then
		begin
			try
				WorkArea.InfoFile := SourceFile;
				WorkArea.InfoPage := 0;
				i := WorkArea.InfoFormat; { Fileformat auf Gltigkeit prfen }
			except
				on EVBXError do
				begin
					ActivityLog.Lines.Add (' ->Dateiformat wird nicht untersttzt.');
					raise;
				end;
			end;
			{ Datei laden}
			WorkArea.PaintWhileLoad := TRUE;
			WorkArea.BackPalette := TRUE;
			WorkArea.pFile := SourceFile;
			case Colors of
				COLOR_1BIT :
					ColorNumber := 1;
				COLOR_4BIT :
					ColorNumber := 4;
				COLOR_8BIT ,COLOR_8BITGRAY :
					ColorNumber := 8;
				COLOR_16BIT :
					ColorNumber := 16;
				COLOR_24BIT :
					ColorNumber := 24;
				COLOR_32BIT :
					ColorNumber := 32;
			end;

			{ Farbformat anpassen}
			WorkArea.BitChgDither := Dither;
			WorkArea.BitChgPalette := LVB_PALETTE_IDENTITY;
			if Colors = COLOR_8BITGRAY then
				WorkArea.GrayScale := TRUE
			else
			begin
				WorkArea.BitmapBits := ColorNumber;
			end;
			{ Repaint the new Color}
			WorkArea.Repaint := TRUE;

			{ Gre anpassen }
			if (Width <> -1) or (Height <> -1) then
			begin
				WorkArea.ResizeType := LVB_RESIZE_INTERPOLATE;
				if Width <> -1 then
					WorkArea.ResizeWidth := Width;
				if Height <> -1 then
					WorkArea.ResizeHeight := Height;

				WorkArea.Resize := TRUE;
				WorkArea.Repaint := TRUE;
			end;

			{ Save Picture }
			WorkArea.SaveBits := ColorNumber;
			WorkArea.SaveFormat := SaveFormat;
			if SaveFormat = LVB_FILE_LEAD then
				WorkArea.SaveQFactor := LVB_QFACTOR_PQ1
			else
				WorkArea.SaveQFactor := 2;
			WorkArea.SaveFile := DestFile;


		end
		else
			ActivityLog.Lines.Add ('Die Datei ist nicht vorhanden!');
	except
		on vbx : EVBXError do
		begin
			ActivityLog.Lines.Add ('Die Datei konnte nicht konvertiert werden!' +
				IntToStr (vbx.HelpContext) + vbx.Message);

		end;
	end;

	{ Optimiere die Palette}
{	ActivityLog.Lines.Add ('Anzahl Farben: ' +
			IntToStr (ColorList.Count) +
        ' unterschiedliche Farben.');}


	{ Clear the Histogram}
	for i := ColorList.Count -1 downto 0 do
	begin
		ColorEntry := ColorList.Items[i];
		ColorEntry.Destroy;
	end;

	ColorList.Destroy;
end;


procedure TMainDialog.EditNormWidthExit(Sender: TObject);
begin
	try
		NormWidth := StrToInt (EditNormWidth.Text);
	except
		NormWidth := -1;
		EditNormWidth.Text := '';
	end;

end;

procedure TMainDialog.EditNormHeightExit(Sender: TObject);
begin
	try
		NormHeight := StrToInt (EditNormHeight.Text);
	except
		NormHeight := -1;
		EditNormHeight.Text := '';
	end;

end;


procedure TMainDialog.ber1Click(Sender: TObject);
begin
	AboutBox.ShowModal;
end;

end.

