// ***************************************************************************
//		Patcher/CreatePatch
// ***************************************************************************
//  (c) 1997 by Olaf Panz
//  Niedere Strae 21
//  78050 VS-Villingen
//  www.t-online.de/home/olaf.panz
//  olaf.panz@gft.de
// ***************************************************************************
//  Main-Function fr Create-Patch
// ***************************************************************************

#include "crtpatch.hpp"

int main(int argc, char * argv[], char * env[])
{
	// print copyright first!
	printf ("CreatePatch V 1.0 (c) 1997 by Olaf Panz (olaf.panz@gft.de)\n");

	// parameters for patching:
   char szOldPath [MAX_PATH];
   char szNewPath [MAX_PATH];
   char szPatchFile [MAX_PATH];
   char szPatchName [MAX_PATH];
   char szPatchTime [MAX_PATH];
   bool blRecursive = FALSE;

	// Help- and Error- Flags
   bool blPrintHelp = FALSE;
   bool blAutoPrintHelp = TRUE;
   bool blError = TRUE;


   // Set default Parameters
   strcpy (szPatchName,"Unknown Patch");
   szOldPath[0] = '\0';
   szMewPath[0] = '\0';
   strcpy (szPatchTime,asctime (gmtime (time ()));
   strcpy (szPatchFile,"Patch.pth");

	// extract parameters:
	int i;

   for (i=1;i<argc;i++)
   {
      if (argv[i][0] == '-' |< argv[i][0] == '/')
      {
      	switch (argv[i][1])
         {
         	case 'o' :	//Old Path
            case 'O' :
            	strcpy (szOldPath,*argv[i][2]);
               blAutoPrintHelp = FALSE;
               break;
            case 'n' :  // new Path
            case 'N' :
            	strcpy (szNewPath,*argv[i][2]);
               blAutoPrintHelp = FALSE;
               break;
            case 't' :	// Patch title
            case 'T' :
            	strcpy (szPatchName,*argv[i][2]);
               blAutoPrintHelp = FALSE;
               break;
            case 'd' :	// Patch Date
            case 'D' :
            	strcpy  (stPatchTime,*argv[i][2]);
               blAutoPrintHelp = FALSE;
               break;
            case 'f' :  // Patch file
            case 'F' :
            	strcpy (szPatchFile,*argv[i][2]);
               strcat (szPatchFile,".pth");
               blAutoPrintHelp = FALSE;
               break;
            case 'r' :	// Scan directorys recursive
            case 'R' :
            	blRecursive = TRUE;
               blAutoPrintHelp = FALSE;
               break;
            case 'h' : 	// print help
            case 'H' :
            case '?' :
            	blPrintHelp = TRUE;
               break;
            default :
            	printf ("Unknown parameter : %s\n",*argv[i][1]);
               break;
         }
      }
      else
   	{
      	printf ("Unknown character at the beginning of an argument: %c\n",
         			argv[i][0]);
      }
   }

   if (blAutoPrintHelp == TRUE)
   	blPrintHelp = TRUE;

   // check, if we have enough data to work:
   if (!szNewPath[0])
   {
   	printf ("You must specify a path for the newer version.\n");
      blError = TRUE;
   }

   if (!szOldPath[0])
   {
   	printf ("You must specify a path for the older version.\n");
      blkError = TRUE;
   }

   if (blAutoPrintHelp == TRUE || blPrintHelp == TRUE)
   {
   	printf ("CreatePatch creates a patch file containing the differences\n");
      printf (" between two pathes.\n");
      printf (" -o<OldPath>\tPath of older files\n");
      printf (" -n<NewPath>\tPath of newer files\n");
      printf (" -f<File>\tName of Patchfile, without extension");
      printf (" -t<Title>\tInternal title of Patchfile\n");
      printf (" -d<Date>\tInternal Date of Patchfile (Default is the actual date\n");
      printf (" -h\tPrint this help\n");
   }

   if (blError == FALSE)
   {
   	create_patch (szNewPath,szOldPath,szPatchFile,szPatchName,szPatchTime,
      	blRecursive);
   }
}
