// ***************************************************************************
//		Patcher/CreatePatch
// ***************************************************************************
//  (c) 1997 by Olaf Panz
//  Niedere Strae 21
//  78050 VS-Villingen
//  www.t-online.de/home/olaf.panz
//  olaf.panz@gft.de
// ***************************************************************************
//	  Patch-Block- Handling
// ***************************************************************************
#include "block.hpp"

#include <mem.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <dir.h>
#include <sys\stat.h>
#include <io.h>
#include <dos.h>
#include <conio.h>
#include "crtpatch.hpp"
#include "fbuffer.hpp"

#define PATCH_BLOCK_SIZE 1024


// ***************************************************************************
//  Class : PatchBlock
// ***************************************************************************
PatchBlock::PatchBlock (void)
{
   m_uiLen = 0;		// BlockLen
   m_szBuffer = (char*) malloc (PATCH_BLOCK_SIZE);
	assert (m_szBuffer);
   m_uiBufferLen = PATCH_BLOCK_SIZE;
}

PatchBlock::PatchBlock (char *cszBuffer,
	unsigned int iBufferSize)
{
   m_szBuffer = cszBuffer;
   m_uiBufferLen = m_uiLen = iBufferSize;
}

PatchBlock::~PatchBlock (void)
{
	if (m_szBuffer)
   {
   	free (m_szBuffer);
      m_szBuffer = 0;
   }
}

bool PatchBlock::add_buffer (const char *m_cBuffer,unsigned int iBufferSize)
{
	if ((m_uiLen+iBufferSize) >= m_uiBufferLen)
   {
      // buffer is to small, realloc it:
      m_uiBufferLen += iBufferSize + PATCH_BLOCK_SIZE;
      m_szBuffer = (char*)realloc (m_szBuffer,m_uiBufferLen);
      assert (m_szBuffer);
   }

   // add to buffer:
   memcpy (m_szBuffer+ m_uiLen,m_cBuffer,iBufferSize);
   m_uiLen += iBufferSize;

   return true;
}

// ***************************************************************************
//  Class : CopyrightPatchBlock
// ***************************************************************************
CopyrightPatchBlock::CopyrightPatchBlock (void)
	: PatchBlock ()
{
	add_buffer (COPYRIGHT,strlen (COPYRIGHT)+1);
}

CopyrightPatchBlock::CopyrightPatchBlock (char *cszBuffer,
      			unsigned int uiBufferSize)
	: PatchBlock (cszBuffer,uiBufferSize)
{
}

// write back functionality
bool CopyrightPatchBlock::proceed (char */*szPath*/)
{
//	printf ("%s\n",copyright());

   return true;
}

// ***************************************************************************
//  Class : InfoPatchBlock
// ***************************************************************************
InfoPatchBlock::InfoPatchBlock (const char* cszName,const char *cszDate)
	: PatchBlock ()
{
	// get date index
   m_uiDateIndex = 5 + strlen (cszName);
   add_buffer ((const char*)&m_uiDateIndex,sizeof (m_uiDateIndex));
   add_buffer (cszName,strlen (cszName)+1);
   add_buffer (cszDate,strlen (cszDate)+1);
}


InfoPatchBlock::InfoPatchBlock (char *cszBuffer,
   unsigned int uiBufferSize)
	: PatchBlock (cszBuffer,uiBufferSize)
{
	// get date index
   m_uiDateIndex = (unsigned int) *m_szBuffer;
}

// write back functionality
bool InfoPatchBlock::proceed (char */*szPath*/)
{
   printf ("%s\nPatch date: %s\n",name (),date());

	return true;
}


// ***************************************************************************
//  Class : PathPatchBlock
// ***************************************************************************
PathPatchBlock::PathPatchBlock (const char *path)
	: PatchBlock ()
{
	add_buffer (path,strlen (path)+1);
}

PathPatchBlock::PathPatchBlock (char *cszBuffer,unsigned int uiBufferSize)
	: PatchBlock (cszBuffer,uiBufferSize)
{
}

// write back functionality
bool PathPatchBlock::proceed (char *szPath)
{
	const char *pPath = path ();
	if (pPath [0] == '\0')
   {	// one step back:
   	int i;

      for (i=strlen (szPath)-2;i>0;i--)
      {
      	if (szPath[i] == PATH_SEPARATOR)
         {
            szPath[i+1] = '\0';
            break;
         }
      }
   }
   else
   {
   	// go one step forward
   	strcat (szPath,pPath);
		int i = strlen (szPath);
      szPath[i] = PATH_SEPARATOR;
      szPath[i+1] = '\0';
   }
   return true;
}

// ***************************************************************************
//  Class : AddPathPatchBlock
// ***************************************************************************
// write back functionality
bool AddPathPatchBlock::proceed (char *szPath)
{
	bool blErg = true;
   char szBuffer [MAXPATH];
   strcpy (szBuffer,szPath);
	strcat (szBuffer,path());

   ffblk ff;

   if (findfirst (szBuffer,&ff,FA_DIREC) == 0)
   	return true; // allready exists

   // create it
   if (mkdir (szBuffer) != 0)
   	blErg = false;

   printf ("Add new path %s\n",szBuffer);

   // add ending slash
/*   int i = strlen (szPath);
   szPath[i] = PATH_SEPARATOR;
   szPath[i+1] = '\0';*/

   return blErg;
}

// ***************************************************************************
//  Abstract Class : FilePatchBlock
// ***************************************************************************
FilePatchBlock::FilePatchBlock (const char *pName)
	: PatchBlock ()
{
   // write filesize
   struct stat st;		// get filesize
   stat (pName,&st);

   // add content size to buffer:
   add_buffer ((const char*)&st.st_size,sizeof (st.st_size));

   // write file data
   FILE *pFile = fopen (pName,"rb");

   struct ftime t;
   // get file time
   getftime (fileno (pFile),&t);

   fclose (pFile);

   //  write filetime;
   add_buffer ((const char*)&t,sizeof (struct ftime));

	// extract filename from name
   char szBuffer [MAXPATH];
   int i;
   for (i = strlen (pName);i > 0 && pName[i] != PATH_SEPARATOR;i--)
		;
	if (pName [i] == PATH_SEPARATOR)
   	i++;
   strcpy (szBuffer,pName+i);

	// write filename
	add_buffer (szBuffer,strlen (szBuffer)+1);
}

FilePatchBlock::FilePatchBlock (char *szBuffer, unsigned int uiBufferSize)
	: PatchBlock (szBuffer,uiBufferSize)
{
}

const char *FilePatchBlock::filename (void) const
{
	return (const char*) (m_szBuffer +sizeof (unsigned int)
   	+ sizeof (struct ftime));
}

struct ftime* FilePatchBlock::file_time (void) const
{
	return (struct ftime*)(m_szBuffer + sizeof (unsigned int));
}

// user data of derived classes:
const char *FilePatchBlock::user_data (unsigned int &uiSize) const
{
	unsigned int uiOffset = sizeof (unsigned int) +
   	sizeof (struct ftime);

	unsigned int uiBufSize = size ();

   // run to end of filename
   while (m_szBuffer[uiOffset] && uiOffset < uiBufSize)
   	uiOffset++;

   uiOffset++;

   uiSize = uiBufSize - uiOffset;

   return m_szBuffer + uiOffset;
}


unsigned int FilePatchBlock::file_size (void) const
{
	return ((unsigned int*)m_szBuffer)[0];
}

// ***************************************************************************
//  Class : AddPatchBlock
// ***************************************************************************
AddFilePatchBlock::AddFilePatchBlock (const char *pName)	 // to add a path/file
	: FilePatchBlock (pName)
{

	TFileBuffer oFile(pName);

/*   FILE *pFile = fopen (pName,"rb");

   if (!pFile)
   {
   	printf ("Cant open %s for reading\n",pName);
      return;
   }

   unsigned int uiSize = file_size ();

   char *pBuffer = (char*) malloc (uiSize+1);
   assert (pBuffer);
   if (fread (pBuffer,1,uiSize,pFile) != uiSize)
   {
   	printf ("Cant read from %s\n",pName);
      free (pBuffer);
      fclose (pFile);
      return;
   }

   // close file:
   fclose (pFile);*/

   // add content to buffer
//   add_buffer (pBuffer,uiSize);
	if (oFile.valid () == false)
   {
   	printf ("Cant read %s.\n",pName);
   }
   else
   {
	   add_buffer (oFile.buffer(),oFile.size());
   }
//   free (pBuffer);
}

AddFilePatchBlock::AddFilePatchBlock (char *cszBuffer,unsigned int uiBufferSize)
	: FilePatchBlock (cszBuffer,uiBufferSize)
{
}

// write back functionality
bool AddFilePatchBlock::proceed (char *szPath)
{
	bool blErg = true;

   char szBuffer [MAXPATH];

	// create complete filename
   strcpy (szBuffer,szPath);
   strcat (szBuffer,filename());

   // check, if file allready exists

   ffblk ff;
   if (findfirst (szBuffer,&ff,0) != 0)
	{ // create file, if file does not exists
      // open file for writing:
      TFileBuffer oFile;

      unsigned int uiSize;
      const char *pBuffer = user_data (uiSize);

      if (oFile.save (szBuffer,file_time(),pBuffer,uiSize) == false)
		{
      	printf ("Cant write to %s\n",szBuffer);
      }
      else
      {
         printf ("Add file %s\n",szBuffer);
      }
/*      FILE *pFile = fopen (szBuffer,"wb");

      if (!pFile)
      {
      	printf ("Cant open for writing %s\n",szBuffer);
         return false;
      }

      unsigned int uiSize;
      const char *pBuffer = user_data (uiSize);

      if (fwrite (pBuffer,1,uiSize,pFile) != uiSize)
      {
      	printf ("Cant write to %s\n",szBuffer);
         blErg = false;
      }
*/
      // set original filetime
//      setftime (fileno (pFile),file_time ());

//      fclose (pFile);

	}

   return blErg;
}

// ***************************************************************************
//  Class : ChangePatchBlock
// ***************************************************************************
ChangePatchBlock::ChangePatchBlock (	const char *pName,
					                        const char *pOldBuffer,
               					         unsigned int uiOldBufferSize,
				                           const char *pNewBuffer,
            					            unsigned int uiNewBufferSize)
	: FilePatchBlock (pName)

{
	// calc and write check sum for old file
	unsigned int iCheck = calc_check_sum (pOldBuffer,uiOldBufferSize);
	add_buffer ((const char*)&iCheck,sizeof (iCheck));

	// calc and write check sum for updated file
   iCheck = calc_check_sum (pNewBuffer,uiNewBufferSize);
	add_buffer ((const char*)&iCheck,sizeof (iCheck));
}

ChangePatchBlock::ChangePatchBlock (char *szBuffer,unsigned int uiBufferSize)
	: FilePatchBlock (szBuffer,uiBufferSize)
{
}

unsigned int ChangePatchBlock::calc_check_sum (const char *pBuffer,
		unsigned int uiSize) const
{
	unsigned int ui,check=0;

   for (ui=0;ui < uiSize;ui++)
      check += (pBuffer[ui]+1)*(ui+1);

   return check;
}

unsigned int ChangePatchBlock::old_check_sum (void) const
{
	unsigned int uiSize;

	unsigned int* puiErg = ((unsigned int*)FilePatchBlock::user_data(uiSize));

   if (uiSize >= 4)
   	return puiErg[0];

   return NULL;
}

unsigned int ChangePatchBlock::new_check_sum (void) const
{
	unsigned int uiSize;

	unsigned int* puiErg = ((unsigned int*)FilePatchBlock::user_data(uiSize));

   if (uiSize >= 8)
   	return puiErg[1];

   return NULL;
}

// user data of derived classes:
const char *ChangePatchBlock::user_data (unsigned int &uiSize) const
{
	const char *pErg = FilePatchBlock::user_data (uiSize) +8;
   if (uiSize >= 8)
   {
   	uiSize -= 8;
      return pErg;
   }

   uiSize = 0;
   return NULL;
}


// ***************************************************************************
//  Class : ChangeBinPatchBlock
// ***************************************************************************
// DiffBlocks:
// From Original: <char: 1><unsigned int: Pos><unsigned int: Len>
// From Diff-File:<char: 2><unsigned int: Len><BYTES>

#define BLOCK_MIN 15
#define STACK_SIZE 4096

ChangeBinPatchBlock::ChangeBinPatchBlock (
										const char *pName,
      							 	const char *pNewBuffer,
                              unsigned int uiNewBufferSize,
                              const char *pOldBuffer,
                              unsigned int uiOldBufferSize)
	: ChangePatchBlock (pName,pOldBuffer,uiOldBufferSize,
   				pNewBuffer,uiNewBufferSize)
{
	int iProgress = 0;
	m_szStack = 0;
	clr_stack ();

   // evaluate differences
 //  unsigned int uiNewIndex, uiOldIndex,uiBlockLen;
//   unsigned int uiOldIndexMax = uiOldBufferSize - BLOCK_MIN;
   unsigned int uiMaxLenStart,uiMaxLenSize;

   const char *pIterNewBuffer = pNewBuffer;
   const char *pNewBufferMax = pNewBuffer + uiNewBufferSize;

   const char *pIterOldBuffer;
   const char *pOldBufferMax = pOldBuffer + uiOldBufferSize;
   const char *pOldBufferMaxBlock = pOldBufferMax -BLOCK_MIN;

//   uiNewIndex = 0;

   while (pIterNewBuffer < pNewBufferMax)
   {
   	uiMaxLenStart = 0;
      uiMaxLenSize = 0;

   	// look if we can find the block of maximal length
      // identical with the actual block of the new file

      for (	pIterOldBuffer = pOldBuffer;
   			pIterOldBuffer < pOldBufferMaxBlock;pIterOldBuffer++)
      {
      	// dont compare if we have found a block more big than
         // the left memory to compare
      	if (uiMaxLenSize >= (pOldBufferMax - pIterOldBuffer))
         	break;

      	// calcualte maximal value for block len:
//      	unsigned int uiBlockMax = uiOldBufferSize -  uiOldIndex;
         const char *p1 = pIterNewBuffer;
         const char *pOldStart = pIterOldBuffer;

         //      	for (uiBlockLen = 0;uiBlockLen < uiBlockMax;uiBlockLen++)
			while (p1 < pNewBufferMax && pIterOldBuffer < pOldBufferMax)
         {
         	if (*p1 != *pIterOldBuffer)
            	break;
            pIterOldBuffer++;
	         p1++;
         }

         unsigned int uiBlockLen = pIterOldBuffer - pOldStart;
         // look, if this is the maximal block:
         if (uiMaxLenSize < uiBlockLen)
         {
            uiMaxLenStart = pOldStart - pOldBuffer;
            uiMaxLenSize = uiBlockLen;
         }
      }

      // look, if we have a block of the minimal len:
      if (uiMaxLenSize >= BLOCK_MIN)
      {
      	write_stack ();
         char c = 1;

         add_buffer (&c,sizeof(c)); // diff-block: from original;
         add_buffer ((const char*)&uiMaxLenStart,sizeof (uiMaxLenStart));
         add_buffer ((const char*)&uiMaxLenSize,sizeof (uiMaxLenSize));
         pIterNewBuffer += uiMaxLenSize;

         if (!iProgress)
         	putch ('.');
         iProgress = ++iProgress & 7;
      }
      else
      {
      	push (*pIterNewBuffer);
      	pIterNewBuffer++;
      }

   }
 	printf ("\n");

   //write the rest from the stack
	write_stack ();
}


ChangeBinPatchBlock::ChangeBinPatchBlock (char *szBuffer,unsigned int uiBufferSize)
	: ChangePatchBlock (szBuffer, uiBufferSize)
{
	m_szStack = 0;
	clr_stack ();
}

ChangeBinPatchBlock::~ChangeBinPatchBlock ()
{
	clr_stack ();
}

// write back functionality
bool ChangeBinPatchBlock::proceed (char *szPath)
{
	// change back:
   // load old file:

   // create filename:
   char szBuffer [MAXPATH];
   strcpy (szBuffer,szPath);

   strcat (szBuffer,filename());

   ffblk ff;

   int iErg = findfirst (szBuffer,&ff,FA_HIDDEN |
         	FA_SYSTEM |	FA_DIREC | FA_ARCH);

	if (iErg)
   {
      printf ("Cant find %s to change.\n",szBuffer);
   	return false;
   }

   TFileBuffer oOldFile (szBuffer);

   unsigned int uiOldSize = oOldFile.size (); //ff.ff_fsize;
	char *pOldBuffer = oOldFile.buffer (); //(char*) malloc (uiOldSize+1);
   assert (pOldBuffer);

/*   FILE *pFile = fopen (szBuffer,"rb");

   if (!pFile)
   {
   	printf ("Cant open %s for reading.\n",szBuffer);
      free (pOldBuffer);
      return false;
   }

   if (fread (pOldBuffer,1,uiOldSize,pFile) != uiOldSize)
   {
   	printf ("Cant read %s.\n",szBuffer);
      free (pOldBuffer);
      fclose (pFile);
      return false;
   }

   fclose (pFile);*/

	// check check_sun

   unsigned int uiAktCheck = calc_check_sum (pOldBuffer,uiOldSize);
   unsigned int uiOldCheck = old_check_sum ();
   unsigned int uiNewCheck = new_check_sum ();

   if (uiNewCheck == uiAktCheck)
   {
   	printf ("File %s is uptodate.\n",szBuffer);
      return false;
   }

   if (uiAktCheck != uiOldCheck)
   {
   	printf ("File %s has not the correct version for this patch.\n",szBuffer);
      return false;
   }


	// create buffer for new file:
   unsigned int uiNewSize = file_size ();
   TFileBuffer oNewFile (uiNewSize);
	char *pNewBuffer = oNewFile.buffer (); //(char*)malloc (uiNewSize);

   // create new file version:
   unsigned int ui=0;

   unsigned int uiPatchSize;
   const char *pPatchData = user_data (uiPatchSize);

   while (ui < uiNewSize)
   {
		switch (pPatchData[0])
      {
      	case 1 :
         {
				// From Original: <char: 1><unsigned int: Pos><unsigned int: Len>
         	pPatchData++;
         	unsigned int uiPos = ((unsigned int*)pPatchData)[0];
            pPatchData += sizeof (unsigned int);
            unsigned int uiLen = ((unsigned int*)pPatchData)[0];
            pPatchData += sizeof (unsigned int);

            // copy data:
            memcpy (pNewBuffer+ui,pOldBuffer+uiPos,uiLen);
            ui += uiLen;
            break;
         }
         case 2 :
         {
				// From Diff-File:<char: 2><unsigned int: Len><BYTES>
            pPatchData++;
            unsigned int uiLen = ((unsigned int*)pPatchData)[0];
            pPatchData += sizeof (unsigned int);

				// copy data:
            memcpy (pNewBuffer + ui,pPatchData,uiLen);
            pPatchData += uiLen;
            ui += uiLen;
         	break;
         }
         default :
         {
         	int i = pPatchData[0];
         	printf ("Unknown Differences Block %i,%i file corrupt!\n",
            	i,ui);
//            free (pNewBuffer);
//            free (pOldBuffer);
            return false;
         }
      }
   }

   // we didnt use old buffer any longer:
//  	free (pOldBuffer);

	if (oNewFile.save (szBuffer,file_time ()) == false)
   {
   	printf ("Cant write patched file %s\n",szBuffer);
   }
   else
   {
 		printf ("Patch file %s\n",szBuffer);
   }
   // write back file:
/*   pFile = fopen (szBuffer,"wb");

   if (!pFile)
   {
   	printf ("Cant open %s for writing.\n",szBuffer);
      free (pNewBuffer);
      return false;
   }

   if (fwrite (pNewBuffer,1,uiNewSize,pFile) != uiNewSize)
   {
   	printf ("Cant write %s.\n",szBuffer);
      free (pNewBuffer);
      fclose (pFile);
      return false;
   }

   setftime (fileno (pFile),file_time());

   fclose (pFile);
   free (pNewBuffer);*/


   return true;
}

void ChangeBinPatchBlock::clr_stack (void)
{
	if (m_szStack)
   	free (m_szStack);

  	m_szStack = 0;
   m_uiStackSize = 0;
   m_uiStackTop = 0;
}


void ChangeBinPatchBlock::write_stack (void)
{
	if (m_szStack && m_uiStackTop)
   {
   	char c= 2;
      // write stack to buffer:
		add_buffer (&c,sizeof (c));
      add_buffer ((const char*)&m_uiStackTop,sizeof (m_uiStackTop));
      add_buffer (m_szStack,m_uiStackTop);
   }

   m_uiStackTop = 0;
}

void ChangeBinPatchBlock::push (char cByte)
{
	if (!m_szStack)
   {
   	m_szStack = (char*) malloc (STACK_SIZE);
      assert (m_szStack);
      m_uiStackSize = STACK_SIZE;
   }
   else if (m_uiStackSize == m_uiStackTop)
   {
   	m_uiStackSize += STACK_SIZE;

      m_szStack = (char*) realloc (m_szStack,m_uiStackSize);
      assert (m_szStack);
   }

   m_szStack [m_uiStackTop] = cByte;
   m_uiStackTop++;
}


// ***************************************************************************
//  Class : ChangeTextPatchBlock
// ***************************************************************************
/*ChangeTextPatchBlock::ChangeTextPatchBlock (
										const char *pName,
      							 	const char *pNewBuffer,
                              unsigned int uiNewBufferSize,
                              const char *pOldBuffer,
                              unsigned int uiOldBufferSize)
	: ChangePatchBlock (pName,pOldBuffer,uiOldBufferSize)
{
	// create differences


}

ChangeTextPatchBlock::ChangeTextPatchBlock (char *szBuffer,unsigned int uiBufferSize)
	: ChangePatchBlock (szBuffer,uiBufferSize)
{
}

// write back functionality
bool ChangeTextPatchBlock::proceed (char *szPath)
{

	return true;
}*/

// ***************************************************************************
//  Class : RemovePatchBlock
// ***************************************************************************
RemovePatchBlock::RemovePatchBlock (const char *pName)
	: PatchBlock ()
{
   add_buffer (pName,strlen (pName)+1);
}

RemovePatchBlock::RemovePatchBlock (char *cszBuffer,unsigned int uiBufferSize)
	: PatchBlock (cszBuffer,uiBufferSize)
{
}

// write back functionality
bool RemovePatchBlock::proceed (char *szPath)
{
	char szBuffer[MAXPATH];

   strcpy (szBuffer,szPath);
   strcat (szBuffer,name());

   ffblk ff;

   int iErg = findfirst (szBuffer,&ff,FA_HIDDEN |
         	FA_SYSTEM |	FA_DIREC | FA_ARCH);

	if (iErg)
   {
   	// its ok, if this file does not exists
   	return true;
   }

   if (ff.ff_attrib & FA_DIREC)
   {  // remove directory
		if (rmdir (szBuffer) != 0)
      {
			printf ("Cant remove directory %s\n",szBuffer);
			return false;
      }
   }
   else
   {
   	if (remove (szBuffer) != 0)
      {
      	printf ("Cant remove file %s\n",szBuffer);
         return false;
      }

   }

   printf ("Remove %s\n",szBuffer);

   return true;
 }

 // ***************************************************************************
//  Class : ChangeStorePatchBlock
// ***************************************************************************
// stores the complete block in the patch file

ChangeStorePatchBlock::ChangeStorePatchBlock (
								const char *pFilename,
                        const char *pOldBuffer,
                        unsigned int uiOldBuffer,
                        const char *pNewBuffer,
                        unsigned int uiNewBuffer)
	: ChangePatchBlock (pFilename,pOldBuffer,uiOldBuffer,pNewBuffer,uiNewBuffer)
{
	// store patch
   TFileBuffer oFile (pFilename);

   if (oFile.valid () == true)
   {
   	add_buffer (oFile.buffer(),oFile.size ());
   }
   else
   {
   	printf ("Cant open %s for reading.\n",pFilename);
   }
}

ChangeStorePatchBlock::ChangeStorePatchBlock (
								char *szBuffer,
								unsigned int uiBufferSize)
	: ChangePatchBlock (szBuffer,uiBufferSize)
{
}

// write back functionality
bool ChangeStorePatchBlock::proceed (char *szPath)
{
   // create filename:
   char szBuffer [MAXPATH];
   strcpy (szBuffer,szPath);

   strcat (szBuffer,filename());

   ffblk ff;

   int iErg = findfirst (szBuffer,&ff,FA_HIDDEN |
         	FA_SYSTEM |	FA_ARCH);

	if (iErg)
   {
      printf ("Cant find %s to change.\n",szBuffer);
   	return false;
   }

   TFileBuffer oNewFile;
	unsigned int uiSize;
   const char *pBuffer = user_data (uiSize);

   if (oNewFile.save (szBuffer,file_time(),pBuffer,uiSize) == false)
   {
   	printf ("Cant write %s\n",szBuffer);
      return false;
   }

 	printf ("Change file %s\n",szBuffer);
	return true;

}

