// ***************************************************************************
//		Patcher/CreatePatch
// ***************************************************************************
//  (c) 1997 by Olaf Panz
//  Niedere Strae 21
//  78050 VS-Villingen
//  www.t-online.de/home/olaf.panz
//  olaf.panz@gft.de
// ***************************************************************************
//	  Patch-Block- Handling
// ***************************************************************************
#ifndef BLOCK_HPP
#define BLOCK_HPP

#include <assert.h>
#include <stdio.h>
#include <sys\timeb.h>


// File blocks:
enum BlockType {
	FILE_BLOCK_COPYRIGHT 	= 0,
	FILE_BLOCK_INFO 			= 1,
	FILE_BLOCK_PATH			= 2,
	FILE_BLOCK_DEL				= 3,
	FILE_BLOCK_ADD_FILE		= 4,
	FILE_BLOCK_ADD_PATH		= 5,
	FILE_BLOCK_CHANGE_TEXT 	= 6,
   FILE_BLOCK_CHANGE_BIN	= 7,
   FILE_BLOCK_CHANGE_STORE = 8
};

#ifdef PTCHFILE_EXPORT
#undef PTCHFILE_EXPORT
#endif

#ifdef __PTCHBASEDLL__
#define PTCHFILE_EXPORT _export
#else
#define PTCHFILE_EXPORT _import
#endif

class PTCHFILE_EXPORT WritePatchFile;
class PTCHFILE_EXPORT ReadPatchFile;

// ***************************************************************************
//  Class : PatchBlock
// ***************************************************************************
class PTCHFILE_EXPORT PatchBlock
{
	private :

      unsigned int m_uiLen;		// BlockLen
      unsigned int m_uiBufferLen;

   protected :

      char *m_szBuffer;

      PatchBlock (void);
      PatchBlock (char *cszBuffer,unsigned int uiBufferSize);

   	bool add_buffer (const char *m_cBuffer,unsigned int uiBufferSize);

   public :

   	virtual BlockType type (void) const=0;
      virtual ~PatchBlock (void);

      // write back functionality
      virtual bool proceed (char *szPath)=0;

      unsigned int size (void) const
      	{ return m_uiLen; }

   friend class WritePatchFile;
   friend class ReadPatchFile;

};

// ***************************************************************************
//  Class : CopyrightPatchBlock
// ***************************************************************************
class PTCHFILE_EXPORT CopyrightPatchBlock : public PatchBlock
{
	private :

   protected :

   public :

   	CopyrightPatchBlock (void);
      CopyrightPatchBlock (char *cszBuffer,
      			unsigned int uiBufferSize);

      const char *copyright (void)
      	{ return m_szBuffer; }

      // write back functionality
      virtual bool proceed (char *szPath);
   	virtual BlockType type (void) const
      	{ return FILE_BLOCK_COPYRIGHT; }

};

// ***************************************************************************
//  Class : InfoPatchBlock
// ***************************************************************************
class PTCHFILE_EXPORT InfoPatchBlock : public PatchBlock
{
	private :

   	unsigned int m_uiDateIndex;

   protected :

   public :

   	InfoPatchBlock (const char* cszName,const char *csDate);
      InfoPatchBlock (char *cszBuffer,unsigned int uiBufferSize);

      const char *name (void) const
      	{ return m_szBuffer +4; }
      const char *date (void) const
      	{ return m_szBuffer + m_uiDateIndex; }

      // write back functionality
      virtual bool proceed (char *szPath);

   	virtual BlockType type (void) const
      	{ return FILE_BLOCK_INFO; }
};

// ***************************************************************************
//  Class : PathPatchBlock
// ***************************************************************************
class PTCHFILE_EXPORT PathPatchBlock	: public PatchBlock
{
	private :

   protected :

   public :

   	PathPatchBlock (const char *path);
      PathPatchBlock (char *cszBuffer,unsigned int uiBufferSize);

      // return '\0' means one step back!
      const char *path (void) const { return m_szBuffer; }

      // write back functionality
	   virtual bool proceed (char *szPath);
    	virtual BlockType type (void) const
      	{ return FILE_BLOCK_PATH; }

};

class PTCHFILE_EXPORT AddPathPatchBlock : public PathPatchBlock
{
	private :

   protected :

   public :

   	AddPathPatchBlock (char *szBuffer,unsigned int uiBufferSize)
      	: PathPatchBlock (szBuffer,uiBufferSize) {}
      AddPathPatchBlock (const char *cszPath)
      	: PathPatchBlock (cszPath) {}

      // write back functionality
      virtual bool proceed (char *szPath);

     	virtual BlockType type (void) const
      	{ return FILE_BLOCK_ADD_PATH; }

};

// ***************************************************************************
//  Abstract Class : FilePatchBlock
// ***************************************************************************
class PTCHFILE_EXPORT FilePatchBlock : public PatchBlock
{
	private :

   protected :

   		// user data of derived classes:
         virtual const char *user_data (unsigned int &uiSize) const;

   public :

   	FilePatchBlock (const char *pName);
      FilePatchBlock (char *szBuffer, unsigned int uiBufferSize);

	  	const char *filename (void) const;
      struct ftime* file_time (void) const;
      unsigned int file_size (void) const;

};

// ***************************************************************************
//  Class : AddPatchBlock
// ***************************************************************************
class PTCHFILE_EXPORT AddFilePatchBlock : public FilePatchBlock
{
	private :

   protected :

   public :

   	AddFilePatchBlock (const char *pName);
      AddFilePatchBlock (char *szBuffer,unsigned int uiBufferSize);

   	virtual BlockType type (void) const
      	{ return FILE_BLOCK_ADD_FILE; }

      // write back functionality
      virtual bool proceed (char *szPath);
};

// ***************************************************************************
//  Class : ChangePatchBlock
// ***************************************************************************
class PTCHFILE_EXPORT ChangePatchBlock : public FilePatchBlock
{
	private :

   protected :

   	unsigned int calc_check_sum (const char *pBuffer,unsigned int uiSize)
      		const;

  		// user data of derived classes:
      virtual const char *user_data (unsigned int &uiSize) const;



   public :

   	ChangePatchBlock (	const char *pName,
      							const char *pOldBuffer,
                           unsigned int uiOldBufferSize,
                           const char *pNewBuffer,
                           unsigned int uiNewBufferSize);

      ChangePatchBlock (char *szBuffer,unsigned int uiBufferSize);

		unsigned int old_check_sum (void) const;
      unsigned int new_check_sum (void) const;

};

// ***************************************************************************
//  Class : ChangeStorePatchBlock
// ***************************************************************************
// stores the complete block in the patch file
class PTCHFILE_EXPORT ChangeStorePatchBlock : public ChangePatchBlock
{
	private :

   protected :

   public :

   	ChangeStorePatchBlock (	const char *pFilename,
                              const char *pOldBuffer,
                              unsigned int uiOldBuffer,
                              const char *pNewBuffer,
                              unsigned int uiNewBuffer);
   	ChangeStorePatchBlock (char *szBuffer,unsigned int uiBufferSize);


   	virtual BlockType type (void) const
      	{ return FILE_BLOCK_CHANGE_STORE; }

      // write back functionality
      virtual bool proceed (char *szPath);

};


// ***************************************************************************
//  Class : ChangeBinPatchBlock
// ***************************************************************************
class PTCHFILE_EXPORT ChangeBinPatchBlock : public ChangePatchBlock
{
	private :

   	char *m_szStack;
      unsigned int m_uiStackSize;
      unsigned int m_uiStackTop;

      void clr_stack (void);

   protected :

   	void write_stack (void);
      void push (char cByte);

   public :

   	ChangeBinPatchBlock (	const char *pName,
      							 	const char *pNewBuffer,
                              unsigned int uiNewBufferSize,
                              const char *pOldBuffer,
                              unsigned int uiOldBufferSize);

      ChangeBinPatchBlock (char *szBuffer,unsigned int uiBufferSize);
      ~ChangeBinPatchBlock ();

   	virtual BlockType type (void) const
      	{ return FILE_BLOCK_CHANGE_BIN; }

      // write back functionality
      virtual bool proceed (char *szPath);

};

// ***************************************************************************
//  Class : ChangeTextPatchBlock
// ***************************************************************************
/*
class PTCHFILE_EXPORT ChangeTextPatchBlock : public ChangePatchBlock
{
	private :

   protected :

   public :

   	ChangeTextPatchBlock (	const char *pName,
      							 	const char *pNewBuffer,
                              unsigned int uiNewBufferSize,
                              const char *pOldBuffer,
                              unsigned int uiOldBufferSize);

      ChangeTextPatchBlock (char *szBuffer,unsigned int uiBufferSize);

   	virtual BlockType type (void) const
      	{ return FILE_BLOCK_CHANGE_TEXT; }

      // write back functionality
      virtual bool proceed (char *szPath);

};*/

// ***************************************************************************
//  Class : RemovePatchBlock
// ***************************************************************************
class PTCHFILE_EXPORT RemovePatchBlock : public PatchBlock
{
	private :

   protected :

   public :

   	RemovePatchBlock (const char *pName);
      RemovePatchBlock (char *cszBuffer,unsigned int uiBufferSize);

   	virtual BlockType type (void) const
      	{ return FILE_BLOCK_DEL; }

      // write back functionality
      virtual bool proceed (char *szPath);

      const char *name (void) const
      	{ return m_szBuffer; }

};




#endif //#ifndef BLOCK_HPP

