// ***************************************************************************
//		Patcher/CreatePatch
// ***************************************************************************
//  (c) 1997 by Olaf Panz
//  Niedere Strae 21
//  78050 VS-Villingen
//  www.t-online.de/home/olaf.panz
//  olaf.panz@gft.de
// ***************************************************************************
//	  Compression
// ***************************************************************************
#ifndef COMPRESSION_HPP
#define COMPRESSION_HPP

#include <stdio.h>

#define HASH_SIZE 2^20

// callback function for data transfer
typedef bool (*TCompressDataFunc)(const char *pBuffer,
		unsigned int uiBufferSize);
// ***************************************************************************
//   TCompress
// ***************************************************************************
class TCompress
{
	private :

   	TCompressDataFunc m_pFunc;
      unsigned short m_oBuffer [HASH_SIZE];

   protected :

   	void init (void);

      // write data to output
      bool write_output (const char *pBuffer,unsigned int uiBufferSize);

   public :

  		TCompress (TCompressDataFunc pFunc);
      virtual ~TCompress ();

};



#endif //#ifndef COMPRESSION_HPP

