// ***************************************************************************
//		Patcher/CreatePatch
// ***************************************************************************
//  (c) 1997 by Olaf Panz
//  Niedere Strae 21
//  78050 VS-Villingen
//  www.t-online.de/home/olaf.panz
//  olaf.panz@gft.de
// ***************************************************************************
#include "crtpatch.hpp"
#include "ptchfile.hpp"
#include "block.hpp"
#include "fbuffer.hpp"

#include <string.h>
#include <dir.h>
#include <dos.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys\stat.h>

// main function to create the patch-file
bool create_patch (
			const char* cszNewPath,
         const char* cszOldPath,
         const char* cszPatchFile,
         const char* cszPatchName,
         const char* cszPatchDate,
         TStatistics& oStat,
         const TPreferences& oPrev)
{
	WritePatchFile oPatchFile (cszPatchFile);

   // first: write info block
   oPatchFile.write_block (InfoPatchBlock (cszPatchName,cszPatchDate));

   char szBuffer [MAXPATH];
   szBuffer[0] = '\0';

   return create_patch_directory (
   		oPatchFile,
         cszNewPath,
         cszOldPath,
         "",
         szBuffer,
         oStat,
         oPrev);
}

// patch one directory:
bool create_patch_directory (
					WritePatchFile& oFile,
					const char* cszNewPath,   // absolute new path (maybe relative to cwdpath)
					const char* cszOldPath,	  // absolute old path (maybe relative to cwdpath)
               const char* cszRelPath,	  // relative working path
               char* szLastRelWorkPath, // last path where we had changes
					TStatistics& oStat,
		         const TPreferences& oPrev)  // should we proceed recursive?
{
	oStat.iDirs++;

	// message:
   printf ("Proceed Directory: %s%s\n",cszNewPath,cszRelPath);

	ffblk stNewFind,stOldFind;
   char szNewFindPattern[MAXPATH],szOldFindPattern[MAXPATH];

   // create search pattern:
   strcpy (szNewFindPattern,cszNewPath);
   strcat (szNewFindPattern,cszRelPath);
   strcat (szNewFindPattern,"*.*");

	int iNewErg = findfirst (szNewFindPattern,&stNewFind,FA_HIDDEN | FA_SYSTEM |
   	FA_DIREC | FA_ARCH);

   // iterate over all files:
   while (!iNewErg)
   {
   	oStat.iLookedFiles++;

   	if (stNewFind.ff_name[0] != '.')
	   {
      	// check, if this file or path exists in the old path:
         strcpy (szOldFindPattern,cszOldPath);
         strcat (szOldFindPattern,cszRelPath);
         strcat (szOldFindPattern,stNewFind.ff_name);

         int iOldErg = findfirst (szOldFindPattern,&stOldFind,FA_HIDDEN |
         	FA_SYSTEM |	FA_DIREC | FA_ARCH);
         bool blItemProceed = false;

      	if (iOldErg != 0)
         {
         	oStat.iAddedFiles++;
         	// this file/path does not exists, it should be created

				// first: we must navigate in the correct relative directory:
				if (write_navigate_path (oFile,cszRelPath,szLastRelWorkPath) == false)
            	return false;

            if (stNewFind.ff_attrib & FA_DIREC)
            {
            	// add directory
               printf ("\tAdd Path %s\n",stNewFind.ff_name);
             	oFile.write_block (AddPathPatchBlock (stNewFind.ff_name));
            }
            else
            {
               // create filename
               char szBuffer [MAXPATH];
               strcpy (szBuffer,szNewFindPattern);
               // remove ending *
               szBuffer [strlen (szBuffer)-3] = '\0';
               strcat (szBuffer,stNewFind.ff_name);

            	// add file
	            printf ("\tAdd file %s\n",szBuffer);
   		    	oFile.write_block (AddFilePatchBlock (szBuffer));
            }

            blItemProceed = true;
         }

      	if (stNewFind.ff_attrib & FA_DIREC)
         {
         	if (oPrev.blRecursive == true)
            {
            	// create new relative path:
               char szBuffer [MAXPATH];
               strcpy (szBuffer,cszRelPath);
               strcat (szBuffer,stNewFind.ff_name);
               int iPos = strlen (szBuffer);
               szBuffer [iPos] = PATH_SEPARATOR;
               szBuffer [iPos+1] = '\0';

					create_patch_directory (oFile,cszNewPath,cszOldPath,szBuffer,
               			szLastRelWorkPath,oStat,oPrev);
            }
         }
         else if (blItemProceed == false)
         {
         	// check differences of two files:
            if (create_patch_file (	oFile,
            								cszNewPath,
                                    cszOldPath,
                                    cszRelPath,
            								szLastRelWorkPath,
                                    stNewFind.ff_name,
                                    stNewFind.ff_fsize,
                                    stOldFind.ff_fsize,
                                    oStat,
                                    oPrev) == false)
            {
            	return false;
            }

         }
      }
      iNewErg = findnext (&stNewFind);
   }


   // check, if we should delete some files:

   // create search pattern:
   strcpy (szOldFindPattern,cszOldPath);
   strcat (szOldFindPattern,cszRelPath);
   strcat (szOldFindPattern,"*.*");

	int iOldErg = findfirst (szOldFindPattern,&stOldFind,FA_HIDDEN | FA_SYSTEM |
   	FA_DIREC | FA_ARCH);

   // iterate over all files:
   while (!iOldErg)
   {
   	if (stOldFind.ff_name[0] != '.')
	   {
      	// check, if this file or path exists in the old path:
         strcpy (szNewFindPattern,cszNewPath);
         strcat (szNewFindPattern,cszRelPath);
         strcat (szNewFindPattern,stOldFind.ff_name);

         iNewErg = findfirst (szNewFindPattern,&stNewFind,FA_HIDDEN |
         	FA_SYSTEM |	FA_DIREC | FA_ARCH);

      	if (iNewErg != 0)
         {

         	// create filename
         	char szBuffer [MAXPATH];
            strcpy (szBuffer,szOldFindPattern);
            // remove ending *
            szBuffer [strlen (szBuffer)-3] = '\0';
            strcat (szBuffer,stOldFind.ff_name);

            printf ("\tRemove %s\n",szBuffer);

            oStat.iRemovedFiles++;

            // if this is a path, we must iterate over it because, we must remve
            // all subitems of it:
         	if (oPrev.blRecursive == true && (stOldFind.ff_attrib & FA_DIREC))
            {
            	// create new relative path:
               char szBuffer [MAXPATH];
               strcpy (szBuffer,cszRelPath);
               strcat (szBuffer,stOldFind.ff_name);
               int iPos = strlen (szBuffer);
               szBuffer [iPos] = PATH_SEPARATOR;
               szBuffer [iPos+1] = '\0';

					create_patch_directory (oFile,cszNewPath,cszOldPath,szBuffer,
               			szLastRelWorkPath,oStat,oPrev);
            }

				// first: we must navigate in the correct relative directory:
				if (write_navigate_path (oFile,cszRelPath,szLastRelWorkPath) == false)
            	return false;

           	oFile.write_block (RemovePatchBlock (stOldFind.ff_name));
         }

      }
      iOldErg = findnext (&stOldFind);
   }


	return true;
}

// write naviagation blocks to file,
// only if necessary
bool write_navigate_path (
	WritePatchFile& oFile,
	const char *cszNewWorkPath,
   char *szOldWorkPath)
{
	int iEqual;

   for (iEqual=0;cszNewWorkPath[iEqual] && cszNewWorkPath[iEqual] ==
   			szOldWorkPath[iEqual];iEqual++)
   	;

   if (!cszNewWorkPath[iEqual] && !szOldWorkPath[iEqual]) // strings equal?
   	return true;


   int i = iEqual;
   // must we go some steps back?
   while (szOldWorkPath[i])
   {
   	// from here each PATH_SEPARATOR means one step back:

   	if (szOldWorkPath[i] == PATH_SEPARATOR)
      {
      	// write a Path-Block for one step back:
         oFile.write_block (PathPatchBlock (""));
//         printf ("Walk: ..\\\n");
      }

      i++;
   }

   // must we go some steps up?
	i = iEqual;
   while (cszNewWorkPath[i])
   {
   	if (cszNewWorkPath[i] == PATH_SEPARATOR)
      {
      	char szBuffer [MAXPATH];

         // copy name into buffer
         memcpy (szBuffer,cszNewWorkPath+iEqual,i - iEqual);
         szBuffer [i - iEqual] = '\0';

         oFile.write_block (PathPatchBlock (szBuffer));
  //       printf ("Walk: %s\n",szBuffer);

       	iEqual = i+1;
		}

   	i++;
   }

   // copy new path into old:
   strcpy (szOldWorkPath,cszNewWorkPath);

   return true;
}

bool create_patch_file (	WritePatchFile& oFile,
									const char* cszNewPath,
                           const char* cszOldPath,
                           const char* cszRelPath,
                           char *szLastRelWorkPath,
                           const char* cszFilename,
                           unsigned int uiNewSize,
                           unsigned int uiOldSize,
									TStatistics& oStat,
						         const TPreferences& oPrev
                           )
{
   // create path/filename:
   char szNewFile [MAXPATH];
   char szOldFile [MAXPATH];
   unsigned int i;
   bool blErg = true;

   strcpy (szNewFile,cszNewPath);
   strcat (szNewFile,cszRelPath);
   strcat (szNewFile,cszFilename);

   strcpy (szOldFile,cszOldPath);
   strcat (szOldFile,cszRelPath);
   strcat (szOldFile,cszFilename);

  	// load new file:
 //	FILE *pFile = fopen (szNewFile,"rb");
   TFileBuffer oNewFile (szNewFile);
   TFileBuffer oOldFile (szOldFile);

/*   if (!pFile)
   {
   	printf ("Cant open file %s\n",szNewFile);
      return false;
   }

   char *pNewBuffer = (char*) malloc (uiNewSize +1);
   											// add one t be sure that there is a buffer
   assert (pNewBuffer);

   if (fread (pNewBuffer,1,uiNewSize,pFile) != uiNewSize)
   {
   	printf ("Cant read file %s\n",szNewFile);
      free (pNewBuffer);
      return false;
   }

   fclose (pFile);


   // load old file:
	pFile = fopen (szOldFile,"rb");

   if (!pFile)
   {
   	printf ("Cant open file %s\n",szOldFile);
      free (pNewBuffer);
      return false;
   }

	char *pOldBuffer = (char*) malloc (uiOldSize +1);
   assert (pOldBuffer);

   if (fread (pOldBuffer,1,uiOldSize,pFile) != uiOldSize)
   {
   	printf ("Cant read file %s\n",szOldFile);
      free (pNewBuffer);
      free (pOldBuffer);
      return false;
   }

   fclose (pFile);
  	*/
   const char *pNewBuffer = oNewFile.buffer ();
   const char *pOldBuffer = oOldFile.buffer ();

   // compare both files:
   if (uiOldSize != uiNewSize)
   {

   	if (write_navigate_path (oFile,cszRelPath,szLastRelWorkPath) == false)
        	return false;

	  	// both files are different, so we must check now if we have text or bin
		bool blIsText = true;

   	// check new file:

      for (i=0;i<uiNewSize;i++)
      {
			if (pNewBuffer [i] & 128)
         {
         	blIsText = false;
            break;
         }
      }

      // check old file:
      if (blIsText == true)
      {
	      for (i=0;i<uiOldSize;i++)
         {
         	if (pOldBuffer [i] & 128)
            {
            	blIsText = false;
               break;
            }
         }
      }

      if (blIsText == false)
		{
      	// write binary differences here
         if (write_bin_diff (oFile,pNewBuffer,uiNewSize,pOldBuffer,uiOldSize,
           	szNewFile,oStat,oPrev) == false)
         {
         	blErg = false;
         }
      }
      else
      {
      	// write text differences here
         if (write_text_diff (oFile,pNewBuffer,uiNewSize,pOldBuffer,uiOldSize,
            	szNewFile,oStat,oPrev) == false)
         {
         	blErg = false;
         }

      }
//	   free (pNewBuffer);
//   	free (pOldBuffer);

      return blErg;
   }
   // check if files are equal:
	char cOr= 0;

   for (i=0;i<uiNewSize;i++)
   {
   	// check, if text or bin:
   	cOr |= pOldBuffer[i] | pNewBuffer[i];

      if (pOldBuffer[i] != pNewBuffer[i])
      {
      	// move to the actual path
	   	if (write_navigate_path (oFile,cszRelPath,szLastRelWorkPath) == false)
   	     	return false;

      	// OK, we are different, but we must check on binary/text now:
        	while (i<uiNewSize && !(cOr & 128))
         	cOr  |= pOldBuffer[i] | pNewBuffer[i];

         if (cOr & 128)
         {
            // write binary differences here
            if (write_bin_diff (oFile,pNewBuffer,uiNewSize,pOldBuffer,uiOldSize,
            	szNewFile,oStat,oPrev) == false)
            {
            	blErg = false;
            }
         }
         else
         {
            // write text differences here
            if (write_text_diff (oFile,pNewBuffer,uiNewSize,pOldBuffer,uiOldSize,
            	szNewFile,oStat,oPrev) == false)
            {
            	blErg = false;
            }

         }
      	break;
      }
   }

//	free (pNewBuffer);
// free (pOldBuffer);

   return blErg;
}


// write binary differences here
bool write_bin_diff (	WritePatchFile& oFile,
								const char *pNewBuffer,
                        unsigned int uiNewSize,
                        const char *pOldBuffer,
                        unsigned int uiOldSize,
                        const char *cszFilename,
								TStatistics& oStat,
					         const TPreferences& oPrev
                        )
{
	printf ("  Evaluate differences of binaray file %s\n",cszFilename);

	oStat.iChangedBinFiles++;


	ChangeBinPatchBlock *pBin=NULL;

   if (oPrev.blDoBinDiff == true)
   {
   	pBin = new ChangeBinPatchBlock(
   					cszFilename,
                  pNewBuffer,
                  uiNewSize,
                  pOldBuffer,
						uiOldSize);
   }

  	ChangeStorePatchBlock oStore(
   					cszFilename,
                  pNewBuffer,
                  uiNewSize,
                  pOldBuffer,
						uiOldSize);

	if (pBin && pBin -> size () < oStore.size ())
		oFile.write_block (*pBin);
   else
		oFile.write_block (oStore);

   delete pBin;

	return true;
}

// write text differences here
bool write_text_diff (	WritePatchFile& oFile,
								const char *pNewBuffer,
                        unsigned int uiNewSize,
                        const char *pOldBuffer,
                        unsigned int uiOldSize,
                        const char *cszFilename,
								TStatistics& oStat,
					         const TPreferences& oPrev
                        )
{
	printf ("  Evaluate differences of textfile %s\n",cszFilename);
	oStat.iChangedTextFiles++;

   ChangeBinPatchBlock *pBin;

   if (oPrev.blDoTextBinDiff == true)
   {
   	pBin = new ChangeBinPatchBlock (
      								cszFilename,
   									pNewBuffer,
                              uiNewSize,
                              pOldBuffer,
                              uiOldSize);
   }

	ChangeStorePatchBlock oStore (
   									cszFilename,
   									pNewBuffer,
                              uiNewSize,
                              pOldBuffer,
                              uiOldSize);

   if (pBin && pBin -> size () < oStore.size ())
      oFile.write_block (*pBin);
   else
      oFile.write_block (oStore);

   delete pBin;

   return true;
}



