// ***************************************************************************
//		Patcher/CreatePatch
// ***************************************************************************
//  (c) 1997 by Olaf Panz
//  Niedere Strae 21
//  78050 VS-Villingen
//  www.t-online.de/home/olaf.panz
//  olaf.panz@gft.de
// ***************************************************************************
#include "crtpatch.hpp"
#include <dir.h>
#include <string.h>
#include <time.h>

int main(int argc, char * argv[], char * /*env*/[])
{
	// print copyright first!
	printf (COPYRIGHT "\n");

	// parameters for patching:
   char szOldPath [MAXPATH];
   char szNewPath [MAXPATH];
   char szPatchFile [MAXPATH];
   char szPatchName [MAXPATH];
   char szPatchTime [MAXPATH];

   TPreferences oPrev;
   TStatistics oStat;
   memset (&oStat,0,sizeof (oStat));

   oPrev.blRecursive = false;
   oPrev.blDoBinDiff = true; 	// create differences for bins
   oPrev.blDoTextDiff = true;	// create differences for texts
   oPrev.blDoTextBinDiff = true;// create text and bin diff for text,
   									  // get shortest

	// Help- and Error- Flags
   bool blPrintHelp = false;
   bool blAutoPrintHelp = true;
   bool blError = false;


   // Set default Parameters
   strcpy (szPatchName,"Unknown Patch");
   szOldPath[0] = '\0';
   szNewPath[0] = '\0';

   time_t tTime = time (NULL);
   strcpy (szPatchTime,asctime (gmtime (&tTime)));
   strcpy (szPatchFile,"Patch.pth");

	// extract parameters:
	int i;

   for (i=1;i<argc;i++)
   {
      if (argv[i][0] == '-' || argv[i][0] == '/')
      {
      	switch (argv[i][1])
         {
         	case 'o' :	//Old Path
            case 'O' :
            	strcpy (szOldPath,argv[i]+2);
               blAutoPrintHelp = false;
               break;
            case 'n' :  // new Path
            case 'N' :
            	strcpy (szNewPath,argv[i]+2);
               blAutoPrintHelp = false;
               break;
            case 't' :	// Patch title
            case 'T' :
            	strcpy (szPatchName,argv[i]+2);
               blAutoPrintHelp = false;
               break;
            case 'd' :	// Patch Date
            case 'D' :
            	strcpy  (szPatchTime,argv[i]+2);
               blAutoPrintHelp = false;
               break;
            case 'f' :  // Patch file
            case 'F' :
            	strcpy (szPatchFile,argv[i]+2);
               if (strchr (szPatchFile,'.') == 0)
	               strcat (szPatchFile,".pth");
               blAutoPrintHelp = false;
               break;
            case 'r' :	// Scan directorys recursive
            case 'R' :
            	oPrev.blRecursive = true;
               blAutoPrintHelp = false;
               break;
            case 's' :
            case 'S' :          // speed level 0=slowes,...
               blAutoPrintHelp = false;

            	switch (argv[i][2])
               {
               	case '0' :
                	   oPrev.blDoBinDiff = true;
						   oPrev.blDoTextDiff = true;
						   oPrev.blDoTextBinDiff = true;
                     break;
               	case '1' :
                	   oPrev.blDoBinDiff = false;
						   oPrev.blDoTextDiff = true;
						   oPrev.blDoTextBinDiff = false;
                     break;
                 	case '2' :
                	   oPrev.blDoBinDiff = false;
						   oPrev.blDoTextDiff = false;
						   oPrev.blDoTextBinDiff = false;
                     break;
                  default :
		            	printf ("Unknown speed : %c\n",argv[i][2]);
                     break;
               }
            	break;
            case 'h' : 	// print help
            case 'H' :
            case '?' :
            	blPrintHelp = true;
               break;
            default :
            	printf ("Unknown parameter : %s\n",argv[i]+1);
               break;
         }
      }
      else
   	{
      	printf ("Unknown character at the beginning of an argument: %c\n",
         			argv[i][0]);
      }
   }

   // check, if we have enough data to work:
   if (!szNewPath[0])
   {
   	printf ("You must specify a path for the newer version.\n");
      blError = true;
   }

   if (!szOldPath[0])
   {
   	printf ("You must specify a path for the older version.\n");
      blError = true;
   }

   if (blAutoPrintHelp == true || blPrintHelp == true)
   {
   	printf (	"CreatePatch creates a patch file containing the differences\n"
			      " between two pathes.\n"
      			" -o<OldPath>\tPath of older files\n"
      			" -n<NewPath>\tPath of newer files\n"
      			" -f<File>\tName of Patchfile, without extension\n"
      			" -t<Title>\tInternal title of Patchfile\n"
      			" -d<Date>\tInternal date of Patchfile Default is the actual date\n"
      			" -r\t\tProceed recursive though pathes\n"
               " -s<0-2>\tSpeed of creation (0=slowest and smallest file)\n"
      			" -h\t\tPrint this help\n");
   }

         // add slashes to the pathes:
   int iLen = strlen (szOldPath);
   if (iLen > 0 && szOldPath[iLen-1] != PATH_SEPARATOR)
   {
   	szOldPath[iLen] = PATH_SEPARATOR;
      szOldPath[iLen+1] = '\0';
   }

   iLen = strlen (szNewPath);
   if (iLen > 0 && szNewPath[iLen-1] != PATH_SEPARATOR)
   {
   	szNewPath[iLen] = PATH_SEPARATOR;
      szNewPath[iLen+1] = '\0';
   }


   if (blError == false)
   {

   	if (create_patch (szNewPath,szOldPath,szPatchFile,szPatchName,szPatchTime,
      	oStat,oPrev) == true)
      {
      	printf ("-------------------------------------------------------------------------------\n"
         		  "Directories:\t\t%i\n"
                 "Files:\t\t\t%i\n"
                 "Added files:\t\t%i\n"
                 "Removed files:\t\t%i\n"
                 "Changed text files:\t%i\n"
                 "Changed binary files:\t%i\n",
                 oStat.iDirs,oStat.iLookedFiles,oStat.iAddedFiles,
                 oStat.iRemovedFiles,oStat.iChangedTextFiles,
                 oStat.iChangedBinFiles);

      	printf ("\nOK.\n");
      }
   }
}
